/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.EnvelopeHandler;
import com.sun.j3d.loaders.lw3d.J3dLwoParser;
import com.sun.j3d.loaders.lw3d.Lw3dLoader;
import com.sun.j3d.loaders.lw3d.LwsFrame;
import com.sun.j3d.loaders.lw3d.LwsMotion;
import com.sun.j3d.loaders.lw3d.LwsPrimitive;
import com.sun.j3d.loaders.lw3d.SequenceReader;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.File;
import java.io.StreamTokenizer;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.media.j3d.Behavior;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3f;

class LwsObject
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Vector shapeList = null;
    boolean hasPivot = false;
    TransformGroup pivotTransGroup = null;

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LwsObject(StreamTokenizer var1_1, boolean var2_2, int var3_3, int var4_4, float var5_5, Lw3dLoader var6_6, int var7_7) {
        super();
        this.debugPrinter.setValidOutput(var7_7);
        this.parent = -1;
        try {
            if (!var2_2) ** GOTO lbl18
            this.fileName = this.getString(var1_1);
            switch (var6_6.getFileType()) {
                case 2: {
                    var8_8 = var6_6.getBasePath();
                    if (var8_8 == null) {
                        var8_8 = var6_6.getInternalBasePath();
                    }
                    if (var8_8 == null) break;
                    this.fileName = this.getQualifiedFilename(var8_8, this.fileName);
                    break;
                }
lbl18:
                // 1 sources

                this.objName = this.getString(var1_1);
                break;
            }
            this.skip(var1_1, "ShowObject", 2);
            this.debugOutputLn(8, "skipped showobject, about to get objectmotion");
            this.getAndCheckString(var1_1, "ObjectMotion");
            this.debugOutputLn(8, "got string " + var1_1.sval);
            this.motion = new LwsMotion(var1_1, var3_3, var4_4, var5_5, var7_7);
            this.debugOutputLn(8, "got motion");
            var8_9 = false;
            while (!this.isCurrentToken(var1_1, "ShadowOptions")) {
                if (!var8_9 && this.isCurrentToken(var1_1, "ParentObject")) {
                    this.parent = (int)this.getNumber(var1_1);
                    var8_9 = true;
                } else if (this.isCurrentToken(var1_1, "PivotPoint")) {
                    this.hasPivot = true;
                    var9_11 = (float)this.getNumber(var1_1);
                    var10_13 = (float)this.getNumber(var1_1);
                    var11_14 = (float)this.getNumber(var1_1);
                    var12_15 = new Vector3f(-var9_11, -var10_13, var11_14);
                    var13_16 = new Transform3D();
                    var13_16.set(var12_15);
                    this.pivotTransGroup = new TransformGroup(var13_16);
                    this.pivotTransGroup.setCapability(18);
                } else if (this.isCurrentToken(var1_1, "ObjDissolve")) {
                    var9_12 = new EnvelopeHandler(var1_1, var4_4, var5_5);
                }
                var1_1.nextToken();
            }
            this.getNumber(var1_1);
            this.debugOutputLn(8, "done with LwsObject constructor");
            return;
        }
        catch (Exception var8_10) {
            this.debugOutputLn(16, "Exception in lwsObject: " + var8_10);
            return;
        }
    }

    void addChild(LwsPrimitive lwsPrimitive) {
        this.debugOutputLn(1, "addChild()");
        if (this.objectTransform != null) {
            this.debugOutputLn(8, "objectTransform = " + this.objectTransform);
            if (lwsPrimitive.getObjectNode() != null) {
                this.debugOutputLn(8, "child has object node");
                if (this.hasPivot) {
                    this.pivotTransGroup.addChild((Node)lwsPrimitive.getObjectNode());
                } else {
                    this.objectTransform.addChild((Node)lwsPrimitive.getObjectNode());
                }
            }
        }
    }

    void createJava3dObject(LwsObject lwsObject, int n) {
        Object object;
        String string = new String("_sequence_");
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        LwsFrame lwsFrame = this.motion.getFirstFrame();
        lwsFrame.setMatrix(matrix4d);
        Transform3D transform3D = new Transform3D();
        transform3D.set(matrix4d);
        this.objectTransform = new TransformGroup(transform3D);
        this.objectTransform.setCapability(18);
        if (this.fileName != null && this.fileName.indexOf(string) != -1) {
            int n2 = this.fileName.indexOf(string);
            object = this.fileName.substring(n2 += string.length());
            int n3 = ((String)object).indexOf(".lwo");
            if (n3 != -1) {
                object = ((String)object).substring(0, n3);
            }
            if (new File((String)object).exists()) {
                SequenceReader sequenceReader = new SequenceReader((String)object, this.motion.totalTime, this.motion.totalFrames);
                sequenceReader.printLines();
                sequenceReader.createJava3dObjects(this.debugPrinter.getValidOutput(), n);
                TransformGroup transformGroup = sequenceReader.getObjectNode();
                if (transformGroup != null) {
                    this.objectTransform.addChild((Node)transformGroup);
                }
                this.objectBehavior = sequenceReader.getObjectBehaviors();
                return;
            }
        }
        if (this.fileName != null) {
            if (lwsObject == null) {
                this.debugOutputLn(2, "About to load binary file for " + this.fileName);
                J3dLwoParser j3dLwoParser = new J3dLwoParser(this.fileName, this.debugPrinter.getValidOutput());
                j3dLwoParser.createJava3dGeometry();
                if (this.hasPivot) {
                    this.objectTransform.addChild((Node)this.pivotTransGroup);
                }
                if (j3dLwoParser.getJava3dShapeList() != null) {
                    this.shapeList = j3dLwoParser.getJava3dShapeList();
                    object = this.shapeList.elements();
                    while (object.hasMoreElements()) {
                        if (!this.hasPivot || this.pivotTransGroup == null) {
                            this.objectTransform.addChild((Node)((Shape3D)object.nextElement()));
                            continue;
                        }
                        this.pivotTransGroup.addChild((Node)((Shape3D)object.nextElement()));
                    }
                }
            } else {
                this.debugOutputLn(8, "Cloning shapes");
                Vector vector = lwsObject.getShapeList();
                object = vector.elements();
                while (object.hasMoreElements()) {
                    this.debugOutputLn(8, "   shape clone");
                    Shape3D shape3D = (Shape3D)object.nextElement();
                    Shape3D shape3D2 = (Shape3D)shape3D.cloneTree();
                    this.objectTransform.addChild((Node)shape3D2);
                }
            }
        }
        this.objectBehavior = new Vector();
        if (n != 0) {
            this.motion.createJava3dBehaviors(this.objectTransform);
            Behavior behavior = this.motion.getBehaviors();
            if (behavior != null) {
                this.objectBehavior.addElement(behavior);
            }
        }
    }

    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    int getParent() {
        return this.parent;
    }

    String getQualifiedFilename(String string, String string2) {
        String string3;
        String string4 = "";
        if (string2.indexOf(File.separator) == 0) {
            int n = string2.lastIndexOf(File.separator);
            if (n != -1) {
                string4 = string2.substring(0, n + 1);
                string2 = string2.substring(n + 1);
            } else {
                return null;
            }
        }
        if (new File(String.valueOf(string4) + string2).exists()) {
            return String.valueOf(string4) + string2;
        }
        if (new File(String.valueOf(string4) + string2.toLowerCase()).exists()) {
            return String.valueOf(string4) + string2.toLowerCase();
        }
        if (new File(String.valueOf(string) + string2).exists()) {
            return String.valueOf(string) + string2;
        }
        if (new File(String.valueOf(string) + string2.toLowerCase()).exists()) {
            return String.valueOf(string) + string2.toLowerCase();
        }
        if (new File(string2).exists()) {
            return string2;
        }
        if (new File(string2.toLowerCase()).exists()) {
            return string2.toLowerCase();
        }
        if (string.equals(File.separator) || string == null || string.equals("")) {
            System.out.println("File not found:" + string2);
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(128);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.separator);
        int n = stringTokenizer.countTokens() - 1;
        if (string.startsWith(File.separator)) {
            stringBuffer.append(File.separator);
        }
        int n2 = 0;
        while (n2 < n) {
            string3 = stringTokenizer.nextToken();
            stringBuffer.append(string3);
            stringBuffer.append(File.separator);
            ++n2;
        }
        string3 = stringBuffer.toString();
        return this.getQualifiedFilename(string3, string2);
    }

    Vector getShapeList() {
        return this.shapeList;
    }

    void printVals() {
        this.debugOutputLn(2, "  OBJECT vals: ");
        this.debugOutputLn(2, "   fileName = " + this.fileName);
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

