/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.loaders.lw3d.LwsEnvelopeFrame;
import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.IOException;
import java.io.StreamTokenizer;
import javax.media.j3d.Behavior;
import javax.media.j3d.TransformGroup;

class LwsEnvelope
extends TextfileParser {
    String name;
    LwsEnvelopeFrame[] frames;
    int numFrames;
    int numChannels;
    boolean loop;
    float totalTime;
    int totalFrames;
    Behavior behaviors;

    LwsEnvelope(StreamTokenizer streamTokenizer, int n, float f) {
        try {
            this.numFrames = 0;
            this.totalTime = f;
            this.totalFrames = n;
            this.name = this.getName(streamTokenizer);
            this.getEnvelope(streamTokenizer);
        }
        catch (Exception exception) {
            this.debugOutputLn(16, "Exception in constructor: " + exception);
            return;
        }
    }

    void createJava3dBehaviors(TransformGroup transformGroup) {
        this.behaviors = null;
    }

    Behavior getBehaviors() {
        return this.behaviors;
    }

    void getEnvelope(StreamTokenizer streamTokenizer) throws IOException {
        this.debugOutputLn(1, "getEnvelope()");
        this.numChannels = (int)this.getNumber(streamTokenizer);
        if (this.numChannels != 1) {
            throw new IOException(J3dUtilsI18N.getString("LwsEnvelope0"));
        }
        this.debugOutputLn(8, "got channels");
        this.numFrames = (int)this.getNumber(streamTokenizer);
        this.frames = new LwsEnvelopeFrame[this.numFrames];
        this.debugOutputLn(2, "got frames" + this.numFrames);
        int n = 0;
        while (n < this.numFrames) {
            this.frames[n] = new LwsEnvelopeFrame(streamTokenizer);
            ++n;
        }
        this.debugOutput(8, "got all frames");
        streamTokenizer.nextToken();
        while (!this.isCurrentToken(streamTokenizer, "EndBehavior")) {
            streamTokenizer.nextToken();
        }
        int n2 = (int)this.getNumber(streamTokenizer);
        this.loop = n2 != 1;
    }

    LwsEnvelopeFrame getFirstFrame() {
        if (this.numFrames > 0) {
            return this.frames[0];
        }
        return null;
    }

    void printVals() {
        this.debugOutputLn(2, "   name = " + this.name);
        this.debugOutputLn(2, "   numChannels = " + this.numChannels);
        this.debugOutputLn(2, "   numFrames = " + this.numFrames);
        this.debugOutputLn(2, "   loop = " + this.loop);
        int n = 0;
        while (n < this.numFrames) {
            this.debugOutputLn(2, "       FRAME " + n);
            this.frames[n].printVals();
            ++n;
        }
    }
}

