/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.Sourcable;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class ReplaceMissingValues
extends PotentialClassIgnorer
implements Sourcable {
    static final long serialVersionUID = 8349568310991609867L;
    private double[] m_ModesAndMeans = null;

    public String globalInfo() {
        return "Replaces all missing values for nominal and numeric attributes in a dataset with the modes and means from the training data.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        this.m_ModesAndMeans = null;
        return true;
    }

    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_ModesAndMeans == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_ModesAndMeans == null) {
            double sumOfWeights = this.getInputFormat().sumOfWeights();
            double[][] counts = new double[this.getInputFormat().numAttributes()][];
            int i = 0;
            while (i < this.getInputFormat().numAttributes()) {
                if (this.getInputFormat().attribute(i).isNominal()) {
                    counts[i] = new double[this.getInputFormat().attribute(i).numValues()];
                    if (counts[i].length > 0) {
                        counts[i][0] = sumOfWeights;
                    }
                }
                ++i;
            }
            double[] sums = new double[this.getInputFormat().numAttributes()];
            int i2 = 0;
            while (i2 < sums.length) {
                sums[i2] = sumOfWeights;
                ++i2;
            }
            double[] results = new double[this.getInputFormat().numAttributes()];
            int j = 0;
            while (j < this.getInputFormat().numInstances()) {
                Instance inst = this.getInputFormat().instance(j);
                int i3 = 0;
                while (i3 < inst.numValues()) {
                    if (!inst.isMissingSparse(i3)) {
                        double value = inst.valueSparse(i3);
                        if (inst.attributeSparse(i3).isNominal()) {
                            if (counts[inst.index(i3)].length > 0) {
                                double[] dArray = counts[inst.index(i3)];
                                int n = (int)value;
                                dArray[n] = dArray[n] + inst.weight();
                                double[] dArray2 = counts[inst.index(i3)];
                                dArray2[0] = dArray2[0] - inst.weight();
                            }
                        } else if (inst.attributeSparse(i3).isNumeric()) {
                            int n = inst.index(i3);
                            results[n] = results[n] + inst.weight() * inst.valueSparse(i3);
                        }
                    } else if (inst.attributeSparse(i3).isNominal()) {
                        if (counts[inst.index(i3)].length > 0) {
                            double[] dArray = counts[inst.index(i3)];
                            dArray[0] = dArray[0] - inst.weight();
                        }
                    } else if (inst.attributeSparse(i3).isNumeric()) {
                        int n = inst.index(i3);
                        sums[n] = sums[n] - inst.weight();
                    }
                    ++i3;
                }
                ++j;
            }
            this.m_ModesAndMeans = new double[this.getInputFormat().numAttributes()];
            int i4 = 0;
            while (i4 < this.getInputFormat().numAttributes()) {
                if (this.getInputFormat().attribute(i4).isNominal()) {
                    this.m_ModesAndMeans[i4] = counts[i4].length == 0 ? Instance.missingValue() : (double)Utils.maxIndex(counts[i4]);
                } else if (this.getInputFormat().attribute(i4).isNumeric() && Utils.gr(sums[i4], 0.0)) {
                    this.m_ModesAndMeans[i4] = results[i4] / sums[i4];
                }
                ++i4;
            }
            i4 = 0;
            while (i4 < this.getInputFormat().numInstances()) {
                this.convertInstance(this.getInputFormat().instance(i4));
                ++i4;
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) {
        Instance inst = null;
        if (instance instanceof SparseInstance) {
            double[] vals = new double[instance.numValues()];
            int[] indices = new int[instance.numValues()];
            int num = 0;
            int j = 0;
            while (j < instance.numValues()) {
                if (instance.isMissingSparse(j) && this.getInputFormat().classIndex() != instance.index(j) && (instance.attributeSparse(j).isNominal() || instance.attributeSparse(j).isNumeric())) {
                    if (this.m_ModesAndMeans[instance.index(j)] != 0.0) {
                        vals[num] = this.m_ModesAndMeans[instance.index(j)];
                        indices[num] = instance.index(j);
                        ++num;
                    }
                } else {
                    vals[num] = instance.valueSparse(j);
                    indices[num] = instance.index(j);
                    ++num;
                }
                ++j;
            }
            if (num == instance.numValues()) {
                inst = new SparseInstance(instance.weight(), vals, indices, instance.numAttributes());
            } else {
                double[] tempVals = new double[num];
                int[] tempInd = new int[num];
                System.arraycopy(vals, 0, tempVals, 0, num);
                System.arraycopy(indices, 0, tempInd, 0, num);
                inst = new SparseInstance(instance.weight(), tempVals, tempInd, instance.numAttributes());
            }
        } else {
            double[] vals = new double[this.getInputFormat().numAttributes()];
            int j = 0;
            while (j < instance.numAttributes()) {
                vals[j] = instance.isMissing(j) && this.getInputFormat().classIndex() != j && (this.getInputFormat().attribute(j).isNominal() || this.getInputFormat().attribute(j).isNumeric()) ? this.m_ModesAndMeans[j] : instance.value(j);
                ++j;
            }
            inst = new Instance(instance.weight(), vals);
        }
        inst.setDataset(instance.dataset());
        this.push(inst);
    }

    public String toSource(String className, Instances data) throws Exception {
        StringBuffer result = new StringBuffer();
        boolean[] numeric = new boolean[data.numAttributes()];
        boolean[] nominal = new boolean[data.numAttributes()];
        String[] modes = new String[data.numAttributes()];
        double[] means = new double[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            numeric[i] = data.attribute(i).isNumeric() && i != data.classIndex();
            nominal[i] = data.attribute(i).isNominal() && i != data.classIndex();
            means[i] = numeric[i] ? this.m_ModesAndMeans[i] : Double.NaN;
            modes[i] = nominal[i] ? data.attribute(i).value((int)this.m_ModesAndMeans[i]) : null;
            ++i;
        }
        result.append("class " + className + " {\n");
        result.append("\n");
        result.append("  /** lists which numeric attributes will be processed */\n");
        result.append("  protected final static boolean[] NUMERIC = new boolean[]{" + Utils.arrayToString(numeric) + "};\n");
        result.append("\n");
        result.append("  /** lists which nominal attributes will be processed */\n");
        result.append("  protected final static boolean[] NOMINAL = new boolean[]{" + Utils.arrayToString(nominal) + "};\n");
        result.append("\n");
        result.append("  /** the means */\n");
        result.append("  protected final static double[] MEANS = new double[]{" + Utils.arrayToString(means).replaceAll("NaN", "Double.NaN") + "};\n");
        result.append("\n");
        result.append("  /** the modes */\n");
        result.append("  protected final static String[] MODES = new String[]{");
        i = 0;
        while (i < modes.length) {
            if (i > 0) {
                result.append(",");
            }
            if (nominal[i]) {
                result.append("\"" + Utils.quote(modes[i]) + "\"");
            } else {
                result.append(modes[i]);
            }
            ++i;
        }
        result.append("};\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters a single row\n");
        result.append("   * \n");
        result.append("   * @param i the row to process\n");
        result.append("   * @return the processed row\n");
        result.append("   */\n");
        result.append("  public static Object[] filter(Object[] i) {\n");
        result.append("    Object[] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      if (i[n] == null) {\n");
        result.append("        if (NUMERIC[n])\n");
        result.append("          result[n] = MEANS[n];\n");
        result.append("        else if (NOMINAL[n])\n");
        result.append("          result[n] = MODES[n];\n");
        result.append("        else\n");
        result.append("          result[n] = i[n];\n");
        result.append("      }\n");
        result.append("      else {\n");
        result.append("        result[n] = i[n];\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * filters multiple rows\n");
        result.append("   * \n");
        result.append("   * @param i the rows to process\n");
        result.append("   * @return the processed rows\n");
        result.append("   */\n");
        result.append("  public static Object[][] filter(Object[][] i) {\n");
        result.append("    Object[][] result;\n");
        result.append("\n");
        result.append("    result = new Object[i.length][];\n");
        result.append("    for (int n = 0; n < i.length; n++) {\n");
        result.append("      result[n] = filter(i[n]);\n");
        result.append("    }\n");
        result.append("\n");
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("}\n");
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5498 $");
    }

    public static void main(String[] argv) {
        ReplaceMissingValues.runFilter(new ReplaceMissingValues(), argv);
    }
}

