/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.experiment.ResultProducer;

public class DatabaseUtils
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -8252351994547116729L;
    public static final String EXP_INDEX_TABLE = "Experiment_index";
    public static final String EXP_TYPE_COL = "Experiment_type";
    public static final String EXP_SETUP_COL = "Experiment_setup";
    public static final String EXP_RESULT_COL = "Result_table";
    public static final String EXP_RESULT_PREFIX = "Results";
    public static final String PROPERTY_FILE = "weka/experiment/DatabaseUtils.props";
    protected Vector DRIVERS = new Vector();
    protected static Vector DRIVERS_ERRORS;
    protected Properties PROPERTIES;
    public static final int STRING = 0;
    public static final int BOOL = 1;
    public static final int DOUBLE = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INTEGER = 5;
    public static final int LONG = 6;
    public static final int FLOAT = 7;
    public static final int DATE = 8;
    public static final int TEXT = 9;
    public static final int TIME = 10;
    protected String m_DatabaseURL;
    protected transient PreparedStatement m_PreparedStatement;
    protected transient Connection m_Connection;
    protected boolean m_Debug = false;
    protected String m_userName = "";
    protected String m_password = "";
    protected String m_stringType = "LONGVARCHAR";
    protected String m_intType = "INT";
    protected String m_doubleType = "DOUBLE";
    protected boolean m_checkForUpperCaseNames = false;
    protected boolean m_checkForLowerCaseNames = false;
    protected boolean m_setAutoCommit = true;
    protected boolean m_createIndex = false;
    protected HashSet<String> m_Keywords = new HashSet();
    protected String m_KeywordsMaskChar = "_";

    public DatabaseUtils() throws Exception {
        if (DRIVERS_ERRORS == null) {
            DRIVERS_ERRORS = new Vector();
        }
        try {
            this.PROPERTIES = Utils.readProperties(PROPERTY_FILE);
            String drivers = this.PROPERTIES.getProperty("jdbcDriver", "jdbc.idbDriver");
            if (drivers == null) {
                throw new Exception("No database drivers (JDBC) specified");
            }
            StringTokenizer st = new StringTokenizer(drivers, ", ");
            while (st.hasMoreTokens()) {
                boolean result;
                String driver = st.nextToken();
                try {
                    Class.forName(driver);
                    this.DRIVERS.addElement(driver);
                    result = true;
                }
                catch (Exception e) {
                    result = false;
                }
                if (this.m_Debug || !result && !DRIVERS_ERRORS.contains(driver)) {
                    System.err.println("Trying to add database driver (JDBC): " + driver + " - " + (result ? "Success!" : "Error, not in CLASSPATH?"));
                }
                if (result) continue;
                DRIVERS_ERRORS.add(driver);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem reading properties. Fix before continuing.");
            System.err.println(ex);
        }
        this.m_DatabaseURL = this.PROPERTIES.getProperty("jdbcURL", "jdbc:idb=experiments.prp");
        this.m_stringType = this.PROPERTIES.getProperty("CREATE_STRING", "LONGVARCHAR");
        this.m_intType = this.PROPERTIES.getProperty("CREATE_INT", "INT");
        this.m_doubleType = this.PROPERTIES.getProperty("CREATE_DOUBLE", "DOUBLE");
        this.m_checkForUpperCaseNames = this.PROPERTIES.getProperty("checkUpperCaseNames", "false").equals("true");
        this.m_checkForLowerCaseNames = this.PROPERTIES.getProperty("checkLowerCaseNames", "false").equals("true");
        this.m_setAutoCommit = this.PROPERTIES.getProperty("setAutoCommit", "false").equals("true");
        this.m_createIndex = this.PROPERTIES.getProperty("createIndex", "false").equals("true");
        this.setKeywords(this.PROPERTIES.getProperty("Keywords", "AND,ASC,BY,DESC,FROM,GROUP,INSERT,ORDER,SELECT,UPDATE,WHERE"));
        this.setKeywordsMaskChar(this.PROPERTIES.getProperty("KeywordsMaskChar", "_"));
    }

    protected String attributeCaseFix(String columnName) {
        if (this.m_checkForUpperCaseNames) {
            String ucname = columnName.toUpperCase();
            if (ucname.equals(EXP_TYPE_COL.toUpperCase())) {
                return EXP_TYPE_COL;
            }
            if (ucname.equals(EXP_SETUP_COL.toUpperCase())) {
                return EXP_SETUP_COL;
            }
            if (ucname.equals(EXP_RESULT_COL.toUpperCase())) {
                return EXP_RESULT_COL;
            }
            return columnName;
        }
        if (this.m_checkForLowerCaseNames) {
            String ucname = columnName.toLowerCase();
            if (ucname.equals(EXP_TYPE_COL.toLowerCase())) {
                return EXP_TYPE_COL;
            }
            if (ucname.equals(EXP_SETUP_COL.toLowerCase())) {
                return EXP_SETUP_COL;
            }
            if (ucname.equals(EXP_RESULT_COL.toLowerCase())) {
                return EXP_RESULT_COL;
            }
            return columnName;
        }
        return columnName;
    }

    public int translateDBColumnType(String type) {
        try {
            String value = this.PROPERTIES.getProperty(type);
            String typeUnderscore = type.replaceAll(" ", "_");
            if (value == null) {
                value = this.PROPERTIES.getProperty(typeUnderscore);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Unknown data type: " + type + ". " + "Add entry in " + PROPERTY_FILE + ".\n" + "If the type contains blanks, either escape them with a backslash " + "or use underscores instead of blanks.");
        }
    }

    public static String arrayToString(Object[] array) {
        String result = "";
        if (array == null) {
            result = "<null>";
        } else {
            int i = 0;
            while (i < array.length) {
                result = array[i] == null ? String.valueOf(result) + " ?" : String.valueOf(result) + " " + array[i];
                ++i;
            }
        }
        return result;
    }

    public static String typeName(int type) {
        switch (type) {
            case -5: {
                return "BIGINT ";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 1: {
                return "CHAR";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 0: {
                return "NULL";
            }
            case 2: {
                return "NUMERIC";
            }
            case 1111: {
                return "OTHER";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "Unknown";
    }

    public String databaseURLTipText() {
        return "Set the URL to the database.";
    }

    public String getDatabaseURL() {
        return this.m_DatabaseURL;
    }

    public void setDatabaseURL(String newDatabaseURL) {
        this.m_DatabaseURL = newDatabaseURL;
    }

    public String debugTipText() {
        return "Whether debug information is printed.";
    }

    public void setDebug(boolean d) {
        this.m_Debug = d;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String usernameTipText() {
        return "The user to use for connecting to the database.";
    }

    public void setUsername(String username) {
        this.m_userName = username;
    }

    public String getUsername() {
        return this.m_userName;
    }

    public String passwordTipText() {
        return "The password to use for connecting to the database.";
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }

    /*
     * Unable to fully structure code
     */
    public void connectToDatabase() throws Exception {
        block14: {
            if (this.m_Debug) {
                System.err.println("Connecting to " + this.m_DatabaseURL);
            }
            if (this.m_Connection == null) {
                if (this.m_userName.equals("")) {
                    try {
                        this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL);
                        break block14;
                    }
                    catch (SQLException e) {
                        i = 0;
                        ** while (i < this.DRIVERS.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Class.forName((String)this.DRIVERS.elementAt(i));
                        }
                        catch (Exception var3_5) {
                            // empty catch block
                        }
                        ++i;
                        continue;
                    }
lbl19:
                    // 1 sources

                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL);
                } else {
                    try {
                        this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
                        break block14;
                    }
                    catch (SQLException e) {
                        i = 0;
                        ** while (i < this.DRIVERS.size())
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Class.forName((String)this.DRIVERS.elementAt(i));
                        }
                        catch (Exception var3_6) {
                            // empty catch block
                        }
                        ++i;
                        continue;
                    }
lbl35:
                    // 1 sources

                    this.m_Connection = DriverManager.getConnection(this.m_DatabaseURL, this.m_userName, this.m_password);
                }
            }
        }
        this.m_Connection.setAutoCommit(this.m_setAutoCommit);
    }

    public void disconnectFromDatabase() throws Exception {
        if (this.m_Debug) {
            System.err.println("Disconnecting from " + this.m_DatabaseURL);
        }
        if (this.m_Connection != null) {
            this.m_Connection.close();
            this.m_Connection = null;
        }
    }

    public boolean isConnected() {
        return this.m_Connection != null;
    }

    public boolean isCursorScrollSensitive() {
        boolean result = false;
        try {
            if (this.isConnected()) {
                result = this.m_Connection.getMetaData().supportsResultSetConcurrency(1005, 1007);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean isCursorScrollable() {
        return this.getSupportedCursorScrollType() != -1;
    }

    public int getSupportedCursorScrollType() {
        int result = -1;
        try {
            if (this.isConnected()) {
                if (this.m_Connection.getMetaData().supportsResultSetConcurrency(1005, 1007)) {
                    result = 1005;
                }
                if (result == -1 && this.m_Connection.getMetaData().supportsResultSetConcurrency(1004, 1007)) {
                    result = 1004;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public boolean execute(String query) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        this.m_PreparedStatement = !this.isCursorScrollable() ? this.m_Connection.prepareStatement(query, 1003, 1007) : this.m_Connection.prepareStatement(query, this.getSupportedCursorScrollType(), 1007);
        return this.m_PreparedStatement.execute();
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.m_PreparedStatement != null) {
            return this.m_PreparedStatement.getResultSet();
        }
        return null;
    }

    public int update(String query) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        Statement statement = !this.isCursorScrollable() ? this.m_Connection.createStatement(1003, 1007) : this.m_Connection.createStatement(this.getSupportedCursorScrollType(), 1007);
        int result = statement.executeUpdate(query);
        statement.close();
        return result;
    }

    public ResultSet select(String query) throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        Statement statement = !this.isCursorScrollable() ? this.m_Connection.createStatement(1003, 1007) : this.m_Connection.createStatement(this.getSupportedCursorScrollType(), 1007);
        ResultSet result = statement.executeQuery(query);
        return result;
    }

    public void close(ResultSet rs) {
        try {
            Statement statement = rs.getStatement();
            rs.close();
            statement.close();
            statement = null;
            rs = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void close() {
        if (this.m_PreparedStatement != null) {
            try {
                this.m_PreparedStatement.close();
                this.m_PreparedStatement = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean tableExists(String tableName) throws Exception {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected, please connect first!");
        }
        if (this.m_Debug) {
            System.err.println("Checking if table " + tableName + " exists...");
        }
        DatabaseMetaData dbmd = this.m_Connection.getMetaData();
        ResultSet rs = this.m_checkForUpperCaseNames ? dbmd.getTables(null, null, tableName.toUpperCase(), null) : (this.m_checkForLowerCaseNames ? dbmd.getTables(null, null, tableName.toLowerCase(), null) : dbmd.getTables(null, null, tableName, null));
        boolean tableExists = rs.next();
        if (rs.next()) {
            throw new Exception("This table seems to exist more than once!");
        }
        rs.close();
        if (this.m_Debug) {
            if (tableExists) {
                System.err.println("... " + tableName + " exists");
            } else {
                System.err.println("... " + tableName + " does not exist");
            }
        }
        return tableExists;
    }

    public static String processKeyString(String s) {
        return s.replaceAll("\\\\", "/").replaceAll("'", "''");
    }

    protected boolean isKeyInTable(String tableName, ResultProducer rp, Object[] key) throws Exception {
        String query = "SELECT Key_Run FROM " + tableName;
        String[] keyNames = rp.getKeyNames();
        if (keyNames.length != key.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        boolean first = true;
        int i = 0;
        while (i < key.length) {
            if (key[i] != null) {
                if (first) {
                    query = String.valueOf(query) + " WHERE ";
                    first = false;
                } else {
                    query = String.valueOf(query) + " AND ";
                }
                query = String.valueOf(query) + "Key_" + keyNames[i] + '=';
                query = key[i] instanceof String ? String.valueOf(query) + "'" + DatabaseUtils.processKeyString(key[i].toString()) + "'" : String.valueOf(query) + key[i].toString();
            }
            ++i;
        }
        boolean retval = false;
        ResultSet rs = this.select(query);
        if (rs.next()) {
            retval = true;
            if (rs.next()) {
                throw new Exception("More than one result entry for result key: " + query);
            }
        }
        this.close(rs);
        return retval;
    }

    public Object[] getResultFromTable(String tableName, ResultProducer rp, Object[] key) throws Exception {
        String query = "SELECT ";
        String[] resultNames = rp.getResultNames();
        int i = 0;
        while (i < resultNames.length) {
            if (i != 0) {
                query = String.valueOf(query) + ", ";
            }
            query = String.valueOf(query) + resultNames[i];
            ++i;
        }
        query = String.valueOf(query) + " FROM " + tableName;
        String[] keyNames = rp.getKeyNames();
        if (keyNames.length != key.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        boolean first = true;
        int i2 = 0;
        while (i2 < key.length) {
            if (key[i2] != null) {
                if (first) {
                    query = String.valueOf(query) + " WHERE ";
                    first = false;
                } else {
                    query = String.valueOf(query) + " AND ";
                }
                query = String.valueOf(query) + "Key_" + keyNames[i2] + '=';
                query = key[i2] instanceof String ? String.valueOf(query) + "'" + DatabaseUtils.processKeyString(key[i2].toString()) + "'" : String.valueOf(query) + key[i2].toString();
            }
            ++i2;
        }
        ResultSet rs = this.select(query);
        ResultSetMetaData md = rs.getMetaData();
        int numAttributes = md.getColumnCount();
        if (!rs.next()) {
            throw new Exception("No result for query: " + query);
        }
        Object[] result = new Object[numAttributes];
        int i3 = 1;
        while (i3 <= numAttributes) {
            switch (this.translateDBColumnType(md.getColumnTypeName(i3))) {
                case 0: {
                    result[i3 - 1] = rs.getString(i3);
                    if (!rs.wasNull()) break;
                    result[i3 - 1] = null;
                    break;
                }
                case 2: 
                case 7: {
                    result[i3 - 1] = new Double(rs.getDouble(i3));
                    if (!rs.wasNull()) break;
                    result[i3 - 1] = null;
                    break;
                }
                default: {
                    throw new Exception("Unhandled SQL result type (field " + (i3 + 1) + "): " + DatabaseUtils.typeName(md.getColumnType(i3)));
                }
            }
            ++i3;
        }
        if (rs.next()) {
            throw new Exception("More than one result entry for result key: " + query);
        }
        this.close(rs);
        return result;
    }

    public void putResultInTable(String tableName, ResultProducer rp, Object[] key, Object[] result) throws Exception {
        String query = "INSERT INTO " + tableName + " VALUES ( ";
        int i = 0;
        while (i < key.length) {
            if (i != 0) {
                query = String.valueOf(query) + ',';
            }
            query = key[i] != null ? (key[i] instanceof String ? String.valueOf(query) + "'" + DatabaseUtils.processKeyString(key[i].toString()) + "'" : (key[i] instanceof Double ? String.valueOf(query) + this.safeDoubleToString((Double)key[i]) : String.valueOf(query) + key[i].toString())) : String.valueOf(query) + "NULL";
            ++i;
        }
        i = 0;
        while (i < result.length) {
            query = String.valueOf(query) + ',';
            query = result[i] != null ? (result[i] instanceof String ? String.valueOf(query) + "'" + result[i].toString() + "'" : (result[i] instanceof Double ? String.valueOf(query) + this.safeDoubleToString((Double)result[i]) : String.valueOf(query) + result[i].toString())) : String.valueOf(query) + "NULL";
            ++i;
        }
        query = String.valueOf(query) + ')';
        if (this.m_Debug) {
            System.err.println("Submitting result: " + query);
        }
        this.update(query);
        this.close();
    }

    private String safeDoubleToString(Double number) {
        if (number.isNaN()) {
            return "NULL";
        }
        String orig = number.toString();
        int pos = orig.indexOf(69);
        if (pos == -1 || orig.charAt(pos + 1) == '-') {
            return orig;
        }
        StringBuffer buff = new StringBuffer(orig);
        buff.insert(pos + 1, '+');
        return new String(buff);
    }

    public boolean experimentIndexExists() throws Exception {
        return this.tableExists(EXP_INDEX_TABLE);
    }

    public void createExperimentIndex() throws Exception {
        if (this.m_Debug) {
            System.err.println("Creating experiment index table...");
        }
        String query = "CREATE TABLE Experiment_index ( Experiment_type " + this.m_stringType + "," + "  " + EXP_SETUP_COL + " " + this.m_stringType + "," + "  " + EXP_RESULT_COL + " " + this.m_intType + " )";
        this.update(query);
        this.close();
    }

    public String createExperimentIndexEntry(ResultProducer rp) throws Exception {
        String tableName;
        if (this.m_Debug) {
            System.err.println("Creating experiment index entry...");
        }
        int numRows = 0;
        String query = "SELECT COUNT(*) FROM Experiment_index";
        ResultSet rs = this.select(query);
        if (this.m_Debug) {
            System.err.println("...getting number of rows");
        }
        if (rs.next()) {
            numRows = rs.getInt(1);
        }
        this.close(rs);
        String expType = rp.getClass().getName();
        String expParams = rp.getCompatibilityState();
        query = "INSERT INTO Experiment_index VALUES ('" + expType + "', '" + expParams + "', " + numRows + " )";
        if (this.update(query) > 0 && this.m_Debug) {
            System.err.println("...create returned resultset");
        }
        this.close();
        if (!this.m_setAutoCommit) {
            this.m_Connection.commit();
            this.m_Connection.setAutoCommit(true);
        }
        if ((tableName = this.getResultsTableName(rp)) == null) {
            throw new Exception("Problem adding experiment index entry");
        }
        try {
            query = "DROP TABLE " + tableName;
            if (this.m_Debug) {
                System.err.println(query);
            }
            this.update(query);
        }
        catch (SQLException ex) {
            System.err.println(ex.getMessage());
        }
        return tableName;
    }

    public String getResultsTableName(ResultProducer rp) throws Exception {
        if (this.m_Debug) {
            System.err.println("Getting results table name...");
        }
        String expType = rp.getClass().getName();
        String expParams = rp.getCompatibilityState();
        String query = "SELECT Result_table FROM Experiment_index WHERE Experiment_type='" + expType + "' AND " + EXP_SETUP_COL + "='" + expParams + "'";
        String tableName = null;
        ResultSet rs = this.select(query);
        if (rs.next()) {
            tableName = rs.getString(1);
            if (rs.next()) {
                throw new Exception("More than one index entry for experiment config: " + query);
            }
        }
        this.close(rs);
        if (this.m_Debug) {
            System.err.println("...results table = " + (tableName == null ? "<null>" : EXP_RESULT_PREFIX + tableName));
        }
        return tableName == null ? tableName : EXP_RESULT_PREFIX + tableName;
    }

    public String createResultsTable(ResultProducer rp, String tableName) throws Exception {
        Object[] types;
        if (this.m_Debug) {
            System.err.println("Creating results table " + tableName + "...");
        }
        String query = "CREATE TABLE " + tableName + " ( ";
        String[] names = rp.getKeyNames();
        if (names.length != (types = rp.getKeyTypes()).length) {
            throw new Exception("key names types differ in length");
        }
        int i = 0;
        while (i < names.length) {
            query = String.valueOf(query) + "Key_" + names[i] + " ";
            if (types[i] instanceof Double) {
                query = String.valueOf(query) + this.m_doubleType;
            } else if (types[i] instanceof String) {
                query = String.valueOf(query) + this.m_stringType + " ";
            } else {
                throw new Exception("Unknown/unsupported field type in key");
            }
            query = String.valueOf(query) + ", ";
            ++i;
        }
        names = rp.getResultNames();
        if (names.length != (types = rp.getResultTypes()).length) {
            throw new Exception("result names and types differ in length");
        }
        i = 0;
        while (i < names.length) {
            query = String.valueOf(query) + names[i] + " ";
            if (types[i] instanceof Double) {
                query = String.valueOf(query) + this.m_doubleType;
            } else if (types[i] instanceof String) {
                query = String.valueOf(query) + this.m_stringType + " ";
            } else {
                throw new Exception("Unknown/unsupported field type in key");
            }
            if (i < names.length - 1) {
                query = String.valueOf(query) + ", ";
            }
            ++i;
        }
        query = String.valueOf(query) + " )";
        this.update(query);
        if (this.m_Debug) {
            System.err.println("table created");
        }
        this.close();
        if (this.m_createIndex) {
            query = "CREATE UNIQUE INDEX Key_IDX ON " + tableName + " (";
            String[] keyNames = rp.getKeyNames();
            boolean first = true;
            int i2 = 0;
            while (i2 < keyNames.length) {
                if (keyNames[i2] != null) {
                    if (first) {
                        first = false;
                        query = String.valueOf(query) + "Key_" + keyNames[i2];
                    } else {
                        query = String.valueOf(query) + ",Key_" + keyNames[i2];
                    }
                }
                ++i2;
            }
            query = String.valueOf(query) + ")";
            this.update(query);
        }
        return tableName;
    }

    public void setKeywords(String value) {
        this.m_Keywords.clear();
        String[] keywords = value.replaceAll(" ", "").split(",");
        int i = 0;
        while (i < keywords.length) {
            this.m_Keywords.add(keywords[i].toUpperCase());
            ++i;
        }
    }

    public String getKeywords() {
        Vector<String> list = new Vector<String>(this.m_Keywords);
        Collections.sort(list);
        String result = "";
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + list.get(i);
            ++i;
        }
        return result;
    }

    public void setKeywordsMaskChar(String value) {
        this.m_KeywordsMaskChar = value;
    }

    public String getKeywordsMaskChar() {
        return this.m_KeywordsMaskChar;
    }

    public boolean isKeyword(String s) {
        return this.m_Keywords.contains(s.toUpperCase());
    }

    public String maskKeyword(String s) {
        if (this.isKeyword(s)) {
            return String.valueOf(s) + this.m_KeywordsMaskChar;
        }
        return s;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5238 $");
    }
}

