/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.pmml.DerivedFieldMetaInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLUtils;
import weka.gui.Logger;

public class MappingInfo
implements Serializable {
    public static final int UNKNOWN_NOMINAL_VALUE = -1;
    private int[] m_fieldsMap = null;
    private int[][] m_nominalValueMaps = null;
    private String m_fieldsMappingText = null;
    private Logger m_log = null;

    public MappingInfo(Instances dataSet, MiningSchema miningSchema, Logger log) throws Exception {
        this.m_log = log;
        Instances fieldsI = miningSchema.getMiningSchemaAsInstances();
        this.m_fieldsMap = new int[fieldsI.numAttributes()];
        this.m_nominalValueMaps = new int[fieldsI.numAttributes()][];
        int i = 0;
        while (i < fieldsI.numAttributes()) {
            String schemaAttName = fieldsI.attribute(i).name();
            boolean found = false;
            int j = 0;
            while (j < dataSet.numAttributes()) {
                if (dataSet.attribute(j).name().equals(schemaAttName)) {
                    Attribute miningSchemaAtt = fieldsI.attribute(i);
                    Attribute incomingAtt = dataSet.attribute(j);
                    if (miningSchemaAtt.type() != incomingAtt.type()) {
                        throw new Exception("[MappingInfo] type mismatch for field " + schemaAttName + ". Mining schema type " + miningSchemaAtt.toString() + ". Incoming type " + incomingAtt.toString() + ".");
                    }
                    if (miningSchemaAtt.numValues() != incomingAtt.numValues()) {
                        String warningString = "[MappingInfo] WARNING: incoming nominal attribute " + incomingAtt.name() + " does not have the same " + "number of values as the corresponding mining " + "schema attribute.";
                        if (this.m_log != null) {
                            this.m_log.logMessage(warningString);
                        } else {
                            System.err.println(warningString);
                        }
                    }
                    if (miningSchemaAtt.isNominal() || miningSchemaAtt.isString()) {
                        int[] valuesMap = new int[incomingAtt.numValues()];
                        int k = 0;
                        while (k < incomingAtt.numValues()) {
                            String incomingNomVal = incomingAtt.value(k);
                            int indexInSchema = miningSchemaAtt.indexOfValue(incomingNomVal);
                            if (indexInSchema < 0) {
                                String warningString = "[MappingInfo] WARNING: incoming nominal attribute " + incomingAtt.name() + " has value " + incomingNomVal + " that doesn't occur in the mining schema.";
                                if (this.m_log != null) {
                                    this.m_log.logMessage(warningString);
                                } else {
                                    System.err.println(warningString);
                                }
                                valuesMap[k] = -1;
                            } else {
                                valuesMap[k] = indexInSchema;
                            }
                            ++k;
                        }
                        this.m_nominalValueMaps[i] = valuesMap;
                    }
                    found = true;
                    this.m_fieldsMap[i] = j;
                }
                ++j;
            }
            if (!found) {
                throw new Exception("[MappingInfo] Unable to find a match for mining schema attribute " + schemaAttName + " in the " + "incoming instances!");
            }
            ++i;
        }
        if (fieldsI.classIndex() >= 0) {
            if (dataSet.classIndex() < 0) {
                String className = fieldsI.classAttribute().name();
                Attribute classMatch = dataSet.attribute(className);
                if (classMatch == null) {
                    throw new Exception("[MappingInfo] Can't find match for target field " + className + "in incoming instances!");
                }
                dataSet.setClass(classMatch);
            } else if (!fieldsI.classAttribute().name().equals(dataSet.classAttribute().name())) {
                throw new Exception("[MappingInfo] class attribute in mining schema does not match class attribute in incoming instances!");
            }
        }
        this.fieldsMappingString(fieldsI, dataSet);
    }

    private void fieldsMappingString(Instances miningSchemaI, Instances incomingI) {
        StringBuffer result = new StringBuffer();
        int maxLength = 0;
        int i = 0;
        while (i < miningSchemaI.numAttributes()) {
            if (miningSchemaI.attribute(i).name().length() > maxLength) {
                maxLength = miningSchemaI.attribute(i).name().length();
            }
            ++i;
        }
        int minLength = 13;
        String headerS = "Mining schema";
        String sep = "-------------";
        if ((maxLength += 12) < minLength) {
            maxLength = minLength;
        }
        headerS = PMMLUtils.pad(headerS, " ", maxLength, false);
        sep = PMMLUtils.pad(sep, "-", maxLength, false);
        sep = String.valueOf(sep) + "\t    ----------------\n";
        headerS = String.valueOf(headerS) + "\t    Incoming fields\n";
        result.append(headerS);
        result.append(sep);
        int i2 = 0;
        while (i2 < miningSchemaI.numAttributes()) {
            Attribute temp = miningSchemaI.attribute(i2);
            String attName = "(" + (temp.isNumeric() ? "numeric)" : "nominal)") + " " + temp.name();
            attName = PMMLUtils.pad(attName, " ", maxLength, false);
            attName = String.valueOf(attName) + "\t--> ";
            result.append(attName);
            Attribute incoming = incomingI.attribute(this.m_fieldsMap[i2]);
            String fieldName = this.m_fieldsMap[i2] + 1 + " (" + (incoming.isNumeric() ? "numeric)" : "nominal)");
            fieldName = String.valueOf(fieldName) + " " + incoming.name();
            result.append(String.valueOf(fieldName) + "\n");
            ++i2;
        }
        this.m_fieldsMappingText = result.toString();
    }

    public double[] instanceToSchema(Instance inst, MiningSchema miningSchema) throws Exception {
        Instances miningSchemaI = miningSchema.getMiningSchemaAsInstances();
        double[] result = new double[miningSchema.getFieldsAsInstances().numAttributes()];
        int i = 0;
        while (i < miningSchemaI.numAttributes()) {
            result[i] = inst.value(this.m_fieldsMap[i]);
            if ((miningSchemaI.attribute(i).isNominal() || miningSchemaI.attribute(i).isString()) && !Instance.isMissingValue(inst.value(this.m_fieldsMap[i]))) {
                int[] valueMap = this.m_nominalValueMaps[i];
                int index = valueMap[(int)inst.value(this.m_fieldsMap[i])];
                String incomingAttValue = inst.attribute(this.m_fieldsMap[i]).value((int)inst.value(this.m_fieldsMap[i]));
                if (index >= 0) {
                    result[i] = index;
                } else {
                    result[i] = -1.0;
                    String warningString = "[MappingInfo] WARNING: Can't match nominal value " + incomingAttValue;
                    if (this.m_log != null) {
                        this.m_log.logMessage(warningString);
                    } else {
                        System.err.println(warningString);
                    }
                }
            }
            ++i;
        }
        miningSchema.applyMissingAndOutlierTreatments(result);
        ArrayList<DerivedFieldMetaInfo> derivedFields = miningSchema.getDerivedFields();
        int i2 = 0;
        while (i2 < derivedFields.size()) {
            double r;
            DerivedFieldMetaInfo temp = derivedFields.get(i2);
            result[i2 + miningSchemaI.numAttributes()] = r = temp.getDerivedValue(result);
            ++i2;
        }
        return result;
    }

    public String getFieldsMappingString() {
        if (this.m_fieldsMappingText == null) {
            return "No fields mapping constructed!";
        }
        return this.m_fieldsMappingText;
    }
}

