/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.Utils;
import weka.core.pmml.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuiltInMath
extends Function {
    private static final long serialVersionUID = -8092338695602573652L;
    protected MathFunc m_func = MathFunc.ABS;

    public BuiltInMath(MathFunc func) {
        this.m_func = func;
        this.m_functionName = this.m_func.toString();
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        this.m_parameterDefs = paramDefs;
        if (!this.m_func.legalNumParams(this.m_parameterDefs.size())) {
            throw new Exception("[BuiltInMath] illegal number of parameters for function: " + this.m_functionName);
        }
    }

    @Override
    public Attribute getOutputDef() {
        return new Attribute("BuiltInMathResult:" + this.m_func.toString());
    }

    @Override
    public String[] getParameterNames() {
        return this.m_func.getParameterNames();
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (this.m_parameterDefs == null) {
            throw new Exception("[BuiltInMath] incoming parameter structure has not been set");
        }
        if (!this.m_func.legalNumParams(incoming.length)) {
            throw new Exception("[BuiltInMath] wrong number of parameters!");
        }
        double result = this.m_func.eval(incoming);
        return result;
    }

    @Override
    public String toString() {
        String result = String.valueOf(this.m_func.toString()) + "(";
        int i = 0;
        while (i < this.m_parameterDefs.size()) {
            result = String.valueOf(result) + ((Attribute)this.m_parameterDefs.get(i)).name();
            result = i != this.m_parameterDefs.size() - 1 ? String.valueOf(result) + ", " : String.valueOf(result) + ")";
            ++i;
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MathFunc {
        MIN("min"){

            double eval(double[] args) {
                return args[Utils.minIndex(args)];
            }

            boolean legalNumParams(int num) {
                return num > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        MAX("max"){

            double eval(double[] args) {
                return args[Utils.maxIndex(args)];
            }

            boolean legalNumParams(int num) {
                return num > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        SUM("sum"){

            double eval(double[] args) {
                return Utils.sum(args);
            }

            boolean legalNumParams(int num) {
                return num > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        AVG("avg"){

            double eval(double[] args) {
                return Utils.mean(args);
            }

            boolean legalNumParams(int num) {
                return num > 0;
            }

            String[] getParameterNames() {
                return null;
            }
        }
        ,
        LOG10("log10"){

            double eval(double[] args) {
                return Math.log10(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        LN("ln"){

            double eval(double[] args) {
                return Math.log(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        SQRT("sqrt"){

            double eval(double[] args) {
                return Math.sqrt(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ABS("abs"){

            double eval(double[] args) {
                return Math.abs(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        EXP("exp"){

            double eval(double[] args) {
                return Math.exp(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        POW("pow"){

            double eval(double[] args) {
                return Math.pow(args[0], args[1]);
            }

            boolean legalNumParams(int num) {
                return num == 2;
            }

            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        THRESHOLD("threshold"){

            double eval(double[] args) {
                if (args[0] > args[1]) {
                    return 1.0;
                }
                return 0.0;
            }

            boolean legalNumParams(int num) {
                return num == 2;
            }

            String[] getParameterNames() {
                return new String[]{"A", "B"};
            }
        }
        ,
        FLOOR("floor"){

            double eval(double[] args) {
                return Math.floor(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        CEIL("ceil"){

            double eval(double[] args) {
                return Math.ceil(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        }
        ,
        ROUND("round"){

            double eval(double[] args) {
                return Math.round(args[0]);
            }

            boolean legalNumParams(int num) {
                return num == 1;
            }

            String[] getParameterNames() {
                return new String[]{"A"};
            }
        };

        private final String m_stringVal;

        abstract double eval(double[] var1);

        abstract boolean legalNumParams(int var1);

        abstract String[] getParameterNames();

        private MathFunc(String funcName) {
            this.m_stringVal = funcName;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }
}

