/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;

public class SVMLightLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = 4988360125354664417L;
    public static String FILE_EXTENSION = ".dat";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected Vector m_Buffer = null;

    public String globalInfo() {
        return "Reads a source that is in svm light format.\n\nFor more information about svm light see:\n\nhttp://svmlight.joachims.org/";
    }

    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public String getFileDescription() {
        return "svm light data files";
    }

    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        if (this.m_File != null) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    public String retrieveURL() {
        return this.m_URL;
    }

    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    protected double[] svmlightToArray(String row) throws Exception {
        double[] result;
        try {
            int index;
            String col;
            int max = 0;
            StringTokenizer tok = new StringTokenizer(row, " \t");
            tok.nextToken();
            while (tok.hasMoreTokens()) {
                col = tok.nextToken();
                if (col.startsWith("#")) break;
                if (col.startsWith("qid:") || (index = Integer.parseInt(col.substring(0, col.indexOf(":")))) <= max) continue;
                max = index;
            }
            tok = new StringTokenizer(row, " \t");
            result = new double[max + 1];
            result[result.length - 1] = Double.parseDouble(tok.nextToken());
            while (tok.hasMoreTokens()) {
                col = tok.nextToken();
                if (!col.startsWith("#")) {
                    double value;
                    if (col.startsWith("qid:")) continue;
                    index = Integer.parseInt(col.substring(0, col.indexOf(":")));
                    result[index - 1] = value = Double.parseDouble(col.substring(col.indexOf(":") + 1));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing line '" + row + "': " + e);
            throw new Exception(e);
        }
        return result;
    }

    protected int determineNumAttributes(double[] values, int num) throws Exception {
        int count = values.length;
        int result = num;
        if (count > result) {
            result = count;
        }
        return result;
    }

    protected Attribute determineClassAttribute() {
        Attribute result;
        boolean binary = true;
        int i = 0;
        while (i < this.m_Buffer.size()) {
            double[] dbls = (double[])this.m_Buffer.get(i);
            double cls = dbls[dbls.length - 1];
            if (cls != -1.0 && cls != 1.0) {
                binary = false;
                break;
            }
            ++i;
        }
        if (binary) {
            FastVector values = new FastVector();
            values.addElement("+1");
            values.addElement("-1");
            result = new Attribute("class", values);
        } else {
            result = new Attribute("class");
        }
        return result;
    }

    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.m_Buffer = new Vector();
            try {
                int cInt;
                int numAtt = 0;
                StringBuffer line = new StringBuffer();
                while ((cInt = this.m_sourceReader.read()) != -1) {
                    char c = (char)cInt;
                    if (c == '\n' || c == '\r') {
                        if (line.length() > 0 && line.charAt(0) != '#') {
                            try {
                                this.m_Buffer.add(this.svmlightToArray(line.toString()));
                                numAtt = this.determineNumAttributes((double[])this.m_Buffer.lastElement(), numAtt);
                            }
                            catch (Exception e) {
                                throw new Exception("Error parsing line '" + line + "': " + e);
                            }
                        }
                        line = new StringBuffer();
                        continue;
                    }
                    line.append(c);
                }
                if (line.length() != 0 && line.charAt(0) != '#') {
                    this.m_Buffer.add(this.svmlightToArray(line.toString()));
                    numAtt = this.determineNumAttributes((double[])this.m_Buffer.lastElement(), numAtt);
                }
                FastVector atts = new FastVector(numAtt);
                int i = 0;
                while (i < numAtt - 1) {
                    atts.addElement(new Attribute("att_" + (i + 1)));
                    ++i;
                }
                atts.addElement(this.determineClassAttribute());
                String relName = !this.m_URL.equals("http://") ? this.m_URL : this.m_File;
                this.m_structure = new Instances(relName, atts, 0);
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("Unable to determine structure as svm light: " + ex);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        Instances result = new Instances(this.m_structure, 0);
        int i = 0;
        while (i < this.m_Buffer.size()) {
            double[] data;
            double[] sparse = (double[])this.m_Buffer.get(i);
            if (sparse.length != this.m_structure.numAttributes()) {
                data = new double[this.m_structure.numAttributes()];
                System.arraycopy(sparse, 0, data, 0, sparse.length - 1);
                data[data.length - 1] = sparse[sparse.length - 1];
            } else {
                data = sparse;
            }
            if (result.classAttribute().isNominal()) {
                if (data[data.length - 1] == 1.0) {
                    data[data.length - 1] = result.classAttribute().indexOfValue("+1");
                } else if (data[data.length - 1] == -1.0) {
                    data[data.length - 1] = result.classAttribute().indexOfValue("-1");
                } else {
                    throw new IllegalStateException("Class is not binary!");
                }
            }
            result.add(new SparseInstance(1.0, data));
            ++i;
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("SVMLightLoader can't read data sets incrementally.");
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4983 $");
    }

    public static void main(String[] args) {
        SVMLightLoader.runFileLoader(new SVMLightLoader(), args);
    }
}

