/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.MatlabLoader;

public class MatlabSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    private static final long serialVersionUID = 4118356803697172614L;
    public static String FILE_EXTENSION = MatlabLoader.FILE_EXTENSION;
    protected boolean m_UseDouble;
    protected boolean m_UseTabs;
    protected boolean m_HeaderWritten;
    protected DecimalFormat m_Format;

    public MatlabSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes Matlab ASCII files, in single or double precision format.";
    }

    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tUse double precision format.\n\t(default: single precision)", "double", 0, "-double"));
        result.addElement(new Option("\tUse tabs as separator.\n\t(default: blanks)", "tabs", 0, "-tabs"));
        return result.elements();
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getUseDouble()) {
            result.add("-double");
        }
        if (this.getUseTabs()) {
            result.add("-tabs");
        }
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        this.setUseDouble(Utils.getFlag("double", options));
        this.setUseTabs(Utils.getFlag("tabs", options));
    }

    public String getFileDescription() {
        return "Matlab ASCII files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(MatlabLoader.FILE_EXTENSION);
        this.setUseDouble(false);
        this.setUseTabs(false);
        this.m_HeaderWritten = false;
    }

    public void setUseDouble(boolean value) {
        this.m_UseDouble = value;
        this.m_Format = this.m_UseDouble ? new DecimalFormat("   0.0000000000000000E00;  -0.0000000000000000E00") : new DecimalFormat("   0.00000000E00;  -0.00000000E00");
    }

    public boolean getUseDouble() {
        return this.m_UseDouble;
    }

    public String useDoubleTipText() {
        return "Sets whether to use double instead of single precision.";
    }

    public void setUseTabs(boolean value) {
        this.m_UseTabs = value;
    }

    public boolean getUseTabs() {
        return this.m_UseTabs;
    }

    public String useTabsTipText() {
        return "Sets whether to use tabs as separators instead of blanks.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    protected String matlabHeader() {
        StringBuffer result = new StringBuffer();
        result.append("% Relation: " + this.getInstances().relationName() + "\n");
        result.append("% Generated on: " + new Date() + "\n");
        result.append("% Generated by: WEKA " + Version.VERSION + "\n");
        result.append("%\n");
        result.append("%  ");
        int i = 0;
        while (i < this.getInstances().numAttributes()) {
            if (i > 0) {
                result.append(this.m_UseTabs ? "\t   " : "    ");
            }
            result.append(Utils.padRight(this.getInstances().attribute(i).name(), (this.m_UseDouble ? 16 : 8) + 5));
            ++i;
        }
        return result.toString();
    }

    protected String instanceToMatlab(Instance inst) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < inst.numAttributes()) {
            if (i > 0) {
                result.append(this.m_UseTabs ? "\t" : " ");
            }
            result.append(this.m_Format.format(inst.value(i)));
            ++i;
        }
        return result.toString();
    }

    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure (Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            if (this.retrieveFile() == null || outW == null) {
                System.out.println(this.matlabHeader());
            } else {
                outW.println(this.matlabHeader());
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null || outW == null) {
                    System.out.println(this.instanceToMatlab(inst));
                } else {
                    outW.println(this.instanceToMatlab(inst));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            System.out.println(this.matlabHeader());
            int i = 0;
            while (i < this.getInstances().numInstances()) {
                System.out.println(this.instanceToMatlab(this.getInstances().instance(i)));
                ++i;
            }
            this.setWriteMode(1);
        } else {
            PrintWriter outW = new PrintWriter(this.getWriter());
            outW.println(this.matlabHeader());
            int i = 0;
            while (i < this.getInstances().numInstances()) {
                outW.println(this.instanceToMatlab(this.getInstances().instance(i)));
                ++i;
            }
            outW.flush();
            outW.close();
            this.setWriteMode(1);
            outW = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5417 $");
    }

    public static void main(String[] args) {
        MatlabSaver.runFileSaver(new MatlabSaver(), args);
    }
}

