/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;

public class CSVSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter,
FileSourcedConverter {
    static final long serialVersionUID = 476636654410701807L;
    protected String m_FieldSeparator = ",";
    protected String m_MissingValue = "?";

    public CSVSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in csv format.";
    }

    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe field separator to be used.\n\t'\\t' can be used as well.\n\t(default: ',')", "S", 1, "-S <separator>"));
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default: ?)", "M", 1, "-M <str>"));
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setUseTab(Utils.getFlag('T', options));
        String tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        } else {
            this.setMissingValue("?");
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getUseTab()) {
            result.add("-T");
        }
        result.add("-M");
        result.add(this.getMissingValue());
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setUseTab(boolean value) {
        this.m_FieldSeparator = value ? "\t" : ",";
    }

    public boolean getUseTab() {
        return this.m_FieldSeparator.equals("\t");
    }

    public String useTabTipText() {
        return "Whether to use TAB instead of COMMA as field separator.";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is '?'.";
    }

    public String getFileDescription() {
        return "CSV file: comma separated files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".csv");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            if (this.retrieveFile() == null || outW == null) {
                int i = 0;
                while (i < structure.numAttributes()) {
                    System.out.print(structure.attribute(i).name());
                    if (i < structure.numAttributes() - 1) {
                        System.out.print(this.m_FieldSeparator);
                    } else {
                        System.out.println();
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < structure.numAttributes()) {
                    outW.print(structure.attribute(i).name());
                    if (i < structure.numAttributes() - 1) {
                        outW.print(this.m_FieldSeparator);
                    } else {
                        outW.println();
                    }
                    ++i;
                }
                outW.flush();
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null || outW == null) {
                    System.out.println(inst);
                } else {
                    outW.println(this.instanceToString(inst));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            int i = 0;
            while (i < this.getInstances().numAttributes()) {
                System.out.print(this.getInstances().attribute(i).name());
                if (i < this.getInstances().numAttributes() - 1) {
                    System.out.print(this.m_FieldSeparator);
                } else {
                    System.out.println();
                }
                ++i;
            }
            i = 0;
            while (i < this.getInstances().numInstances()) {
                System.out.println(this.getInstances().instance(i));
                ++i;
            }
            this.setWriteMode(1);
            return;
        }
        PrintWriter outW = new PrintWriter(this.getWriter());
        int i = 0;
        while (i < this.getInstances().numAttributes()) {
            outW.print(this.getInstances().attribute(i).name());
            if (i < this.getInstances().numAttributes() - 1) {
                outW.print(this.m_FieldSeparator);
            } else {
                outW.println();
            }
            ++i;
        }
        i = 0;
        while (i < this.getInstances().numInstances()) {
            outW.println(this.instanceToString(this.getInstances().instance(i)));
            ++i;
        }
        outW.flush();
        outW.close();
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    protected String instanceToString(Instance inst) {
        Instance outInst;
        StringBuffer result = new StringBuffer();
        if (inst instanceof SparseInstance) {
            outInst = new Instance(inst.weight(), inst.toDoubleArray());
            outInst.setDataset(inst.dataset());
        } else {
            outInst = inst;
        }
        int i = 0;
        while (i < outInst.numAttributes()) {
            if (i > 0) {
                result.append(this.m_FieldSeparator);
            }
            if (outInst.isMissing(i)) {
                result.append(this.m_MissingValue);
            } else {
                result.append(outInst.toString(i));
            }
            ++i;
        }
        return result.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4917 $");
    }

    public static void main(String[] args) {
        CSVSaver.runFileSaver(new CSVSaver(), args);
    }
}

