/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import weka.core.FastVector;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.AbstractSaver;
import weka.core.converters.ArffLoader;
import weka.core.converters.FileSourcedConverter;

public abstract class AbstractFileSaver
extends AbstractSaver
implements OptionHandler,
FileSourcedConverter {
    private File m_outputFile;
    private BufferedWriter m_writer;
    private String FILE_EXTENSION;
    private String m_prefix;
    private String m_dir;
    protected int m_incrementalCounter;
    protected boolean m_useRelativePath = false;

    public void resetOptions() {
        super.resetOptions();
        this.m_outputFile = null;
        this.m_writer = null;
        this.m_prefix = "";
        this.m_dir = "";
        this.m_incrementalCounter = 0;
    }

    public BufferedWriter getWriter() {
        return this.m_writer;
    }

    public void resetWriter() {
        this.m_writer = null;
    }

    public String getFileExtension() {
        return this.FILE_EXTENSION;
    }

    protected void setFileExtension(String paramString) {
        this.FILE_EXTENSION = paramString;
    }

    public File retrieveFile() {
        return this.m_outputFile;
    }

    public void setFile(File paramFile) throws IOException {
        this.m_outputFile = paramFile;
    }

    public void setFilePrefix(String paramString) {
        this.m_prefix = paramString;
    }

    public String filePrefix() {
        return this.m_prefix;
    }

    public void setDir(String paramString) {
        this.m_dir = paramString;
    }

    public String retrieveDir() {
        return this.m_dir;
    }

    public Enumeration listOptions() {
        FastVector localFastVector = new FastVector(2);
        localFastVector.addElement(new Option("The input file", "i", 1, "-i <the input file>"));
        localFastVector.addElement(new Option("The output file", "o", 1, "-o <the output file>"));
        return localFastVector.elements();
    }

    public void setUseRelativePath(boolean rp) {
        this.m_useRelativePath = rp;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    public void setOptions(String[] paramArrayOfString) throws Exception {
        String str1 = Utils.getOption('o', paramArrayOfString);
        String str2 = Utils.getOption('i', paramArrayOfString);
        ArffLoader localArffLoader = new ArffLoader();
        this.resetOptions();
        if (str2.length() != 0) {
            try {
                File localFile1 = new File(str2);
                localArffLoader.setFile(localFile1);
                this.setInstances(localArffLoader.getDataSet());
            }
            catch (Exception localException1) {
                throw new IOException("No data set loaded. Data set has to be in ARFF format.");
            }
            throw new IOException("No data set to save.");
        }
        if (str1.length() != 0) {
            if (!str1.endsWith(this.FILE_EXTENSION)) {
                str1 = str1.lastIndexOf(46) != -1 ? String.valueOf(str1.substring(0, str1.lastIndexOf(46))) + this.FILE_EXTENSION : String.valueOf(str1) + this.FILE_EXTENSION;
            }
            try {
                try {
                    File localFile2 = new File(str1);
                    this.setFile(localFile2);
                }
                catch (Exception exception) {
                    this.setDestination(this.m_outputFile);
                }
            }
            finally {
                this.setDestination(this.m_outputFile);
            }
        }
    }

    public String[] getOptions() {
        String[] arrayOfString = new String[10];
        int i = 0;
        if (this.m_outputFile != null) {
            arrayOfString[i++] = "-o";
            arrayOfString[i++] = "" + this.m_outputFile;
        } else {
            arrayOfString[i++] = "-o";
            arrayOfString[i++] = "";
        }
        if (this.getInstances() != null) {
            arrayOfString[i++] = "-i";
            arrayOfString[i++] = this.getInstances().relationName();
        } else {
            arrayOfString[i++] = "-i";
            arrayOfString[i++] = "";
        }
        while (i < arrayOfString.length) {
            arrayOfString[i++] = "";
        }
        return arrayOfString;
    }

    public void cancel() {
        if (this.getWriteMode() == 2) {
            if (this.m_outputFile != null && this.m_outputFile.exists() && this.m_outputFile.delete()) {
                System.out.println("File deleted.");
            }
            this.resetOptions();
        }
    }

    protected static String makeOptionStr(AbstractFileSaver saver) {
        StringBuffer result = new StringBuffer();
        result.append("\n");
        result.append(saver.getClass().getName().replaceAll(".*\\.", ""));
        result.append(" options:\n\n");
        Enumeration enm = saver.listOptions();
        while (enm.hasMoreElements()) {
            Option option = (Option)enm.nextElement();
            result.append(String.valueOf(option.synopsis()) + "\n");
            result.append(String.valueOf(option.description()) + "\n");
        }
        return result.toString();
    }

    public static void runFileSaver(AbstractFileSaver saver, String[] options) {
        try {
            String[] tmpOptions = (String[])options.clone();
            if (Utils.getFlag('h', tmpOptions)) {
                System.err.println("\nHelp requested\n" + AbstractFileSaver.makeOptionStr(saver));
                return;
            }
        }
        catch (Exception tmpOptions) {
            // empty catch block
        }
        try {
            try {
                saver.setOptions(options);
            }
            catch (Exception ex) {
                System.err.println(AbstractFileSaver.makeOptionStr(saver));
                System.exit(1);
            }
            saver.writeBatch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setDestination(File paramFile) throws IOException {
        boolean bool = false;
        String str1 = paramFile.getAbsolutePath();
        if (this.m_outputFile != null) {
            try {
                try {
                    if (paramFile.exists()) {
                        if (paramFile.delete()) {
                            System.out.println("File exists and will be overridden.");
                        } else {
                            throw new IOException("File already exists.");
                        }
                    }
                    if (str1.lastIndexOf(File.separatorChar) == -1) {
                        bool = paramFile.createNewFile();
                    } else {
                        String str2 = str1.substring(0, str1.lastIndexOf(File.separatorChar));
                        File localFile = new File(str2);
                        if (localFile.exists()) {
                            bool = paramFile.createNewFile();
                        } else {
                            localFile.mkdirs();
                            bool = paramFile.createNewFile();
                        }
                    }
                    if (bool) {
                        this.m_outputFile = paramFile;
                        this.setDestination(new FileOutputStream(this.m_outputFile));
                    }
                }
                catch (Exception exception) {
                    if (!bool) {
                        System.err.println("Cannot create a new output file. Standard out is used.");
                        this.m_outputFile = null;
                    }
                }
            }
            finally {
                if (!bool) {
                    System.err.println("Cannot create a new output file. Standard out is used.");
                    this.m_outputFile = null;
                }
            }
        }
    }

    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    public void setDestination(OutputStream paramOutputStream) throws IOException {
        this.m_writer = new BufferedWriter(new OutputStreamWriter(paramOutputStream));
    }

    public void setDirAndPrefix(String paramString1, String paramString2) {
        try {
            if (this.m_dir.equals("")) {
                this.m_dir = System.getProperty("user.dir");
            }
            if (this.m_prefix.equals("")) {
                this.setFile(new File(String.valueOf(this.m_dir) + File.separator + paramString1 + paramString2 + this.FILE_EXTENSION));
            } else {
                this.setFile(new File(String.valueOf(this.m_dir) + File.separator + this.m_prefix + "_" + paramString1 + paramString2 + this.FILE_EXTENSION));
            }
            this.setDestination(this.m_outputFile);
        }
        catch (Exception localException) {
            System.err.println("File prefix and/or directory could not have been set.");
            localException.printStackTrace();
        }
    }

    public abstract String getFileDescription();
}

