/*
 * Decompiled with CFR 0.152.
 */
package weka.core.MatrixFolder;

import java.io.Serializable;
import weka.core.MatrixFolder.Maths;
import weka.core.MatrixFolder.MatrixOther;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SingularValueDecomposition
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8738089610999867951L;
    private double[][] U;
    private double[][] V;
    private double[] s;
    private int m;
    private int n;

    public SingularValueDecomposition(MatrixOther Arg) {
        int i;
        double t;
        int k;
        int j;
        double[][] A = Arg.getArrayCopy();
        this.m = Arg.getRowDimension();
        this.n = Arg.getColumnDimension();
        int nu = Math.min(this.m, this.n);
        this.s = new double[Math.min(this.m + 1, this.n)];
        this.U = new double[this.m][nu];
        this.V = new double[this.n][this.n];
        double[] e = new double[this.n];
        double[] work = new double[this.m];
        boolean wantu = true;
        boolean wantv = true;
        int nct = Math.min(this.m - 1, this.n);
        int nrt = Math.max(0, Math.min(this.n - 2, this.m));
        int k2 = 0;
        while (k2 < Math.max(nct, nrt)) {
            int i2;
            int i3;
            if (k2 < nct) {
                this.s[k2] = 0.0;
                i3 = k2;
                while (i3 < this.m) {
                    this.s[k2] = Maths.hypot(this.s[k2], A[i3][k2]);
                    ++i3;
                }
                if (this.s[k2] != 0.0) {
                    if (A[k2][k2] < 0.0) {
                        this.s[k2] = -this.s[k2];
                    }
                    i3 = k2;
                    while (i3 < this.m) {
                        double[] dArray = A[i3];
                        int n = k2;
                        dArray[n] = dArray[n] / this.s[k2];
                        ++i3;
                    }
                    double[] dArray = A[k2];
                    int n = k2;
                    dArray[n] = dArray[n] + 1.0;
                }
                this.s[k2] = -this.s[k2];
            }
            j = k2 + 1;
            while (j < this.n) {
                if (k2 < nct & this.s[k2] != 0.0) {
                    double t2 = 0.0;
                    i2 = k2;
                    while (i2 < this.m) {
                        t2 += A[i2][k2] * A[i2][j];
                        ++i2;
                    }
                    t2 = -t2 / A[k2][k2];
                    i2 = k2;
                    while (i2 < this.m) {
                        double[] dArray = A[i2];
                        int n = j;
                        dArray[n] = dArray[n] + t2 * A[i2][k2];
                        ++i2;
                    }
                }
                e[j] = A[k2][j];
                ++j;
            }
            if (wantu & k2 < nct) {
                i3 = k2;
                while (i3 < this.m) {
                    this.U[i3][k2] = A[i3][k2];
                    ++i3;
                }
            }
            if (k2 < nrt) {
                e[k2] = 0.0;
                i3 = k2 + 1;
                while (i3 < this.n) {
                    e[k2] = Maths.hypot(e[k2], e[i3]);
                    ++i3;
                }
                if (e[k2] != 0.0) {
                    if (e[k2 + 1] < 0.0) {
                        e[k2] = -e[k2];
                    }
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        int n = i3++;
                        e[n] = e[n] / e[k2];
                    }
                    int n = k2 + 1;
                    e[n] = e[n] + 1.0;
                }
                e[k2] = -e[k2];
                if (k2 + 1 < this.m & e[k2] != 0.0) {
                    i3 = k2 + 1;
                    while (i3 < this.m) {
                        work[i3] = 0.0;
                        ++i3;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        int i4 = k2 + 1;
                        while (i4 < this.m) {
                            int n = i4;
                            work[n] = work[n] + e[j] * A[i4][j];
                            ++i4;
                        }
                        ++j;
                    }
                    j = k2 + 1;
                    while (j < this.n) {
                        double t3 = -e[j] / e[k2 + 1];
                        i2 = k2 + 1;
                        while (i2 < this.m) {
                            double[] dArray = A[i2];
                            int n = j;
                            dArray[n] = dArray[n] + t3 * work[i2];
                            ++i2;
                        }
                        ++j;
                    }
                }
                if (wantv) {
                    i3 = k2 + 1;
                    while (i3 < this.n) {
                        this.V[i3][k2] = e[i3];
                        ++i3;
                    }
                }
            }
            ++k2;
        }
        int p = Math.min(this.n, this.m + 1);
        if (nct < this.n) {
            this.s[nct] = A[nct][nct];
        }
        if (this.m < p) {
            this.s[p - 1] = 0.0;
        }
        if (nrt + 1 < p) {
            e[nrt] = A[nrt][p - 1];
        }
        e[p - 1] = 0.0;
        if (wantu) {
            j = nct;
            while (j < nu) {
                int i5 = 0;
                while (i5 < this.m) {
                    this.U[i5][j] = 0.0;
                    ++i5;
                }
                this.U[j][j] = 1.0;
                ++j;
            }
            k = nct - 1;
            while (k >= 0) {
                int i6;
                if (this.s[k] != 0.0) {
                    int j2 = k + 1;
                    while (j2 < nu) {
                        t = 0.0;
                        i = k;
                        while (i < this.m) {
                            t += this.U[i][k] * this.U[i][j2];
                            ++i;
                        }
                        t = -t / this.U[k][k];
                        i = k;
                        while (i < this.m) {
                            double[] dArray = this.U[i];
                            int n = j2;
                            dArray[n] = dArray[n] + t * this.U[i][k];
                            ++i;
                        }
                        ++j2;
                    }
                    i6 = k;
                    while (i6 < this.m) {
                        this.U[i6][k] = -this.U[i6][k];
                        ++i6;
                    }
                    this.U[k][k] = 1.0 + this.U[k][k];
                    i6 = 0;
                    while (i6 < k - 1) {
                        this.U[i6][k] = 0.0;
                        ++i6;
                    }
                } else {
                    i6 = 0;
                    while (i6 < this.m) {
                        this.U[i6][k] = 0.0;
                        ++i6;
                    }
                    this.U[k][k] = 1.0;
                }
                --k;
            }
        }
        if (wantv) {
            k = this.n - 1;
            while (k >= 0) {
                if (k < nrt & e[k] != 0.0) {
                    int j3 = k + 1;
                    while (j3 < nu) {
                        t = 0.0;
                        i = k + 1;
                        while (i < this.n) {
                            t += this.V[i][k] * this.V[i][j3];
                            ++i;
                        }
                        t = -t / this.V[k + 1][k];
                        i = k + 1;
                        while (i < this.n) {
                            double[] dArray = this.V[i];
                            int n = j3;
                            dArray[n] = dArray[n] + t * this.V[i][k];
                            ++i;
                        }
                        ++j3;
                    }
                }
                int i7 = 0;
                while (i7 < this.n) {
                    this.V[i7][k] = 0.0;
                    ++i7;
                }
                this.V[k][k] = 1.0;
                --k;
            }
        }
        int pp = p - 1;
        int iter = 0;
        double eps = Math.pow(2.0, -52.0);
        double tiny = Math.pow(2.0, -966.0);
        block35: while (p > 0) {
            int kase;
            int k3 = p - 2;
            while (k3 >= -1) {
                if (k3 == -1) break;
                if (Math.abs(e[k3]) <= tiny + eps * (Math.abs(this.s[k3]) + Math.abs(this.s[k3 + 1]))) {
                    e[k3] = 0.0;
                    break;
                }
                --k3;
            }
            if (k3 == p - 2) {
                kase = 4;
            } else {
                int ks = p - 1;
                while (ks >= k3) {
                    if (ks == k3) break;
                    double t4 = (ks != p ? Math.abs(e[ks]) : 0.0) + (ks != k3 + 1 ? Math.abs(e[ks - 1]) : 0.0);
                    if (Math.abs(this.s[ks]) <= tiny + eps * t4) {
                        this.s[ks] = 0.0;
                        break;
                    }
                    --ks;
                }
                if (ks == k3) {
                    kase = 3;
                } else if (ks == p - 1) {
                    kase = 1;
                } else {
                    kase = 2;
                    k3 = ks;
                }
            }
            ++k3;
            switch (kase) {
                case 1: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[p - 2];
                    e[p - 2] = 0.0;
                    int j4 = p - 2;
                    while (j4 >= k3) {
                        t5 = Maths.hypot(this.s[j4], f);
                        cs = this.s[j4] / t5;
                        sn = f / t5;
                        this.s[j4] = t5;
                        if (j4 != k3) {
                            f = -sn * e[j4 - 1];
                            e[j4 - 1] = cs * e[j4 - 1];
                        }
                        if (wantv) {
                            i8 = 0;
                            while (i8 < this.n) {
                                t5 = cs * this.V[i8][j4] + sn * this.V[i8][p - 1];
                                this.V[i8][p - 1] = -sn * this.V[i8][j4] + cs * this.V[i8][p - 1];
                                this.V[i8][j4] = t5;
                                ++i8;
                            }
                        }
                        --j4;
                    }
                    continue block35;
                }
                case 2: {
                    int i8;
                    double sn;
                    double cs;
                    double t5;
                    double f = e[k3 - 1];
                    e[k3 - 1] = 0.0;
                    int j5 = k3;
                    while (j5 < p) {
                        t5 = Maths.hypot(this.s[j5], f);
                        cs = this.s[j5] / t5;
                        sn = f / t5;
                        this.s[j5] = t5;
                        f = -sn * e[j5];
                        e[j5] = cs * e[j5];
                        if (wantu) {
                            i8 = 0;
                            while (i8 < this.m) {
                                t5 = cs * this.U[i8][j5] + sn * this.U[i8][k3 - 1];
                                this.U[i8][k3 - 1] = -sn * this.U[i8][j5] + cs * this.U[i8][k3 - 1];
                                this.U[i8][j5] = t5;
                                ++i8;
                            }
                        }
                        ++j5;
                    }
                    continue block35;
                }
                case 3: {
                    double scale = Math.max(Math.max(Math.max(Math.max(Math.abs(this.s[p - 1]), Math.abs(this.s[p - 2])), Math.abs(e[p - 2])), Math.abs(this.s[k3])), Math.abs(e[k3]));
                    double sp = this.s[p - 1] / scale;
                    double spm1 = this.s[p - 2] / scale;
                    double epm1 = e[p - 2] / scale;
                    double sk = this.s[k3] / scale;
                    double ek = e[k3] / scale;
                    double b = ((spm1 + sp) * (spm1 - sp) + epm1 * epm1) / 2.0;
                    double c = sp * epm1 * (sp * epm1);
                    double shift = 0.0;
                    if (b != 0.0 | c != 0.0) {
                        shift = Math.sqrt(b * b + c);
                        if (b < 0.0) {
                            shift = -shift;
                        }
                        shift = c / (b + shift);
                    }
                    double f = (sk + sp) * (sk - sp) + shift;
                    double g = sk * ek;
                    int j6 = k3;
                    while (j6 < p - 1) {
                        int i9;
                        double t6 = Maths.hypot(f, g);
                        double cs = f / t6;
                        double sn = g / t6;
                        if (j6 != k3) {
                            e[j6 - 1] = t6;
                        }
                        f = cs * this.s[j6] + sn * e[j6];
                        e[j6] = cs * e[j6] - sn * this.s[j6];
                        g = sn * this.s[j6 + 1];
                        this.s[j6 + 1] = cs * this.s[j6 + 1];
                        if (wantv) {
                            i9 = 0;
                            while (i9 < this.n) {
                                t6 = cs * this.V[i9][j6] + sn * this.V[i9][j6 + 1];
                                this.V[i9][j6 + 1] = -sn * this.V[i9][j6] + cs * this.V[i9][j6 + 1];
                                this.V[i9][j6] = t6;
                                ++i9;
                            }
                        }
                        t6 = Maths.hypot(f, g);
                        cs = f / t6;
                        sn = g / t6;
                        this.s[j6] = t6;
                        f = cs * e[j6] + sn * this.s[j6 + 1];
                        this.s[j6 + 1] = -sn * e[j6] + cs * this.s[j6 + 1];
                        g = sn * e[j6 + 1];
                        e[j6 + 1] = cs * e[j6 + 1];
                        if (wantu && j6 < this.m - 1) {
                            i9 = 0;
                            while (i9 < this.m) {
                                t6 = cs * this.U[i9][j6] + sn * this.U[i9][j6 + 1];
                                this.U[i9][j6 + 1] = -sn * this.U[i9][j6] + cs * this.U[i9][j6 + 1];
                                this.U[i9][j6] = t6;
                                ++i9;
                            }
                        }
                        ++j6;
                    }
                    e[p - 2] = f;
                    ++iter;
                    break;
                }
                case 4: {
                    if (this.s[k3] <= 0.0) {
                        double d = this.s[k3] = this.s[k3] < 0.0 ? -this.s[k3] : 0.0;
                        if (wantv) {
                            int i10 = 0;
                            while (i10 <= pp) {
                                this.V[i10][k3] = -this.V[i10][k3];
                                ++i10;
                            }
                        }
                    }
                    while (k3 < pp) {
                        int i11;
                        if (this.s[k3] >= this.s[k3 + 1]) break;
                        double t7 = this.s[k3];
                        this.s[k3] = this.s[k3 + 1];
                        this.s[k3 + 1] = t7;
                        if (wantv && k3 < this.n - 1) {
                            i11 = 0;
                            while (i11 < this.n) {
                                t7 = this.V[i11][k3 + 1];
                                this.V[i11][k3 + 1] = this.V[i11][k3];
                                this.V[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        if (wantu && k3 < this.m - 1) {
                            i11 = 0;
                            while (i11 < this.m) {
                                t7 = this.U[i11][k3 + 1];
                                this.U[i11][k3 + 1] = this.U[i11][k3];
                                this.U[i11][k3] = t7;
                                ++i11;
                            }
                        }
                        ++k3;
                    }
                    iter = 0;
                    --p;
                }
            }
        }
    }

    public MatrixOther getU() {
        return new MatrixOther(this.U, this.m, Math.min(this.m + 1, this.n));
    }

    public MatrixOther getV() {
        return new MatrixOther(this.V, this.n, this.n);
    }

    public double[] getSingularValues() {
        return this.s;
    }

    public MatrixOther getS() {
        MatrixOther X = new MatrixOther(this.n, this.n);
        double[][] S = X.getArray();
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                S[i][j] = 0.0;
                ++j;
            }
            S[i][i] = this.s[i];
            ++i;
        }
        return X;
    }

    public double norm2() {
        return this.s[0];
    }

    public double cond() {
        return this.s[0] / this.s[Math.min(this.m, this.n) - 1];
    }

    public int rank() {
        double eps = Math.pow(2.0, -52.0);
        double tol = (double)Math.max(this.m, this.n) * this.s[0] * eps;
        int r = 0;
        int i = 0;
        while (i < this.s.length) {
            if (this.s[i] > tol) {
                ++r;
            }
            ++i;
        }
        return r;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.5 $");
    }
}

