/*
 * Decompiled with CFR 0.152.
 */
package weka.core.MatrixFolder;

import java.io.Serializable;
import weka.core.MatrixFolder.Maths;
import weka.core.MatrixFolder.MatrixOther;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class QRDecomposition
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -5013090736132211418L;
    private double[][] QR;
    private int m;
    private int n;
    private double[] Rdiag;

    public QRDecomposition(MatrixOther A) {
        this.QR = A.getArrayCopy();
        this.m = A.getRowDimension();
        this.n = A.getColumnDimension();
        this.Rdiag = new double[this.n];
        int k = 0;
        while (k < this.n) {
            double nrm = 0.0;
            int i = k;
            while (i < this.m) {
                nrm = Maths.hypot(nrm, this.QR[i][k]);
                ++i;
            }
            if (nrm != 0.0) {
                if (this.QR[k][k] < 0.0) {
                    nrm = -nrm;
                }
                i = k;
                while (i < this.m) {
                    double[] dArray = this.QR[i];
                    int n = k;
                    dArray[n] = dArray[n] / nrm;
                    ++i;
                }
                double[] dArray = this.QR[k];
                int n = k;
                dArray[n] = dArray[n] + 1.0;
                int j = k + 1;
                while (j < this.n) {
                    double s = 0.0;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.QR[i2][k] * this.QR[i2][j];
                        ++i2;
                    }
                    s = -s / this.QR[k][k];
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray2 = this.QR[i2];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + s * this.QR[i2][k];
                        ++i2;
                    }
                    ++j;
                }
            }
            this.Rdiag[k] = -nrm;
            ++k;
        }
    }

    public boolean isFullRank() {
        int j = 0;
        while (j < this.n) {
            if (this.Rdiag[j] == 0.0) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public MatrixOther getH() {
        MatrixOther X = new MatrixOther(this.m, this.n);
        double[][] H = X.getArray();
        int i = 0;
        while (i < this.m) {
            int j = 0;
            while (j < this.n) {
                H[i][j] = i >= j ? this.QR[i][j] : 0.0;
                ++j;
            }
            ++i;
        }
        return X;
    }

    public MatrixOther getR() {
        MatrixOther X = new MatrixOther(this.n, this.n);
        double[][] R = X.getArray();
        int i = 0;
        while (i < this.n) {
            int j = 0;
            while (j < this.n) {
                R[i][j] = i < j ? this.QR[i][j] : (i == j ? this.Rdiag[i] : 0.0);
                ++j;
            }
            ++i;
        }
        return X;
    }

    public MatrixOther getQ() {
        MatrixOther X = new MatrixOther(this.m, this.n);
        double[][] Q = X.getArray();
        int k = this.n - 1;
        while (k >= 0) {
            int i = 0;
            while (i < this.m) {
                Q[i][k] = 0.0;
                ++i;
            }
            Q[k][k] = 1.0;
            int j = k;
            while (j < this.n) {
                if (this.QR[k][k] != 0.0) {
                    double s = 0.0;
                    int i2 = k;
                    while (i2 < this.m) {
                        s += this.QR[i2][k] * Q[i2][j];
                        ++i2;
                    }
                    s = -s / this.QR[k][k];
                    i2 = k;
                    while (i2 < this.m) {
                        double[] dArray = Q[i2];
                        int n = j;
                        dArray[n] = dArray[n] + s * this.QR[i2][k];
                        ++i2;
                    }
                }
                ++j;
            }
            --k;
        }
        return X;
    }

    public MatrixOther solve(MatrixOther B) {
        int j;
        if (B.getRowDimension() != this.m) {
            throw new IllegalArgumentException("MatrixOther row dimensions must agree.");
        }
        if (!this.isFullRank()) {
            throw new RuntimeException("MatrixOther is rank deficient.");
        }
        int nx = B.getColumnDimension();
        double[][] X = B.getArrayCopy();
        int k = 0;
        while (k < this.n) {
            j = 0;
            while (j < nx) {
                double s = 0.0;
                int i = k;
                while (i < this.m) {
                    s += this.QR[i][k] * X[i][j];
                    ++i;
                }
                s = -s / this.QR[k][k];
                i = k;
                while (i < this.m) {
                    double[] dArray = X[i];
                    int n = j;
                    dArray[n] = dArray[n] + s * this.QR[i][k];
                    ++i;
                }
                ++j;
            }
            ++k;
        }
        k = this.n - 1;
        while (k >= 0) {
            j = 0;
            while (j < nx) {
                double[] dArray = X[k];
                int n = j++;
                dArray[n] = dArray[n] / this.Rdiag[k];
            }
            int i = 0;
            while (i < k) {
                int j2 = 0;
                while (j2 < nx) {
                    double[] dArray = X[i];
                    int n = j2;
                    dArray[n] = dArray[n] - X[k][j2] * this.QR[i][k];
                    ++j2;
                }
                ++i;
            }
            --k;
        }
        return new MatrixOther(X, this.n, nx).getMatrixOther(0, this.n - 1, 0, nx - 1);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }
}

