/*
 * Decompiled with CFR 0.152.
 */
package weka.core.MatrixFolder;

import java.util.Arrays;
import weka.core.MatrixFolder.FlexibleDecimalFormat;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class IntVector
implements Cloneable,
RevisionHandler {
    int[] V;
    private int sizeOfVector;

    public IntVector() {
        this.V = new int[0];
        this.setSize(0);
    }

    public IntVector(int n) {
        this.V = new int[n];
        this.setSize(n);
    }

    public IntVector(int n, int s) {
        this(n);
        this.set(s);
    }

    public IntVector(int[] v) {
        if (v == null) {
            this.V = new int[0];
            this.setSize(0);
        } else {
            this.V = new int[v.length];
            this.setSize(v.length);
            this.set(0, this.size() - 1, v, 0);
        }
    }

    public int size() {
        return this.sizeOfVector;
    }

    public void setSize(int size) {
        if (size > this.capacity()) {
            throw new IllegalArgumentException("insufficient capacity");
        }
        this.sizeOfVector = size;
    }

    public void set(int s) {
        int i = 0;
        while (i < this.size()) {
            this.set(i, s);
            ++i;
        }
    }

    public void set(int i0, int i1, int[] v, int j0) {
        int i = i0;
        while (i <= i1) {
            this.set(i, v[j0 + i - i0]);
            ++i;
        }
    }

    public void set(int i0, int i1, IntVector v, int j0) {
        int i = i0;
        while (i <= i1) {
            this.set(i, v.get(j0 + i - i0));
            ++i;
        }
    }

    public void set(IntVector v) {
        this.set(0, v.size() - 1, v, 0);
    }

    public static IntVector seq(int i0, int i1) {
        if (i1 < i0) {
            throw new IllegalArgumentException("i1 < i0 ");
        }
        IntVector v = new IntVector(i1 - i0 + 1);
        int i = 0;
        while (i < i1 - i0 + 1) {
            v.set(i, i + i0);
            ++i;
        }
        return v;
    }

    public int[] getArray() {
        return this.V;
    }

    protected void setArray(int[] a) {
        this.V = a;
    }

    public void sort() {
        Arrays.sort(this.V, 0, this.size());
    }

    public int[] getArrayCopy() {
        int[] b = new int[this.size()];
        int i = 0;
        while (i <= this.size() - 1) {
            b[i] = this.V[i];
            ++i;
        }
        return b;
    }

    public int capacity() {
        return this.V.length;
    }

    public void setCapacity(int capacity) {
        if (capacity == this.capacity()) {
            return;
        }
        int[] old_V = this.V;
        int m = Math.min(capacity, this.size());
        this.V = new int[capacity];
        this.setSize(capacity);
        this.set(0, m - 1, old_V, 0);
    }

    public void set(int i, int s) {
        this.V[i] = s;
    }

    public int get(int i) {
        return this.V[i];
    }

    public IntVector copy() {
        return (IntVector)this.clone();
    }

    public Object clone() {
        IntVector u = new IntVector(this.size());
        int i = 0;
        while (i < this.size()) {
            u.V[i] = this.V[i];
            ++i;
        }
        return u;
    }

    public IntVector subvector(int i0, int i1) {
        IntVector v = new IntVector(i1 - i0 + 1);
        v.set(0, i1 - i0, this, i0);
        return v;
    }

    public IntVector subvector(IntVector index) {
        IntVector v = new IntVector(index.size());
        int i = 0;
        while (i < index.size()) {
            v.V[i] = this.V[index.V[i]];
            ++i;
        }
        return v;
    }

    public void swap(int i, int j) {
        if (i == j) {
            return;
        }
        int t = this.get(i);
        this.set(i, this.get(j));
        this.set(j, t);
    }

    public void shift(int i, int j) {
        if (i == j) {
            return;
        }
        if (i < j) {
            int t = this.V[i];
            int k = i;
            while (k <= j - 1) {
                this.V[k] = this.V[k + 1];
                ++k;
            }
            this.V[j] = t;
        } else {
            this.shift(j, i);
        }
    }

    public void shiftToEnd(int j) {
        this.shift(j, this.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.toString(5, false);
    }

    public String toString(int digits, boolean trailing) {
        if (this.isEmpty()) {
            return "null vector";
        }
        StringBuffer text = new StringBuffer();
        FlexibleDecimalFormat nf = new FlexibleDecimalFormat(digits, trailing);
        nf.grouping(true);
        int i = 0;
        while (i < this.size()) {
            nf.update(this.get(i));
            ++i;
        }
        int count = 0;
        int width = 80;
        int i2 = 0;
        while (i2 < this.size()) {
            String number = nf.format(this.get(i2));
            if ((count += 1 + number.length()) > width - 1) {
                text.append('\n');
                count = 1 + number.length();
            }
            text.append(" " + number);
            ++i2;
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.4 $");
    }

    public static void main(String[] args) {
        IntVector u = new IntVector();
        System.out.println(u);
        IntVector v = IntVector.seq(10, 25);
        System.out.println(v);
        IntVector w = IntVector.seq(25, 10);
        System.out.println(w);
    }
}

