/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Enumeration;
import weka.core.Attribute;
import weka.core.Copyable;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.UnassignedClassException;
import weka.core.UnassignedDatasetException;
import weka.core.Utils;

public class Instance
implements Copyable,
Serializable,
RevisionHandler {
    static final long serialVersionUID = 1482635194499365122L;
    protected static final double MISSING_VALUE = Double.NaN;
    protected Instances m_Dataset;
    protected double[] m_AttValues;
    protected double m_Weight;

    public Instance(Instance instance) {
        this.m_AttValues = instance.m_AttValues;
        this.m_Weight = instance.m_Weight;
        this.m_Dataset = null;
    }

    public Instance(double weight, double[] attValues) {
        this.m_AttValues = attValues;
        this.m_Weight = weight;
        this.m_Dataset = null;
    }

    public Instance(int numAttributes) {
        this.m_AttValues = new double[numAttributes];
        int i = 0;
        while (i < this.m_AttValues.length) {
            this.m_AttValues[i] = Double.NaN;
            ++i;
        }
        this.m_Weight = 1.0;
        this.m_Dataset = null;
    }

    public Attribute attribute(int index) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(index);
    }

    public Attribute attributeSparse(int indexOfIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.attribute(indexOfIndex);
    }

    public Attribute classAttribute() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classAttribute();
    }

    public int classIndex() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.classIndex();
    }

    public boolean classIsMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.isMissing(this.classIndex());
    }

    public double classValue() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        return this.value(this.classIndex());
    }

    public Object copy() {
        Instance result = new Instance(this);
        result.m_Dataset = this.m_Dataset;
        return result;
    }

    public Instances dataset() {
        return this.m_Dataset;
    }

    public void deleteAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has access to a dataset!");
        }
        this.forceDeleteAttributeAt(position);
    }

    public Enumeration enumerateAttributes() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.enumerateAttributes();
    }

    public boolean equalHeaders(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeaders(inst.m_Dataset);
    }

    public String equalHeadersMsg(Instance inst) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.equalHeadersMsg(inst.m_Dataset);
    }

    public boolean hasMissingValue() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        int i = 0;
        while (i < this.numAttributes()) {
            if (i != this.classIndex() && this.isMissing(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int index(int position) {
        return position;
    }

    public void insertAttributeAt(int position) {
        if (this.m_Dataset != null) {
            throw new RuntimeException("Instance has accesss to a dataset!");
        }
        if (position < 0 || position > this.numAttributes()) {
            throw new IllegalArgumentException("Can't insert attribute: index out of range");
        }
        this.forceInsertAttributeAt(position);
    }

    public boolean isMissing(int attIndex) {
        return Double.isNaN(this.m_AttValues[attIndex]);
    }

    public boolean isMissingSparse(int indexOfIndex) {
        return Double.isNaN(this.m_AttValues[indexOfIndex]);
    }

    public boolean isMissing(Attribute att) {
        return this.isMissing(att.index());
    }

    public static boolean isMissingValue(double val) {
        return Double.isNaN(val);
    }

    public Instance mergeInstance(Instance inst) {
        int m = 0;
        double[] newVals = new double[this.numAttributes() + inst.numAttributes()];
        int j = 0;
        while (j < this.numAttributes()) {
            newVals[m] = this.value(j);
            ++j;
            ++m;
        }
        j = 0;
        while (j < inst.numAttributes()) {
            newVals[m] = inst.value(j);
            ++j;
            ++m;
        }
        return new Instance(1.0, newVals);
    }

    public static double missingValue() {
        return Double.NaN;
    }

    public int numAttributes() {
        return this.m_AttValues.length;
    }

    public int numClasses() {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.m_Dataset.numClasses();
    }

    public int numValues() {
        return this.m_AttValues.length;
    }

    public void replaceMissingValues(double[] array) {
        if (array == null || array.length != this.m_AttValues.length) {
            throw new IllegalArgumentException("Unequal number of attributes!");
        }
        this.freshAttributeVector();
        int i = 0;
        while (i < this.m_AttValues.length) {
            if (this.isMissing(i)) {
                this.m_AttValues[i] = array[i];
            }
            ++i;
        }
    }

    public void setClassMissing() {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setMissing(this.classIndex());
    }

    public void setClassValue(double value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setClassValue(String value) {
        if (this.classIndex() < 0) {
            throw new UnassignedClassException("Class is not set!");
        }
        this.setValue(this.classIndex(), value);
    }

    public final void setDataset(Instances instances) {
        this.m_Dataset = instances;
    }

    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Double.NaN);
    }

    public final void setMissing(Attribute att) {
        this.setMissing(att.index());
    }

    public void setValue(int attIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[attIndex] = value;
    }

    public void setValueSparse(int indexOfIndex, double value) {
        this.freshAttributeVector();
        this.m_AttValues[indexOfIndex] = value;
    }

    public final void setValue(int attIndex, String value) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        if (!this.attribute(attIndex).isNominal() && !this.attribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = this.attribute(attIndex).indexOfValue(value);
        if (valIndex == -1) {
            if (this.attribute(attIndex).isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            this.attribute(attIndex).forceAddValue(value);
            valIndex = this.attribute(attIndex).indexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    public final void setValue(Attribute att, double value) {
        this.setValue(att.index(), value);
    }

    public final void setValue(Attribute att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        int valIndex = att.indexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            att.forceAddValue(value);
            valIndex = att.indexOfValue(value);
        }
        this.setValue(att.index(), (double)valIndex);
    }

    public void modifyValue(int attIndex, double value) {
        this.m_AttValues[attIndex] = value;
    }

    public final void setWeight(double weight) {
        this.m_Weight = weight;
    }

    public final Instances relationalValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.relationalValue(this.m_Dataset.attribute(attIndex));
    }

    public final Instances relationalValue(Attribute att) {
        int attIndex = att.index();
        if (att.isRelationValued()) {
            return att.relation((int)this.value(attIndex));
        }
        throw new IllegalArgumentException("Attribute isn't relation-valued!");
    }

    public final String stringValue(int attIndex) {
        if (this.m_Dataset == null) {
            throw new UnassignedDatasetException("Instance doesn't have access to a dataset!");
        }
        return this.stringValue(this.m_Dataset.attribute(attIndex));
    }

    public final String stringValue(Attribute att) {
        int attIndex = att.index();
        switch (att.type()) {
            case 1: 
            case 2: {
                return att.value((int)this.value(attIndex));
            }
            case 3: {
                return att.formatDate(this.value(attIndex));
            }
            case 4: {
                return att.relation((int)this.value(attIndex)).stringWithoutHeader();
            }
        }
        throw new IllegalArgumentException("Attribute isn't nominal, string or date!");
    }

    public double[] toDoubleArray() {
        double[] newValues = new double[this.m_AttValues.length];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, this.m_AttValues.length);
        return newValues;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.m_AttValues.length) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i));
            ++i;
        }
        if (this.m_Weight != 1.0) {
            text.append(",{" + Utils.doubleToString(this.m_Weight, 6) + "}");
        }
        return text.toString();
    }

    protected String toStringNoWeight() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.m_AttValues.length) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i));
            ++i;
        }
        return text.toString();
    }

    public final String toString(int attIndex) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.m_Dataset == null) {
            text.append(Utils.doubleToString(this.m_AttValues[attIndex], 6));
        } else {
            switch (this.m_Dataset.attribute(attIndex).type()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    text.append(Utils.quote(this.stringValue(attIndex)));
                    break;
                }
                case 0: {
                    text.append(Utils.doubleToString(this.value(attIndex), 6));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown attribute type");
                }
            }
        }
        return text.toString();
    }

    public final String toString(Attribute att) {
        return this.toString(att.index());
    }

    public double value(int attIndex) {
        return this.m_AttValues[attIndex];
    }

    public double valueSparse(int indexOfIndex) {
        return this.m_AttValues[indexOfIndex];
    }

    public double value(Attribute att) {
        return this.value(att.index());
    }

    public final double weight() {
        return this.m_Weight;
    }

    void forceDeleteAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length - 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        if (position < this.m_AttValues.length - 1) {
            System.arraycopy(this.m_AttValues, position + 1, newValues, position, this.m_AttValues.length - (position + 1));
        }
        this.m_AttValues = newValues;
    }

    void forceInsertAttributeAt(int position) {
        double[] newValues = new double[this.m_AttValues.length + 1];
        System.arraycopy(this.m_AttValues, 0, newValues, 0, position);
        newValues[position] = Double.NaN;
        System.arraycopy(this.m_AttValues, position, newValues, position + 1, this.m_AttValues.length - position);
        this.m_AttValues = newValues;
    }

    protected Instance() {
    }

    private void freshAttributeVector() {
        this.m_AttValues = this.toDoubleArray();
    }

    public static void main(String[] options) {
        try {
            Attribute length = new Attribute("length");
            Attribute weight = new Attribute("weight");
            FastVector my_nominal_values = new FastVector(3);
            my_nominal_values.addElement("first");
            my_nominal_values.addElement("second");
            my_nominal_values.addElement("third");
            Attribute position = new Attribute("position", my_nominal_values);
            FastVector attributes = new FastVector(3);
            attributes.addElement(length);
            attributes.addElement(weight);
            attributes.addElement(position);
            Instances race = new Instances("race", attributes, 0);
            race.setClassIndex(position.index());
            Instance inst = new Instance(3);
            inst.setValue(length, 5.3);
            inst.setValue(weight, 300.0);
            inst.setValue(position, "first");
            inst.setDataset(race);
            System.out.println("The instance: " + inst);
            System.out.println("First attribute: " + inst.attribute(0));
            System.out.println("Class attribute: " + inst.classAttribute());
            System.out.println("Class index: " + inst.classIndex());
            System.out.println("Class is missing: " + inst.classIsMissing());
            System.out.println("Class value (internal format): " + inst.classValue());
            Instance copy = (Instance)inst.copy();
            System.out.println("Shallow copy: " + copy);
            copy.setDataset(inst.dataset());
            System.out.println("Shallow copy with dataset set: " + copy);
            copy.setDataset(null);
            copy.deleteAttributeAt(0);
            copy.insertAttributeAt(0);
            copy.setDataset(inst.dataset());
            System.out.println("Copy with first attribute deleted and inserted: " + copy);
            System.out.println("Enumerating attributes (leaving out class):");
            Enumeration enu = inst.enumerateAttributes();
            while (enu.hasMoreElements()) {
                Attribute att = (Attribute)enu.nextElement();
                System.out.println(att);
            }
            System.out.println("Header of original and copy equivalent: " + inst.equalHeaders(copy));
            System.out.println("Length of copy missing: " + copy.isMissing(length));
            System.out.println("Weight of copy missing: " + copy.isMissing(weight.index()));
            System.out.println("Length of copy missing: " + Instance.isMissingValue(copy.value(length)));
            System.out.println("Missing value coded as: " + Instance.missingValue());
            System.out.println("Number of attributes: " + copy.numAttributes());
            System.out.println("Number of classes: " + copy.numClasses());
            double[] meansAndModes = new double[]{2.0, 3.0, 0.0};
            copy.replaceMissingValues(meansAndModes);
            System.out.println("Copy with missing value replaced: " + copy);
            copy.setClassMissing();
            System.out.println("Copy with missing class: " + copy);
            copy.setClassValue(0.0);
            System.out.println("Copy with class value set to first value: " + copy);
            copy.setClassValue("third");
            System.out.println("Copy with class value set to \"third\": " + copy);
            copy.setMissing(1);
            System.out.println("Copy with second attribute set to be missing: " + copy);
            copy.setMissing(length);
            System.out.println("Copy with length set to be missing: " + copy);
            copy.setValue(0, 0.0);
            System.out.println("Copy with first attribute set to 0: " + copy);
            copy.setValue(weight, 1.0);
            System.out.println("Copy with weight attribute set to 1: " + copy);
            copy.setValue(position, "second");
            System.out.println("Copy with position set to \"second\": " + copy);
            copy.setValue(2, "first");
            System.out.println("Copy with last attribute set to \"first\": " + copy);
            System.out.println("Current weight of instance copy: " + copy.weight());
            copy.setWeight(2.0);
            System.out.println("Current weight of instance copy (set to 2): " + copy.weight());
            System.out.println("Last value of copy: " + copy.toString(2));
            System.out.println("Value of position for copy: " + copy.toString(position));
            System.out.println("Last value of copy (internal format): " + copy.value(2));
            System.out.println("Value of position for copy (internal format): " + copy.value(position));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4997 $");
    }
}

