/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.classifiers.pmml.PMMLClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MatrixFolder.Maths;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.MiningSchema;
import weka.core.pmml.PMMLUtils;
import weka.core.pmml.TargetMetaInfo;

public class GeneralRegression
extends PMMLClassifier
implements Serializable {
    private static final long serialVersionUID = 2583880411828388959L;
    protected ModelType m_modelType = ModelType.REGRESSION;
    protected String m_modelName;
    protected String m_algorithmName;
    protected int m_functionType = 0;
    protected CumulativeLinkFunction m_cumulativeLinkFunction = CumulativeLinkFunction.NONE;
    protected LinkFunction m_linkFunction = LinkFunction.NONE;
    protected double m_linkParameter = Double.NaN;
    protected String m_trialsVariable;
    protected double m_trialsValue = Double.NaN;
    protected Distribution m_distribution = Distribution.NORMAL;
    protected double m_distParameter = Double.NaN;
    protected String m_offsetVariable;
    protected double m_offsetValue = Double.NaN;
    protected ArrayList<Parameter> m_parameterList = new ArrayList();
    protected ArrayList<Predictor> m_factorList = new ArrayList();
    protected ArrayList<Predictor> m_covariateList = new ArrayList();
    protected PPCell[][] m_ppMatrix;
    protected PCell[][] m_paramMatrix;

    public GeneralRegression(Element model, Instances dataDictionary, MiningSchema miningSchema) throws Exception {
        super(dataDictionary, miningSchema);
        String offsetVal;
        String offsetV;
        String distP;
        String distribution;
        String algName;
        String fName;
        String mName;
        Enum[] enumArray;
        String mType = model.getAttribute("modelType");
        boolean found = false;
        ModelType[] modelTypeArray = ModelType.values();
        int n = modelTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelType m = modelTypeArray[n2];
            if (m.toString().equals(mType)) {
                this.m_modelType = m;
                found = true;
                break;
            }
            ++n2;
        }
        if (!found) {
            throw new Exception("[GeneralRegression] unknown model type: " + mType);
        }
        if (this.m_modelType == ModelType.ORDINALMULTINOMIAL) {
            String cLink = model.getAttribute("cumulativeLink");
            found = false;
            enumArray = CumulativeLinkFunction.values();
            int n3 = enumArray.length;
            n = 0;
            while (n < n3) {
                Enum c = enumArray[n];
                if (((CumulativeLinkFunction)c).toString().equals(cLink)) {
                    this.m_cumulativeLinkFunction = c;
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found) {
                throw new Exception("[GeneralRegression] cumulative link function " + cLink);
            }
        } else if (this.m_modelType == ModelType.GENERALIZEDLINEAR || this.m_modelType == ModelType.GENERALLINEAR) {
            String trialsV;
            String trials;
            String link = model.getAttribute("linkFunction");
            found = false;
            enumArray = LinkFunction.values();
            int n4 = enumArray.length;
            n = 0;
            while (n < n4) {
                Enum l = enumArray[n];
                if (((LinkFunction)l).toString().equals(link)) {
                    this.m_linkFunction = l;
                    found = true;
                    break;
                }
                ++n;
            }
            if (!found) {
                throw new Exception("[GeneralRegression] unknown link function " + link);
            }
            String linkP = model.getAttribute("linkParameter");
            if (linkP != null && linkP.length() > 0) {
                try {
                    this.m_linkParameter = Double.parseDouble(linkP);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("[GeneralRegression] unable to parse the link parameter");
                }
            }
            if ((trials = model.getAttribute("trialsVariable")) != null && trials.length() > 0) {
                this.m_trialsVariable = trials;
            }
            if ((trialsV = model.getAttribute("trialsValue")) != null && trialsV.length() > 0) {
                try {
                    this.m_trialsValue = Double.parseDouble(trialsV);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("[GeneralRegression] unable to parse the trials value");
                }
            }
        }
        if ((mName = model.getAttribute("modelName")) != null && mName.length() > 0) {
            this.m_modelName = mName;
        }
        if ((fName = model.getAttribute("functionName")).equals("classification")) {
            this.m_functionType = 1;
        }
        if ((algName = model.getAttribute("algorithmName")) != null && algName.length() > 0) {
            this.m_algorithmName = algName;
        }
        if ((distribution = model.getAttribute("distribution")) != null && distribution.length() > 0) {
            found = false;
            Distribution[] distributionArray = Distribution.values();
            int n5 = distributionArray.length;
            int n6 = 0;
            while (n6 < n5) {
                Distribution d = distributionArray[n6];
                if (d.toString().equals(distribution)) {
                    this.m_distribution = d;
                    found = true;
                    break;
                }
                ++n6;
            }
            if (!found) {
                throw new Exception("[GeneralRegression] unknown distribution type " + distribution);
            }
        }
        if ((distP = model.getAttribute("distParameter")) != null && distP.length() > 0) {
            try {
                this.m_distParameter = Double.parseDouble(distP);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[GeneralRegression] unable to parse the distribution parameter");
            }
        }
        if ((offsetV = model.getAttribute("offsetVariable")) != null && offsetV.length() > 0) {
            this.m_offsetVariable = offsetV;
        }
        if ((offsetVal = model.getAttribute("offsetValue")) != null && offsetVal.length() > 0) {
            try {
                this.m_offsetValue = Double.parseDouble(offsetVal);
            }
            catch (IllegalArgumentException ex) {
                throw new Exception("[GeneralRegression] unable to parse the offset value");
            }
        }
        this.readParameterList(model);
        this.readFactorsAndCovariates(model, "FactorList");
        this.readFactorsAndCovariates(model, "CovariateList");
        this.readPPMatrix(model);
        this.readParamMatrix(model);
    }

    protected void readParameterList(Element model) throws Exception {
        NodeList paramL = model.getElementsByTagName("ParameterList");
        if (paramL.getLength() == 1) {
            Node paramN = paramL.item(0);
            if (paramN.getNodeType() == 1) {
                NodeList parameterList = ((Element)paramN).getElementsByTagName("Parameter");
                int i = 0;
                while (i < parameterList.getLength()) {
                    Node parameter = parameterList.item(i);
                    if (parameter.getNodeType() == 1) {
                        Parameter p = new Parameter();
                        p.m_name = ((Element)parameter).getAttribute("name");
                        String label = ((Element)parameter).getAttribute("label");
                        if (label != null && label.length() > 0) {
                            p.m_label = label;
                        }
                        this.m_parameterList.add(p);
                    }
                    ++i;
                }
            }
        } else {
            throw new Exception("[GeneralRegression] more than one parameter list!");
        }
    }

    protected void readFactorsAndCovariates(Element model, String factorOrCovariate) throws Exception {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        NodeList factorL = model.getElementsByTagName(factorOrCovariate);
        if (factorL.getLength() == 1) {
            Node factor = factorL.item(0);
            if (factor.getNodeType() == 1) {
                NodeList predL = ((Element)factor).getElementsByTagName("Predictor");
                int i = 0;
                while (i < predL.getLength()) {
                    Node pred = predL.item(i);
                    if (pred.getNodeType() == 1) {
                        Predictor p = new Predictor();
                        p.m_name = ((Element)pred).getAttribute("name");
                        boolean found = false;
                        int j = 0;
                        while (j < miningSchemaI.numAttributes()) {
                            if (miningSchemaI.attribute(j).name().equals(p.m_name)) {
                                found = true;
                                p.m_miningSchemaIndex = j;
                                break;
                            }
                            ++j;
                        }
                        if (found) {
                            if (factorOrCovariate.equals("FactorList")) {
                                this.m_factorList.add(p);
                            } else {
                                this.m_covariateList.add(p);
                            }
                        } else {
                            throw new Exception("[GeneralRegression] reading factors and covariates - unable to find predictor " + p.m_name + " in the mining schema");
                        }
                    }
                    ++i;
                }
            }
        } else if (factorL.getLength() > 1) {
            throw new Exception("[GeneralRegression] more than one " + factorOrCovariate + "! ");
        }
    }

    protected void readPPMatrix(Element model) throws Exception {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        NodeList matrixL = model.getElementsByTagName("PPMatrix");
        if (matrixL.getLength() == 1) {
            this.m_ppMatrix = new PPCell[this.m_parameterList.size()][miningSchemaI.numAttributes()];
            Node ppM = matrixL.item(0);
            if (ppM.getNodeType() == 1) {
                NodeList cellL = ((Element)ppM).getElementsByTagName("PPCell");
                int i = 0;
                while (i < cellL.getLength()) {
                    Node cell = cellL.item(i);
                    if (cell.getNodeType() == 1) {
                        String predictorName = ((Element)cell).getAttribute("predictorName");
                        String parameterName = ((Element)cell).getAttribute("parameterName");
                        String value = ((Element)cell).getAttribute("value");
                        double expOrIndex = -1.0;
                        int predictorIndex = -1;
                        int parameterIndex = -1;
                        int j = 0;
                        while (j < this.m_parameterList.size()) {
                            if (this.m_parameterList.get((int)j).m_name.equals(parameterName)) {
                                parameterIndex = j;
                                break;
                            }
                            ++j;
                        }
                        if (parameterIndex == -1) {
                            throw new Exception("[GeneralRegression] unable to find parameter name " + parameterName + " in parameter list");
                        }
                        Predictor p = this.getCovariate(predictorName);
                        if (p != null) {
                            try {
                                expOrIndex = Double.parseDouble(value);
                                predictorIndex = p.m_miningSchemaIndex;
                            }
                            catch (IllegalArgumentException ex) {
                                throw new Exception("[GeneralRegression] unable to parse PPCell value: " + value);
                            }
                        } else {
                            p = this.getFactor(predictorName);
                            if (p != null) {
                                if (miningSchemaI.attribute(p.m_miningSchemaIndex).isNumeric()) {
                                    try {
                                        expOrIndex = Double.parseDouble(value);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        throw new Exception("[GeneralRegresion] unable to parse PPCell value: " + value);
                                    }
                                } else {
                                    Attribute att = miningSchemaI.attribute(p.m_miningSchemaIndex);
                                    expOrIndex = att.indexOfValue(value);
                                    if (expOrIndex == -1.0) {
                                        throw new Exception("[GeneralRegression] unable to find PPCell value " + value + " in mining schema attribute " + att.name());
                                    }
                                }
                            } else {
                                throw new Exception("[GeneralRegression] cant find predictor " + predictorName + "in either the factors list " + "or the covariates list");
                            }
                            predictorIndex = p.m_miningSchemaIndex;
                        }
                        PPCell ppc = new PPCell();
                        ppc.m_predictorName = predictorName;
                        ppc.m_parameterName = parameterName;
                        ppc.m_value = expOrIndex;
                        this.m_ppMatrix[parameterIndex][predictorIndex] = ppc;
                    }
                    ++i;
                }
            }
        } else {
            throw new Exception("[GeneralRegression] more than one PPMatrix!");
        }
    }

    private Predictor getCovariate(String predictorName) {
        int i = 0;
        while (i < this.m_covariateList.size()) {
            if (predictorName.equals(this.m_covariateList.get((int)i).m_name)) {
                return this.m_covariateList.get(i);
            }
            ++i;
        }
        return null;
    }

    private Predictor getFactor(String predictorName) {
        int i = 0;
        while (i < this.m_factorList.size()) {
            if (predictorName.equals(this.m_factorList.get((int)i).m_name)) {
                return this.m_factorList.get(i);
            }
            ++i;
        }
        return null;
    }

    private void readParamMatrix(Element model) throws Exception {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        Attribute classAtt = miningSchemaI.classAttribute();
        ArrayList<String> targetVals = null;
        NodeList matrixL = model.getElementsByTagName("ParamMatrix");
        if (matrixL.getLength() != 1) {
            throw new Exception("[GeneralRegression] more than one ParamMatrix!");
        }
        Element matrix = (Element)matrixL.item(0);
        if (this.m_functionType == 1 && classAtt.isNumeric()) {
            if (!this.m_miningSchema.hasTargetMetaData()) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however, there is no Target element specifying legal discrete values for the target!");
            }
            if (this.m_miningSchema.getTargetMetaData().getOptype() != FieldMetaInfo.Optype.CATEGORICAL) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however Target element in PMML does not have optype categorical!");
            }
            targetVals = this.m_miningSchema.getTargetMetaData().getValues();
            if (targetVals.size() == 0) {
                throw new Exception("[GeneralRegression] function type is classification and class attribute in mining schema is numeric, however Target element in PMML does not have any discrete values defined!");
            }
            this.m_miningSchema.convertNumericAttToNominal(miningSchemaI.classIndex(), targetVals);
        }
        this.m_paramMatrix = new PCell[classAtt.isNumeric() ? 1 : classAtt.numValues()][this.m_parameterList.size()];
        NodeList pcellL = matrix.getElementsByTagName("PCell");
        int i = 0;
        while (i < pcellL.getLength()) {
            int targetCategoryIndex = -1;
            int parameterIndex = -1;
            Node pcell = pcellL.item(i);
            if (pcell.getNodeType() == 1) {
                String paramName = ((Element)pcell).getAttribute("parameterName");
                String targetCatName = ((Element)pcell).getAttribute("targetCategory");
                String coefficient = ((Element)pcell).getAttribute("beta");
                String df = ((Element)pcell).getAttribute("df");
                int j = 0;
                while (j < this.m_parameterList.size()) {
                    if (this.m_parameterList.get((int)j).m_name.equals(paramName)) {
                        parameterIndex = j;
                        if (this.m_parameterList.get((int)j).m_label == null) break;
                        paramName = this.m_parameterList.get((int)j).m_label;
                        break;
                    }
                    ++j;
                }
                if (parameterIndex == -1) {
                    throw new Exception("[GeneralRegression] unable to find parameter name " + paramName + " in parameter list");
                }
                if (targetCatName != null && targetCatName.length() > 0) {
                    if (classAtt.isNominal() || classAtt.isString()) {
                        targetCategoryIndex = classAtt.indexOfValue(targetCatName);
                    } else {
                        throw new Exception("[GeneralRegression] found a PCell with a named target category: " + targetCatName + " but class attribute is numeric in " + "mining schema");
                    }
                }
                PCell p = new PCell();
                if (targetCategoryIndex != -1) {
                    p.m_targetCategory = targetCatName;
                }
                p.m_parameterName = paramName;
                try {
                    p.m_beta = Double.parseDouble(coefficient);
                }
                catch (IllegalArgumentException ex) {
                    throw new Exception("[GeneralRegression] unable to parse beta value " + coefficient + " as a double from PCell");
                }
                if (df != null && df.length() > 0) {
                    try {
                        p.m_df = Integer.parseInt(df);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new Exception("[GeneralRegression] unable to parse df value " + df + " as an int from PCell");
                    }
                }
                if (targetCategoryIndex != -1) {
                    this.m_paramMatrix[targetCategoryIndex][parameterIndex] = p;
                } else {
                    int j2 = 0;
                    while (j2 < this.m_paramMatrix.length) {
                        this.m_paramMatrix[j2][parameterIndex] = p;
                        ++j2;
                    }
                }
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        temp.append("PMML version " + this.getPMMLVersion());
        if (!this.getCreatorApplication().equals("?")) {
            temp.append("\nApplication: " + this.getCreatorApplication());
        }
        temp.append("\nPMML Model: " + (Object)((Object)this.m_modelType));
        temp.append("\n\n");
        temp.append(this.m_miningSchema);
        if (this.m_factorList.size() > 0) {
            temp.append("Factors:\n");
            for (Predictor p : this.m_factorList) {
                temp.append("\t" + p + "\n");
            }
        }
        temp.append("\n");
        if (this.m_covariateList.size() > 0) {
            temp.append("Covariates:\n");
            for (Predictor p : this.m_covariateList) {
                temp.append("\t" + p + "\n");
            }
        }
        temp.append("\n");
        this.printPPMatrix(temp);
        temp.append("\n");
        this.printParameterMatrix(temp);
        temp.append("\n");
        if (this.m_linkFunction != LinkFunction.NONE) {
            temp.append("Link function: " + (Object)((Object)this.m_linkFunction));
            if (this.m_offsetVariable != null) {
                temp.append("\n\tOffset variable " + this.m_offsetVariable);
            } else if (!Double.isNaN(this.m_offsetValue)) {
                temp.append("\n\tOffset value " + this.m_offsetValue);
            }
            if (this.m_trialsVariable != null) {
                temp.append("\n\tTrials variable " + this.m_trialsVariable);
            } else if (!Double.isNaN(this.m_trialsValue)) {
                temp.append("\n\tTrials value " + this.m_trialsValue);
            }
            if (this.m_distribution != Distribution.NONE) {
                temp.append("\nDistribution: " + (Object)((Object)this.m_distribution));
            }
            if (this.m_linkFunction == LinkFunction.NEGBIN && this.m_distribution == Distribution.NEGBINOMIAL && !Double.isNaN(this.m_distParameter)) {
                temp.append("\n\tDistribution parameter " + this.m_distParameter);
            }
            if (!(this.m_linkFunction != LinkFunction.POWER && this.m_linkFunction != LinkFunction.ODDSPOWER || Double.isNaN(this.m_linkParameter))) {
                temp.append("\n\nLink parameter " + this.m_linkParameter);
            }
        }
        if (this.m_cumulativeLinkFunction != CumulativeLinkFunction.NONE) {
            temp.append("Cumulative link function: " + (Object)((Object)this.m_cumulativeLinkFunction));
            if (this.m_offsetVariable != null) {
                temp.append("\n\tOffset variable " + this.m_offsetVariable);
            } else if (!Double.isNaN(this.m_offsetValue)) {
                temp.append("\n\tOffset value " + this.m_offsetValue);
            }
        }
        temp.append("\n");
        return temp.toString();
    }

    protected void printPPMatrix(StringBuffer buff) {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        int maxAttWidth = 0;
        int i = 0;
        while (i < miningSchemaI.numAttributes()) {
            Attribute a = miningSchemaI.attribute(i);
            if (a.name().length() > maxAttWidth) {
                maxAttWidth = a.name().length();
            }
            ++i;
        }
        i = 0;
        while (i < this.m_parameterList.size()) {
            int j = 0;
            while (j < miningSchemaI.numAttributes()) {
                if (this.m_ppMatrix[i][j] != null) {
                    String val;
                    double width = Math.log(Math.abs(this.m_ppMatrix[i][j].m_value)) / Math.log(10.0);
                    if (width < 0.0) {
                        width = 1.0;
                    }
                    if ((int)(width += 2.0) > maxAttWidth) {
                        maxAttWidth = (int)width;
                    }
                    if ((miningSchemaI.attribute(j).isNominal() || miningSchemaI.attribute(j).isString()) && (val = String.valueOf(miningSchemaI.attribute(j).value((int)this.m_ppMatrix[i][j].m_value)) + " ").length() > maxAttWidth) {
                        maxAttWidth = val.length();
                    }
                }
                ++j;
            }
            ++i;
        }
        int maxParamWidth = "Parameter  ".length();
        for (Parameter p : this.m_parameterList) {
            String temp;
            String string = temp = p.m_label != null ? String.valueOf(p.m_label) + " " : String.valueOf(p.m_name) + " ";
            if (temp.length() <= maxParamWidth) continue;
            maxParamWidth = temp.length();
        }
        buff.append("Predictor-to-Parameter matrix:\n");
        buff.append(PMMLUtils.pad("Predictor", " ", maxParamWidth + (maxAttWidth * 2 + 2) - "Predictor".length(), true));
        buff.append("\n" + PMMLUtils.pad("Parameter", " ", maxParamWidth - "Parameter".length(), false));
        int i2 = 0;
        while (i2 < miningSchemaI.numAttributes()) {
            if (i2 != miningSchemaI.classIndex()) {
                String attName = miningSchemaI.attribute(i2).name();
                buff.append(PMMLUtils.pad(attName, " ", maxAttWidth + 1 - attName.length(), true));
            }
            ++i2;
        }
        buff.append("\n");
        i2 = 0;
        while (i2 < this.m_parameterList.size()) {
            Parameter param = this.m_parameterList.get(i2);
            String paramS = param.m_label != null ? param.m_label : param.m_name;
            buff.append(PMMLUtils.pad(paramS, " ", maxParamWidth - paramS.length(), false));
            int j = 0;
            while (j < miningSchemaI.numAttributes()) {
                if (j != miningSchemaI.classIndex()) {
                    PPCell p = this.m_ppMatrix[i2][j];
                    String val = " ";
                    if (p != null) {
                        val = miningSchemaI.attribute(j).isNominal() || miningSchemaI.attribute(j).isString() ? miningSchemaI.attribute(j).value((int)p.m_value) : Utils.doubleToString(p.m_value, maxAttWidth, 4).trim();
                    }
                    buff.append(PMMLUtils.pad(val, " ", maxAttWidth + 1 - val.length(), true));
                }
                ++j;
            }
            buff.append("\n");
            ++i2;
        }
    }

    protected void printParameterMatrix(StringBuffer buff) {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        int maxClassWidth = miningSchemaI.classAttribute().name().length();
        if (miningSchemaI.classAttribute().isNominal() || miningSchemaI.classAttribute().isString()) {
            int i = 0;
            while (i < miningSchemaI.classAttribute().numValues()) {
                if (miningSchemaI.classAttribute().value(i).length() > maxClassWidth) {
                    maxClassWidth = miningSchemaI.classAttribute().value(i).length();
                }
                ++i;
            }
        }
        int maxParamWidth = 0;
        int i = 0;
        while (i < this.m_parameterList.size()) {
            String val;
            Parameter p = this.m_parameterList.get(i);
            String string = val = p.m_label != null ? String.valueOf(p.m_label) + " " : String.valueOf(p.m_name) + " ";
            if (val.length() > maxParamWidth) {
                maxParamWidth = val.length();
            }
            ++i;
        }
        int maxBetaWidth = "Coeff.".length();
        int i2 = 0;
        while (i2 < this.m_paramMatrix.length) {
            int j = 0;
            while (j < this.m_parameterList.size()) {
                PCell p = this.m_paramMatrix[i2][j];
                if (p != null) {
                    double width = Math.log(Math.abs(p.m_beta)) / Math.log(10.0);
                    if (width < 0.0) {
                        width = 1.0;
                    }
                    if ((int)(width += 7.0) > maxBetaWidth) {
                        maxBetaWidth = (int)width;
                    }
                }
                ++j;
            }
            ++i2;
        }
        buff.append("Parameter estimates:\n");
        buff.append(PMMLUtils.pad(miningSchemaI.classAttribute().name(), " ", maxClassWidth + maxParamWidth + 2 - miningSchemaI.classAttribute().name().length(), false));
        buff.append(PMMLUtils.pad("Coeff.", " ", maxBetaWidth + 1 - "Coeff.".length(), true));
        buff.append(PMMLUtils.pad("df", " ", maxBetaWidth - "df".length(), true));
        buff.append("\n");
        i2 = 0;
        while (i2 < this.m_paramMatrix.length) {
            boolean ok = false;
            int j = 0;
            while (j < this.m_parameterList.size()) {
                if (this.m_paramMatrix[i2][j] != null) {
                    ok = true;
                }
                ++j;
            }
            if (ok) {
                String cVal = miningSchemaI.classAttribute().isNominal() || miningSchemaI.classAttribute().isString() ? miningSchemaI.classAttribute().value(i2) : " ";
                buff.append(PMMLUtils.pad(cVal, " ", maxClassWidth - cVal.length(), false));
                buff.append("\n");
                int j2 = 0;
                while (j2 < this.m_parameterList.size()) {
                    PCell p = this.m_paramMatrix[i2][j2];
                    if (p != null) {
                        String label = p.m_parameterName;
                        buff.append(PMMLUtils.pad(label, " ", maxClassWidth + maxParamWidth + 2 - label.length(), true));
                        String betaS = Utils.doubleToString(p.m_beta, maxBetaWidth, 4).trim();
                        buff.append(PMMLUtils.pad(betaS, " ", maxBetaWidth + 1 - betaS.length(), true));
                        String dfS = Utils.doubleToString(p.m_df, maxBetaWidth, 4).trim();
                        buff.append(PMMLUtils.pad(dfS, " ", maxBetaWidth - dfS.length(), true));
                        buff.append("\n");
                    }
                    ++j2;
                }
            }
            ++i2;
        }
    }

    private double[] incomingParamVector(double[] incomingInst) throws Exception {
        Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
        double[] incomingPV = new double[this.m_parameterList.size()];
        int i = 0;
        while (i < this.m_parameterList.size()) {
            incomingPV[i] = 1.0;
            int j = 0;
            while (j < miningSchemaI.numAttributes()) {
                PPCell cellEntry = this.m_ppMatrix[i][j];
                Predictor p = null;
                if (cellEntry != null) {
                    p = this.getFactor(cellEntry.m_predictorName);
                    if (p != null) {
                        if ((int)incomingInst[p.m_miningSchemaIndex] == (int)cellEntry.m_value) {
                            int n = i;
                            incomingPV[n] = incomingPV[n] * 1.0;
                        } else {
                            int n = i;
                            incomingPV[n] = incomingPV[n] * 0.0;
                        }
                    } else {
                        p = this.getCovariate(cellEntry.m_predictorName);
                        if (p != null) {
                            int n = i;
                            incomingPV[n] = incomingPV[n] * Math.pow(incomingInst[p.m_miningSchemaIndex], cellEntry.m_value);
                        } else {
                            throw new Exception("[GeneralRegression] can't find predictor " + cellEntry.m_predictorName + " in either the list of factors or covariates");
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        return incomingPV;
    }

    @Override
    public double[] distributionForInstance(Instance inst) throws Exception {
        if (!this.m_initialized) {
            this.mapToMiningSchema(inst.dataset());
        }
        double[] preds = null;
        preds = this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric() ? new double[1] : new double[this.m_miningSchema.getFieldsAsInstances().classAttribute().numValues()];
        double[] incoming = this.m_fieldsMap.instanceToSchema(inst, this.m_miningSchema);
        boolean hasMissing = false;
        int i = 0;
        while (i < incoming.length) {
            if (i != this.m_miningSchema.getFieldsAsInstances().classIndex() && Double.isNaN(incoming[i])) {
                hasMissing = true;
                break;
            }
            ++i;
        }
        if (hasMissing) {
            if (!this.m_miningSchema.hasTargetMetaData()) {
                String message = "[GeneralRegression] WARNING: Instance to predict has missing value(s) but there is no missing value handling meta data and no prior probabilities/default value to fall back to. No prediction will be made (" + (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNominal() || this.m_miningSchema.getFieldsAsInstances().classAttribute().isString() ? "zero probabilities output)." : "NaN output).");
                if (this.m_log == null) {
                    System.err.println(message);
                } else {
                    this.m_log.logMessage(message);
                }
                if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                    preds[0] = Instance.missingValue();
                }
                return preds;
            }
            TargetMetaInfo targetData = this.m_miningSchema.getTargetMetaData();
            if (this.m_miningSchema.getFieldsAsInstances().classAttribute().isNumeric()) {
                preds[0] = targetData.getDefaultValue();
            } else {
                Instances miningSchemaI = this.m_miningSchema.getFieldsAsInstances();
                int i2 = 0;
                while (i2 < miningSchemaI.classAttribute().numValues()) {
                    preds[i2] = targetData.getPriorProbability(miningSchemaI.classAttribute().value(i2));
                    ++i2;
                }
            }
            return preds;
        }
        double[] inputParamVector = this.incomingParamVector(incoming);
        this.computeResponses(incoming, inputParamVector, preds);
        return preds;
    }

    private void computeResponses(double[] incomingInst, double[] incomingParamVector, double[] responses) throws Exception {
        int i = 0;
        while (i < responses.length) {
            int j = 0;
            while (j < this.m_parameterList.size()) {
                PCell p = this.m_paramMatrix[i][j];
                if (p == null) {
                    int n = i;
                    responses[n] = responses[n] + 0.0 * incomingParamVector[j];
                } else {
                    int n = i;
                    responses[n] = responses[n] + incomingParamVector[j] * p.m_beta;
                }
                ++j;
            }
            ++i;
        }
        switch (this.m_modelType) {
            case MULTINOMIALLOGISTIC: {
                GeneralRegression.computeProbabilitiesMultinomialLogistic(responses);
                break;
            }
            case REGRESSION: {
                break;
            }
            case GENERALLINEAR: 
            case GENERALIZEDLINEAR: {
                if (this.m_linkFunction != LinkFunction.NONE) {
                    this.computeResponseGeneralizedLinear(incomingInst, responses);
                    break;
                }
                throw new Exception("[GeneralRegression] no link function specified!");
            }
            case ORDINALMULTINOMIAL: {
                if (this.m_cumulativeLinkFunction != CumulativeLinkFunction.NONE) {
                    this.computeResponseOrdinalMultinomial(incomingInst, responses);
                    break;
                }
                throw new Exception("[GeneralRegression] no cumulative link function specified!");
            }
            default: {
                throw new Exception("[GeneralRegression] unknown model type");
            }
        }
    }

    private static void computeProbabilitiesMultinomialLogistic(double[] responses) {
        double[] r = (double[])responses.clone();
        int j = 0;
        while (j < r.length) {
            double sum = 0.0;
            boolean overflow = false;
            int k = 0;
            while (k < r.length) {
                if (r[k] - r[j] > 700.0) {
                    overflow = true;
                    break;
                }
                sum += Math.exp(r[k] - r[j]);
                ++k;
            }
            responses[j] = overflow ? 0.0 : 1.0 / sum;
            ++j;
        }
    }

    private void computeResponseGeneralizedLinear(double[] incomingInst, double[] responses) throws Exception {
        double[] r = (double[])responses.clone();
        double offset = 0.0;
        if (this.m_offsetVariable != null) {
            Attribute offsetAtt = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_offsetVariable);
            if (offsetAtt == null) {
                throw new Exception("[GeneralRegression] unable to find offset variable " + this.m_offsetVariable + " in the mining schema!");
            }
            offset = incomingInst[offsetAtt.index()];
        } else if (!Double.isNaN(this.m_offsetValue)) {
            offset = this.m_offsetValue;
        }
        double trials = 1.0;
        if (this.m_trialsVariable != null) {
            Attribute trialsAtt = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_trialsVariable);
            if (trialsAtt == null) {
                throw new Exception("[GeneralRegression] unable to find trials variable " + this.m_trialsVariable + " in the mining schema!");
            }
            trials = incomingInst[trialsAtt.index()];
        } else if (!Double.isNaN(this.m_trialsValue)) {
            trials = this.m_trialsValue;
        }
        double distParam = 0.0;
        if (this.m_linkFunction == LinkFunction.NEGBIN && this.m_distribution == Distribution.NEGBINOMIAL) {
            if (Double.isNaN(this.m_distParameter)) {
                throw new Exception("[GeneralRegression] no distribution parameter defined!");
            }
            distParam = this.m_distParameter;
        }
        double linkParam = 0.0;
        if (this.m_linkFunction == LinkFunction.POWER || this.m_linkFunction == LinkFunction.ODDSPOWER) {
            if (Double.isNaN(this.m_linkParameter)) {
                throw new Exception("[GeneralRegression] no link parameter defined!");
            }
            linkParam = this.m_linkParameter;
        }
        int i = 0;
        while (i < r.length) {
            responses[i] = this.m_linkFunction.eval(r[i], offset, trials, distParam, linkParam);
            ++i;
        }
    }

    private void computeResponseOrdinalMultinomial(double[] incomingInst, double[] responses) throws Exception {
        double[] r = (double[])responses.clone();
        double offset = 0.0;
        if (this.m_offsetVariable != null) {
            Attribute offsetAtt = this.m_miningSchema.getFieldsAsInstances().attribute(this.m_offsetVariable);
            if (offsetAtt == null) {
                throw new Exception("[GeneralRegression] unable to find offset variable " + this.m_offsetVariable + " in the mining schema!");
            }
            offset = incomingInst[offsetAtt.index()];
        } else if (!Double.isNaN(this.m_offsetValue)) {
            offset = this.m_offsetValue;
        }
        int i = 0;
        while (i < r.length) {
            responses[i] = i == 0 ? this.m_cumulativeLinkFunction.eval(r[i], offset) : (i == r.length - 1 ? 1.0 - responses[i - 1] : this.m_cumulativeLinkFunction.eval(r[i], offset) - responses[i - 1]);
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.1 $");
    }

    static enum CumulativeLinkFunction {
        NONE("none"){

            @Override
            double eval(double value, double offset) {
                return Double.NaN;
            }
        }
        ,
        LOGIT("logit"){

            @Override
            double eval(double value, double offset) {
                return 1.0 / (1.0 + Math.exp(-(value + offset)));
            }
        }
        ,
        PROBIT("probit"){

            @Override
            double eval(double value, double offset) {
                return Maths.pnorm(value + offset);
            }
        }
        ,
        CLOGLOG("cloglog"){

            @Override
            double eval(double value, double offset) {
                return 1.0 - Math.exp(-Math.exp(value + offset));
            }
        }
        ,
        LOGLOG("loglog"){

            @Override
            double eval(double value, double offset) {
                return Math.exp(-Math.exp(-(value + offset)));
            }
        }
        ,
        CAUCHIT("cauchit"){

            @Override
            double eval(double value, double offset) {
                return 0.5 + 0.3183098861837907 * Math.atan(value + offset);
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3);

        private CumulativeLinkFunction(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum Distribution {
        NONE("none"),
        NORMAL("normal"),
        BINOMIAL("binomial"),
        GAMMA("gamma"),
        INVGAUSSIAN("igauss"),
        NEGBINOMIAL("negbin"),
        POISSON("poisson");

        private final String m_stringVal;

        private Distribution(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum LinkFunction {
        NONE("none"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return Double.NaN;
            }
        }
        ,
        CLOGLOG("cloglog"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return (1.0 - Math.exp(-Math.exp(value + offset))) * trials;
            }
        }
        ,
        IDENTITY("identity"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return (value + offset) * trials;
            }
        }
        ,
        LOG("log"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return Math.exp(value + offset) * trials;
            }
        }
        ,
        LOGC("logc"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return (1.0 - Math.exp(value + offset)) * trials;
            }
        }
        ,
        LOGIT("logit"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return 1.0 / (1.0 + Math.exp(-(value + offset))) * trials;
            }
        }
        ,
        LOGLOG("loglog"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return Math.exp(-Math.exp(-(value + offset))) * trials;
            }
        }
        ,
        NEGBIN("negbin"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return 1.0 / (distParam * (Math.exp(-(value + offset)) - 1.0)) * trials;
            }
        }
        ,
        ODDSPOWER("oddspower"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return linkParam < 0.0 || linkParam > 0.0 ? 1.0 / (1.0 + Math.pow(1.0 + linkParam * (value + offset), -1.0 / linkParam)) * trials : 1.0 / (1.0 + Math.exp(-(value + offset))) * trials;
            }
        }
        ,
        POWER("power"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return linkParam < 0.0 || linkParam > 0.0 ? Math.pow(value + offset, 1.0 / linkParam) * trials : Math.exp(value + offset) * trials;
            }
        }
        ,
        PROBIT("probit"){

            @Override
            double eval(double value, double offset, double trials, double distParam, double linkParam) {
                return Maths.pnorm(value + offset) * trials;
            }
        };

        private final String m_stringVal;

        abstract double eval(double var1, double var3, double var5, double var7, double var9);

        private LinkFunction(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static enum ModelType {
        REGRESSION("regression"),
        GENERALLINEAR("generalLinear"),
        MULTINOMIALLOGISTIC("multinomialLogistic"),
        ORDINALMULTINOMIAL("ordinalMultinomial"),
        GENERALIZEDLINEAR("generalizedLinear");

        private final String m_stringVal;

        private ModelType(String name) {
            this.m_stringVal = name;
        }

        public String toString() {
            return this.m_stringVal;
        }
    }

    static class PCell
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_targetCategory = null;
        protected String m_parameterName = null;
        protected double m_beta = 0.0;
        protected int m_df = -1;

        PCell() {
        }
    }

    static class PPCell
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_predictorName = null;
        protected String m_parameterName = null;
        protected double m_value = 0.0;
        protected String m_targetCategory = null;

        PPCell() {
        }
    }

    static class Parameter
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_name = null;
        protected String m_label = null;

        Parameter() {
        }
    }

    static class Predictor
    implements Serializable {
        private static final long serialVersionUID = 6502780192411755341L;
        protected String m_name = null;
        protected int m_miningSchemaIndex = -1;

        Predictor() {
        }

        public String toString() {
            return this.m_name;
        }
    }
}

