/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.BIFReader;
import weka.classifiers.bayes.net.ParentSet;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class SearchAlgorithm
implements OptionHandler,
Serializable,
RevisionHandler {
    static final long serialVersionUID = 6164792240778525312L;
    protected int m_nMaxNrOfParents = 1;
    protected boolean m_bInitAsNaiveBayes = true;
    protected boolean m_bMarkovBlanketClassifier = false;
    protected String m_sInitalBIFFile;

    protected boolean addArcMakesSense(BayesNet bayesNet, Instances instances, int iAttributeHead, int iAttributeTail) {
        if (iAttributeHead == iAttributeTail) {
            return false;
        }
        if (this.isArc(bayesNet, iAttributeHead, iAttributeTail)) {
            return false;
        }
        int nNodes = instances.numAttributes();
        boolean[] bDone = new boolean[nNodes];
        int iNode = 0;
        while (iNode < nNodes) {
            bDone[iNode] = false;
            ++iNode;
        }
        bayesNet.getParentSet(iAttributeHead).addParent(iAttributeTail, instances);
        iNode = 0;
        while (iNode < nNodes) {
            boolean bFound = false;
            int iNode2 = 0;
            while (!bFound && iNode2 < nNodes) {
                if (!bDone[iNode2]) {
                    boolean bHasNoParents = true;
                    int iParent = 0;
                    while (iParent < bayesNet.getParentSet(iNode2).getNrOfParents()) {
                        if (!bDone[bayesNet.getParentSet(iNode2).getParent(iParent)]) {
                            bHasNoParents = false;
                        }
                        ++iParent;
                    }
                    if (bHasNoParents) {
                        bDone[iNode2] = true;
                        bFound = true;
                    }
                }
                ++iNode2;
            }
            if (!bFound) {
                bayesNet.getParentSet(iAttributeHead).deleteLastParent(instances);
                return false;
            }
            ++iNode;
        }
        bayesNet.getParentSet(iAttributeHead).deleteLastParent(instances);
        return true;
    }

    protected boolean reverseArcMakesSense(BayesNet bayesNet, Instances instances, int iAttributeHead, int iAttributeTail) {
        if (iAttributeHead == iAttributeTail) {
            return false;
        }
        if (!this.isArc(bayesNet, iAttributeHead, iAttributeTail)) {
            return false;
        }
        int nNodes = instances.numAttributes();
        boolean[] bDone = new boolean[nNodes];
        int iNode = 0;
        while (iNode < nNodes) {
            bDone[iNode] = false;
            ++iNode;
        }
        bayesNet.getParentSet(iAttributeTail).addParent(iAttributeHead, instances);
        iNode = 0;
        while (iNode < nNodes) {
            boolean bFound = false;
            int iNode2 = 0;
            while (!bFound && iNode2 < nNodes) {
                if (!bDone[iNode2]) {
                    ParentSet parentSet = bayesNet.getParentSet(iNode2);
                    boolean bHasNoParents = true;
                    int iParent = 0;
                    while (iParent < parentSet.getNrOfParents()) {
                        if (!(bDone[parentSet.getParent(iParent)] || iNode2 == iAttributeHead && parentSet.getParent(iParent) == iAttributeTail)) {
                            bHasNoParents = false;
                        }
                        ++iParent;
                    }
                    if (bHasNoParents) {
                        bDone[iNode2] = true;
                        bFound = true;
                    }
                }
                ++iNode2;
            }
            if (!bFound) {
                bayesNet.getParentSet(iAttributeTail).deleteLastParent(instances);
                return false;
            }
            ++iNode;
        }
        bayesNet.getParentSet(iAttributeTail).deleteLastParent(instances);
        return true;
    }

    protected boolean isArc(BayesNet bayesNet, int iAttributeHead, int iAttributeTail) {
        int iParent = 0;
        while (iParent < bayesNet.getParentSet(iAttributeHead).getNrOfParents()) {
            if (bayesNet.getParentSet(iAttributeHead).getParent(iParent) == iAttributeTail) {
                return true;
            }
            ++iParent;
        }
        return false;
    }

    public Enumeration listOptions() {
        return new Vector(0).elements();
    }

    public void setOptions(String[] options) throws Exception {
    }

    public String[] getOptions() {
        return new String[0];
    }

    public String toString() {
        return "SearchAlgorithm\n";
    }

    public void buildStructure(BayesNet bayesNet, Instances instances) throws Exception {
        if (this.m_sInitalBIFFile != null && !this.m_sInitalBIFFile.equals("")) {
            BIFReader localBiReader = new BIFReader().processFile(this.m_sInitalBIFFile);
            int iAttribute = 0;
            while (iAttribute < instances.numAttributes()) {
                int iNode = localBiReader.getNode(bayesNet.getNodeName(iAttribute));
                int iParent = 0;
                while (iParent < localBiReader.getParentSet(iNode).getNrOfParents()) {
                    String sParent = localBiReader.getNodeName(localBiReader.getParentSet(iNode).getParent(iParent));
                    int nParent = 0;
                    while (nParent < bayesNet.getNrOfNodes() && !bayesNet.getNodeName(nParent).equals(sParent)) {
                        ++nParent;
                    }
                    if (nParent < bayesNet.getNrOfNodes()) {
                        bayesNet.getParentSet(iAttribute).addParent(nParent, instances);
                    } else {
                        System.err.println("Warning: Node " + sParent + " is ignored. It is found in initial network but not in data set.");
                    }
                    ++iParent;
                }
                ++iAttribute;
            }
        } else if (this.m_bInitAsNaiveBayes) {
            int iClass = instances.classIndex();
            int iAttribute = 0;
            while (iAttribute < instances.numAttributes()) {
                if (iAttribute != iClass) {
                    bayesNet.getParentSet(iAttribute).addParent(iClass, instances);
                }
                ++iAttribute;
            }
        }
        this.search(bayesNet, instances);
        if (this.m_bMarkovBlanketClassifier) {
            this.doMarkovBlanketCorrection(bayesNet, instances);
        }
    }

    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
    }

    protected void doMarkovBlanketCorrection(BayesNet bayesNet, Instances instances) {
        int iClass = instances.classIndex();
        ParentSet ancestors = new ParentSet();
        int nOldSize = 0;
        ancestors.addParent(iClass, instances);
        while (nOldSize != ancestors.getNrOfParents()) {
            nOldSize = ancestors.getNrOfParents();
            int iNode = 0;
            while (iNode < nOldSize) {
                int iCurrent = ancestors.getParent(iNode);
                ParentSet p = bayesNet.getParentSet(iCurrent);
                int iParent = 0;
                while (iParent < p.getNrOfParents()) {
                    if (!ancestors.contains(p.getParent(iParent))) {
                        ancestors.addParent(p.getParent(iParent), instances);
                    }
                    ++iParent;
                }
                ++iNode;
            }
        }
        int iAttribute = 0;
        while (iAttribute < instances.numAttributes()) {
            boolean bIsInMarkovBoundary = iAttribute == iClass || bayesNet.getParentSet(iAttribute).contains(iClass) || bayesNet.getParentSet(iClass).contains(iAttribute);
            int iAttribute2 = 0;
            while (!bIsInMarkovBoundary && iAttribute2 < instances.numAttributes()) {
                bIsInMarkovBoundary = bayesNet.getParentSet(iAttribute2).contains(iAttribute) && bayesNet.getParentSet(iAttribute2).contains(iClass);
                ++iAttribute2;
            }
            if (!bIsInMarkovBoundary) {
                if (ancestors.contains(iAttribute)) {
                    if (bayesNet.getParentSet(iClass).getCardinalityOfParents() < 1024) {
                        bayesNet.getParentSet(iClass).addParent(iAttribute, instances);
                    }
                } else {
                    bayesNet.getParentSet(iAttribute).addParent(iClass, instances);
                }
            }
            ++iAttribute;
        }
    }

    protected void setMarkovBlanketClassifier(boolean bMarkovBlanketClassifier) {
        this.m_bMarkovBlanketClassifier = bMarkovBlanketClassifier;
    }

    protected boolean getMarkovBlanketClassifier() {
        return this.m_bMarkovBlanketClassifier;
    }

    public String maxNrOfParentsTipText() {
        return "Set the maximum number of parents a node in the Bayes net can have. When initialized as Naive Bayes, setting this parameter to 1 results in a Naive Bayes classifier. When set to 2, a Tree Augmented Bayes Network (TAN) is learned, and when set >2, a Bayes Net Augmented Bayes Network (BAN) is learned. By setting it to a value much larger than the number of nodes in the network (the default of 100000 pretty much guarantees this), no restriction on the number of parents is enforced";
    }

    public String initAsNaiveBayesTipText() {
        return "When set to true (default), the initial network used for structure learning is a Naive Bayes Network, that is, a network with an arrow from the classifier node to each other node. When set to false, an empty network is used as initial network structure";
    }

    protected String markovBlanketClassifierTipText() {
        return "When set to true (default is false), after a network structure is learned a Markov Blanket correction is applied to the network structure. This ensures that all nodes in the network are part of the Markov blanket of the classifier node.";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.9 $");
    }
}

