/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.estimate;

import java.util.Enumeration;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.estimate.BayesNetEstimator;
import weka.classifiers.bayes.net.estimate.DiscreteEstimatorBayes;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.estimators.Estimator;

public class SimpleEstimator
extends BayesNetEstimator {
    static final long serialVersionUID = 5874941612331806172L;

    public String globalInfo() {
        return "SimpleEstimator is used for estimating the conditional probability tables of a Bayes network once the structure has been learned. Estimates probabilities directly from data.";
    }

    public void estimateCPTs(BayesNet bayesNet) throws Exception {
        this.initCPTs(bayesNet);
        Enumeration enumInsts = bayesNet.m_Instances.enumerateInstances();
        while (enumInsts.hasMoreElements()) {
            Instance instance = (Instance)enumInsts.nextElement();
            this.updateClassifier(bayesNet, instance);
        }
    }

    public void updateClassifier(BayesNet bayesNet, Instance instance) throws Exception {
        int iAttribute = 0;
        while (iAttribute < bayesNet.m_Instances.numAttributes()) {
            double iCPT = 0.0;
            int iParent = 0;
            while (iParent < bayesNet.getParentSet(iAttribute).getNrOfParents()) {
                int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                iCPT = iCPT * (double)bayesNet.m_Instances.attribute(nParent).numValues() + instance.value(nParent);
                ++iParent;
            }
            bayesNet.m_Distributions[iAttribute][(int)iCPT].addValue(instance.value(iAttribute), instance.weight());
            ++iAttribute;
        }
    }

    public void initCPTs(BayesNet bayesNet) throws Exception {
        Instances instances = bayesNet.m_Instances;
        int nMaxParentCardinality = 1;
        int iAttribute = 0;
        while (iAttribute < instances.numAttributes()) {
            if (bayesNet.getParentSet(iAttribute).getCardinalityOfParents() > nMaxParentCardinality) {
                nMaxParentCardinality = bayesNet.getParentSet(iAttribute).getCardinalityOfParents();
            }
            ++iAttribute;
        }
        bayesNet.m_Distributions = new Estimator[instances.numAttributes()][nMaxParentCardinality];
        iAttribute = 0;
        while (iAttribute < instances.numAttributes()) {
            int iParent = 0;
            while (iParent < bayesNet.getParentSet(iAttribute).getCardinalityOfParents()) {
                bayesNet.m_Distributions[iAttribute][iParent] = new DiscreteEstimatorBayes(instances.attribute(iAttribute).numValues(), this.m_fAlpha);
                ++iParent;
            }
            ++iAttribute;
        }
    }

    public double[] distributionForInstance(BayesNet bayesNet, Instance instance) throws Exception {
        Instances instances = bayesNet.m_Instances;
        int nNumClasses = instances.numClasses();
        double[] fProbs = new double[nNumClasses];
        int iClass = 0;
        while (iClass < nNumClasses) {
            fProbs[iClass] = 1.0;
            ++iClass;
        }
        iClass = 0;
        while (iClass < nNumClasses) {
            double logfP = 0.0;
            int iAttribute = 0;
            while (iAttribute < instances.numAttributes()) {
                double iCPT = 0.0;
                int iParent = 0;
                while (iParent < bayesNet.getParentSet(iAttribute).getNrOfParents()) {
                    int nParent = bayesNet.getParentSet(iAttribute).getParent(iParent);
                    iCPT = nParent == instances.classIndex() ? iCPT * (double)nNumClasses + (double)iClass : iCPT * (double)instances.attribute(nParent).numValues() + instance.value(nParent);
                    ++iParent;
                }
                logfP = iAttribute == instances.classIndex() ? (logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(iClass))) : (logfP += Math.log(bayesNet.m_Distributions[iAttribute][(int)iCPT].getProbability(instance.value(iAttribute))));
                ++iAttribute;
            }
            int n = iClass++;
            fProbs[n] = fProbs[n] + logfP;
        }
        double fMax = fProbs[0];
        int iClass2 = 0;
        while (iClass2 < nNumClasses) {
            if (fProbs[iClass2] > fMax) {
                fMax = fProbs[iClass2];
            }
            ++iClass2;
        }
        iClass2 = 0;
        while (iClass2 < nNumClasses) {
            fProbs[iClass2] = Math.exp(fProbs[iClass2] - fMax);
            ++iClass2;
        }
        Utils.normalize(fProbs);
        return fProbs;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.6 $");
    }
}

