/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.util.Pair;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class PairItemEditor
implements ToggleItemEditor,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemEditor editor;
    protected transient Pair pair;
    protected int pairItem = 1;

    public PairItemEditor(ItemEditor editor, int pairItem) {
        this.editor = editor;
        this.pairItem = pairItem;
        if (this.pairItem < 1 || this.pairItem > 2) {
            this.pairItem = 1;
        }
    }

    public Object getValue() {
        if (this.editor != null && this.pair != null) {
            Object data = this.editor.getValue();
            if (this.pairItem == 1) {
                this.pair.first = data;
            } else {
                this.pair.second = data;
            }
            return this.pair;
        }
        if (this.editor != null) {
            return this.editor.getValue();
        }
        return this.pair;
    }

    public Component getComponent() {
        if (this.editor != null) {
            return this.editor.getComponent();
        }
        return null;
    }

    public boolean isToggle(Object data, Rectangle rect, ItemEditSite site) {
        if (this.editor != null && this.editor instanceof ToggleItemEditor) {
            return ((ToggleItemEditor)this.editor).isToggle(data, rect, site);
        }
        return false;
    }

    public void startEdit(Object data, Rectangle bounds, ItemEditSite editSite) {
        if (data instanceof Pair) {
            this.pair = (Pair)data;
            Object pairData = null;
            pairData = this.pairItem == 1 ? this.pair.first : this.pair.second;
            this.editor.startEdit(pairData, bounds, editSite);
        } else {
            this.pair = null;
            this.editor.startEdit(data, bounds, editSite);
        }
    }

    public void changeBounds(Rectangle bounds) {
        if (this.editor != null) {
            this.editor.changeBounds(bounds);
        }
    }

    public boolean canPost() {
        if (this.editor != null) {
            return this.editor.canPost();
        }
        return false;
    }

    public void endEdit(boolean posted) {
        if (this.editor != null) {
            this.editor.endEdit(posted);
        }
        this.pair = null;
    }

    public void addKeyListener(KeyListener l) {
        if (this.editor != null) {
            this.editor.addKeyListener(l);
        }
    }

    public void removeKeyListener(KeyListener l) {
        if (this.editor != null) {
            this.editor.removeKeyListener(l);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.editor instanceof Serializable ? this.editor : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof ItemEditor) {
            this.editor = (ItemEditor)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

