/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.util.DottedLine;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class FocusableItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    protected transient ItemPainter painter;
    protected boolean showRollover = true;
    protected Color rollColor = SystemColor.textHighlight;

    public FocusableItemPainter() {
        this.painter = null;
    }

    public FocusableItemPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public FocusableItemPainter(ItemPainter painter, boolean showRollover) {
        this.painter = painter;
        this.showRollover = showRollover;
    }

    public void setPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setRolloverColor(Color rollColor) {
        this.rollColor = rollColor;
    }

    public Color getRollColor() {
        return this.rollColor;
    }

    public Dimension getPreferredSize(Object object, Graphics g, int state, ItemPaintSite site) {
        return this.painter != null ? this.painter.getPreferredSize(object, g, state, site) : new Dimension(0, 0);
    }

    public void paint(Object object, Graphics g, Rectangle r, int state, ItemPaintSite site) {
        Color c = g.getColor();
        if (this.painter != null) {
            this.painter.paint(object, g, r, state, site);
        }
        if ((state & 2) != 0) {
            g.setColor(Color.black);
            g.setXORMode(Color.white);
            DottedLine.drawRect(g, r.x, r.y, r.width, r.height);
            g.setPaintMode();
        } else if (this.showRollover && (state & 0x40) != 0) {
            g.setColor(this.rollColor);
            g.drawRect(r.x, r.y, r.width - 1, r.height - 1);
        }
        g.setColor(c);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

