/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.UIManager;

public class DataToolTip
extends JToolTip
implements ItemPaintSite,
Serializable {
    public transient Object data;
    public transient ItemPainter painter;
    public transient int state;
    public transient ItemPaintSite site;
    public transient boolean active;

    public DataToolTip() {
    }

    public DataToolTip(JComponent c) {
        super.setComponent(c);
        if (c instanceof ItemPaintSite) {
            this.site = (ItemPaintSite)((Object)c);
        }
    }

    public void paintComponent(Graphics g) {
        if (this.active) {
            Dimension sz = this.getSize();
            if (this.painter != null) {
                this.state &= 0xFFFFFFFD;
                this.state &= 0xFFFFFFBF;
                this.painter.paint(this.data, g, new Rectangle(1, 1, sz.width - 2, sz.height - 2), this.state, this);
                g.setColor(SystemColor.control);
                g.drawRect(0, 0, sz.width - 1, sz.height - 1);
            } else {
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }

    public Dimension getPreferredSize() {
        Graphics g;
        if (this.active && (g = this.getComponent().getGraphics()) != null && this.painter != null) {
            Dimension sz = this.painter.getPreferredSize(this.data, g, this.state, this);
            return new Dimension(sz.width + 2, sz.height + 2);
        }
        return super.getPreferredSize();
    }

    public Color getBackground() {
        if (this.active && this.site != null && !this.site.isTransparent()) {
            return this.site.getBackground();
        }
        return UIManager.getColor("ToolTip.background");
    }

    public Color getForeground() {
        if (this.active && this.site != null) {
            return this.site.getForeground();
        }
        return UIManager.getColor("ToolTip.foreground");
    }

    public boolean isTransparent() {
        return false;
    }

    public Font getFont() {
        if (this.active && this.site != null) {
            return this.site.getFont();
        }
        return UIManager.getFont("ToolTip.font");
    }

    public int getAlignment() {
        return this.site != null ? this.site.getAlignment() : 33;
    }

    public Insets getItemMargins() {
        return this.site != null ? this.site.getItemMargins() : new Insets(2, 2, 2, 2);
    }

    public Component getSiteComponent() {
        return this.site != null ? this.site.getSiteComponent() : this;
    }
}

