/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class LookAndFeelEditor
implements PropertyEditor,
Serializable {
    protected LookAndFeel lookAndFeel;
    protected UIManager.LookAndFeelInfo[] list = UIManager.getInstalledLookAndFeels();
    protected PropertyChangeSupport propertyChanges = new PropertyChangeSupport(this);

    public LookAndFeelEditor() {
        this.lookAndFeel = UIManager.getLookAndFeel();
    }

    public void setValue(Object value) {
        if (value instanceof LookAndFeel) {
            this.lookAndFeel = (LookAndFeel)value;
        }
    }

    public Object getValue() {
        return this.lookAndFeel;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle rect) {
    }

    public String getJavaInitializationString() {
        return String.valueOf(String.valueOf(new StringBuffer("new ").append(this.lookAndFeel.getClass().getName()).append("()")));
    }

    public String getAsText() {
        return this.lookAndFeel.getName();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        try {
            String className = this.getClassNameFromLAFName(text);
            this.lookAndFeel = (LookAndFeel)Class.forName(className).newInstance();
        }
        catch (Exception x) {
            throw new IllegalArgumentException(x.getMessage());
        }
    }

    public String[] getTags() {
        String[] tags = new String[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            tags[i] = this.list[i].getName();
        }
        return tags;
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    public Component getCustomEditor() {
        return null;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChanges.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChanges.removePropertyChangeListener(l);
    }

    protected String getClassNameFromLAFName(String text) {
        for (int i = 0; i < this.list.length; ++i) {
            String name = this.list[i].getName();
            if (name != text && !(name != null & name.equals(text))) continue;
            return this.list[i].getClassName();
        }
        return text;
    }
}

