/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.dx.dataset.AccessEvent;
import com.borland.dx.dataset.AccessListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.DataSetAware;
import com.borland.dx.dataset.DataSetException;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.dx.dataset.StatusEvent;
import com.borland.dx.dataset.StatusListener;
import com.borland.jbcl.control.ButtonBar;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.util.BlackBox;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class NavigatorControl
extends ButtonBar
implements AccessListener,
ActionListener,
NavigationListener,
StatusListener,
DataSetAware,
BlackBox,
Serializable {
    public static final String FIRST = Res._First;
    public static final String PRIOR = Res._Prior;
    public static final String NEXT = Res._Next;
    public static final String LAST = Res._Last;
    public static final String INSERT = Res._Insert;
    public static final String DELETE = Res._Delete;
    public static final String POST = Res._Post;
    public static final String CANCEL = Res._Cancel1;
    public static final String DITTO = Res._Ditto;
    public static final String SAVE = Res._Save;
    public static final String REFRESH = Res._Refresh;
    private DataSet dataSet;
    private DataSet boundDataSet;
    private boolean addNotifyCalled;

    public NavigatorControl() {
        super.setBevelInner(0);
        super.setBevelOuter(0);
        super.setLayout(new GridLayout(1, 0));
        super.setMargins(new Insets(0, 0, 0, 0));
        super.setButtonType(2);
        super.setLabels(new String[]{FIRST, PRIOR, NEXT, LAST, INSERT, DELETE, POST, CANCEL, DITTO, SAVE, REFRESH});
        super.setImageNames(new String[]{"image/first.gif", "image/prior.gif", "image/next.gif", "image/last.gif", "image/insert.gif", "image/delete.gif", "image/post.gif", "image/cancel.gif", "image/ditto.gif", "image/save.gif", "image/refresh.gif"});
        this.addActionListener(this);
    }

    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (ps.width == 100) {
            ps.width = 275;
        }
        if (ps.height == 100) {
            ps.height = 26;
        }
        return ps;
    }

    public void addNotify() {
        super.addNotify();
        if (!this.addNotifyCalled) {
            this.addNotifyCalled = true;
            if (this.dataSet != null) {
                this.openDataSet(this.dataSet);
            }
        }
    }

    public void setLabels(String[] labels) {
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet newDataSet) {
        if (this.dataSet != null) {
            this.dataSet.removeAccessListener((AccessListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
            this.dataSet.removeStatusListener((StatusListener)this);
        }
        this.openDataSet(newDataSet);
        if (this.dataSet != null) {
            this.dataSet.addAccessListener((AccessListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
            this.dataSet.addStatusListener((StatusListener)this);
        }
    }

    private void openDataSet(DataSet newDataSet) {
        this.dataSet = newDataSet;
        if (this.dataSet == null) {
            this.rebuild();
            return;
        }
        if (this.addNotifyCalled && !this.dataSet.isOpen()) {
            try {
                this.dataSet.open();
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                return;
            }
        }
        if (this.dataSet.isOpen()) {
            this.boundDataSet = this.dataSet;
            this.setButtonEnabled(SAVE, this.boundDataSet.saveChangesSupported());
            this.setButtonEnabled(REFRESH, this.boundDataSet.refreshSupported());
            this.updateSelection();
        }
    }

    protected void rebuild() {
        if (!this.addNotifyCalled) {
            this.needsRebuild = true;
        }
        super.rebuild();
        if (this.dataSet != null) {
            this.setButtonEnabled(INSERT, this.dataSet.isEnableInsert());
        } else {
            this.setButtonEnabled(FIRST, false);
            this.setButtonEnabled(PRIOR, false);
            this.setButtonEnabled(NEXT, false);
            this.setButtonEnabled(LAST, false);
            this.setButtonEnabled(INSERT, false);
            this.setButtonEnabled(DELETE, false);
            this.setButtonEnabled(POST, false);
            this.setButtonEnabled(CANCEL, false);
            this.setButtonEnabled(DITTO, false);
            this.setButtonEnabled(SAVE, false);
            this.setButtonEnabled(REFRESH, false);
        }
    }

    public void accessChange(AccessEvent event) {
        switch (event.getID()) {
            case 1: {
                try {
                    this.openDataSet(this.dataSet);
                }
                catch (Exception ex) {
                    event.appendException(ex);
                }
                break;
            }
            case 2: {
                this.boundDataSet = null;
                break;
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        block22: {
            if (this.boundDataSet != null) {
                try {
                    String command = e.getActionCommand();
                    if (FIRST.equals(command)) {
                        this.boundDataSet.first();
                        break block22;
                    }
                    if (NEXT.equals(command)) {
                        if (this.boundDataSet.atLast()) {
                            this.boundDataSet.insertRow(false);
                        } else {
                            this.boundDataSet.next();
                        }
                        break block22;
                    }
                    if (PRIOR.equals(command)) {
                        this.boundDataSet.prior();
                        break block22;
                    }
                    if (LAST.equals(command)) {
                        this.boundDataSet.last();
                        break block22;
                    }
                    if (INSERT.equals(command)) {
                        this.boundDataSet.insertRow(true);
                        break block22;
                    }
                    if (DELETE.equals(command)) {
                        this.boundDataSet.deleteRow();
                        break block22;
                    }
                    if (POST.equals(command)) {
                        this.boundDataSet.post();
                        break block22;
                    }
                    if (DITTO.equals(command)) {
                        this.boundDataSet.dittoRow(false, true);
                        break block22;
                    }
                    if (CANCEL.equals(command)) {
                        if (this.boundDataSet.isEditing()) {
                            this.boundDataSet.cancel();
                        } else {
                            this.boundDataSet.cancelLoading();
                        }
                        break block22;
                    }
                    if (SAVE.equals(command) && this.dataSet != null) {
                        try {
                            this.dataSet.saveChanges();
                        }
                        catch (Exception ex) {
                            DataSetModel.handleException(this.dataSet, this, ex);
                        }
                        break block22;
                    }
                    if (REFRESH.equals(command) && this.dataSet != null) {
                        try {
                            this.dataSet.refresh();
                        }
                        catch (Exception ex) {
                            DataSetModel.handleException(this.dataSet, this, ex);
                        }
                        break block22;
                    }
                    return;
                }
                catch (DataSetException ex) {
                    DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
                }
            }
        }
    }

    public void statusMessage(StatusEvent event) {
        if (this.boundDataSet != null) {
            try {
                switch (event.getCode()) {
                    case 8: 
                    case 11: 
                    case 12: {
                        this.setButtonEnabled(INSERT, !this.boundDataSet.isEditingNewRow() && this.boundDataSet.isEnableInsert());
                        this.setButtonEnabled(DELETE, !this.boundDataSet.isEmpty() && this.boundDataSet.isEnableDelete());
                        this.setButtonEnabled(POST, this.boundDataSet.isEditing());
                        this.setButtonEnabled(CANCEL, this.boundDataSet.isEditing());
                        this.setButtonEnabled(DITTO, this.boundDataSet.isEditingNewRow() || !this.boundDataSet.isEditing());
                    }
                }
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
            }
        }
    }

    public void navigated(NavigationEvent event) {
        this.updateSelection();
    }

    private void updateSelection() {
        if (this.boundDataSet != null) {
            try {
                this.setButtonEnabled(FIRST, !this.boundDataSet.atFirst() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(PRIOR, !this.boundDataSet.atFirst() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(NEXT, !this.boundDataSet.atLast() || !this.boundDataSet.isEditingNewRow());
                this.setButtonEnabled(LAST, !this.boundDataSet.atLast() && !this.boundDataSet.isEmpty());
                this.setButtonEnabled(INSERT, this.boundDataSet.isEnableInsert());
                this.setButtonEnabled(DELETE, !this.boundDataSet.isEmpty() && this.boundDataSet.isEnableDelete());
            }
            catch (DataSetException ex) {
                DataSetModel.handleException(this.dataSet, this, (Exception)((Object)ex));
            }
        }
    }
}

