/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;

public abstract class StatisticsOpImage
extends OpImage {
    protected ROI roi;
    protected int xStart;
    protected int yStart;
    protected int xPeriod;
    protected int yPeriod;
    protected int maxWidth;
    protected int maxHeight;
    protected Hashtable properties = new Hashtable();

    public StatisticsOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, int n5, int n6) {
        super(renderedImage, null, null, StatisticsOpImage.layoutHelper(renderedImage), false);
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        this.roi = rOI;
        this.xStart = n;
        this.yStart = n2;
        this.xPeriod = n3;
        this.yPeriod = n4;
        this.maxWidth = n5;
        this.maxHeight = n6;
    }

    protected abstract void accumulateStatistics(String var1, Raster var2, Object var3);

    protected abstract Object createStatistics(String var1);

    public Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == null || object.equals(Image.UndefinedProperty)) {
            StatisticsOpImage statisticsOpImage = this;
            synchronized (statisticsOpImage) {
                object = this.createStatistics(string);
                if (!object.equals(Image.UndefinedProperty)) {
                    int n = this.source0.getMinTileX();
                    int n2 = this.source0.getMaxTileX();
                    int n3 = this.source0.getMinTileY();
                    int n4 = this.source0.getMaxTileY();
                    int n5 = n3;
                    while (n5 <= n4) {
                        int n6 = n;
                        while (n6 <= n2) {
                            if (this.tileIntersectsROI(n6, n5)) {
                                this.accumulateStatistics(string, this.getTile(n6, n5), object);
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                }
                this.setProperty(string, object);
                this.properties.put(string, object);
            }
        }
        return object;
    }

    public String[] getPropertyNames() {
        int n;
        String[] stringArray;
        String[] stringArray2 = this.getStatisticsNames();
        String[] stringArray3 = super.getPropertyNames();
        if (stringArray3 == null) {
            return stringArray2;
        }
        Vector<String[]> vector = new Vector<String[]>();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray = stringArray2[n2];
            String[] stringArray4 = PlanarImage.getPropertyNames(stringArray3, (String)stringArray);
            n = 0;
            while (n < stringArray4.length) {
                if (stringArray4.equals(stringArray)) {
                    vector.add(stringArray);
                }
                ++n;
            }
            ++n2;
        }
        if (vector.size() == 0) {
            return stringArray3;
        }
        stringArray = new String[stringArray3.length + vector.size()];
        System.arraycopy(stringArray3, 0, stringArray, 0, stringArray3.length);
        int n3 = stringArray3.length;
        n = 0;
        while (n < vector.size()) {
            stringArray[n3++] = (String)vector.get(n);
            ++n;
        }
        return stringArray;
    }

    protected abstract String[] getStatisticsNames();

    public Raster getTile(int n, int n2) {
        return this.source0.getTile(n, n2);
    }

    public Raster[] getTiles(Point[] pointArray) {
        return this.source0.getTiles(pointArray);
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage) {
        return new ImageLayout(renderedImage);
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return new Rectangle(rectangle);
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return new Rectangle(rectangle);
    }

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }
}

