/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.PlanarImage;

public final class BorderExtenderConstant
extends BorderExtender {
    private double[] constants;

    public BorderExtenderConstant(double[] dArray) {
        this.constants = dArray;
    }

    private int clamp(int n, int n2, int n3) {
        if (n < this.constants.length) {
            double d = this.constants[n];
            return d > (double)n2 ? (d > (double)n3 ? n3 : (int)d) : 0;
        }
        return 0;
    }

    public final void extend(WritableRaster writableRaster, PlanarImage planarImage) {
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands();
        int n4 = writableRaster.getMinX();
        int n5 = n4 + n;
        int n6 = writableRaster.getMinY();
        int n7 = n6 + n2;
        int n8 = Math.max(planarImage.getMinX(), n4);
        int n9 = Math.min(planarImage.getMaxX(), n5);
        int n10 = Math.max(planarImage.getMinY(), n6);
        int n11 = Math.min(planarImage.getMaxY(), n7);
        int[] nArray = new int[n3];
        float[] fArray = null;
        double[] dArray = null;
        int n12 = 0;
        while (n12 < n3) {
            switch (writableRaster.getSampleModel().getDataType()) {
                case 0: {
                    nArray[n12] = this.clamp(n12, 0, 255);
                    break;
                }
                case 2: {
                    nArray[n12] = this.clamp(n12, Short.MIN_VALUE, Short.MAX_VALUE);
                    break;
                }
                case 1: {
                    nArray[n12] = this.clamp(n12, 0, 65535);
                    break;
                }
                case 3: {
                    nArray[n12] = this.clamp(n12, Integer.MIN_VALUE, Integer.MAX_VALUE);
                    break;
                }
                case 4: {
                    fArray = new float[n3];
                    fArray[n12] = n12 < this.constants.length ? (float)this.constants[n12] : 0.0f;
                    break;
                }
                case 5: {
                    dArray = new double[n3];
                    dArray[n12] = n12 < this.constants.length ? this.constants[n12] : 0.0;
                    break;
                }
            }
            ++n12;
        }
        switch (writableRaster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray2 = new int[n * n3];
                int n13 = 0;
                int n14 = 0;
                while (n14 < n) {
                    int n15 = 0;
                    while (n15 < n3) {
                        nArray2[n13++] = nArray[n15];
                        ++n15;
                    }
                    ++n14;
                }
                int n16 = n6;
                while (n16 < n10) {
                    writableRaster.setPixels(n4, n16, n, 1, nArray2);
                    ++n16;
                }
                n16 = n10;
                while (n16 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n16, n8 - n4, 1, nArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n16, n5 - n9, 1, nArray2);
                    }
                    ++n16;
                }
                n16 = n11;
                while (n16 < n7) {
                    writableRaster.setPixels(n4, n16, n, 1, nArray2);
                    ++n16;
                }
                break;
            }
            case 4: {
                float[] fArray2 = new float[n * n3];
                int n17 = 0;
                int n18 = 0;
                while (n18 < n) {
                    int n19 = 0;
                    while (n19 < n3) {
                        fArray2[n17++] = fArray[n19];
                        ++n19;
                    }
                    ++n18;
                }
                int n20 = n6;
                while (n20 < n10) {
                    writableRaster.setPixels(n4, n20, n, 1, fArray2);
                    ++n20;
                }
                n20 = n10;
                while (n20 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n20, n8 - n4, 1, fArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n20, n5 - n9, 1, fArray2);
                    }
                    ++n20;
                }
                n20 = n11;
                while (n20 < n7) {
                    writableRaster.setPixels(n4, n20, n, 1, fArray2);
                    ++n20;
                }
                break;
            }
            case 5: {
                double[] dArray2 = new double[n * n3];
                int n21 = 0;
                int n22 = 0;
                while (n22 < n) {
                    int n23 = 0;
                    while (n23 < n3) {
                        dArray2[n21++] = dArray[n23];
                        ++n23;
                    }
                    ++n22;
                }
                int n24 = n6;
                while (n24 < n10) {
                    writableRaster.setPixels(n4, n24, n, 1, dArray2);
                    ++n24;
                }
                n24 = n10;
                while (n24 < n11) {
                    if (n4 < n8) {
                        writableRaster.setPixels(n4, n24, n8 - n4, 1, dArray2);
                    }
                    if (n9 < n5) {
                        writableRaster.setPixels(n9, n24, n5 - n9, 1, dArray2);
                    }
                    ++n24;
                }
                n24 = n11;
                while (n24 < n7) {
                    writableRaster.setPixels(n4, n24, n, 1, dArray2);
                    ++n24;
                }
                break;
            }
        }
    }
}

