/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class JDKWorkarounds {
    private JDKWorkarounds() {
    }

    public static void setRect(WritableRaster writableRaster, Raster raster) {
        JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
    }

    public static void setRect(WritableRaster writableRaster, Raster raster, int n, int n2) {
        int n3;
        SampleModel sampleModel = raster.getSampleModel();
        SampleModel sampleModel2 = writableRaster.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel2 instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)sampleModel2;
            DataBuffer dataBuffer = raster.getDataBuffer();
            DataBuffer dataBuffer2 = raster.getDataBuffer();
            if (dataBuffer instanceof DataBufferByte && dataBuffer2 instanceof DataBufferByte && multiPixelPackedSampleModel.getPixelBitStride() == 1 && multiPixelPackedSampleModel2.getPixelBitStride() == 1 && JDKWorkarounds.setRectBilevel(writableRaster, raster, n, n2)) {
                return;
            }
        }
        if ((n3 = writableRaster.getSampleModel().getDataType()) != 4 && n3 != 5) {
            writableRaster.setRect(n, n2, raster);
            return;
        }
        int n4 = raster.getWidth();
        int n5 = raster.getHeight();
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        int n8 = n + n6;
        int n9 = n2 + n7;
        int n10 = writableRaster.getMinX();
        int n11 = writableRaster.getMinY();
        int n12 = writableRaster.getWidth();
        int n13 = writableRaster.getHeight();
        if (n8 + n4 > n10 + n12) {
            n4 = n10 + n12 - n8;
        }
        if (n9 + n5 > n11 + n13) {
            n5 = n11 + n13 - n9;
        }
        switch (raster.getSampleModel().getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int[] nArray = null;
                int n14 = 0;
                while (n14 < n5) {
                    nArray = raster.getPixels(n6, n7 + n14, n4, 1, nArray);
                    writableRaster.setPixels(n8, n9 + n14, n4, 1, nArray);
                    ++n14;
                }
                break;
            }
            case 4: {
                float[] fArray = null;
                int n15 = 0;
                while (n15 < n5) {
                    fArray = raster.getPixels(n6, n7 + n15, n4, 1, fArray);
                    writableRaster.setPixels(n8, n9 + n15, n4, 1, fArray);
                    ++n15;
                }
                break;
            }
            case 5: {
                double[] dArray = null;
                int n16 = 0;
                while (n16 < n5) {
                    dArray = raster.getPixels(n6, n7 + n16, n4, 1, dArray);
                    writableRaster.setPixels(n8, n9 + n16, n4, 1, dArray);
                    ++n16;
                }
                break;
            }
        }
    }

    private static boolean setRectBilevel(WritableRaster writableRaster, Raster raster, int n, int n2) {
        block17: {
            int n3;
            int n4;
            int n5;
            int n6;
            byte[] byArray;
            byte[] byArray2;
            int n7;
            int n8;
            block16: {
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                n8 = raster.getWidth();
                n7 = raster.getHeight();
                int n15 = raster.getMinX();
                int n16 = raster.getMinY();
                int n17 = n + n15;
                int n18 = n2 + n16;
                int n19 = writableRaster.getMinX();
                int n20 = writableRaster.getMinY();
                int n21 = writableRaster.getWidth();
                int n22 = writableRaster.getHeight();
                if (n17 + n8 > n19 + n21) {
                    n8 = n19 + n21 - n17;
                }
                if (n18 + n7 > n20 + n22) {
                    n7 = n20 + n22 - n18;
                }
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
                MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
                DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
                byArray2 = dataBufferByte.getData();
                byArray = dataBufferByte2.getData();
                int n23 = raster.getSampleModelTranslateX();
                int n24 = raster.getSampleModelTranslateY();
                int n25 = multiPixelPackedSampleModel.getDataBitOffset();
                n6 = multiPixelPackedSampleModel.getScanlineStride();
                int n26 = (n16 - n24) * n6;
                int n27 = n25 + (n15 - n23);
                int n28 = writableRaster.getSampleModelTranslateX();
                int n29 = writableRaster.getSampleModelTranslateY();
                int n30 = multiPixelPackedSampleModel2.getDataBitOffset();
                n5 = n26 * 8 + n27;
                n4 = multiPixelPackedSampleModel2.getScanlineStride();
                int n31 = (n18 - n29) * n4;
                n3 = n31 * 8 + (n14 = n30 + (n17 - n28));
                if ((n5 & 7) != (n3 & 7)) break block16;
                int n32 = n8;
                int n33 = n5 & 7;
                if (n33 != 0) {
                    n13 = n5 >> 3;
                    n12 = n3 >> 3;
                    n11 = 255 >> n33;
                    if (n32 < (n33 = 8 - n33)) {
                        n11 &= n11 << 8 - n32;
                        n33 = n32;
                    }
                    n10 = 0;
                    while (n10 < n7) {
                        n9 = byArray[n12];
                        n9 &= ~n11;
                        byArray[n12] = (byte)(n9 |= byArray2[n13] & n11);
                        n13 += n6;
                        n12 += n4;
                        ++n10;
                    }
                    n5 += n33;
                    n3 += n33;
                    n32 -= n33;
                }
                if (n32 >= 8) {
                    n13 = n5 >> 3;
                    n12 = n3 >> 3;
                    n11 = n32 >> 3;
                    if (n11 == n6 && n6 == n4) {
                        System.arraycopy(byArray2, n13, byArray, n12, n6 * n7);
                    } else {
                        n10 = 0;
                        while (n10 < n7) {
                            System.arraycopy(byArray2, n13, byArray, n12, n11);
                            n13 += n6;
                            n12 += n4;
                            ++n10;
                        }
                    }
                    n33 = n11 * 8;
                    n5 += n33;
                    n3 += n33;
                    n32 -= n33;
                }
                if (n32 <= 0) break block17;
                n13 = n5 >> 3;
                n12 = n3 >> 3;
                n11 = 65280 >> n32 & 0xFF;
                n10 = 0;
                while (n10 < n7) {
                    n9 = byArray[n12];
                    n9 &= ~n11;
                    byArray[n12] = (byte)(n9 |= byArray2[n13] & n11);
                    n13 += n6;
                    n12 += n4;
                    ++n10;
                }
                break block17;
            }
            int n34 = 0;
            while (n34 < n7) {
                int n35;
                int n36;
                int n37;
                int n38;
                int n39 = n5;
                int n40 = n3;
                int n41 = n8;
                int n42 = n3 & 7;
                if (n42 > 0) {
                    n38 = n5 >> 8;
                    n37 = n3 >> 8;
                    n36 = 255 >> n42;
                    if (n41 < n42) {
                        n36 &= n36 << 8 - n41;
                        n42 = n41;
                    }
                    n35 = byArray[n37];
                    n35 &= ~n36;
                    byArray[n37] = (byte)(n35 |= byArray2[n38] & n36);
                    n5 += n42;
                    n3 += n42;
                    n41 -= n42;
                }
                if (n41 != 0) {
                    int n43;
                    n35 = n5 & 7;
                    int n44 = 7 - n35;
                    int n45 = 255 >> n44;
                    n38 = n5 >> 3;
                    n37 = n3 >> 3;
                    int n46 = byArray2[n38];
                    while (n41 >= 8) {
                        n43 = byArray2[n38 + 1];
                        int n47 = n46 << n35 | n43 >> n44 & n45;
                        byArray[n37] = (byte)n47;
                        n46 = n43;
                        ++n38;
                        ++n37;
                        n5 += 8;
                        n3 += 8;
                        n41 -= 8;
                    }
                    if (n41 > 0) {
                        n38 = n5 >> 3;
                        n37 = n3 >> 3;
                        n36 = 65280 >> n41 & 0xFF;
                        n43 = byArray[n37];
                        n43 &= ~n36;
                        byArray[n37] = (byte)(n43 |= byArray2[n38] & n36);
                    }
                    n5 = n39 + 8 * n6;
                    n3 = n40 + 8 * n4;
                }
                ++n34;
            }
        }
        return true;
    }
}

