/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;

final class InvertOpImage
extends PointOpImage {
    public InvertOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout) {
        super(renderedImage, tileCache, imageLayout, true);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: 
            case 5: {
                throw new RuntimeException(JaiI18N.getString("InvertOpImage0"));
            }
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n6;
                int n14 = n13 + n3 * n7;
                while (n13 < n14) {
                    byArray4[n13] = (byte)(255 - (byArray3[n12] & 0xFF));
                    n12 += n2;
                    n13 += n7;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int[] nArray5 = nArray2[0];
        int[] nArray6 = nArray4[0];
        int n8 = nArray6.length;
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n9 = 0;
                while (n9 < n8) {
                    nArray6[n9] = ~nArray5[n9] & 0xFF;
                    ++n9;
                }
                break;
            }
            case 1: {
                int n10 = 0;
                while (n10 < n8) {
                    nArray6[n10] = ~nArray5[n10] & 0xFFFF;
                    ++n10;
                }
                break;
            }
            case 2: {
                int n11 = 0;
                while (n11 < n8) {
                    nArray6[n11] = Short.MAX_VALUE - nArray5[n11];
                    ++n11;
                }
                break;
            }
            case 3: {
                int n12 = 0;
                while (n12 < n5) {
                    nArray5 = nArray2[n12];
                    nArray6 = nArray4[n12];
                    int n13 = nArray[n12];
                    int n14 = nArray3[n12];
                    int n15 = 0;
                    while (n15 < n4) {
                        int n16 = n13;
                        int n17 = n14;
                        n13 += n;
                        n14 += n6;
                        int n18 = n17 + n3 * n7;
                        while (n17 < n18) {
                            nArray6[n17] = Integer.MAX_VALUE - nArray5[n16];
                            n16 += n2;
                            n17 += n7;
                        }
                        ++n15;
                    }
                    ++n12;
                }
                break;
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n6;
                int n14 = n13 + n3 * n7;
                while (n13 < n14) {
                    sArray4[n13] = (short)(Short.MAX_VALUE - sArray3[n12]);
                    n12 += n2;
                    n13 += n7;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n8 = 0;
        while (n8 < n5) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n6;
                int n14 = n13 + n3 * n7;
                while (n13 < n14) {
                    sArray4[n13] = (short)(65535 - (sArray3[n12] & 0xFFFF));
                    n12 += n2;
                    n13 += n7;
                }
                ++n11;
            }
            ++n8;
        }
    }
}

