/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorConvertOp;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;

final class ColorConvertOpImage
extends PointOpImage {
    private boolean srcFloat;
    private boolean dstFloat;
    private ColorSpace srcColorSpace = null;
    private ColorSpace dstColorSpace = null;
    private ColorConvertOp colorConvertOp = null;
    private float srcMinValue = 0.0f;
    private float dstMinValue = 0.0f;
    private float srcRange = 1.0f;
    private float dstRange = 1.0f;

    public ColorConvertOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, ColorSpace colorSpace) {
        super(renderedImage, tileCache, imageLayout, true);
        this.srcColorSpace = renderedImage.getColorModel().getColorSpace();
        this.dstColorSpace = colorSpace;
        int n = renderedImage.getSampleModel().getTransferType();
        int n2 = this.sampleModel.getTransferType();
        this.srcFloat = n == 4 || n == 5;
        boolean bl = this.dstFloat = n2 == 4 || n2 == 5;
        if (!this.srcFloat && !this.dstFloat) {
            this.colorConvertOp = new ColorConvertOp(this.srcColorSpace, this.dstColorSpace, null);
        } else {
            this.srcMinValue = ColorConvertOpImage.getMinValue(n);
            this.dstMinValue = ColorConvertOpImage.getMinValue(n2);
            this.srcRange = ColorConvertOpImage.getRange(n);
            this.dstRange = ColorConvertOpImage.getRange(n2);
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        if (this.colorConvertOp != null) {
            WritableRaster writableRaster2;
            Raster raster = rasterArray[0];
            if (raster.getMinX() != rectangle.x || raster.getMinY() != rectangle.y || raster.getWidth() != rectangle.width || raster.getHeight() != rectangle.height) {
                raster = raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
            if ((writableRaster2 = writableRaster).getMinX() != rectangle.x || writableRaster2.getMinY() != rectangle.y || writableRaster2.getWidth() != rectangle.width || writableRaster2.getHeight() != rectangle.height) {
                writableRaster2 = writableRaster2.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
            this.colorConvertOp.filter(raster, writableRaster2);
        } else {
            int n = rectangle.y + rectangle.height;
            int n2 = rectangle.x + rectangle.width;
            int n3 = this.srcColorSpace.getNumComponents();
            float[] fArray = new float[n3];
            Raster raster = rasterArray[0];
            int n4 = rectangle.y;
            while (n4 < n) {
                int n5 = rectangle.x;
                while (n5 < n2) {
                    int n6;
                    fArray = raster.getPixel(n5, n4, fArray);
                    if (!this.srcFloat) {
                        n6 = 0;
                        while (n6 < n3) {
                            fArray[n6] = (fArray[n6] - this.srcMinValue) / this.srcRange;
                            ++n6;
                        }
                    }
                    float[] fArray2 = this.srcColorSpace.toCIEXYZ(fArray);
                    float[] fArray3 = this.dstColorSpace.fromCIEXYZ(fArray2);
                    if (!this.dstFloat) {
                        n6 = 0;
                        while (n6 < n3) {
                            fArray3[n6] = fArray3[n6] * this.dstRange + this.dstMinValue;
                            ++n6;
                        }
                    }
                    writableRaster.setPixel(n5, n4, fArray3);
                    ++n5;
                }
                ++n4;
            }
        }
    }

    private static float getMinValue(int n) {
        float f = 0.0f;
        switch (n) {
            case 0: {
                f = 0.0f;
                break;
            }
            case 2: {
                f = -32768.0f;
                break;
            }
            case 1: {
                f = 0.0f;
                break;
            }
            case 3: {
                f = -2.1474836E9f;
                break;
            }
            default: {
                f = 0.0f;
            }
        }
        return f;
    }

    private static float getRange(int n) {
        float f = 1.0f;
        switch (n) {
            case 0: {
                f = 255.0f;
                break;
            }
            case 2: {
                f = 65535.0f;
                break;
            }
            case 1: {
                f = 65535.0f;
                break;
            }
            case 3: {
                f = -1.0f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        return f;
    }
}

