/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.util;

public class FloatArray {
    private float[] elementData;
    private int size;

    public FloatArray() {
        this(10);
    }

    public FloatArray(int initialCapacity) {
        this.elementData = new float[initialCapacity];
    }

    public float[] toArray() {
        float[] result = new float[this.size];
        System.arraycopy(this.elementData, 0, result, 0, this.size);
        return result;
    }

    public float get(int index) {
        this.RangeCheck(index);
        return this.elementData[index];
    }

    public void set(int index, float value) {
        this.RangeCheck(index);
        this.elementData[index] = value;
    }

    public boolean add(float i) {
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = i;
        return true;
    }

    public void clear() {
        this.size = 0;
    }

    private void RangeCheck(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            float[] oldData = this.elementData;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new float[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.size);
        }
    }
}

