/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.FDGLAlgoT;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.MergeJoinBag;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;
import org.tigr.util.FloatMatrix;

public class Terrain
extends AbstractAlgorithm
implements InterfaceToObjects {
    private FloatMatrix experiment;
    private IntArray[] links;
    private FloatArray[] distances;
    private float[][] coords;
    private boolean stop = false;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters map = data.getParams();
        int function = map.getInt("distance-function", 1);
        float factor = map.getFloat("distance-factor", 1.0f);
        boolean absolute = map.getBoolean("distance-absolute", false);
        int k_neighbours = map.getInt("neighbors");
        this.experiment = data.getMatrix("experiment");
        if (!map.getBoolean("use-genes")) {
            FloatMatrix matrix = new FloatMatrix(this.experiment.getColumnDimension(), this.experiment.getRowDimension());
            for (int i = 0; i < this.experiment.getRowDimension(); ++i) {
                for (int j = 0; j < this.experiment.getColumnDimension(); ++j) {
                    matrix.set(j, i, this.experiment.get(i, j));
                }
            }
            this.experiment = matrix;
        }
        int nGenes = this.experiment.getRowDimension();
        int sum = nGenes * (nGenes + 1) / 2;
        int step = sum / 100 + 1;
        MergeJoinBag bag = new MergeJoinBag(nGenes, Math.min(k_neighbours, nGenes));
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 1, 100, "Analyzing Links...");
        this.fireValueChanged(event);
        event.setId(2);
        int progress = 0;
        for (int nCurIndOuter = 0; nCurIndOuter < nGenes; ++nCurIndOuter) {
            if (this.stop) {
                throw new AbortException();
            }
            ++progress;
            for (int nCurIndInner = nCurIndOuter + 1; nCurIndInner < nGenes; ++nCurIndInner) {
                float value = ExperimentUtil.geneDistance(this.experiment, null, nCurIndOuter, nCurIndInner, function, factor, absolute);
                bag.Assert(nCurIndOuter, nCurIndInner, value);
                if (++progress % step != 0) continue;
                event.setIntValue(progress / step);
                event.setDescription("Analysing Links...");
                this.fireValueChanged(event);
            }
        }
        bag.Normalize(0.01f);
        this.links = new IntArray[nGenes];
        this.distances = new FloatArray[nGenes];
        for (int i = 0; i < this.links.length; ++i) {
            this.links[i] = new IntArray();
            this.links[i].add(i);
            this.distances[i] = new FloatArray();
            this.distances[i].add(0.0f);
        }
        int bagRowCount = bag.getRowCount();
        int bagColCount = bag.getColumnCount();
        for (int i = 0; i < bagRowCount; ++i) {
            int[] pIntVect = bag.getIndVector(i);
            float[] pFloatVect = bag.getValVector(i);
            for (int j = 0; j < bagColCount; ++j) {
                if (pIntVect[j] < 0 || !(pFloatVect[j] > 0.0f)) continue;
                this.links[i].add(pIntVect[j]);
                this.distances[i].add(pFloatVect[j]);
                this.links[pIntVect[j]].add(i);
                this.distances[pIntVect[j]].add(pFloatVect[j]);
            }
        }
        Cluster cluster = new Cluster();
        NodeList clusterNodeList = cluster.getNodeList();
        clusterNodeList.ensureCapacity(nGenes);
        for (int i = 0; i < nGenes; ++i) {
            NodeValueList values = new NodeValueList(1);
            values.addNodeValue(new NodeValue("weights", (Object)this.distances[i].toArray()));
            Node node = new Node(this.links[i].toArray());
            node.setValues(values);
            clusterNodeList.addNode(node);
        }
        int[][] clusters = new int[this.links.length][];
        for (int i = 0; i < clusters.length; ++i) {
            clusters[i] = this.links[i].toArray();
        }
        this.coords = this.doCircularLayout(clusters);
        FDGLAlgoT fdgl = new FDGLAlgoT(this);
        fdgl.InitFromInterface();
        event.setId(1);
        event.setIntValue(100);
        event.setDescription("Building Layout...");
        this.fireValueChanged(event);
        event.setId(2);
        while (!fdgl.shouldStop()) {
            if (this.stop) {
                throw new AbortException();
            }
            fdgl.CalculateForceField();
            fdgl.MoveSystem();
            fdgl.UpdateSource();
            event.setIntValue((int)fdgl.getPercentage());
            event.setDescription("Building Layout...");
            this.fireValueChanged(event);
        }
        float max = this.normalize(this.coords);
        float sigma = 0.02f;
        AlgorithmData result = new AlgorithmData();
        result.addCluster("links", cluster);
        result.addMatrix("locations", new FloatMatrix(this.coords));
        result.addParam("sigma", String.valueOf(sigma));
        return result;
    }

    public void abort() {
        this.stop = true;
    }

    private float[][] doCircularLayout(int[][] clusters) {
        float[][] coords = new float[clusters.length][2];
        int[][] subnets = this.formRelevanceNetworks(clusters);
        int x_size = (int)Math.ceil(Math.sqrt(subnets.length));
        int y_size = (int)Math.ceil((float)subnets.length / (float)x_size);
        for (int y = 0; y < y_size; ++y) {
            int subnet;
            for (int x = 0; x < x_size && (subnet = y * x_size + x) < subnets.length; ++x) {
                this.arrangeGraph(subnets[subnet], coords, x, y);
            }
        }
        return coords;
    }

    private void arrangeGraph(int[] subnet, float[][] coords, int x, int y) {
        for (int i = 0; i < subnet.length; ++i) {
            coords[subnet[i]][0] = (float)(1000.0 * Math.cos(Math.PI * 2 * (double)i / (double)subnet.length) + (double)(1500 * (x + 1)));
            coords[subnet[i]][1] = (float)(1000.0 * Math.sin(Math.PI * 2 * (double)i / (double)subnet.length) + (double)(1500 * (y + 1)));
        }
    }

    private float normalize(float[][] coords) {
        int i;
        float max = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        for (i = 0; i < coords.length; ++i) {
            minX = Math.min(minX, coords[i][0]);
            minY = Math.min(minY, coords[i][1]);
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] - minX;
            coords[i][1] = coords[i][1] - minY;
        }
        for (i = 0; i < coords.length; ++i) {
            max = Math.max(max, Math.max(coords[i][0], coords[i][1]));
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] / max;
            coords[i][1] = coords[i][1] / max;
        }
        return max;
    }

    private void normalize(float[][] coords, int[][] clusters) {
        int j;
        int i;
        float max = 0.0f;
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        for (i = 0; i < clusters.length; ++i) {
            if (clusters[i].length <= 1) continue;
            for (j = 0; j < clusters[i].length; ++j) {
                minX = Math.min(minX, coords[clusters[i][j]][0]);
                minY = Math.min(minY, coords[clusters[i][j]][1]);
            }
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] - minX;
            coords[i][1] = coords[i][1] - minY;
        }
        for (i = 0; i < clusters.length; ++i) {
            if (clusters[i].length <= 1) continue;
            for (j = 0; j < clusters[i].length; ++j) {
                max = Math.max(max, Math.max(coords[clusters[i][j]][0], coords[clusters[i][j]][1]));
            }
        }
        for (i = 0; i < coords.length; ++i) {
            coords[i][0] = coords[i][0] / max;
            coords[i][1] = coords[i][1] / max;
        }
    }

    public int[][] formRelevanceNetworks(int[][] clusters) {
        int size = clusters.length;
        boolean[] visited = new boolean[size];
        Arrays.fill(visited, false);
        ArrayList<IntArray> subnets = new ArrayList<IntArray>();
        for (int node = 0; node < size; ++node) {
            if (visited[node]) continue;
            subnets.add(this.fillSubnet(new IntArray(), node, visited, clusters));
        }
        int subnets_size = subnets.size();
        int number_of_subnets = 0;
        for (int i = 0; i < subnets_size; ++i) {
            if (((IntArray)subnets.get(i)).getSize() <= 1) continue;
            ++number_of_subnets;
        }
        int[][] result = new int[number_of_subnets][];
        int subnet_pos = 0;
        for (int i = 0; i < subnets_size; ++i) {
            IntArray subnet = (IntArray)subnets.get(i);
            if (subnet.getSize() <= 1) continue;
            result[subnet_pos] = subnet.toArray();
            ++subnet_pos;
        }
        return result;
    }

    private IntArray fillSubnet(IntArray subnet, int root, boolean[] visited, int[][] clusters) {
        subnet.add(root);
        visited[root] = true;
        int[] cluster = clusters[root];
        for (int i = 1; i < cluster.length; ++i) {
            int node = cluster[i];
            if (visited[node]) continue;
            this.fillSubnet(subnet, node, visited, clusters);
        }
        return subnet;
    }

    @Override
    public int[] GetAllObjectsIds() {
        int number_of_genes = this.experiment.getRowDimension();
        int[] ids = new int[number_of_genes];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i;
        }
        return ids;
    }

    @Override
    public void GetObjectGeom(int iObjID, Vector2f pt) {
        pt.set(this.coords[iObjID][0], this.coords[iObjID][1]);
    }

    @Override
    public int GetAdjCountFor(int iObjId) {
        return this.links[iObjId].getSize() - 1;
    }

    @Override
    public void GetAdjInfoFor(int iObjId, IntArray rArrAdjIds, FloatArray rArrAdjVals) {
        int iSize = this.links[iObjId].getSize();
        rArrAdjIds.clear();
        rArrAdjVals.clear();
        for (int i = 1; i < iSize; ++i) {
            rArrAdjIds.add(this.links[iObjId].get(i));
            rArrAdjVals.add(this.distances[iObjId].get(i));
        }
    }

    @Override
    public void SetObjectGeom(Vector2f[] rRet) {
        for (int i = 0; i < rRet.length; ++i) {
            this.coords[i][0] = rRet[i].x;
            this.coords[i][1] = rRet[i].y;
        }
    }
}

