/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Vector2f;

public class RectDT {
    public float m_Left;
    public float m_Top;
    public float m_Right;
    public float m_Bottom;

    public RectDT() {
    }

    public RectDT(RectDT rIn) {
        this.set(rIn);
    }

    public void set(RectDT rIn) {
        this.m_Left = rIn.m_Left;
        this.m_Top = rIn.m_Top;
        this.m_Right = rIn.m_Right;
        this.m_Bottom = rIn.m_Bottom;
    }

    public float Width() {
        return this.m_Right - this.m_Left;
    }

    public float Height() {
        return this.m_Bottom - this.m_Top;
    }

    public void NormalizeRect() {
        float Tmp;
        if (this.m_Right < this.m_Left) {
            Tmp = this.m_Right;
            this.m_Right = this.m_Left;
            this.m_Left = Tmp;
        }
        if (this.m_Bottom < this.m_Top) {
            Tmp = this.m_Bottom;
            this.m_Bottom = this.m_Top;
            this.m_Top = Tmp;
        }
    }

    public void SetRect(Vector2f ptDLeftTop, Vector2f ptDRightBottom) {
        this.m_Left = ptDLeftTop.x;
        this.m_Top = ptDLeftTop.y;
        this.m_Right = ptDRightBottom.x;
        this.m_Bottom = ptDRightBottom.y;
    }

    public void MakeEmpty() {
        this.m_Left = Float.MAX_VALUE;
        this.m_Top = Float.MAX_VALUE;
        this.m_Right = -3.4028235E38f;
        this.m_Bottom = -3.4028235E38f;
    }

    public void IncludePoint(Vector2f rPt) {
        if (this.m_Left > rPt.x) {
            this.m_Left = rPt.x;
        }
        if (this.m_Right < rPt.x) {
            this.m_Right = rPt.x;
        }
        if (this.m_Top > rPt.y) {
            this.m_Top = rPt.y;
        }
        if (this.m_Bottom < rPt.y) {
            this.m_Bottom = rPt.y;
        }
    }

    public boolean PtInRect(Vector2f rIn) {
        return this.m_Left <= rIn.x && this.m_Right >= rIn.x && this.m_Top <= rIn.y && this.m_Bottom >= rIn.y;
    }

    public static float _hypot(float x, float y) {
        return (float)Math.sqrt(x * x + y * y);
    }

    public float Distance(Vector2f rIn) {
        if (rIn.y < this.m_Top) {
            if (rIn.x < this.m_Left) {
                return RectDT._hypot(rIn.x - this.m_Left, rIn.y - this.m_Top);
            }
            if (rIn.x > this.m_Right) {
                return RectDT._hypot(rIn.x - this.m_Right, rIn.y - this.m_Top);
            }
            return this.m_Top - rIn.y;
        }
        if (rIn.y > this.m_Bottom) {
            if (rIn.x < this.m_Left) {
                return RectDT._hypot(rIn.x - this.m_Left, rIn.y - this.m_Bottom);
            }
            if (rIn.x > this.m_Right) {
                return RectDT._hypot(rIn.x - this.m_Right, rIn.y - this.m_Bottom);
            }
            return rIn.y - this.m_Bottom;
        }
        if (rIn.x <= this.m_Left) {
            return this.m_Left - rIn.x;
        }
        if (rIn.x >= this.m_Right) {
            return rIn.x - this.m_Right;
        }
        return 0.0f;
    }
}

