/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.RectDT;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;

public class QuadTreeT {
    public SNode[] m_arrNodes;
    private InterfaceToObjects m_rInterface;
    private static final int c_iMaxQuadTreeTDepth = 15;
    public static final int LEFT_UP = 1;
    public static final int RIGHT_UP = 2;
    public static final int LEFT_DOWN = 3;
    public static final int RIGHT_DOWN = 4;

    private int GetLinearSize(int iDepth) {
        return (int)((Math.pow(4.0, iDepth) - 1.0) / 3.0 + 0.5);
    }

    private void Clear() {
        int n = this.m_arrNodes.length;
        for (int i = 0; i < n; ++i) {
            this.m_arrNodes[i].Destroy();
        }
    }

    private void SetNode(int iInd, int[] rArrIds) {
        if (rArrIds.length <= 0) {
            return;
        }
        int nSize = rArrIds.length;
        Vector2f ptSum = new Vector2f();
        Vector2f ptAvg = new Vector2f();
        Vector2f ptCur = new Vector2f();
        Vector2f ptTmp = new Vector2f();
        RectDT rectBounding = new RectDT();
        rectBounding.MakeEmpty();
        for (int i = 0; i < nSize; ++i) {
            this.m_rInterface.GetObjectGeom(rArrIds[i], ptTmp);
            ptCur.x = ptTmp.x;
            ptCur.y = ptTmp.y;
            rectBounding.IncludePoint(ptCur);
            ptSum.add((Tuple2f)ptCur);
        }
        ptAvg.set((Tuple2f)ptSum);
        ptAvg.scale(1.0f / (float)nSize);
        Vector2f midPoint = new Vector2f((rectBounding.m_Right + rectBounding.m_Left) / 2.0f, (rectBounding.m_Bottom + rectBounding.m_Top) / 2.0f);
        this.m_arrNodes[iInd].m_ptMid.set((Tuple2f)ptAvg);
        this.m_arrNodes[iInd].m_ptAvg.set((Tuple2f)ptAvg);
        this.m_arrNodes[iInd].m_Rect.set(rectBounding);
        this.m_arrNodes[iInd].m_iPointNumBehind = nSize;
        int iChildInd = this.GetChild(iInd, 1);
        if (iChildInd < 0 || nSize == 1) {
            this.m_arrNodes[iInd].SetLeaf();
            this.m_arrNodes[iInd].m_arrPointsIds = rArrIds;
            return;
        }
        IntArray arrLeftUpIds = new IntArray();
        IntArray arrRightUpIds = new IntArray();
        IntArray arrLeftDownIds = new IntArray();
        IntArray arrRightDownIds = new IntArray();
        for (int i = 0; i < nSize; ++i) {
            this.m_rInterface.GetObjectGeom(rArrIds[i], ptTmp);
            ptCur.set((Tuple2f)ptTmp);
            if (ptCur.x <= midPoint.x) {
                if (ptCur.y <= midPoint.y) {
                    arrLeftUpIds.add(rArrIds[i]);
                    continue;
                }
                arrLeftDownIds.add(rArrIds[i]);
                continue;
            }
            if (ptCur.y <= midPoint.y) {
                arrRightUpIds.add(rArrIds[i]);
                continue;
            }
            arrRightDownIds.add(rArrIds[i]);
        }
        this.SetNode(iChildInd, arrLeftUpIds.toArray());
        arrLeftUpIds = null;
        iChildInd = this.GetChild(iInd, 2);
        this.SetNode(iChildInd, arrRightUpIds.toArray());
        arrRightUpIds = null;
        iChildInd = this.GetChild(iInd, 3);
        this.SetNode(iChildInd, arrLeftDownIds.toArray());
        arrLeftDownIds = null;
        iChildInd = this.GetChild(iInd, 4);
        this.SetNode(iChildInd, arrRightDownIds.toArray());
        arrRightDownIds = null;
    }

    QuadTreeT(int iDepth, InterfaceToObjects rInterface) {
        if (iDepth > 15) {
            throw new IllegalArgumentException("The tree depth can't be more than 15");
        }
        this.m_rInterface = rInterface;
        int iSize = this.GetLinearSize(iDepth);
        this.m_arrNodes = new SNode[iSize];
        for (int i = 0; i < this.m_arrNodes.length; ++i) {
            this.m_arrNodes[i] = new SNode();
        }
    }

    void Initialize() {
        this.Clear();
        int[] arrObjIds = this.m_rInterface.GetAllObjectsIds();
        this.SetNode(0, arrObjIds);
    }

    int GetParent(int iChild) {
        return iChild > 0 ? iChild >> 2 : 0;
    }

    int GetChild(int iChild, int eDir) {
        int iNewInd = (iChild << 2) + eDir;
        if (iNewInd < 0 || iNewInd >= this.m_arrNodes.length) {
            iNewInd = -1;
        }
        return iNewInd;
    }

    public static class SNode {
        Vector2f m_ptMid = new Vector2f();
        Vector2f m_ptAvg = new Vector2f();
        public RectDT m_Rect = new RectDT();
        int m_iPointNumBehind;
        int[] m_arrPointsIds;

        public SNode() {
            this.Destroy();
        }

        public void Destroy() {
            this.m_arrPointsIds = null;
            this.m_ptMid.set(Float.MAX_VALUE, Float.MAX_VALUE);
            this.m_iPointNumBehind = 0;
        }

        public void Init(Vector2f rIn) {
            this.Destroy();
            this.m_ptMid.set((Tuple2f)rIn);
        }

        public void Init(int[] rIn) {
            this.Destroy();
            this.m_arrPointsIds = rIn;
        }

        public boolean IsLeaf() {
            return this.m_ptMid.x == Float.MAX_VALUE && this.m_ptMid.y == Float.MAX_VALUE;
        }

        public void SetLeaf() {
            this.m_ptMid.set(Float.MAX_VALUE, Float.MAX_VALUE);
        }
    }
}

