/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import java.util.Arrays;

public class MergeJoinBag {
    private int[][] m_pVectToInd;
    private float[][] m_pDistToVal;
    private float m_fltMin;
    private float m_fltMax;

    public int[] getIndVector(int row) {
        return this.m_pVectToInd[row];
    }

    public float[] getValVector(int row) {
        return this.m_pDistToVal[row];
    }

    public MergeJoinBag(int iRowCount, int iColumnCount) {
        this(iRowCount, iColumnCount, false);
    }

    public MergeJoinBag(int iRowCount, int iColumnCount, boolean bNoIndMatr) {
        int i;
        if (bNoIndMatr) {
            this.m_pVectToInd = null;
        } else {
            this.m_pVectToInd = new int[iRowCount][iColumnCount];
            for (i = 0; i < this.m_pVectToInd.length; ++i) {
                Arrays.fill(this.m_pVectToInd[i], -1);
            }
        }
        this.m_pDistToVal = new float[iRowCount][iColumnCount];
        for (i = 0; i < this.m_pDistToVal.length; ++i) {
            Arrays.fill(this.m_pDistToVal[i], Float.MAX_VALUE);
        }
        this.m_fltMin = Float.MAX_VALUE;
        this.m_fltMax = -3.4028235E38f;
    }

    public int getRowCount() {
        return this.m_pDistToVal.length;
    }

    public int getColumnCount() {
        if (this.m_pDistToVal.length <= 0 || this.m_pDistToVal[0] == null) {
            return 0;
        }
        return this.m_pDistToVal[0].length;
    }

    public void Clear() {
        this.m_pVectToInd = null;
        this.m_pDistToVal = null;
    }

    public void AppendTo(int iIndFrom, int iIndTo, float fltDist) {
        int iIndToInsert;
        int[] pFirstInt = this.getIndVector(iIndFrom);
        float[] pFirstDist = this.getValVector(iIndFrom);
        for (iIndToInsert = 0; iIndToInsert < pFirstDist.length && !(fltDist <= pFirstDist[iIndToInsert]); ++iIndToInsert) {
        }
        if (iIndToInsert < pFirstDist.length) {
            if (pFirstDist.length - iIndToInsert - 1 > 0) {
                System.arraycopy(pFirstDist, iIndToInsert, pFirstDist, iIndToInsert + 1, pFirstDist.length - iIndToInsert - 1);
                System.arraycopy(pFirstInt, iIndToInsert, pFirstInt, iIndToInsert + 1, pFirstInt.length - iIndToInsert - 1);
            }
            pFirstInt[iIndToInsert] = iIndTo;
            pFirstDist[iIndToInsert] = fltDist;
        }
    }

    public void Assert(int iIndFrom, int iIndTo, float fltDist) {
        this.m_fltMin = Math.min(this.m_fltMin, fltDist);
        this.m_fltMax = Math.max(this.m_fltMax, fltDist);
        this.AppendTo(iIndFrom, iIndTo, fltDist);
        this.AppendTo(iIndTo, iIndFrom, fltDist);
    }

    public void Normalize(float fltLow) {
        float delta = this.m_fltMax - this.m_fltMin;
        for (int i = 0; i < this.m_pDistToVal.length; ++i) {
            for (int j = 0; j < this.m_pDistToVal[i].length; ++j) {
                this.m_pDistToVal[i][j] = (1.0f - (this.m_pDistToVal[i][j] - this.m_fltMin) / delta) * (1.0f - fltLow) + fltLow;
            }
        }
    }
}

