/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.terrain;

import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.InterfaceToObjects;
import org.tigr.microarray.mev.cluster.algorithm.impl.terrain.QuadTreeT;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.FloatArray;
import org.tigr.microarray.mev.cluster.algorithm.impl.util.IntArray;

public class FDGLAlgoT {
    public static final float c_AttractiveRadius = 0.0f;
    public static final float c_RepulsiveRadius = 200.0f;
    public static final float c_dblFDGLAlgoThreshold = 1.0f;
    public static final int c_iQuadTreeDepth = 5;
    public static final int c_iHistoryQueueSize = 10;
    private Vector2f[] m_arrPoints;
    private SLink[][] m_arrLinks;
    private Vector2f m_rPt;
    private QuadTreeT m_QTree;
    private InterfaceToObjects m_pInterface;
    private Vector2f[] m_arrForceField;
    private float m_dblMaxForceLength;
    private int m_iDoNotMove;
    private float[] m_arrEnergyHist = new float[]{-1.0f, -1.0f, -1.0f, -1.0f};
    private int m_iEnergyIndex = 0;
    static final float MAX_ENERGY = 100.0f;

    public FDGLAlgoT(InterfaceToObjects pInterface) {
        this.m_pInterface = pInterface;
        this.m_QTree = new QuadTreeT(5, pInterface);
        this.m_rPt = new Vector2f(0.0f, 0.0f);
        this.m_iDoNotMove = -1;
    }

    private void PushEnergy(float fltEnergyValue) {
        this.m_arrEnergyHist[3] = this.m_arrEnergyHist[2];
        this.m_arrEnergyHist[2] = this.m_arrEnergyHist[1];
        this.m_arrEnergyHist[1] = this.m_arrEnergyHist[0];
        this.m_arrEnergyHist[0] = fltEnergyValue;
    }

    public float getPercentage() {
        return 100.0f * (float)this.m_iEnergyIndex / 100.0f;
    }

    public boolean shouldStop() {
        if ((float)this.m_iEnergyIndex > 100.0f) {
            return true;
        }
        if (this.m_arrEnergyHist[3] < 0.0f) {
            return false;
        }
        return false;
    }

    private static float CalcAttractiveForceFromR2(float R2) {
        float tmpVal = R2 - 0.0f;
        if (R2 > 40000.0f) {
            return 40000.0f;
        }
        if (tmpVal < 0.0f) {
            return 0.0f;
        }
        return tmpVal;
    }

    private static float CalcRepulsiveForceFromR2(float R2) {
        float tmpVal = 40000.0f - R2;
        if (tmpVal < 0.0f) {
            return 0.0f;
        }
        return tmpVal;
    }

    private Vector2f CalcAttractiveForcesAt(int iNode) {
        SLink[] rArrAdjNodes = this.m_arrLinks[iNode];
        int nAdjNodeSize = rArrAdjNodes.length;
        Vector2f vectResult = new Vector2f();
        if (nAdjNodeSize > 0) {
            float dblCurX = this.m_arrPoints[iNode].x;
            float dblCurY = this.m_arrPoints[iNode].y;
            Vector2f curVector = new Vector2f();
            for (int i = 0; i < nAdjNodeSize; ++i) {
                Vector2f rCurAdjNode = this.m_arrPoints[rArrAdjNodes[i].m_iToId];
                float CurWeight = rArrAdjNodes[i].m_Weight;
                curVector.set(rCurAdjNode.x - dblCurX, rCurAdjNode.y - dblCurY);
                float Norm = curVector.length();
                if (Norm <= 0.0f) continue;
                float Norm2 = Norm * Norm;
                float attractive_factor = FDGLAlgoT.CalcAttractiveForceFromR2(Norm2);
                curVector.scale(CurWeight * attractive_factor / Norm);
                vectResult.add((Tuple2f)curVector);
            }
        }
        return vectResult;
    }

    private Vector2f CalcRepulsiveForcesAtBruteForce(float dblX, float dblY) {
        int iSize = this.m_arrPoints.length;
        Vector2f vectResult = new Vector2f();
        Vector2f curVector = new Vector2f();
        for (int i = 0; i < iSize; ++i) {
            curVector.set(dblX - this.m_arrPoints[i].x, dblY - this.m_arrPoints[i].y);
            float Norm = curVector.length();
            float Norm2 = Norm * Norm;
            if (Norm2 <= 0.0f || Norm <= 0.0f) continue;
            float repulsive_factor = FDGLAlgoT.CalcRepulsiveForceFromR2(Norm2);
            curVector.scale(repulsive_factor / Norm);
            vectResult.add((Tuple2f)curVector);
        }
        return vectResult;
    }

    protected Vector2f CalcRepulsiveForcesAt(float X, float Y) {
        this.m_rPt.x = X;
        this.m_rPt.y = Y;
        return this.GetRepulsiveForceFrom(0);
    }

    protected Vector2f GetRepulsiveForceFrom(int iNode) {
        Vector2f ptRes = new Vector2f(0.0f, 0.0f);
        if (iNode < 0) {
            return ptRes;
        }
        QuadTreeT.SNode rQuadTreeNode = this.m_QTree.m_arrNodes[iNode];
        if (rQuadTreeNode.m_iPointNumBehind == 0) {
            return ptRes;
        }
        if (rQuadTreeNode.m_iPointNumBehind == 1) {
            ptRes.x = this.m_rPt.x - this.m_arrPoints[rQuadTreeNode.m_arrPointsIds[0]].x;
            ptRes.y = this.m_rPt.y - this.m_arrPoints[rQuadTreeNode.m_arrPointsIds[0]].y;
            float Norm = ptRes.length();
            if (Norm <= 0.0f) {
                return ptRes;
            }
            float Norm2 = Norm * Norm;
            float repulsive_factor = FDGLAlgoT.CalcRepulsiveForceFromR2(Norm2);
            ptRes.scale(repulsive_factor / Norm);
            return ptRes;
        }
        boolean bPtInCurRect = rQuadTreeNode.m_Rect.PtInRect(this.m_rPt);
        boolean bUseAveragePt = false;
        boolean bIsLeaf = rQuadTreeNode.IsLeaf();
        if (!bPtInCurRect) {
            boolean bl = bUseAveragePt = rQuadTreeNode.m_Rect.Distance(this.m_rPt) / Math.max(rQuadTreeNode.m_Rect.Width(), rQuadTreeNode.m_Rect.Height()) >= 1.0f;
        }
        if (!bIsLeaf && !bUseAveragePt) {
            int iChild = this.m_QTree.GetChild(iNode, 1);
            ptRes = this.GetRepulsiveForceFrom(iChild);
            iChild = this.m_QTree.GetChild(iNode, 2);
            ptRes.add((Tuple2f)this.GetRepulsiveForceFrom(iChild));
            iChild = this.m_QTree.GetChild(iNode, 3);
            ptRes.add((Tuple2f)this.GetRepulsiveForceFrom(iChild));
            iChild = this.m_QTree.GetChild(iNode, 4);
            ptRes.add((Tuple2f)this.GetRepulsiveForceFrom(iChild));
            return ptRes;
        }
        if (bUseAveragePt) {
            ptRes.x = this.m_rPt.x - rQuadTreeNode.m_ptAvg.x;
            ptRes.y = this.m_rPt.y - rQuadTreeNode.m_ptAvg.y;
            float Norm = ptRes.length();
            if (Norm <= 0.0f) {
                return ptRes;
            }
            float Norm2 = Norm * Norm;
            float repulsive_factor = FDGLAlgoT.CalcRepulsiveForceFromR2(Norm2);
            if (repulsive_factor <= 0.0f) {
                ptRes.x = 0.0f;
                ptRes.y = 0.0f;
                return ptRes;
            }
            ptRes.scale(repulsive_factor * (float)rQuadTreeNode.m_iPointNumBehind / Norm);
            return ptRes;
        }
        Vector2f curVector = new Vector2f();
        int iSize = rQuadTreeNode.m_arrPointsIds.length;
        for (int i = 0; i < iSize; ++i) {
            curVector.set(this.m_rPt.x - this.m_arrPoints[rQuadTreeNode.m_arrPointsIds[i]].x, this.m_rPt.y - this.m_arrPoints[rQuadTreeNode.m_arrPointsIds[i]].y);
            float Norm = curVector.length();
            if (Norm <= 0.0f) {
                return ptRes;
            }
            float Norm2 = Norm * Norm;
            float repulsive_factor = FDGLAlgoT.CalcRepulsiveForceFromR2(Norm2);
            curVector.scale(repulsive_factor / Norm);
            ptRes.add((Tuple2f)curVector);
        }
        return ptRes;
    }

    public void DoNotMove(int i) {
        this.m_iDoNotMove = i;
    }

    public void CalculateForceField() {
        int iSize = this.m_arrPoints.length;
        this.m_arrForceField = new Vector2f[iSize];
        this.m_dblMaxForceLength = 0.0f;
        this.m_QTree.Initialize();
        for (int i = 0; i < iSize; ++i) {
            this.m_arrForceField[i] = this.CalcAttractiveForcesAt(i);
            this.m_arrForceField[i].add((Tuple2f)this.CalcRepulsiveForcesAt(this.m_arrPoints[i].x, this.m_arrPoints[i].y));
            float dblCurLength = this.m_arrForceField[i].length();
            if (!(this.m_dblMaxForceLength < dblCurLength)) continue;
            this.m_dblMaxForceLength = dblCurLength;
        }
    }

    public void MoveSystem() {
        ++this.m_iEnergyIndex;
        if (this.m_dblMaxForceLength <= 0.0f) {
            return;
        }
        float dblFactor = (float)Math.sqrt(Math.sqrt(this.m_dblMaxForceLength));
        if (dblFactor <= 0.0f) {
            return;
        }
        int iSize = this.m_arrPoints.length;
        for (int i = 0; i < iSize; ++i) {
            if (i == this.m_iDoNotMove) continue;
            float abs_force = this.m_arrForceField[i].length();
            if (abs_force < dblFactor) {
                this.m_arrPoints[i].x += this.m_arrForceField[i].x;
                this.m_arrPoints[i].y += this.m_arrForceField[i].y;
                continue;
            }
            this.m_arrPoints[i].x += this.m_arrForceField[i].x / abs_force * dblFactor;
            this.m_arrPoints[i].y += this.m_arrForceField[i].y / abs_force * dblFactor;
        }
        this.PushEnergy(this.m_dblMaxForceLength);
    }

    public void UpdateSource() {
        this.m_pInterface.SetObjectGeom(this.m_arrPoints);
    }

    public void InitFromInterface() {
        int[] arrObjIds = this.m_pInterface.GetAllObjectsIds();
        int n = arrObjIds.length;
        this.m_arrLinks = new SLink[n][];
        this.m_arrPoints = new Vector2f[n];
        for (int i = 0; i < this.m_arrPoints.length; ++i) {
            this.m_arrPoints[i] = new Vector2f();
        }
        Vector2f pdDbl = new Vector2f();
        for (int i = 0; i < n; ++i) {
            this.m_pInterface.GetObjectGeom(arrObjIds[i], pdDbl);
            this.m_arrPoints[i].x = pdDbl.x;
            this.m_arrPoints[i].y = pdDbl.y;
            FloatArray arrWeight = new FloatArray();
            IntArray arrAdjNodes = new IntArray();
            this.m_pInterface.GetAdjInfoFor(arrObjIds[i], arrAdjNodes, arrWeight);
            int nAdjNodesCouns = arrAdjNodes.getSize();
            this.m_arrLinks[i] = new SLink[nAdjNodesCouns];
            for (int j = 0; j < nAdjNodesCouns; ++j) {
                this.m_arrLinks[i][j] = new SLink();
                this.m_arrLinks[i][j].m_iToId = arrAdjNodes.get(j);
                this.m_arrLinks[i][j].m_Weight = arrWeight.get(j);
            }
        }
    }

    public QuadTreeT GetQuadTree() {
        return this.m_QTree;
    }

    public class SLink {
        int m_iToId;
        float m_Weight;
    }
}

