/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.tease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.HypergeometricProbability;

public class TEASEBench {
    public String population_file_name = "";
    public String list_file_name = "";
    public String output_file_name;
    public Vector annotation_file_names;
    public int population_total;
    public int list_total;
    public Hashtable categories;
    public Hashtable categories_population;
    public Hashtable categories_list;
    public Hashtable hitAccumulator;
    public HypergeometricProbability hgp_computation;
    public BufferedReader read_in_stream;
    public String[][] records;
    public String[] categoryNames;
    public String[][] listHitMatrix;
    public String[] orders;
    public boolean reportEaseScore;
    private Hashtable pop_totals;
    private Hashtable sample_totals;
    private String impliesFileLocation;
    private String sep = System.getProperty("file.separator");

    public TEASEBench() {
        this.initiation();
        this.pop_totals = new Hashtable();
        this.categories = new Hashtable();
        this.sample_totals = new Hashtable();
        this.annotation_file_names = new Vector();
        this.categories_population = new Hashtable();
        this.reportEaseScore = true;
    }

    public void initiation() {
        this.hitAccumulator = new Hashtable();
        this.hgp_computation = new HypergeometricProbability();
        this.population_total = 0;
        this.list_total = 0;
    }

    public TEASEBench(boolean reportEaseScore) {
        this();
        this.reportEaseScore = reportEaseScore;
    }

    public void AddAnnotationFileName(String file_name) {
        this.annotation_file_names.addElement(file_name);
    }

    public void setImpliesFileLocation(String impliesFileLocation) {
        this.impliesFileLocation = impliesFileLocation;
    }

    public void GetCategories() {
        BufferedReader in = null;
        Hashtable hash_table = new Hashtable();
        Hashtable implied_associations = new Hashtable();
        String line = "";
        String category = "";
        String file_name = "";
        boolean c = false;
        try {
            int idx;
            String term;
            Enumeration e = this.annotation_file_names.elements();
            while (e.hasMoreElements()) {
                file_name = e.nextElement().toString();
                in = new BufferedReader(new FileReader(file_name));
                term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
                this.sample_totals.put(term, new Hashtable());
                this.pop_totals.put(term, new Hashtable());
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf("\t");
                    if (idx >= line.length() || idx < 1) continue;
                    int idx2 = line.indexOf("\t", idx + 1);
                    if (idx2 >= line.length() || idx2 < 1) {
                        idx2 = line.length();
                    }
                    if (!this.categories.containsKey(category = term + "\t" + line.substring(idx + 1, idx2).trim())) {
                        this.categories.put(category, new Hashtable());
                        ((Hashtable)this.categories.get(category)).put(line.substring(0, idx).trim(), "");
                        continue;
                    }
                    ((Hashtable)this.categories.get(category)).put(line.substring(0, idx).trim(), "");
                }
            }
            for (int i = 0; i < this.annotation_file_names.size(); ++i) {
                String fileName = (String)this.annotation_file_names.elementAt(i);
                File file = new File(this.impliesFileLocation, fileName);
                if (!file.exists() || !file.isFile()) continue;
                in = new BufferedReader(new FileReader(file));
                term = fileName.substring(fileName.lastIndexOf(this.sep) + 1, fileName.lastIndexOf("."));
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf(9);
                    if (idx >= line.length() || idx < 1) continue;
                    if (!implied_associations.containsKey(term + "\t" + line.substring(0, idx).trim())) {
                        implied_associations.put(term + "\t" + line.substring(0, idx).trim(), new Vector());
                        ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                        continue;
                    }
                    ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                }
            }
            boolean end = false;
            for (int k = 0; k < 10 && !end; ++k) {
                String cat = "";
                end = true;
                Enumeration enum6 = implied_associations.keys();
                while (enum6.hasMoreElements()) {
                    cat = (String)enum6.nextElement();
                    if (!this.categories.containsKey(cat)) continue;
                    Hashtable catHash = (Hashtable)this.categories.get(cat);
                    Vector impVector = (Vector)implied_associations.get(cat);
                    for (int i = 0; i < impVector.size(); ++i) {
                        Enumeration categoryEnum;
                        String impCat = (String)impVector.elementAt(i);
                        if (!this.categories.containsKey(impCat)) {
                            end = false;
                            this.categories.put(impCat, new Hashtable());
                            categoryEnum = catHash.keys();
                            while (categoryEnum.hasMoreElements()) {
                                ((Hashtable)this.categories.get(impCat)).put((String)categoryEnum.nextElement(), "");
                            }
                            continue;
                        }
                        categoryEnum = catHash.keys();
                        while (categoryEnum.hasMoreElements()) {
                            String indexString = (String)categoryEnum.nextElement();
                            if (((Hashtable)this.categories.get(impCat)).containsKey(indexString)) continue;
                            ((Hashtable)this.categories.get(impCat)).put(indexString, "");
                            end = false;
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            System.out.println("Error occured collecting categories");
            System.out.println(error.getMessage());
            error.printStackTrace();
        }
    }

    public void GetCategories(Vector popVector) {
        BufferedReader in = null;
        Hashtable hash_table = new Hashtable();
        Hashtable implied_associations = new Hashtable();
        String line = "";
        String category = "";
        String file_name = "";
        boolean c = false;
        try {
            int idx;
            String term;
            Enumeration e = this.annotation_file_names.elements();
            while (e.hasMoreElements()) {
                file_name = e.nextElement().toString();
                in = new BufferedReader(new FileReader(file_name));
                term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
                this.sample_totals.put(term, new Hashtable());
                this.pop_totals.put(term, new Hashtable());
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf("\t");
                    if (idx >= line.length() || idx < 1) continue;
                    int idx2 = line.indexOf("\t", idx + 1);
                    if (idx2 >= line.length() || idx2 < 1) {
                        idx2 = line.length();
                    }
                    category = term + "\t" + line.substring(idx + 1, idx2).trim();
                    if (!popVector.contains(line.substring(0, idx).trim())) continue;
                    if (!this.categories.containsKey(category)) {
                        this.categories.put(category, new Hashtable());
                        ((Hashtable)this.categories.get(category)).put(line.substring(0, idx).trim(), "");
                        continue;
                    }
                    ((Hashtable)this.categories.get(category)).put(line.substring(0, idx).trim(), "");
                }
            }
            for (int i = 0; i < this.annotation_file_names.size(); ++i) {
                String fileName = (String)this.annotation_file_names.elementAt(i);
                File file = new File(this.impliesFileLocation, fileName);
                if (!file.exists() || !file.isFile()) continue;
                in = new BufferedReader(new FileReader(file));
                term = fileName.substring(fileName.lastIndexOf(this.sep) + 1, fileName.lastIndexOf("."));
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf(9);
                    if (idx >= line.length() || idx < 1) continue;
                    if (!implied_associations.containsKey(term + "\t" + line.substring(0, idx).trim())) {
                        implied_associations.put(term + "\t" + line.substring(0, idx).trim(), new Vector());
                        ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                        continue;
                    }
                    ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                }
            }
            boolean end = false;
            for (int k = 0; k < 10 && !end; ++k) {
                String cat = "";
                end = true;
                Enumeration enum6 = implied_associations.keys();
                while (enum6.hasMoreElements()) {
                    cat = (String)enum6.nextElement();
                    if (!this.categories.containsKey(cat)) continue;
                    Hashtable catHash = (Hashtable)this.categories.get(cat);
                    Vector impVector = (Vector)implied_associations.get(cat);
                    for (int i = 0; i < impVector.size(); ++i) {
                        Enumeration categoryEnum;
                        String impCat = (String)impVector.elementAt(i);
                        if (!this.categories.containsKey(impCat)) {
                            end = false;
                            this.categories.put(impCat, new Hashtable());
                            categoryEnum = catHash.keys();
                            while (categoryEnum.hasMoreElements()) {
                                ((Hashtable)this.categories.get(impCat)).put((String)categoryEnum.nextElement(), "");
                            }
                            continue;
                        }
                        categoryEnum = catHash.keys();
                        while (categoryEnum.hasMoreElements()) {
                            String indexString = (String)categoryEnum.nextElement();
                            if (((Hashtable)this.categories.get(impCat)).containsKey(indexString)) continue;
                            ((Hashtable)this.categories.get(impCat)).put(indexString, "");
                            end = false;
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            System.out.println("Error occured collecting categories");
            System.out.println(error.getMessage());
            error.printStackTrace();
        }
    }

    public void ConstructResults() {
        String key = "";
        String list_hit = "";
        String population_hit = "";
        String temp = "";
        this.records = new String[this.categories_list.size()][7];
        this.orders = new String[this.categories_list.size()];
        int c = 0;
        Enumeration e = this.categories_list.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            list_hit = "";
            population_hit = "";
            temp = key.substring(0, key.indexOf(9)).trim();
            this.records[c][0] = temp.substring(temp.lastIndexOf(this.sep) + 1).trim();
            this.records[c][1] = key.substring(key.indexOf(9)).trim();
            this.records[c][2] = list_hit = (String)this.categories_list.get(key);
            this.list_total = ((Hashtable)this.sample_totals.get(temp)).size();
            this.records[c][3] = String.valueOf(this.list_total);
            this.records[c][4] = this.categories_population.containsKey(key) ? (population_hit = (String)this.categories_population.get(key)) : "";
            this.population_total = ((Hashtable)this.pop_totals.get(temp)).size();
            this.records[c][5] = String.valueOf(this.population_total);
            if (!list_hit.equals("") && !population_hit.equals("")) {
                double p = this.reportEaseScore ? (Integer.parseInt(list_hit) > 1 ? this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(population_hit), this.list_total - 1, Integer.parseInt(list_hit) - 1) : 1.0) : this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(population_hit), this.list_total, Integer.parseInt(list_hit));
                this.records[c][6] = String.valueOf(p);
            } else {
                this.records[c][6] = "1.0";
            }
            ++c;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int cnt = 0;
        Enumeration e2 = this.hitAccumulator.keys();
        while (e2.hasMoreElements()) {
            String cat;
            this.categoryNames[cnt] = cat = (String)e2.nextElement();
            Vector locusVector = (Vector)this.hitAccumulator.get(cat);
            this.listHitMatrix[cnt] = new String[locusVector.size()];
            for (int i = 0; i < this.listHitMatrix[cnt].length; ++i) {
                this.listHitMatrix[cnt][i] = (String)locusVector.elementAt(i);
            }
            ++cnt;
        }
    }

    public void SortRecords() {
        for (int i0 = 0; i0 < this.records.length; ++i0) {
            for (int i = 0; i < this.records.length - 1 - i0; ++i) {
                BigDecimal big1 = new BigDecimal(this.records[i][6]);
                BigDecimal big2 = new BigDecimal(this.records[i + 1][6]);
                if (big1.compareTo(big2) <= 0) continue;
                for (int j = 0; j < 7; ++j) {
                    String holder = this.records[i][j];
                    this.records[i][j] = this.records[i + 1][j];
                    this.records[i + 1][j] = holder;
                }
            }
        }
    }

    public void DisplayResults() {
        try {
            File output_file = new File(this.output_file_name);
            FileWriter output_writer = new FileWriter(output_file);
            for (int i = 0; i < this.records.length; ++i) {
                for (int j = 0; j < 6; ++j) {
                    System.out.print(this.records[i][j] + "\t");
                    output_writer.write(this.records[i][j] + "\t");
                    output_writer.write("\n");
                }
            }
            output_writer.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void GetPopulationHitsByCategory(Vector list) {
        Object in = null;
        String category = "";
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        this.pop_totals = this.clear(this.pop_totals);
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put((String)list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration enum6 = this.categories.keys();
                while (enum6.hasMoreElements()) {
                    key = (String)enum6.nextElement();
                    hash_table = (Hashtable)this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_population.containsKey(key)) {
                        this.categories_population.put(key, "1");
                    } else {
                        hits = String.valueOf(Integer.parseInt((String)this.categories_population.get(key)) + 1);
                        this.categories_population.put(key, hits);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    ((Hashtable)this.pop_totals.get(key)).put(locus_id, "");
                }
            }
            this.population_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public Hashtable clear(Hashtable hash) {
        Iterator it = hash.keySet().iterator();
        while (it.hasNext()) {
            hash.put(it.next(), new Hashtable());
        }
        return hash;
    }

    public void GetListHitsByCategory(Vector list) {
        this.initiation();
        this.categories_list = new Hashtable();
        Object in = null;
        String category = "";
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        this.sample_totals = this.clear(this.sample_totals);
        boolean c = false;
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put((String)list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration enum6 = this.categories.keys();
                while (enum6.hasMoreElements()) {
                    key = (String)enum6.nextElement();
                    hash_table = (Hashtable)this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_list.containsKey(key)) {
                        this.categories_list.put(key, "1");
                        this.hitAccumulator.put(key, new Vector());
                        ((Vector)this.hitAccumulator.get(key)).add(locus_id);
                    } else {
                        hits = String.valueOf(Integer.parseInt((String)this.categories_list.get(key)) + 1);
                        this.categories_list.put(key, hits);
                        ((Vector)this.hitAccumulator.get(key)).add(locus_id);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    ((Hashtable)this.sample_totals.get(key)).put(locus_id, "");
                }
            }
            this.list_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    String[][] getResults() {
        return this.records;
    }

    String[][] getSurveyResults() {
        return this.records;
    }

    String[][] getListHitMatrix() {
        return this.listHitMatrix;
    }

    String[] getCategoryNames() {
        return this.categoryNames;
    }

    public void resetForNewList() {
        this.categories_list = new Hashtable();
        this.sample_totals = new Hashtable();
        Enumeration e = this.annotation_file_names.elements();
        while (e.hasMoreElements()) {
            String file_name = e.nextElement().toString();
            String term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
            this.sample_totals.put(term, new Hashtable());
        }
    }

    public void GetPopulationHitsByCategoryForSurvey(Vector list) {
        this.initiation();
        this.categories_population = new Hashtable();
        String category = "";
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        String impliedCategory = "";
        this.pop_totals = this.clear(this.pop_totals);
        boolean c = false;
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put((String)list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration enum6 = this.categories.keys();
                while (enum6.hasMoreElements()) {
                    key = (String)enum6.nextElement();
                    hash_table = (Hashtable)this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_population.containsKey(key)) {
                        this.categories_population.put(key, "1");
                        this.hitAccumulator.put(key, new Vector());
                        ((Vector)this.hitAccumulator.get(key)).add(locus_id);
                    } else {
                        hits = String.valueOf(Integer.parseInt((String)this.categories_population.get(key)) + 1);
                        this.categories_population.put(key, hits);
                        ((Vector)this.hitAccumulator.get(key)).add(locus_id);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    ((Hashtable)this.pop_totals.get(key)).put(locus_id, "");
                }
            }
            this.population_total = count_ids.size();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ConstructSurveyResults() {
        String key = "";
        String list_hit = "";
        String population_hit = "";
        String temp = "";
        this.records = new String[this.categories_population.size()][4];
        this.orders = new String[this.categories_population.size()];
        int c = 0;
        Enumeration e = this.categories_population.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            list_hit = "";
            population_hit = "";
            temp = key.substring(0, key.indexOf(9)).trim();
            this.records[c][0] = temp.substring(temp.lastIndexOf(this.sep) + 1).trim();
            this.records[c][1] = key.substring(key.indexOf(9)).trim();
            this.records[c][2] = list_hit = (String)this.categories_population.get(key);
            this.population_total = ((Hashtable)this.pop_totals.get(temp)).size();
            this.records[c][3] = String.valueOf(this.population_total);
            ++c;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int cnt = 0;
        Enumeration e2 = this.hitAccumulator.keys();
        while (e2.hasMoreElements()) {
            String cat;
            this.categoryNames[cnt] = cat = (String)e2.nextElement();
            Vector locusVector = (Vector)this.hitAccumulator.get(cat);
            this.listHitMatrix[cnt] = new String[locusVector.size()];
            for (int i = 0; i < this.listHitMatrix[cnt].length; ++i) {
                this.listHitMatrix[cnt][i] = (String)locusVector.elementAt(i);
            }
            ++cnt;
        }
    }
}

