/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.tease;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.tease.EASEAnalysis;
import org.tigr.microarray.mev.cluster.algorithm.impl.tease.HCL;
import org.tigr.util.FloatMatrix;

public class TEASE
extends AbstractAlgorithm {
    private EASEAnalysis ease;
    private boolean stop = false;
    private int[] child1;
    private int[] child2;
    private int[] node;
    private String[] annotation;
    private ArrayList rootList;
    private HashMap leafMap = new HashMap();
    private HashMap selectedLeafMap = new HashMap();
    private AlgorithmEvent event;
    static final int NUMBER = 1000;

    public TEASE() {
        this.ease = new EASEAnalysis();
        this.event = new AlgorithmEvent((Object)this, 3, 0);
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        AlgorithmParameters params = data.getParams();
        AlgorithmData resultData = new AlgorithmData();
        HCL hcl = new HCL();
        resultData = hcl.execute(data);
        resultData.addParam("hcl-only", String.valueOf(params.getBoolean("hcl-only")));
        if (params.getBoolean("hcl-only")) {
            return resultData;
        }
        this.setAndDisplayEvent("Complete HCL analysis. Assigning clusters...");
        this.annotation = data.getStringArray("annotation-list");
        this.child1 = resultData.getIntArray("child-1-array");
        this.child2 = resultData.getIntArray("child-2-array");
        this.node = resultData.getIntArray("node-order");
        int min = params.getInt("minimum-genes");
        int max = params.getInt("maximum-genes");
        this.getSelectedLeafMap(min, max);
        this.setAndDisplayEvent("Complete leafmap. Setting up category map...");
        this.ease.setCategories(data);
        this.setAndDisplayEvent("Waiting for EASE iteration...");
        int[] rootArray = this.listToArray(this.rootList);
        this.setAndDisplayEvent("number of EASE iteration: " + rootArray.length);
        for (int i = 0; i < rootArray.length; ++i) {
            if (this.stop) {
                return null;
            }
            ArrayList indices = (ArrayList)this.selectedLeafMap.get(new Integer(rootArray[i]));
            String[] sample = this.mapIndiceToGene(indices);
            AlgorithmData singleResult = new AlgorithmData();
            singleResult.addParam("upper-boundary", params.getString("upper-boundary"));
            singleResult.addParam("lower-boundary", params.getString("lower-boundary"));
            singleResult.addIntArray("sample-indices", this.listToArray(indices));
            singleResult.addStringArray("sample-list", sample);
            singleResult = this.ease.runEASEAnalysis(singleResult);
            resultData.addResultAlgorithmData(new Integer(rootArray[i]), singleResult);
            this.setAndDisplayEvent("Complete analyzing node: " + rootArray[i]);
        }
        this.setAndDisplayEvent("Complete execution. Exiting TEASE.");
        resultData.addIntArray("node-list", rootArray);
        resultData.addStringArray("name-list", data.getStringArray("name-list"));
        return resultData;
    }

    private void setAndDisplayEvent(String eventMessage) {
        this.event.setDescription("\n" + eventMessage);
        this.fireValueChanged(this.event);
    }

    private void print() {
        int i;
        System.out.println("annotation-array");
        for (i = 0; i < this.annotation.length; ++i) {
            System.out.print(this.annotation[i] + " ");
        }
        System.out.println("\nchild1-array");
        for (i = 0; i < this.child1.length; ++i) {
            System.out.print(this.child1[i] + " ");
        }
        System.out.println("\nchild2-array");
        for (i = 0; i < this.child2.length; ++i) {
            System.out.print(this.child2[i] + " ");
        }
        System.out.println("\nnode-array");
        for (i = 0; i < this.node.length; ++i) {
            System.out.print(this.node[i] + " ");
        }
    }

    private String[] mapIndiceToGene(ArrayList arr) {
        String[] str = new String[arr.size()];
        for (int i = 0; i < arr.size(); ++i) {
            str[i] = this.annotation[(Integer)arr.get(i)];
        }
        return str;
    }

    private int[] listToArray(ArrayList rootList) {
        int[] roots = new int[rootList.size()];
        for (int i = 0; i < rootList.size(); ++i) {
            roots[i] = (Integer)rootList.get(i);
        }
        return roots;
    }

    public void abort() {
        this.stop = true;
        this.ease.abort();
    }

    private void getSelectedLeafMap(int min, int max) {
        HashMap leafMap = this.getLeafMap();
        this.rootList = new ArrayList();
        for (int i = 0; i < this.node.length - 1; ++i) {
            Integer root = new Integer(this.node[i]);
            ArrayList leaves = (ArrayList)leafMap.get(root);
            if (leaves.size() < min || leaves.size() > max) continue;
            this.rootList.add(root);
            this.selectedLeafMap.put(root, leaves);
        }
    }

    private HashMap getLeafMap() {
        HashMap<Integer, ArrayList> leafMap = new HashMap<Integer, ArrayList>();
        for (int i = 0; i < this.node.length - 1; ++i) {
            int root = this.node[i];
            ArrayList leafList = new ArrayList();
            Integer node1 = new Integer(this.child1[root]);
            Integer node2 = new Integer(this.child2[root]);
            if (leafMap.containsKey(node1)) {
                this.stitch(leafList, (ArrayList)leafMap.get(node1));
            } else {
                leafList = this.findLeaves(leafList, node1);
            }
            if (leafMap.containsKey(node2)) {
                this.stitch(leafList, (ArrayList)leafMap.get(node2));
            } else {
                leafList = this.findLeaves(leafList, node2);
            }
            leafMap.put(new Integer(root), leafList);
        }
        return leafMap;
    }

    private ArrayList stitch(ArrayList list1, ArrayList list2) {
        for (int i = 0; i < list2.size(); ++i) {
            list1.add(list2.get(i));
        }
        return list1;
    }

    private ArrayList findLeaves(ArrayList leafList, int root) {
        if (root < this.node.length) {
            leafList.add(new Integer(root));
            return leafList;
        }
        this.findLeaves(leafList, this.child1[root]);
        this.findLeaves(leafList, this.child2[root]);
        return leafList;
    }

    public static void main(String[] args) {
        TEASE algorithm = new TEASE();
        AlgorithmData data = new AlgorithmData();
        AlgorithmParameters params = new AlgorithmParameters();
        int max = 100;
        int min = 10;
        String inputFile = "C:/Documents and Settings/hwl2/Desktop/data/expdata.txt";
        String outputFile = "C:/Documents and Settings/hwl2/Desktop/output.txt";
        String dataFile = "C:/Documents and Settings/hwl2/Desktop/data/RV14-test(1000).txt";
        try {
            BufferedReader buff = new BufferedReader(new FileReader(dataFile));
            data = TEASE.readData(buff);
            System.out.println("Completed reading data. Waiting for HCL data...");
            buff.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] annotations = new String[]{"C:/MeV3.1/data/ease/Data/Class/GO Biological Process.txt"};
        data.addParam("minimum-genes", String.valueOf(min));
        data.addParam("maximum-genes", String.valueOf(max));
        data.addParam("perform-cluster-analysis", "false");
        data.addParam("trim-option", "NO_TRIM");
        data.addStringArray("annotation-file-list", annotations);
        data.addParam("hcl-distance-function", "1");
        data.addParam("hcl-distance-absolute", "false");
        data.addParam("method-linkage", "0");
        try {
            AlgorithmData result = algorithm.execute(data);
            int[] roots = result.getIntArray("node-list");
            PrintWriter out = new PrintWriter(new FileOutputStream(outputFile));
            out.println("size of data set: 1000");
            out.println("number of iteration: " + roots.length);
            out.println("\n\n");
            for (int i = 0; i < roots.length; ++i) {
                out.println("node = " + roots[i]);
                AlgorithmData indiData = result.getResultAlgorithmData((Object)new Integer(roots[i]));
                String[] names = result.getStringArray("name-list");
                TEASE.printResult(indiData, names, out);
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void printDataResult(AlgorithmData data) {
        int[] nodes = data.getIntArray("node-list");
        String[] names = data.getStringArray("name-list");
        String outputFile = "C:/Documents and Settings/hwl2/Desktop/output.txt";
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(outputFile));
            out.println("size of data set: ");
            out.println("number of iteration: " + nodes.length);
            out.println("\n\n");
            for (int i = 0; i < nodes.length; ++i) {
                out.println("node = " + nodes[i]);
                AlgorithmData single = data.getResultAlgorithmData((Object)new Integer(nodes[i]));
                TEASE.printResult(single, names, out);
            }
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printResult(AlgorithmData result, String[] names, PrintWriter out) throws IOException {
        String[][] re = (String[][])result.getObjectMatrix("result-matrix");
        String[] sample = result.getStringArray("sample-list");
        int[] indices = result.getIntArray("sample-indices");
        for (int j = 0; j < sample.length; ++j) {
            out.print(sample[j] + ": ");
        }
        out.println();
        String[] header = result.getStringArray("header-names");
        for (int j = 0; j < header.length; ++j) {
            out.print(header[j] + "\t");
        }
        out.println();
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < re[x].length; ++y) {
                out.print(re[x][y] + "\t");
            }
            out.println();
        }
        out.println();
        out.println();
    }

    private static AlgorithmData readData(BufferedReader buff) throws IOException {
        AlgorithmData data = new AlgorithmData();
        FloatMatrix matrix = new FloatMatrix(1000, 12);
        String line = buff.readLine();
        String[] genes = new String[1000];
        String[] names = new String[1000];
        int parse1 = 0;
        int parse2 = 0;
        for (int i = 0; i < 1000; ++i) {
            line = buff.readLine();
            parse2 = line.indexOf("\t");
            genes[i] = line.substring(0, parse2);
            parse1 = parse2 + 1;
            parse2 = line.indexOf("\t", parse1 + 1);
            names[i] = line.substring(parse1, parse2);
            for (int j = 0; j < 11; ++j) {
                parse1 = parse2 + 1;
                parse2 = line.indexOf("\t", parse1 + 1);
                String exp = line.substring(parse1, parse2);
                matrix.set(i, j, Float.valueOf(exp).floatValue());
            }
            String exp = line.substring(parse2 + 1, line.length());
            matrix.set(i, 11, Float.valueOf(exp).floatValue());
        }
        data.addMatrix("experiment", matrix);
        data.addStringArray("population-list", genes);
        data.addStringArray("annotation-list", genes);
        data.addStringArray("name-list", names);
        return data;
    }
}

