/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.tease;

import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.util.FloatMatrix;

public class HCL
extends AbstractAlgorithm {
    private boolean stop = false;
    private int parentless;
    private double TreeHeight;
    private int Assigned;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        int i;
        int i2;
        FloatMatrix expMatrix = data.getMatrix("experiment");
        if (expMatrix == null) {
            throw new AlgorithmException("Input data is absent.");
        }
        AlgorithmParameters map = data.getParams();
        int function = map.getInt("hcl-distance-function", 4);
        boolean absolute = map.getBoolean("hcl-distance-absolute", false);
        boolean genes = map.getBoolean("calculate-genes", true);
        int method = map.getInt("method-linkage", 0);
        int n = genes ? expMatrix.getRowDimension() : expMatrix.getColumnDimension();
        int two_n = 2 * n;
        this.Assigned = n;
        this.parentless = n;
        this.TreeHeight = 0.0;
        double MaxCorrelation = 0.0;
        float[] Height = new float[two_n];
        int[] Parent = new int[two_n];
        int[] Child1 = new int[two_n];
        int[] Child2 = new int[two_n];
        int[] NodeHeight = new int[two_n];
        int[] NodeOrder = new int[n];
        int[] NumberOfChildren = new int[two_n];
        for (i2 = 0; i2 < two_n; ++i2) {
            Height[i2] = 0.0f;
            Parent[i2] = -1;
            Child1[i2] = -1;
            Child2[i2] = -1;
            NodeHeight[i2] = 0;
        }
        for (i2 = 0; i2 < n; ++i2) {
            NodeOrder[i2] = -1;
            NumberOfChildren[i2] = 1;
        }
        float[][] SimilarityMatrix = new float[n][];
        float[] Min = new float[n];
        int[] MinIndex = new int[n];
        int UNITS = 200;
        AlgorithmEvent event = null;
        event = new AlgorithmEvent((Object)this, 1, 200, "Creating similarity matrix");
        this.fireValueChanged(event);
        event.setId(2);
        event.setIntValue(0);
        this.fireValueChanged(event);
        int CurrentProgress = 0;
        int OldCurrentProgress = 0;
        double Factor = 200.0 / (double)n;
        float factor = 1.0f;
        for (i = 1; i < n; ++i) {
            CurrentProgress = (int)((double)i * Factor);
            if (CurrentProgress > OldCurrentProgress) {
                event.setIntValue(CurrentProgress);
                this.fireValueChanged(event);
                OldCurrentProgress = CurrentProgress;
            }
            SimilarityMatrix[i] = new float[i];
            Min[i] = Float.POSITIVE_INFINITY;
            for (int j = 0; j < i; ++j) {
                if (this.stop) {
                    throw new AbortException();
                }
                SimilarityMatrix[i][j] = genes ? ExperimentUtil.geneDistance(expMatrix, null, i, j, function, factor, absolute) : ExperimentUtil.distance(expMatrix, i, j, function, factor, absolute);
                if (!(SimilarityMatrix[i][j] < Min[i])) continue;
                Min[i] = SimilarityMatrix[i][j];
                MinIndex[i] = j;
            }
        }
        if (this.stop) {
            throw new AbortException();
        }
        event = new AlgorithmEvent((Object)this, 1, 200, "Calculating tree");
        this.fireValueChanged(event);
        event.setId(2);
        event.setIntValue(0);
        this.fireValueChanged(event);
        long CalculatedNodes = 0L;
        CurrentProgress = 0;
        OldCurrentProgress = 0;
        Factor = 200.0 / (double)n;
        int NodeCounter = 0;
        double MaxDistance = 0.0;
        double MinDistance = Double.POSITIVE_INFINITY;
        MaxCorrelation = Double.POSITIVE_INFINITY;
        double MinCorrelation = Double.POSITIVE_INFINITY;
        int[] owner = new int[n];
        for (i = 0; i < n; ++i) {
            owner[i] = i;
        }
        while (this.parentless > 1) {
            int p;
            int k;
            if (this.stop) {
                throw new AbortException();
            }
            CurrentProgress = (int)((double)CalculatedNodes * Factor);
            if (CurrentProgress > OldCurrentProgress) {
                event.setIntValue(CurrentProgress);
                this.fireValueChanged(event);
                OldCurrentProgress = CurrentProgress;
            }
            ++CalculatedNodes;
            double close_d = Double.POSITIVE_INFINITY;
            double test_d = Double.POSITIVE_INFINITY;
            int test_i = -2;
            int test_j = -2;
            for (i = 1; i < n; ++i) {
                if (owner[i] == -1 || !((double)Min[i] < test_d)) continue;
                test_d = Min[i];
                test_i = i;
                test_j = MinIndex[i];
            }
            i = test_i;
            int j = test_j;
            double height_k = close_d = test_d;
            if (Math.abs(close_d) > 0.0 && Math.abs(close_d) < MinDistance) {
                MinDistance = Math.abs(close_d);
            }
            if (close_d != 1.0 && close_d < MaxCorrelation) {
                MaxCorrelation = close_d;
            }
            if (close_d > MaxCorrelation && close_d < MinCorrelation) {
                MinCorrelation = close_d;
            }
            if (close_d > MaxDistance) {
                MaxDistance = close_d;
            }
            try {
                if (owner[i] >= n && (double)Height[owner[i]] > height_k) {
                    k = owner[i];
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[j], k);
                } else if (owner[j] >= n && (double)Height[owner[j]] > height_k) {
                    k = owner[j];
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[i], k);
                } else {
                    k = this.NewNode(Height, height_k);
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[i], k);
                    this.AssertParentage(Parent, NumberOfChildren, Child1, Child2, owner[j], k);
                }
                NodeOrder[NodeCounter] = k;
                NodeHeight[k] = Math.max(NodeHeight[Child1[k]] + 1, NodeHeight[Child2[k]] + 1);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.fireValueChanged(new AlgorithmEvent((Object)this, 4, 0, "Error: " + e.toString() + " - Height(" + String.valueOf(height_k) + "," + ")"));
                k = 0;
            }
            ++NodeCounter;
            owner[i] = k;
            owner[j] = -1;
            if (method == -1) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = Math.min(SimilarityMatrix[i][p], SimilarityMatrix[j][p]);
                }
                for (p = j + 1; p < i; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = Math.min(SimilarityMatrix[i][p], SimilarityMatrix[p][j]);
                }
                for (p = i + 1; p < n; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[p][i] = Math.min(SimilarityMatrix[p][i], SimilarityMatrix[p][j]);
                }
            } else if (method == 1) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = Math.max(SimilarityMatrix[i][p], SimilarityMatrix[j][p]);
                }
                for (p = j + 1; p < i; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = Math.max(SimilarityMatrix[i][p], SimilarityMatrix[p][j]);
                }
                for (p = i + 1; p < n; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[p][i] = Math.max(SimilarityMatrix[p][i], SimilarityMatrix[p][j]);
                }
            } else if (method == 2) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = (float)((double)(SimilarityMatrix[i][p] * (float)NumberOfChildren[owner[i]] + SimilarityMatrix[j][p] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[i]], NumberOfChildren[owner[j]])));
                }
                for (p = j + 1; p < i; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = (float)((double)(SimilarityMatrix[i][p] * (float)NumberOfChildren[owner[i]] + SimilarityMatrix[p][j] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[i]], NumberOfChildren[owner[j]])));
                }
                for (p = i + 1; p < n; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[p][i] = (float)((double)(SimilarityMatrix[p][i] * (float)NumberOfChildren[owner[i]] + SimilarityMatrix[p][j] * (float)NumberOfChildren[owner[j]]) / (2.0 * (double)Math.min(NumberOfChildren[owner[i]], NumberOfChildren[owner[j]])));
                }
            } else if (method == 0) {
                for (p = 0; p < j; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = (float)((double)(SimilarityMatrix[i][p] + SimilarityMatrix[j][p]) / 2.0);
                }
                for (p = j + 1; p < i; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[i][p] = (float)((double)(SimilarityMatrix[i][p] + SimilarityMatrix[p][j]) / 2.0);
                }
                for (p = i + 1; p < n; ++p) {
                    if (owner[p] == -1) continue;
                    SimilarityMatrix[p][i] = (float)((double)(SimilarityMatrix[p][i] + SimilarityMatrix[p][j]) / 2.0);
                }
            }
            for (p = j; p < n; ++p) {
                if (owner[p] == -1 || MinIndex[p] != j && MinIndex[p] != i) continue;
                Min[p] = Float.POSITIVE_INFINITY;
                for (int l = 0; l < p; ++l) {
                    if (owner[l] == -1 || !(SimilarityMatrix[p][l] < Min[p])) continue;
                    Min[p] = SimilarityMatrix[p][l];
                    MinIndex[p] = l;
                }
            }
        }
        AlgorithmData result = new AlgorithmData();
        result.addIntArray("child-1-array", Child1);
        result.addIntArray("child-2-array", Child2);
        result.addIntArray("node-order", NodeOrder);
        result.addMatrix("height", new FloatMatrix(Height, Height.length));
        return result;
    }

    public void AssertParentage(int[] Parent, int[] NumberOfChildren, int[] Child1, int[] Child2, int child, int paren) {
        try {
            if (Parent[child] == -1) {
                Parent[child] = paren;
                --this.parentless;
                Child2[paren] = Child1[paren];
                Child1[paren] = child;
                int n = paren;
                NumberOfChildren[n] = NumberOfChildren[n] + NumberOfChildren[child];
            }
        }
        catch (Exception e) {
            this.fireValueChanged(new AlgorithmEvent((Object)this, 4, 0, "Error: " + e.toString() + " - AssertParentage(" + String.valueOf(child) + "," + String.valueOf(paren) + ")"));
        }
    }

    public int NewNode(float[] Height, double h) {
        Height[this.Assigned] = (float)h;
        if (h > this.TreeHeight) {
            this.TreeHeight = h;
        }
        ++this.parentless;
        return this.Assigned++;
    }
}

