/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.tease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseElementList;
import org.tigr.microarray.mev.cluster.algorithm.impl.tease.TEASEBench;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class EASEAnalysis {
    private TEASEBench bench;
    private AbstractAlgorithm algorithm;
    private AlgorithmEvent event;
    private AlgorithmParameters params;
    private DecimalFormat format;
    private FloatMatrix expData;
    private Vector sampleVector;
    private Vector populationVector;
    private Vector headerNames;
    private String[] annotationFileList;
    private String[][] result;
    private String[][] hitList;
    private String[] categoryNames;
    private String converterFileName;
    private boolean haveAccessionNumbers = false;
    private boolean reportEaseScore = false;
    private boolean stop = false;
    private boolean performClusterAnalysis;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData runEASEAnalysis(AlgorithmData algorithmData) throws AlgorithmException {
        if (this.performClusterAnalysis) {
            return this.performClusterAnnotationAnalysis(algorithmData);
        }
        return this.performSlideAnnotationSurvey(algorithmData);
    }

    private void createAndInitialize() {
        this.headerNames = new Vector();
        this.format = new DecimalFormat("0.###E00");
        this.intializeHeaderNames();
    }

    private AlgorithmData performClusterAnnotationAnalysis(AlgorithmData algorithmData) throws AlgorithmException {
        this.createAndInitialize();
        int[] clusterIndices = algorithmData.getIntArray("sample-indices");
        String[] sampleList = algorithmData.getStringArray("sample-list");
        EaseElementList sampleElementList = new EaseElementList(clusterIndices, sampleList);
        try {
            if (this.converterFileName != null) {
                sampleElementList.loadValues(this.converterFileName);
            } else {
                sampleElementList.setDefaultValues();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + this.converterFileName + "\n" + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new AlgorithmException("Error Reading File: " + this.converterFileName + "\n" + ioe.getMessage());
        }
        this.sampleVector = sampleElementList.getUniqueValueList();
        this.bench.GetListHitsByCategory(this.sampleVector);
        this.bench.ConstructResults();
        this.result = this.bench.getResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.bench.getListHitMatrix();
        this.categoryNames = this.bench.getCategoryNames();
        this.sortResults();
        if (algorithmData.getParams().getBoolean("p-value-corrections", false)) {
            this.pValueCorrections(algorithmData);
        }
        if (algorithmData.getParams().getBoolean("run-permutation-analysis", false)) {
            this.permutationAnalysis(algorithmData.getParams().getInt("permutation-count", 1));
            System.out.println("EASEAnalysis 192 permutation run");
        }
        this.result = this.appendAccessions(this.result, this.annotationFileList);
        algorithmData.addParam("have-accession-numbers", String.valueOf(this.haveAccessionNumbers));
        String trimOption = this.params.getString("trim-option");
        if (!trimOption.equals("NO_TRIM")) {
            float trimValue = this.params.getFloat("trim-value");
            this.trimResult(trimOption, trimValue);
        }
        this.indexResult();
        algorithmData.addObjectMatrix("result-matrix", (Object[][])this.result);
        algorithmData.addObjectMatrix("hit-list-matrix", (Object[][])this.hitList);
        int[][] clusters = this.getClusters(sampleElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.addIntMatrix("cluster-matrix", clusters);
        algorithmData.addStringArray("header-names", this.getHeaderNames());
        FloatMatrix means = this.getMeans(this.expData, clusters);
        algorithmData.addMatrix("means", means);
        algorithmData.addMatrix("variances", this.getVariances(this.expData, means, clusters));
        return algorithmData;
    }

    private AlgorithmData performSlideAnnotationSurvey(AlgorithmData algorithmData) throws AlgorithmException {
        this.createAndInitialize();
        String[] sampleList = algorithmData.getStringArray("sample-list");
        EaseElementList sampleElementList = new EaseElementList(sampleList);
        try {
            if (this.converterFileName != null) {
                sampleElementList.loadValues(this.converterFileName);
            } else {
                sampleElementList.setDefaultValues();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + this.converterFileName + "\n" + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new AlgorithmException("Error Reading File: " + this.converterFileName + "\n" + ioe.getMessage());
        }
        this.sampleVector = sampleElementList.getUniqueValueList();
        this.bench.GetPopulationHitsByCategoryForSurvey(this.sampleVector);
        this.bench.ConstructSurveyResults();
        this.result = this.bench.getSurveyResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.bench.getListHitMatrix();
        this.categoryNames = this.bench.getCategoryNames();
        this.sortSurveyResults();
        this.result = this.appendAccessions(this.result, this.annotationFileList);
        algorithmData.addParam("have-accession-numbers", String.valueOf(this.haveAccessionNumbers));
        algorithmData.addStringArray("header-names", this.getHeaderNames());
        String trimOption = this.params.getString("trim-option");
        if (!trimOption.equals("NO_TRIM")) {
            this.event.setDescription("Trim Result\n");
            this.algorithm.fireValueChanged(this.event);
            float trimValue = this.params.getFloat("trim-value");
            this.trimResult(trimOption, trimValue);
        }
        this.indexResult();
        algorithmData.addObjectMatrix("result-matrix", (Object[][])this.result);
        algorithmData.addObjectMatrix("hit-list-matrix", (Object[][])this.hitList);
        int[][] clusters = this.getClusters(sampleElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.addIntMatrix("cluster-matrix", clusters);
        return algorithmData;
    }

    public void setCategories(AlgorithmData data) throws AlgorithmException {
        this.params = data.getParams();
        this.expData = data.getMatrix("experiment");
        this.converterFileName = this.params.getString("converter-file-name");
        this.reportEaseScore = this.params.getBoolean("report-ease-score", false);
        this.performClusterAnalysis = this.params.getBoolean("perform-cluster-analysis", true);
        this.bench = new TEASEBench(this.reportEaseScore);
        this.annotationFileList = data.getStringArray("annotation-file-list");
        for (int i = 0; i < this.annotationFileList.length; ++i) {
            this.bench.AddAnnotationFileName(this.annotationFileList[i]);
        }
        this.bench.setImpliesFileLocation(data.getParams().getString("implies-location-list"));
        if (this.performClusterAnalysis) {
            String[] populationList = data.getStringArray("population-list");
            EaseElementList populationElementList = new EaseElementList(populationList);
            try {
                if (this.converterFileName != null) {
                    populationElementList.loadValues(this.converterFileName);
                } else {
                    populationElementList.setDefaultValues();
                }
                this.populationVector = populationElementList.getUniqueValueList();
                this.bench.GetCategories(this.populationVector);
                this.bench.GetPopulationHitsByCategory(this.populationVector);
            }
            catch (FileNotFoundException fnfe) {
                throw new AlgorithmException("Annotation Conversion File Not Found\n" + this.converterFileName + "\n" + fnfe.getMessage());
            }
            catch (IOException ioe) {
                throw new AlgorithmException("Error Reading File: " + this.converterFileName + "\n" + ioe.getMessage());
            }
        } else {
            this.bench.GetCategories();
        }
    }

    private void intializeHeaderNames() {
        this.headerNames.add("Index");
        this.headerNames.add("File");
        this.headerNames.add("Term");
        if (this.performClusterAnalysis) {
            this.headerNames.add("List Hits");
            this.headerNames.add("List Size");
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
            if (this.reportEaseScore) {
                this.headerNames.add("EASE Score");
            } else {
                this.headerNames.add("Fisher's Exact");
            }
        } else {
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
        }
    }

    private int[][] getClusters(EaseElementList clusterList, String[][] hitList) {
        int[][] clusters = new int[hitList.length][];
        for (int i = 0; i < hitList.length; ++i) {
            clusters[i] = clusterList.getIndices(hitList[i]);
        }
        return clusters;
    }

    private void sortResults() {
        int i;
        double[] stat = new double[this.result.length];
        int pValueIndex = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --pValueIndex;
        for (int i2 = 0; i2 < this.result.length; ++i2) {
            stat[i2] = Double.parseDouble(this.result[i2][pValueIndex]);
        }
        QSort qsorter = new QSort(stat);
        stat = qsorter.getSortedDouble();
        int[] orderedIndices = qsorter.getOrigIndx();
        String[] newCatNames = new String[this.categoryNames.length];
        String[][] newHitList = new String[this.hitList.length][];
        String[][] newResult = new String[this.result.length][];
        for (i = 0; i < orderedIndices.length; ++i) {
            newCatNames[i] = this.categoryNames[orderedIndices[i]];
            newHitList[i] = this.hitList[orderedIndices[i]];
            newResult[i] = this.result[orderedIndices[i]];
        }
        for (i = 0; i < newResult.length; ++i) {
            newResult[i][pValueIndex] = this.format.format(Double.parseDouble(newResult[i][pValueIndex]));
        }
        this.categoryNames = newCatNames;
        this.hitList = newHitList;
        this.result = newResult;
    }

    private void sortSurveyResults() {
        double[] hitCounts = new double[this.result.length];
        int hitIndex = this.headerNames.indexOf("Pop. Hits");
        --hitIndex;
        for (int i = 0; i < this.result.length; ++i) {
            hitCounts[i] = Double.parseDouble(this.result[i][hitIndex]);
        }
        QSort qsorter = new QSort(hitCounts);
        hitCounts = qsorter.getSortedDouble();
        int[] orderedIndices = qsorter.getOrigIndx();
        String[] newCatNames = new String[this.categoryNames.length];
        String[][] newHitList = new String[this.hitList.length][];
        String[][] newResult = new String[this.result.length][];
        int index = 0;
        for (int i = orderedIndices.length - 1; i >= 0; --i) {
            newCatNames[index] = this.categoryNames[orderedIndices[i]];
            newHitList[index] = this.hitList[orderedIndices[i]];
            newResult[index] = this.result[orderedIndices[i]];
            ++index;
        }
        this.categoryNames = newCatNames;
        this.hitList = newHitList;
        this.result = newResult;
    }

    private String[][] appendAccessions(String[][] resultMatrix, String[] fileNames) {
        if (resultMatrix == null || resultMatrix.length < 1) {
            return resultMatrix;
        }
        String[][] newResult = null;
        File file = null;
        this.haveAccessionNumbers = false;
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                file = this.getAccessionFile(fileNames[i]);
                if (!file.isFile()) continue;
                if (!this.haveAccessionNumbers) {
                    newResult = new String[resultMatrix.length][resultMatrix[0].length + 1];
                    this.initializeNewResult(newResult, resultMatrix);
                    this.headerNames.insertElementAt("Acc.", 2);
                }
                this.insertAccessions(file, newResult);
                this.haveAccessionNumbers = true;
                resultMatrix = newResult;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "Error in collecting accessions following analysis from file: " + file.getName() + "\n Results will not have accessions.  Please check file location" + " and format", "File Error", 2);
            return this.result;
        }
        if (this.haveAccessionNumbers) {
            return newResult;
        }
        return resultMatrix;
    }

    private void initializeNewResult(String[][] newResult, String[][] oldResult) {
        int i;
        for (i = 0; i < newResult.length; ++i) {
            for (int j = 0; j < oldResult[0].length; ++j) {
                if (j < 1) {
                    newResult[i][j] = oldResult[i][j];
                    continue;
                }
                newResult[i][j + 1] = oldResult[i][j];
            }
        }
        for (i = 0; i < newResult.length; ++i) {
            newResult[i][1] = " ";
        }
    }

    private void indexResult() {
        if (this.result == null || this.result.length < 1) {
            return;
        }
        String[][] newResult = new String[this.result.length][this.result[0].length + 1];
        for (int i = 0; i < this.result.length; ++i) {
            newResult[i][0] = String.valueOf(i + 1);
            for (int j = 1; j < newResult[0].length; ++j) {
                newResult[i][j] = this.result[i][j - 1];
            }
        }
        this.result = newResult;
    }

    private void insertAccessions(File file, String[][] result) throws IOException {
        String line;
        if (file == null) {
            return;
        }
        BufferedReader fr = new BufferedReader(new FileReader(file));
        Hashtable<String, String> accHash = new Hashtable<String, String>();
        while ((line = fr.readLine()) != null) {
            StringTokenizer stok = new StringTokenizer(line, "\t");
            accHash.put(stok.nextToken(), stok.nextToken());
        }
        for (int i = 0; i < result.length; ++i) {
            String acc = (String)accHash.get(result[i][2]);
            if (acc == null) continue;
            result[i][1] = acc;
        }
    }

    private File getAccessionFile(String fileName) {
        String sep = System.getProperty("file.separator");
        File file = new File(fileName);
        String accFileName = file.getName();
        file = file.getParentFile();
        file = new File(file.getPath() + sep + "URL data" + sep + "Tags" + sep + accFileName);
        return file;
    }

    private String[] getHeaderNames() {
        String[] headerNamesArray = new String[this.headerNames.size()];
        for (int i = 0; i < headerNamesArray.length; ++i) {
            headerNamesArray[i] = (String)this.headerNames.elementAt(i);
        }
        return headerNamesArray;
    }

    private FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    private float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    private float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }

    private void appendResult(Vector resultVector) {
        int numCorr = resultVector.size();
        int rawPIndex = this.result[0].length;
        int resultColumns = rawPIndex + numCorr;
        String[][] newResult = new String[this.result.length][resultColumns];
        for (int i = 0; i < this.result.length; ++i) {
            for (int j = 0; j < this.result[0].length; ++j) {
                newResult[i][j] = this.result[i][j];
            }
        }
        for (int col = 0; col < numCorr; ++col) {
            double[] currentArray = (double[])resultVector.elementAt(col);
            int resultCol = col + rawPIndex;
            for (int row = 0; row < newResult.length; ++row) {
                newResult[row][resultCol] = this.format.format(currentArray[row]);
            }
        }
        this.result = newResult;
    }

    private void pValueCorrections(AlgorithmData inputData) {
        int k = this.result.length;
        double[] pValues = new double[k];
        double[] correctedP = new double[k];
        int pIndex = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --pIndex;
        Vector<double[]> pValueCorrectionVector = new Vector<double[]>();
        for (int i = 0; i < k; ++i) {
            pValues[i] = Double.parseDouble(this.result[i][pIndex]);
        }
        AlgorithmParameters params = inputData.getParams();
        if (params.getBoolean("bonferroni-correction", false)) {
            pValueCorrectionVector.add(this.bonferroniCorrection(pValues));
            this.headerNames.add("Bonf. Corr.");
        }
        if (params.getBoolean("bonferroni-step-down-correction", false)) {
            pValueCorrectionVector.add(this.stepDownBonferroniCorrection(pValues));
            this.headerNames.add("Bonf. S.D. Corr.");
        }
        if (params.getBoolean("sidak-correction", false)) {
            pValueCorrectionVector.add(this.sidakCorrection(pValues));
            this.headerNames.add("Sidak Corr.");
        }
        this.appendResult(pValueCorrectionVector);
    }

    private double[] bonferroniCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        for (int i = 0; i < k; ++i) {
            correctedP[i] = pValues[i] * (double)k;
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    private double[] stepDownBonferroniCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        int m = 0;
        correctedP[0] = pValues[0] * (double)k;
        for (int i = 1; i < k; ++i) {
            if (pValues[i] > pValues[i - 1]) {
                m = i;
            }
            correctedP[i] = pValues[i] * (double)(k - m);
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    private double[] sidakCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        for (int i = 0; i < k; ++i) {
            correctedP[i] = 1.0 - Math.pow(1.0 - pValues[i], k);
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    private void permutationAnalysis(int p) {
        AlgorithmEvent permEvent = new AlgorithmEvent((Object)this, 2, p);
        permEvent.setDescription("SET_UNITS");
        permEvent.setIntValue(p);
        this.algorithm.fireValueChanged(permEvent);
        permEvent.setDescription("SET_VALUE");
        long start = System.currentTimeMillis();
        int k = this.result.length;
        int sampleSize = this.sampleVector.size();
        int populationSize = this.populationVector.size();
        int[] accumulator = new int[this.result.length];
        for (int i = 0; i < accumulator.length; ++i) {
            accumulator[0] = 0;
        }
        int[] hitNumberAcc = new int[sampleSize];
        Random rand = new Random(System.currentTimeMillis());
        long sampleTime = 0L;
        for (int i = 0; i < p; ++i) {
            permEvent.setIntValue(i + 1);
            this.algorithm.fireValueChanged(permEvent);
            this.sampleVector = this.getRandomSampleVector(sampleSize, rand);
            this.bench.resetForNewList();
            this.bench.GetListHitsByCategory(this.sampleVector);
            this.bench.ConstructResults();
            String[][] testResult = this.bench.getResults();
            this.accumulateBinHits(testResult, accumulator);
        }
        double[] prob = new double[k];
        for (int i = 0; i < k; ++i) {
            prob[i] = (double)accumulator[i] / (double)p;
            if (prob[i] != 0.0) continue;
            prob[i] = 1.0 / (double)p;
        }
        permEvent.setDescription("DISPOSE");
        this.algorithm.fireValueChanged(permEvent);
        Vector<double[]> probVector = new Vector<double[]>();
        probVector.add(prob);
        this.appendResult(probVector);
        this.headerNames.add("Prob. Anal.");
    }

    private int getMaxPopHits(String[][] result) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < result.length; ++i) {
            max = Math.max(max, Integer.parseInt(result[i][4]));
        }
        return max;
    }

    private Vector getRandomSampleVector(int sampleSize, Random rand) {
        Vector sampleVector = new Vector(sampleSize);
        Vector dummyPopVector = (Vector)this.populationVector.clone();
        int popSize = this.populationVector.size();
        int index = 0;
        for (int i = 0; i < sampleSize; ++i) {
            index = (int)((float)dummyPopVector.size() * rand.nextFloat());
            sampleVector.add(dummyPopVector.remove(index));
        }
        return sampleVector;
    }

    private void accumulateHits(String[][] result, String[] keys, int[] accumulator) {
        block0: for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < keys.length; ++j) {
                if (!result[i][1].equals(keys[j])) continue;
                if (Integer.parseInt(result[i][2]) <= Integer.parseInt(this.result[j][2])) continue block0;
                int n = j;
                accumulator[n] = accumulator[n] + 1;
                continue block0;
            }
        }
    }

    private void accumulateBinHits(String[][] newResult, int[] accumulator) {
        for (int cat = 0; cat < this.annotationFileList.length; ++cat) {
            double minP = Double.POSITIVE_INFINITY;
            for (int i = 0; i < newResult.length; ++i) {
                if (this.annotationFileList[cat].indexOf(newResult[i][0]) < 0) continue;
                minP = Math.min(minP, Double.parseDouble(newResult[i][6]));
            }
            for (int j = 0; j < this.result.length; ++j) {
                if (this.annotationFileList[cat].indexOf(this.result[j][0]) < 0 || !(minP < Double.parseDouble(this.result[j][6]))) continue;
                int n = j;
                accumulator[n] = accumulator[n] + 1;
            }
        }
    }

    private double[] orderBootStrappedProb(double[] prob) {
        double[] orderedProb = new double[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            orderedProb[i] = prob[Integer.parseInt(this.result[i][2])];
        }
        return orderedProb;
    }

    private void trimResult(String trimOption, float trimValue) {
        int i;
        boolean[] flagged = new boolean[this.result.length];
        int hitIndex = this.performClusterAnalysis ? this.headerNames.indexOf("List Hits") : this.headerNames.indexOf("Pop. Hits");
        --hitIndex;
        int keeperCount = this.result.length;
        if (trimOption.equals("NO_TRIM")) {
            for (i = 0; i < this.result.length; ++i) {
                if (!((float)Integer.parseInt(this.result[i][hitIndex]) < trimValue)) continue;
                flagged[i] = true;
                --keeperCount;
            }
        } else {
            trimValue /= 100.0f;
            for (i = 0; i < this.result.length; ++i) {
                if (!(Double.parseDouble(this.result[i][hitIndex]) / Double.parseDouble(this.result[i][hitIndex + 1]) < (double)trimValue)) continue;
                flagged[i] = true;
                --keeperCount;
            }
        }
        String[][] newResult = new String[keeperCount][];
        String[][] newHitList = new String[keeperCount][];
        String[] newCategoryNames = new String[keeperCount];
        int keeperIndex = 0;
        for (int i2 = 0; i2 < this.result.length; ++i2) {
            if (flagged[i2]) continue;
            newResult[keeperIndex] = this.result[i2];
            newHitList[keeperIndex] = this.hitList[i2];
            newCategoryNames[keeperIndex] = this.categoryNames[i2];
            ++keeperIndex;
        }
        this.result = newResult;
        this.hitList = newHitList;
        this.categoryNames = newCategoryNames;
    }
}

