/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.nonpar;

import JSci.maths.DoubleMatrix;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.statistics.ChiSqrDistribution;
import JSci.maths.statistics.NormalDistribution;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.microarray.mev.cluster.Cluster;
import org.tigr.microarray.mev.cluster.Node;
import org.tigr.microarray.mev.cluster.NodeList;
import org.tigr.microarray.mev.cluster.NodeValue;
import org.tigr.microarray.mev.cluster.NodeValueList;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.impl.HCL;
import org.tigr.microarray.mev.cluster.algorithm.impl.nonpar.NonparHypergeometricProbability;
import org.tigr.microarray.mev.cluster.gui.impl.nonpar.NonparFDRDialog;
import org.tigr.microarray.mev.r.REXP;
import org.tigr.microarray.mev.r.RList;
import org.tigr.microarray.mev.r.RSrvException;
import org.tigr.microarray.mev.r.Rconnection;
import org.tigr.microarray.mev.r.RconnectionManager;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class Nonpar
extends AbstractAlgorithm {
    private String MODE_WILCOXON_MANN_WHITNEY = "nonpar-mode-wilcoxon-mann-whitney";
    private String MODE_KRUSKAL_WALLIS = "nonpar-mode-kruscal-wallis";
    private String MODE_MACK_SKILLINGS = "nonpar-mode-mack-skillings";
    private String MODE_FISHER_EXACT = "nonpar-fisher-exact";
    private float FRACTION_PER_BATCH = 0.1f;
    private int MAX_BATCH_SIZE = 1000;
    private String INSUFFICIENT_N = "Skipped -- Insufficient Data";
    private String DESIGN_DESC_INCOMPLETE = "Incomplete Design";
    private String DESIGN_DESC_BALANCED = "Balanced Design";
    private String DESIGN_DESC_UNBALANCED = "Unbalanced Design";
    private String METHOD_MACK_SKILLINGS = "Mack-Skillings";
    private String METHOD_GENERALIZED_MACK_SKILLINGS = "Mack-Skillings (generalized for unbal.)";
    private String METHOD_NONE_INCOMPLETE = "None (incomplete design)";
    private AlgorithmData algData;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        this.algData = data;
        FloatMatrix matrix = data.getMatrix("matrix");
        String mode = data.getParams().getString("nonpar-mode");
        if (mode.equals(this.MODE_WILCOXON_MANN_WHITNEY)) {
            this.executeWilcoxonTest(matrix);
        } else if (mode.equals(this.MODE_KRUSKAL_WALLIS)) {
            this.executeKruskalWallisTest(matrix);
        } else if (mode.equals(this.MODE_MACK_SKILLINGS)) {
            this.executeMackSkillings(matrix);
        } else if (mode.equals(this.MODE_FISHER_EXACT)) {
            this.executeFisherExactTest(matrix);
        }
        return this.algData;
    }

    public void abort() {
    }

    private void executeWilcoxonTest(FloatMatrix m) throws AlgorithmException {
        boolean useAlpha = this.algData.getParams().getBoolean("use-alpha-criterion", true);
        int[] groups = this.algData.getIntArray("group-assignments");
        int[][] clusters = new int[2][];
        String[] method = new String[m.getRowDimension()];
        FloatMatrix resultMatrix = new FloatMatrix(m.getRowDimension(), useAlpha ? 5 : 6);
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Executing Wilcoxon Rank Sum"));
        int numRows = m.getRowDimension();
        float[] p_values = new float[m.getRowDimension()];
        for (int iter = 0; iter < numRows; ++iter) {
            NonparOneWayData dataObj = new NonparOneWayData(m.A[iter], groups, 2);
            int[] groupCounts = dataObj.getGroupNs();
            resultMatrix.set(iter, 0, (float)groupCounts[0]);
            resultMatrix.set(iter, 1, (float)groupCounts[1]);
            if (!dataObj.areGroupsNull) {
                float[] dataVals = dataObj.getValues();
                double[] resultVals = this.wilcoxonImpl(dataVals, dataObj.getGroups(), groupCounts[0], groupCounts[1]);
                resultMatrix.set(iter, 2, (float)resultVals[0]);
                resultMatrix.set(iter, 3, (float)resultVals[1]);
                p_values[iter] = (float)resultVals[2];
                resultMatrix.set(iter, 4, p_values[iter]);
                if (Float.isNaN(p_values[iter]) && !useAlpha) {
                    resultMatrix.set(iter, 5, Float.NaN);
                }
                method[iter] = "(W*) Large Sample Approx.";
                if (resultVals[3] == 1.0) {
                    int n = iter;
                    method[n] = method[n] + " w/ corr. for tied ranks";
                }
            } else {
                resultMatrix.set(iter, 0, (float)groupCounts[0]);
                resultMatrix.set(iter, 1, (float)groupCounts[1]);
                resultMatrix.set(iter, 2, Float.NaN);
                resultMatrix.set(iter, 3, Float.NaN);
                resultMatrix.set(iter, 4, Float.NaN);
                p_values[iter] = Float.NaN;
                if (!useAlpha) {
                    resultMatrix.set(iter, 5, Float.NaN);
                }
                method[iter] = "None, empty group(s)";
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, (int)((float)iter / (float)numRows * 100.0f), "Executing Wilcoxon Rank Sum (finished batch " + iter + ")"));
        }
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Processing Results"));
        if (!useAlpha) {
            Vector<Float> validP = new Vector<Float>();
            Vector<Integer> validInd = new Vector<Integer>();
            Vector<Integer> invalidInd = new Vector<Integer>();
            for (int i = 0; i < p_values.length; ++i) {
                if (!Float.isNaN(p_values[i])) {
                    validP.add(new Float(p_values[i]));
                    validInd.add(new Integer(i));
                    continue;
                }
                invalidInd.add(new Integer(i));
            }
            int validCnt = validP.size();
            p_values = new float[validCnt];
            for (int i = 0; i < validCnt; ++i) {
                p_values[i] = ((Float)validP.get(i)).floatValue();
            }
            Vector bhResult = this.benjaminiHochberg(p_values);
            float[] adjPValues = (float[])bhResult.get(0);
            int[] bhOrderedIndices = (int[])bhResult.get(1);
            int[] orderedIndices = new int[bhOrderedIndices.length];
            for (int i = 0; i < adjPValues.length; ++i) {
                orderedIndices[i] = (Integer)validInd.get(bhOrderedIndices[i]);
                resultMatrix.set(orderedIndices[i], 5, adjPValues[i]);
            }
            if (this.algData.getParams().getBoolean("use-fdr-graph")) {
                Object[][] frameMatrix = this.algData.getObjectMatrix("main-frame");
                NonparFDRDialog fdrDialog = new NonparFDRDialog((JFrame)frameMatrix[0][0], adjPValues, orderedIndices);
                if (fdrDialog.showModal() == 0) {
                    int i;
                    int[] sigGenesArray = fdrDialog.getSelectedIndices();
                    int[] nonSigGenesArray = fdrDialog.getNonSelectedIndices();
                    int[] nonSig = new int[nonSigGenesArray.length + invalidInd.size()];
                    for (i = 0; i < nonSigGenesArray.length; ++i) {
                        nonSig[i] = nonSigGenesArray[i];
                    }
                    for (i = 0; i < invalidInd.size(); ++i) {
                        nonSig[nonSigGenesArray.length + i] = (Integer)invalidInd.get(i);
                    }
                    clusters[0] = sigGenesArray;
                    clusters[1] = nonSig;
                }
                this.algData.addParam("fdr", String.valueOf(fdrDialog.getFDRLimit()));
            } else {
                int i;
                float fdrLimit = this.algData.getParams().getFloat("fdr");
                Vector<Integer> sigGenes = new Vector<Integer>();
                Vector<Integer> nonSigGenes = new Vector<Integer>();
                for (i = 0; i < adjPValues.length; ++i) {
                    if (adjPValues[i] <= fdrLimit) {
                        sigGenes.add(new Integer(orderedIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(orderedIndices[i]));
                }
                for (i = 0; i < invalidInd.size(); ++i) {
                    nonSigGenes.add((Integer)invalidInd.get(i));
                }
                int[] sigGenesArray = new int[sigGenes.size()];
                int[] nonSigGenesArray = new int[nonSigGenes.size()];
                for (i = 0; i < sigGenesArray.length; ++i) {
                    sigGenesArray[i] = (Integer)sigGenes.get(i);
                }
                for (i = 0; i < nonSigGenesArray.length; ++i) {
                    nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                }
                clusters[0] = sigGenesArray;
                clusters[1] = nonSigGenesArray;
            }
            if (clusters[0].length > 0) {
                this.algData.addParam("estimated-fdr", String.valueOf(adjPValues[clusters[0].length - 1]));
            } else {
                this.algData.addParam("estimated-fdr", String.valueOf(Float.NaN));
            }
        } else {
            int i;
            Vector<Integer> sigGenes = new Vector<Integer>();
            Vector<Integer> nonSigGenes = new Vector<Integer>();
            float alpha = this.algData.getParams().getFloat("alpha");
            int numResultCols = resultMatrix.getColumnDimension();
            for (i = 0; i < numRows; ++i) {
                if (!Float.isNaN(resultMatrix.A[i][numResultCols - 1]) && resultMatrix.A[i][numResultCols - 1] <= alpha) {
                    sigGenes.add(new Integer(i));
                    continue;
                }
                nonSigGenes.add(new Integer(i));
            }
            int[] sigGenesArray = new int[sigGenes.size()];
            int[] nonSigGenesArray = new int[nonSigGenes.size()];
            for (i = 0; i < sigGenesArray.length; ++i) {
                sigGenesArray[i] = (Integer)sigGenes.get(i);
            }
            for (i = 0; i < nonSigGenesArray.length; ++i) {
                nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
            }
            clusters[0] = sigGenesArray;
            clusters[1] = nonSigGenesArray;
        }
        this.algData.addMatrix("result-matrix", resultMatrix);
        this.algData.addStringArray("method-array", method);
        FloatMatrix clusterMeans = this.getMeans(m, clusters);
        FloatMatrix clusterVars = this.getVariances(m, clusterMeans, clusters);
        this.algData.addIntMatrix("clusters", (int[][])clusters);
        this.algData.addMatrix("cluster-means", clusterMeans);
        this.algData.addMatrix("cluster-variances", clusterVars);
        if (this.algData.getParams().getBoolean("hcl-execution")) {
            int linkageMethod = this.algData.getParams().getInt("method-linkage");
            int metric = this.algData.getParams().getInt("hcl-distance-function");
            boolean genes = this.algData.getParams().getBoolean("calculate-genes");
            boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
            boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
            NodeValueList nodeValueList = this.calculateHierarchicalTree(m, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
            Node node = new Node(clusters[0]);
            node.setValues(nodeValueList);
            NodeList nodeList = new NodeList();
            nodeList.addNode(node);
            Cluster hclCluster = new Cluster();
            hclCluster.setNodeList(nodeList);
            this.algData.addCluster("hcl-clusters", hclCluster);
        }
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 110, "Processing Results"));
    }

    private void executeKruskalWallisTest(FloatMatrix m) throws AlgorithmException {
        boolean useAlpha = this.algData.getParams().getBoolean("use-alpha-criterion", true);
        int[] groups = this.algData.getIntArray("group-assignments");
        int numGroups = this.algData.getStringArray("group-names").length - 1;
        FloatMatrix resultMatrix = new FloatMatrix(m.getRowDimension(), useAlpha ? 3 : 4);
        int[][] clusters = new int[2][];
        String[] method = new String[m.getRowDimension()];
        int numRows = m.getRowDimension();
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Executing Kruskal-Wallis Test"));
        float[] p_values = new float[m.getRowDimension()];
        for (int iter = 0; iter < numRows; ++iter) {
            NonparOneWayData data = new NonparOneWayData(m.A[iter], groups, numGroups);
            if (!data.getAreGroupsNull()) {
                float[] result = this.kruskalImpl(data.getValues(), data.getGroups(), numGroups);
                method[iter] = result[3] != 1.0f ? "(H) Kruskal-Wallis" : "(H') Kruskal-Wallis w/ Ties Corr.";
                resultMatrix.A[iter][0] = result[0];
                resultMatrix.A[iter][1] = result[1];
                resultMatrix.A[iter][2] = result[2];
                p_values[iter] = result[2];
            } else {
                resultMatrix.A[iter][0] = Float.NaN;
                resultMatrix.A[iter][1] = Float.NaN;
                resultMatrix.A[iter][2] = Float.NaN;
                p_values[iter] = Float.NaN;
                if (!useAlpha) {
                    resultMatrix.A[iter][3] = Float.NaN;
                }
                method[iter] = "None, empty group(s)";
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, (int)((float)iter / (float)numRows * 100.0f), "Executing Kruskal-Wallis Test (finished batch " + iter + ")"));
        }
        if (!useAlpha) {
            Vector<Float> validP = new Vector<Float>();
            Vector<Integer> validInd = new Vector<Integer>();
            Vector<Integer> invalidInd = new Vector<Integer>();
            for (int i = 0; i < p_values.length; ++i) {
                if (!Float.isNaN(p_values[i])) {
                    validP.add(new Float(p_values[i]));
                    validInd.add(new Integer(i));
                    continue;
                }
                invalidInd.add(new Integer(i));
            }
            int validCnt = validP.size();
            p_values = new float[validCnt];
            for (int i = 0; i < validCnt; ++i) {
                p_values[i] = ((Float)validP.get(i)).floatValue();
            }
            Vector bhResult = this.benjaminiHochberg(p_values);
            float[] adjPValues = (float[])bhResult.get(0);
            int[] bhOrderedIndices = (int[])bhResult.get(1);
            int[] orderedIndices = new int[bhOrderedIndices.length];
            for (int i = 0; i < adjPValues.length; ++i) {
                orderedIndices[i] = (Integer)validInd.get(bhOrderedIndices[i]);
                resultMatrix.set(orderedIndices[i], 3, adjPValues[i]);
            }
            if (this.algData.getParams().getBoolean("use-fdr-graph")) {
                Object[][] frameMatrix = this.algData.getObjectMatrix("main-frame");
                NonparFDRDialog fdrDialog = new NonparFDRDialog((JFrame)frameMatrix[0][0], adjPValues, orderedIndices);
                if (fdrDialog.showModal() == 0) {
                    int i;
                    int[] sigGenesArray = fdrDialog.getSelectedIndices();
                    int[] nonSigGenesArray = fdrDialog.getNonSelectedIndices();
                    int[] nonSig = new int[nonSigGenesArray.length + invalidInd.size()];
                    for (i = 0; i < nonSigGenesArray.length; ++i) {
                        nonSig[i] = nonSigGenesArray[i];
                    }
                    for (i = 0; i < invalidInd.size(); ++i) {
                        nonSig[nonSigGenesArray.length + i] = (Integer)invalidInd.get(i);
                    }
                    clusters[0] = sigGenesArray;
                    clusters[1] = nonSig;
                }
                this.algData.addParam("fdr", String.valueOf(fdrDialog.getFDRLimit()));
            } else {
                int i;
                float fdrLimit = this.algData.getParams().getFloat("fdr");
                Vector<Integer> sigGenes = new Vector<Integer>();
                Vector<Integer> nonSigGenes = new Vector<Integer>();
                for (i = 0; i < adjPValues.length; ++i) {
                    if (adjPValues[i] <= fdrLimit) {
                        sigGenes.add(new Integer(orderedIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(orderedIndices[i]));
                }
                for (i = 0; i < invalidInd.size(); ++i) {
                    nonSigGenes.add((Integer)invalidInd.get(i));
                }
                int[] sigGenesArray = new int[sigGenes.size()];
                int[] nonSigGenesArray = new int[nonSigGenes.size()];
                for (i = 0; i < sigGenesArray.length; ++i) {
                    sigGenesArray[i] = (Integer)sigGenes.get(i);
                }
                for (i = 0; i < nonSigGenesArray.length; ++i) {
                    nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                }
                clusters[0] = sigGenesArray;
                clusters[1] = nonSigGenesArray;
            }
            if (clusters[0].length > 0) {
                this.algData.addParam("estimated-fdr", String.valueOf(adjPValues[clusters[0].length - 1]));
            } else {
                this.algData.addParam("estimated-fdr", String.valueOf(Float.NaN));
            }
        } else {
            int i;
            Vector<Integer> sigGenes = new Vector<Integer>();
            Vector<Integer> nonSigGenes = new Vector<Integer>();
            float alpha = this.algData.getParams().getFloat("alpha");
            int numResultCols = resultMatrix.getColumnDimension();
            for (i = 0; i < numRows; ++i) {
                if (!Float.isNaN(resultMatrix.A[i][numResultCols - 1]) && resultMatrix.A[i][numResultCols - 1] <= alpha) {
                    sigGenes.add(new Integer(i));
                    continue;
                }
                nonSigGenes.add(new Integer(i));
            }
            int[] sigGenesArray = new int[sigGenes.size()];
            int[] nonSigGenesArray = new int[nonSigGenes.size()];
            for (i = 0; i < sigGenesArray.length; ++i) {
                sigGenesArray[i] = (Integer)sigGenes.get(i);
            }
            for (i = 0; i < nonSigGenesArray.length; ++i) {
                nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
            }
            clusters[0] = sigGenesArray;
            clusters[1] = nonSigGenesArray;
        }
        this.algData.addMatrix("result-matrix", resultMatrix);
        this.algData.addStringArray("method-array", method);
        FloatMatrix clusterMeans = this.getMeans(m, clusters);
        FloatMatrix clusterVars = this.getVariances(m, clusterMeans, clusters);
        this.algData.addIntMatrix("clusters", (int[][])clusters);
        this.algData.addMatrix("cluster-means", clusterMeans);
        this.algData.addMatrix("cluster-variances", clusterVars);
        if (this.algData.getParams().getBoolean("hcl-execution")) {
            int linkageMethod = this.algData.getParams().getInt("method-linkage");
            int metric = this.algData.getParams().getInt("hcl-distance-function");
            boolean genes = this.algData.getParams().getBoolean("calculate-genes");
            boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
            boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
            NodeValueList nodeValueList = this.calculateHierarchicalTree(m, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
            Node node = new Node(clusters[0]);
            node.setValues(nodeValueList);
            NodeList nodeList = new NodeList();
            nodeList.addNode(node);
            Cluster hclCluster = new Cluster();
            hclCluster.setNodeList(nodeList);
            this.algData.addCluster("hcl-clusters", hclCluster);
        }
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 110, "Processing Results"));
    }

    private void executeMackSkillings(FloatMatrix matrix) throws AlgorithmException {
        int[] rawFactorAGroupings = this.algData.getIntArray("factor-A-group-assignments");
        int[] rawFactorBGroupings = this.algData.getIntArray("factor-B-group-assignments");
        int numFactorALevels = this.algData.getStringArray("factor-A-level-names").length;
        int numFactorBLevels = this.algData.getStringArray("factor-B-level-names").length;
        int numRows = matrix.getRowDimension();
        ChiSqrDistribution factorAChiDist = new ChiSqrDistribution((double)(numFactorALevels - 1));
        ChiSqrDistribution factorBChiDist = new ChiSqrDistribution((double)(numFactorBLevels - 1));
        float[][] resultData = new float[numRows][7];
        String[] designDesc = new String[numRows];
        String[] method = new String[numRows];
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Executing Kruskal-Wallis Test"));
        for (int row = 0; row < numRows; ++row) {
            NonparTwoWayData currentData = new NonparTwoWayData(matrix.A[row], numFactorALevels, numFactorBLevels, rawFactorAGroupings, rawFactorBGroupings);
            resultData[row][0] = currentData.nVals;
            if (currentData.isComplete && !currentData.isFlat) {
                float pValue;
                float msStat;
                if (currentData.isBalanced) {
                    designDesc[row] = this.DESIGN_DESC_BALANCED;
                    method[row] = this.METHOD_MACK_SKILLINGS;
                    float[] sVals = this.computeSValues(currentData.values, currentData.repTotals[0][0], numFactorALevels, numFactorBLevels, currentData.factorAGrouping, currentData.factorBGrouping);
                    msStat = this.getMackSkillingsStatistic(sVals, currentData.repTotals[0][0], numFactorALevels, numFactorBLevels);
                    pValue = (float)(1.0 - factorAChiDist.cumulative((double)msStat));
                    resultData[row][1] = numFactorALevels;
                    resultData[row][2] = msStat;
                    resultData[row][3] = pValue;
                    currentData.transposeRepTots();
                    sVals = this.computeSValues(currentData.values, currentData.repTotals[0][0], numFactorBLevels, numFactorALevels, currentData.factorBGrouping, currentData.factorAGrouping);
                    msStat = this.getMackSkillingsStatistic(sVals, currentData.repTotals[0][0], numFactorBLevels, numFactorALevels);
                    pValue = (float)(1.0 - factorBChiDist.cumulative((double)msStat));
                    resultData[row][4] = numFactorBLevels;
                    resultData[row][5] = msStat;
                    resultData[row][6] = pValue;
                } else {
                    designDesc[row] = this.DESIGN_DESC_UNBALANCED;
                    method[row] = this.METHOD_GENERALIZED_MACK_SKILLINGS;
                    msStat = (float)this.computeGeneralizedMS(currentData.values, currentData.repTotals, numFactorALevels, numFactorBLevels, currentData.factorAGrouping, currentData.factorBGrouping);
                    pValue = (float)(1.0 - factorAChiDist.cumulative((double)msStat));
                    resultData[row][1] = numFactorALevels;
                    resultData[row][2] = msStat;
                    resultData[row][3] = pValue;
                    currentData.transposeRepTots();
                    msStat = (float)this.computeGeneralizedMS(currentData.values, currentData.repTotals, numFactorBLevels, numFactorALevels, currentData.factorBGrouping, currentData.factorAGrouping);
                    pValue = (float)(1.0 - factorBChiDist.cumulative((double)msStat));
                    resultData[row][4] = numFactorBLevels;
                    resultData[row][5] = msStat;
                    resultData[row][6] = pValue;
                }
            } else {
                designDesc[row] = this.DESIGN_DESC_INCOMPLETE;
                method[row] = this.METHOD_NONE_INCOMPLETE;
                resultData[row][1] = Float.NaN;
                resultData[row][2] = Float.NaN;
                resultData[row][3] = Float.NaN;
                resultData[row][4] = Float.NaN;
                resultData[row][5] = Float.NaN;
                resultData[row][6] = Float.NaN;
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, (int)((float)row / (float)numRows * 100.0f), "Executing Mack-Skillings Test"));
        }
        this.algData.addMatrix("result-matrix", new FloatMatrix(resultData));
        this.algData.addStringArray("design-array", designDesc);
        this.algData.addStringArray("method-array", method);
        float factorAAlpha = this.algData.getParams().getFloat("alpha");
        float factorBAlpha = this.algData.getParams().getFloat("alpha");
        int[][] clusters = this.getTwoWaySignificantGenes(resultData, factorAAlpha, factorBAlpha, 3, 6);
        this.algData.addIntMatrix("clusters", clusters);
        FloatMatrix means = this.getMeans(matrix, clusters);
        FloatMatrix vars = this.getVariances(matrix, means, clusters);
        this.algData.addMatrix("cluster-means", means);
        this.algData.addMatrix("cluster-variances", vars);
        if (this.algData.getParams().getBoolean("hcl-execution")) {
            int linkageMethod = this.algData.getParams().getInt("method-linkage");
            int metric = this.algData.getParams().getInt("hcl-distance-function");
            boolean genes = this.algData.getParams().getBoolean("calculate-genes");
            boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
            boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
            NodeList nodeList = new NodeList();
            NodeValueList nodeValueList = this.calculateHierarchicalTree(matrix, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
            Node node = new Node(clusters[0]);
            node.setValues(nodeValueList);
            nodeList.addNode(node);
            nodeValueList = this.calculateHierarchicalTree(matrix, clusters[2], linkageMethod, metric, absoluteDistance, genes, experiments);
            node = new Node(clusters[2]);
            node.setValues(nodeValueList);
            nodeList.addNode(node);
            Cluster hclCluster = new Cluster();
            hclCluster.setNodeList(nodeList);
            this.algData.addCluster("hcl-clusters", hclCluster);
        }
    }

    private void executeFisherExactTest(FloatMatrix matrix) throws AlgorithmException {
        int[] nonSigGenesArray;
        float binCutoff = this.algData.getParams().getFloat("fisher-exact-bin-cutoff");
        int[] groups = this.algData.getIntArray("group-assignments");
        int numRows = matrix.getRowDimension();
        boolean useAlpha = this.algData.getParams().getBoolean("use-alpha-criterion", true);
        float[] pValuesUpper = new float[numRows];
        float[] pValuesLower = new float[numRows];
        float[] p_values = new float[numRows];
        boolean swapGroupLoc = this.algData.getParams().getBoolean("swap-groups");
        boolean swapBinLoc = this.algData.getParams().getBoolean("swap-bins");
        int upperBinIndex = this.algData.getParams().getInt("upper-bin-index");
        FloatMatrix resultMatrix = new FloatMatrix(numRows, useAlpha ? 7 : 8);
        int[][] clusters = new int[4][];
        boolean[] invalidP = new boolean[numRows];
        NonparHypergeometricProbability hyperG = new NonparHypergeometricProbability();
        for (int i = 0; i < numRows; ++i) {
            NonparOneWayData data = new NonparOneWayData(matrix.A[i], groups, 2);
            if (!data.areGroupsNull) {
                int j;
                int m22 = 0;
                int m21 = 0;
                int m12 = 0;
                int m11 = 0;
                int[] currGroups = data.getGroups();
                float[] currData = data.getValues();
                int[] groupNs = data.getGroupNs();
                boolean[] binPartition = new boolean[currData.length];
                for (j = 0; j < binPartition.length; ++j) {
                    if (currData[j] >= binCutoff) {
                        if (upperBinIndex != 0) continue;
                        binPartition[j] = true;
                        continue;
                    }
                    if (upperBinIndex != 1) continue;
                    binPartition[j] = true;
                }
                if (!swapGroupLoc) {
                    for (j = 0; j < currData.length; ++j) {
                        if (currGroups[j] == 0) {
                            if (!swapBinLoc) {
                                if (binPartition[j]) {
                                    ++m11;
                                    continue;
                                }
                                ++m21;
                                continue;
                            }
                            if (binPartition[j]) {
                                ++m21;
                                continue;
                            }
                            ++m11;
                            continue;
                        }
                        if (!swapBinLoc) {
                            if (binPartition[j]) {
                                ++m12;
                                continue;
                            }
                            ++m22;
                            continue;
                        }
                        if (binPartition[j]) {
                            ++m22;
                            continue;
                        }
                        ++m12;
                    }
                } else {
                    for (j = 0; j < currData.length; ++j) {
                        if (currGroups[j] == 1) {
                            if (!swapBinLoc) {
                                if (binPartition[j]) {
                                    ++m11;
                                    continue;
                                }
                                ++m21;
                                continue;
                            }
                            if (binPartition[j]) {
                                ++m21;
                                continue;
                            }
                            ++m11;
                            continue;
                        }
                        if (!swapBinLoc) {
                            if (binPartition[j]) {
                                ++m12;
                                continue;
                            }
                            ++m22;
                            continue;
                        }
                        if (binPartition[j]) {
                            ++m22;
                            continue;
                        }
                        ++m12;
                    }
                }
                resultMatrix.set(i, 0, (float)m11);
                resultMatrix.set(i, 1, (float)m12);
                resultMatrix.set(i, 2, (float)m21);
                resultMatrix.set(i, 3, (float)m22);
                pValuesUpper[i] = (float)hyperG.upperSumHGP(m11 + m21 + m12 + m22, m11 + m21, m11 + m12, m11);
                pValuesLower[i] = (float)hyperG.lowerSumHGP(m11 + m21 + m12 + m22, m11 + m21, m11 + m12, m11);
                double exactPforMatrix = hyperG.pExactForMatrix(m11, m12, m21, m22);
                p_values[i] = pValuesUpper[i] < pValuesLower[i] ? pValuesUpper[i] + (float)hyperG.conditionalLowerSumHGP(m11 + m21 + m12 + m22, m11 + m21, m11 + m12, m11, exactPforMatrix) : pValuesLower[i] + (float)hyperG.conditionalUpperSumHGP(m11 + m21 + m12 + m22, m11 + m21, m11 + m12, m11, exactPforMatrix);
                resultMatrix.set(i, 4, pValuesLower[i]);
                resultMatrix.set(i, 5, pValuesUpper[i]);
                resultMatrix.set(i, 6, p_values[i]);
                continue;
            }
            invalidP[i] = true;
            pValuesUpper[i] = Float.NaN;
            pValuesLower[i] = Float.NaN;
            p_values[i] = Float.NaN;
            resultMatrix.set(i, 4, Float.NaN);
            resultMatrix.set(i, 5, Float.NaN);
            resultMatrix.set(i, 6, Float.NaN);
        }
        if (!useAlpha) {
            Vector<Float> validP = new Vector<Float>();
            Vector<Integer> validInd = new Vector<Integer>();
            Vector<Integer> invalidInd = new Vector<Integer>();
            for (int i = 0; i < p_values.length; ++i) {
                if (!Float.isNaN(p_values[i])) {
                    validP.add(new Float(p_values[i]));
                    validInd.add(new Integer(i));
                    continue;
                }
                invalidInd.add(new Integer(i));
            }
            int validCnt = validP.size();
            p_values = new float[validCnt];
            for (int i = 0; i < validCnt; ++i) {
                p_values[i] = ((Float)validP.get(i)).floatValue();
            }
            Vector bhResult = this.benjaminiHochberg(p_values);
            float[] adjPValues = (float[])bhResult.get(0);
            int[] bhOrderedIndices = (int[])bhResult.get(1);
            int[] orderedIndices = new int[bhOrderedIndices.length];
            for (int i = 0; i < adjPValues.length; ++i) {
                orderedIndices[i] = (Integer)validInd.get(bhOrderedIndices[i]);
                resultMatrix.set(orderedIndices[i], 7, adjPValues[i]);
            }
            if (this.algData.getParams().getBoolean("use-fdr-graph")) {
                Object[][] frameMatrix = this.algData.getObjectMatrix("main-frame");
                NonparFDRDialog fdrDialog = new NonparFDRDialog((JFrame)frameMatrix[0][0], adjPValues, orderedIndices);
                if (fdrDialog.showModal() == 0) {
                    int i;
                    int[] sigGenesArray = fdrDialog.getSelectedIndices();
                    nonSigGenesArray = fdrDialog.getNonSelectedIndices();
                    int[] nonSig = new int[nonSigGenesArray.length + invalidInd.size()];
                    for (i = 0; i < nonSigGenesArray.length; ++i) {
                        nonSig[i] = nonSigGenesArray[i];
                    }
                    for (i = 0; i < invalidInd.size(); ++i) {
                        nonSig[nonSigGenesArray.length + i] = (Integer)invalidInd.get(i);
                    }
                    clusters[0] = sigGenesArray;
                    clusters[3] = nonSig;
                }
                this.algData.addParam("fdr", String.valueOf(fdrDialog.getFDRLimit()));
            } else {
                int i;
                float fdrLimit = this.algData.getParams().getFloat("fdr");
                Vector<Integer> sigGenes = new Vector<Integer>();
                Vector<Integer> nonSigGenes = new Vector<Integer>();
                for (i = 0; i < adjPValues.length; ++i) {
                    if (adjPValues[i] <= fdrLimit) {
                        sigGenes.add(new Integer(orderedIndices[i]));
                        continue;
                    }
                    nonSigGenes.add(new Integer(orderedIndices[i]));
                }
                for (i = 0; i < invalidInd.size(); ++i) {
                    nonSigGenes.add((Integer)invalidInd.get(i));
                }
                int[] sigGenesArray = new int[sigGenes.size()];
                nonSigGenesArray = new int[nonSigGenes.size()];
                for (i = 0; i < sigGenesArray.length; ++i) {
                    sigGenesArray[i] = (Integer)sigGenes.get(i);
                }
                for (i = 0; i < nonSigGenesArray.length; ++i) {
                    nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                }
                clusters[0] = sigGenesArray;
                clusters[3] = nonSigGenesArray;
            }
            if (clusters[0].length > 0) {
                this.algData.addParam("estimated-fdr", String.valueOf(adjPValues[clusters[0].length - 1]));
            } else {
                this.algData.addParam("estimated-fdr", String.valueOf(Float.NaN));
            }
        } else {
            int i;
            Vector<Integer> sigGenes = new Vector<Integer>();
            Vector<Integer> nonSigGenes = new Vector<Integer>();
            float alpha = this.algData.getParams().getFloat("alpha");
            int numResultCols = resultMatrix.getColumnDimension();
            for (i = 0; i < numRows; ++i) {
                if (!Float.isNaN(resultMatrix.A[i][numResultCols - 1]) && resultMatrix.A[i][numResultCols - 1] <= alpha) {
                    sigGenes.add(new Integer(i));
                    continue;
                }
                nonSigGenes.add(new Integer(i));
            }
            int[] sigGenesArray = new int[sigGenes.size()];
            nonSigGenesArray = new int[nonSigGenes.size()];
            for (i = 0; i < sigGenesArray.length; ++i) {
                sigGenesArray[i] = (Integer)sigGenes.get(i);
            }
            for (i = 0; i < nonSigGenesArray.length; ++i) {
                nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
            }
            clusters[0] = sigGenesArray;
            clusters[3] = nonSigGenesArray;
        }
        int[][] sigClusters = this.getFisherExactTailClusters(clusters[0], pValuesLower, pValuesUpper);
        clusters[1] = sigClusters[0];
        clusters[2] = sigClusters[1];
        this.algData.addMatrix("result-matrix", resultMatrix);
        FloatMatrix clusterMeans = this.getMeans(matrix, clusters);
        FloatMatrix clusterVars = this.getVariances(matrix, clusterMeans, clusters);
        this.algData.addIntMatrix("clusters", (int[][])clusters);
        this.algData.addMatrix("cluster-means", clusterMeans);
        this.algData.addMatrix("cluster-variances", clusterVars);
        if (this.algData.getParams().getBoolean("hcl-execution")) {
            int linkageMethod = this.algData.getParams().getInt("method-linkage");
            int metric = this.algData.getParams().getInt("hcl-distance-function");
            boolean genes = this.algData.getParams().getBoolean("calculate-genes");
            boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
            boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
            NodeValueList nodeValueList = this.calculateHierarchicalTree(matrix, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
            Node node = new Node(clusters[0]);
            node.setValues(nodeValueList);
            NodeList nodeList = new NodeList();
            nodeList.addNode(node);
            Cluster hclCluster = new Cluster();
            hclCluster.setNodeList(nodeList);
            this.algData.addCluster("hcl-clusters", hclCluster);
        }
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 110, "Processing Results"));
    }

    public int[][] getFisherExactTailClusters(int[] sigGenes, float[] leftTailP, float[] rightTailP) {
        int i;
        int[][] leftAndRightClusters = new int[2][];
        if (sigGenes.length < 1) {
            leftAndRightClusters[0] = new int[0];
            leftAndRightClusters[1] = new int[0];
            return leftAndRightClusters;
        }
        Vector<Integer> leftSig = new Vector<Integer>();
        Vector<Integer> rightSig = new Vector<Integer>();
        for (i = 0; i < sigGenes.length; ++i) {
            if (leftTailP[sigGenes[i]] < rightTailP[sigGenes[i]]) {
                leftSig.add(new Integer(sigGenes[i]));
                continue;
            }
            rightSig.add(new Integer(sigGenes[i]));
        }
        leftAndRightClusters[0] = new int[leftSig.size()];
        leftAndRightClusters[1] = new int[rightSig.size()];
        for (i = 0; i < leftAndRightClusters[0].length; ++i) {
            leftAndRightClusters[0][i] = (Integer)leftSig.get(i);
        }
        for (i = 0; i < leftAndRightClusters[1].length; ++i) {
            leftAndRightClusters[1][i] = (Integer)rightSig.get(i);
        }
        return leftAndRightClusters;
    }

    private int[][] getTwoWaySignificantGenes(float[][] data, float factorAAlpha, float factorBAlpha, int factorAPCol, int factorBPCol) {
        int[][] clusters = new int[5][];
        Vector<Integer> factorASig = new Vector<Integer>();
        Vector<Integer> factorANonSig = new Vector<Integer>();
        Vector<Integer> factorBSig = new Vector<Integer>();
        Vector<Integer> factorBNonSig = new Vector<Integer>();
        Vector<Integer> incomp = new Vector<Integer>();
        for (int i = 0; i < data.length; ++i) {
            Integer index = new Integer(i);
            if (data[i][factorAPCol] != Float.NaN) {
                if (data[i][factorAPCol] <= factorAAlpha) {
                    factorASig.add(index);
                } else {
                    factorANonSig.add(index);
                }
                if (data[i][factorBPCol] <= factorBAlpha) {
                    factorBSig.add(index);
                    continue;
                }
                factorBNonSig.add(index);
                continue;
            }
            incomp.add(index);
        }
        clusters[0] = this.toIntArray(factorASig);
        clusters[1] = this.toIntArray(factorANonSig);
        clusters[2] = this.toIntArray(factorBSig);
        clusters[3] = this.toIntArray(factorBNonSig);
        clusters[4] = this.toIntArray(incomp);
        return clusters;
    }

    private int[] toIntArray(Vector intVector) {
        int[] arr = new int[intVector.size()];
        for (int i = 0; i < intVector.size(); ++i) {
            arr[i] = (Integer)intVector.get(i);
        }
        return arr;
    }

    private FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    private float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    private FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    private float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }

    private NodeValueList calculateHierarchicalTree(FloatMatrix m, int[] features, int method, int metric, boolean absoluteDistance, boolean genes, boolean experiments) throws AlgorithmException {
        AlgorithmData result;
        NodeValueList nodeList = new NodeValueList();
        AlgorithmData data = new AlgorithmData();
        FloatMatrix experiment = this.getSubExperiment(m, features);
        data.addMatrix("experiment", experiment);
        data.addParam("hcl-distance-function", String.valueOf(metric));
        data.addParam("hcl-distance-absolute", String.valueOf(absoluteDistance));
        data.addParam("method-linkage", String.valueOf(method));
        HCL hcl = new HCL();
        if (genes) {
            data.addParam("calculate-genes", String.valueOf(true));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        if (experiments) {
            data.addParam("calculate-genes", String.valueOf(false));
            result = hcl.execute(data);
            this.validate(result);
            this.addNodeValues(nodeList, result);
        }
        return nodeList;
    }

    private void addNodeValues(NodeValueList target_list, AlgorithmData source_result) {
        target_list.addNodeValue(new NodeValue("child-1-array", (Object)source_result.getIntArray("child-1-array")));
        target_list.addNodeValue(new NodeValue("child-2-array", (Object)source_result.getIntArray("child-2-array")));
        target_list.addNodeValue(new NodeValue("node-order", (Object)source_result.getIntArray("node-order")));
        target_list.addNodeValue(new NodeValue("height", (Object)source_result.getMatrix("height").getRowPackedCopy()));
    }

    private FloatMatrix getSubExperiment(FloatMatrix experiment, int[] features) {
        FloatMatrix subExperiment = new FloatMatrix(features.length, experiment.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = experiment.A[features[i]];
        }
        return subExperiment;
    }

    private FloatMatrix getSubExperimentReducedCols(FloatMatrix experiment, int[] features) {
        FloatMatrix copyMatrix = experiment.copy();
        FloatMatrix subExperiment = new FloatMatrix(features.length, copyMatrix.getColumnDimension());
        for (int i = 0; i < features.length; ++i) {
            subExperiment.A[i] = copyMatrix.A[features[i]];
        }
        subExperiment = subExperiment.transpose();
        return subExperiment;
    }

    private void validate(AlgorithmData result) throws AlgorithmException {
        if (result.getIntArray("child-1-array") == null) {
            throw new AlgorithmException("parameter 'child-1-array' is null");
        }
        if (result.getIntArray("child-2-array") == null) {
            throw new AlgorithmException("parameter 'child-2-array' is null");
        }
        if (result.getIntArray("node-order") == null) {
            throw new AlgorithmException("parameter 'node-order' is null");
        }
        if (result.getMatrix("height") == null) {
            throw new AlgorithmException("parameter 'height' is null");
        }
    }

    private double computeGeneralizedMS(float[] vals, int[][] numRepsPerCell, int numFactorALevels, int numFactorBLevels, int[] factors, int[] conds) {
        float[] rankArray;
        int[] sortedIndices;
        int[] q = new int[numFactorBLevels];
        for (int i = 0; i < numFactorALevels; ++i) {
            int[] blockCountArray = numRepsPerCell[i];
            for (int j = 0; j < blockCountArray.length; ++j) {
                int n = j;
                q[n] = q[n] + blockCountArray[j];
            }
        }
        int valIndex = 0;
        float[][] rankingArrays = new float[numFactorBLevels][];
        int[][] sortedRankIndices = new int[numFactorBLevels][];
        for (int cond = 0; cond < numFactorBLevels; ++cond) {
            int i;
            float[] condVals = new float[q[cond]];
            int[] tempValueIndices = new int[q[cond]];
            int[] valueIndices = new int[q[cond]];
            valIndex = 0;
            for (i = 0; i < vals.length; ++i) {
                if (conds[i] != cond) continue;
                condVals[valIndex] = vals[i];
                tempValueIndices[valIndex] = i;
                ++valIndex;
            }
            QSort qsort = new QSort(condVals);
            float[] sortedVals = qsort.getSorted();
            sortedIndices = qsort.getOrigIndx();
            for (i = 0; i < sortedIndices.length; ++i) {
                valueIndices[i] = tempValueIndices[sortedIndices[i]];
            }
            sortedRankIndices[cond] = valueIndices;
            rankingArrays[cond] = rankArray = this.getRankings(sortedVals);
        }
        rankArray = rankingArrays[0];
        sortedIndices = sortedRankIndices[0];
        float[] condRankSums = new float[numFactorALevels];
        for (int factor = 0; factor < numFactorALevels; ++factor) {
            for (int cond = 0; cond < numFactorBLevels; ++cond) {
                rankArray = rankingArrays[cond];
                sortedIndices = sortedRankIndices[cond];
                for (int rankIndex = 0; rankIndex < rankArray.length; ++rankIndex) {
                    if (factors[sortedIndices[rankIndex]] != factor) continue;
                    int n = factor;
                    condRankSums[n] = condRankSums[n] + rankArray[rankIndex] / (float)q[cond];
                }
            }
        }
        double[] V = new double[numFactorALevels - 1];
        for (int i = 0; i < V.length; ++i) {
            double sum = 0.0;
            for (int cond = 0; cond < numFactorBLevels; ++cond) {
                sum += (double)numRepsPerCell[i][cond] * ((double)q[cond] + 1.0) / (2.0 * (double)q[cond]);
            }
            V[i] = (double)condRankSums[i] - sum;
        }
        double[][] A = new double[numFactorALevels - 1][numFactorALevels - 1];
        for (int i = 0; i < numFactorALevels - 1; ++i) {
            for (int j = 0; j < numFactorALevels - 1; ++j) {
                double repsPerCell;
                int cond;
                if (i != j) {
                    for (cond = 0; cond < numFactorBLevels; ++cond) {
                        repsPerCell = numRepsPerCell[i][cond];
                        double repsPerCellAlt = numRepsPerCell[j][cond];
                        double[] dArray = A[i];
                        int n = j;
                        dArray[n] = dArray[n] + repsPerCell * repsPerCellAlt * (double)(q[cond] + 1) / (12.0 * Math.pow(q[cond], 2.0));
                    }
                    A[i][j] = -1.0 * A[i][j];
                    continue;
                }
                for (cond = 0; cond < numFactorBLevels; ++cond) {
                    repsPerCell = numRepsPerCell[i][cond];
                    double[] dArray = A[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)((float)(repsPerCell * ((double)q[cond] - repsPerCell) * (double)(q[cond] + 1))) / (12.0 * Math.pow(q[cond], 2.0));
                }
            }
        }
        DoubleSquareMatrix coVarDoubleMatrix = new DoubleSquareMatrix(A);
        DoubleSquareMatrix invCoVar = coVarDoubleMatrix.inverse();
        double[][] dm = new double[][]{V};
        DoubleMatrix vVec = new DoubleMatrix((double[][])dm);
        DoubleMatrix vVecTranspose = (DoubleMatrix)vVec.transpose();
        DoubleMatrix ms = vVec.multiply((DoubleMatrix)invCoVar).multiply(vVecTranspose);
        return ms.getElement(0, 0);
    }

    private float[] computeSValues(float[] v, int numRep, int numFactorALevels, int numFactorBLevels, int[] factorAGrouping, int[] factorBGrouping) {
        float[] sArray = new float[numFactorALevels];
        float[][] condRankings = new float[numFactorBLevels][];
        int[][] sortedRankingIndices = new int[numFactorBLevels][];
        float[] vals = new float[numRep * numFactorALevels];
        for (int cond = 0; cond < numFactorBLevels; ++cond) {
            int[] valueIndices = new int[vals.length];
            int[] tempValIndices = new int[vals.length];
            int valIndex = 0;
            for (int k = 0; k < v.length; ++k) {
                if (factorBGrouping[k] != cond) continue;
                vals[valIndex] = v[k];
                tempValIndices[valIndex] = k;
                ++valIndex;
            }
            QSort qsort = new QSort(vals);
            float[] sortedV = qsort.getSorted();
            int[] sortedIndices = qsort.getOrigIndx();
            for (int i = 0; i < sortedIndices.length; ++i) {
                valueIndices[i] = tempValIndices[sortedIndices[i]];
            }
            sortedRankingIndices[cond] = valueIndices;
            float[] rankings = this.getRankings(sortedV);
            condRankings[cond] = rankings;
        }
        float[] rankingSums = new float[numFactorALevels];
        for (int factor = 0; factor < numFactorALevels; ++factor) {
            for (int cond = 0; cond < numFactorBLevels; ++cond) {
                float[] currCondRanking = condRankings[cond];
                int[] currSortedIndices = sortedRankingIndices[cond];
                for (int rankIndex = 0; rankIndex < currCondRanking.length; ++rankIndex) {
                    if (factorAGrouping[currSortedIndices[rankIndex]] != factor) continue;
                    int n = factor;
                    rankingSums[n] = rankingSums[n] + currCondRanking[rankIndex];
                }
            }
            sArray[factor] = rankingSums[factor] / (float)numRep;
        }
        return sArray;
    }

    private float[] getRankings(float[] sortedVals) {
        float[] ranks = new float[sortedVals.length];
        float accRank = 0.0f;
        int numAcc = 1;
        float currRank = 1.0f;
        boolean acc = false;
        for (int i = 0; i < sortedVals.length; ++i) {
            int j;
            if (i < sortedVals.length - 1) {
                if (sortedVals[i] != sortedVals[i + 1]) {
                    if (!acc) {
                        ranks[i] = i + 1;
                        accRank = ranks[i];
                        numAcc = 1;
                        continue;
                    }
                    acc = false;
                    accRank += (float)(i + 1);
                    for (j = 0; j < numAcc; ++j) {
                        ranks[i - j] = accRank / (float)numAcc;
                    }
                    accRank = ranks[i];
                    numAcc = 1;
                    continue;
                }
                accRank = acc ? (accRank += (float)(i + 1)) : (float)(i + 1);
                ++numAcc;
                acc = true;
                continue;
            }
            if (!acc) {
                ranks[ranks.length - 1] = ranks.length;
                continue;
            }
            accRank += (float)(i + 1);
            for (j = 0; j < numAcc; ++j) {
                ranks[ranks.length - 1 - j] = accRank / (float)numAcc;
            }
        }
        return ranks;
    }

    private float getMackSkillingsStatistic(float[] sArray, int numReps, int numFactorALevels, int numFactorBLevels) {
        float sumSquaredS = 0.0f;
        float numVals = numReps * numFactorALevels * numFactorBLevels;
        for (int i = 0; i < sArray.length; ++i) {
            sumSquaredS = (float)((double)sumSquaredS + Math.pow(sArray[i], 2.0));
        }
        float ms = 12.0f / ((float)numFactorALevels * (numVals + (float)numFactorBLevels)) * sumSquaredS - 3.0f * (numVals + (float)numFactorBLevels);
        return ms;
    }

    private float getPValue(float msStat, float df) {
        ChiSqrDistribution d = new ChiSqrDistribution((double)df);
        return (float)(1.0 - d.cumulative((double)msStat));
    }

    private double[] wilcoxonImpl(float[] data, int[] grouping, int n, int m) {
        double varNotW;
        QSort sort = new QSort(data);
        float[] sortedData = sort.getSorted();
        int[] sortedOrder = sort.getOrigIndx();
        float[] rankings = this.getRankings(sortedData);
        double[] results = new double[4];
        double W = 0.0;
        for (int i = 0; i < sortedData.length; ++i) {
            if (grouping[sortedOrder[i]] != 1) continue;
            W += (double)rankings[i];
        }
        if (!this.areThereRankingTies(rankings)) {
            varNotW = (double)(n * m * (n + m + 1)) / 12.0;
        } else {
            double[] ties = this.getNumberAndSizeOfTies(rankings);
            double tiedSum = 0.0;
            for (int i = 0; i < ties.length; ++i) {
                tiedSum += (ties[i] - 1.0) * ties[i] * (ties[i] + 1.0);
            }
            int N = m + n;
            varNotW = (double)(n * m) * ((double)N + 1.0) / 12.0 - (double)(n * m) * tiedSum / (12.0 * (double)N * (double)(N - 1));
            results[3] = 1.0;
        }
        double W_Star = (W - (double)(m * (n + m + 1)) / 2.0) / Math.sqrt(varNotW);
        NormalDistribution normDist = new NormalDistribution();
        normDist.cumulative(W_Star);
        results[0] = W;
        results[1] = W_Star;
        results[2] = 2.0 * (1.0 - normDist.cumulative(Math.abs(W_Star)));
        return results;
    }

    private boolean isFlat(float[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            if (Float.isNaN(data[i]) || Float.isNaN(data[i + 1]) || data[i] == data[i + 1]) continue;
            return false;
        }
        return true;
    }

    private boolean areThereRankingTies(float[] rankings) {
        for (int i = 0; i < rankings.length - 1; ++i) {
            if (rankings[i] != rankings[i + 1]) continue;
            return true;
        }
        return false;
    }

    private double[] getNumberAndSizeOfTies(float[] rankings) {
        Vector<Integer> tiedCounts = new Vector<Integer>();
        int currCnt = 1;
        boolean buildingTies = false;
        for (int i = 0; i < rankings.length - 1; ++i) {
            if (rankings[i] == rankings[i + 1]) {
                ++currCnt;
                buildingTies = true;
                continue;
            }
            tiedCounts.add(new Integer(currCnt));
            currCnt = 1;
            buildingTies = false;
        }
        if (rankings[rankings.length - 2] == rankings[rankings.length - 1]) {
            tiedCounts.add(new Integer(currCnt));
        } else {
            tiedCounts.add(new Integer(1));
        }
        double[] counts = new double[tiedCounts.size()];
        for (int i = 0; i < counts.length; ++i) {
            counts[i] = ((Integer)tiedCounts.get(i)).doubleValue();
        }
        return counts;
    }

    private float[] kruskalImpl(float[] data, int[] groups, int numGroups) {
        float[] results = new float[4];
        boolean isFlat = this.isFlat(data);
        QSort sort = new QSort(data);
        float[] sortedData = sort.getSorted();
        int[] sortedOrder = sort.getOrigIndx();
        float[] rankings = this.getRankings(sortedData);
        boolean hasTies = this.areThereRankingTies(rankings);
        int[] groupCounts = this.getGroupCounts(groups, numGroups);
        double[] R = this.getKruskalRvalues(rankings, sortedOrder, groups, numGroups);
        double sumNormRsquared = 0.0;
        for (int group = 0; group < numGroups; ++group) {
            sumNormRsquared += Math.pow(R[group], 2.0) / (double)groupCounts[group];
        }
        int N = rankings.length;
        double H = 12.0 * sumNormRsquared / (double)(N * (N + 1)) - (double)(3 * (N + 1));
        if (hasTies) {
            double HPrime;
            results[3] = 1.0f;
            double[] ties = this.getNumberAndSizeOfTies(rankings);
            double tiesSumVal = 0.0;
            for (int i = 0; i < ties.length; ++i) {
                tiesSumVal += Math.pow(ties[i], 3.0) - ties[i];
            }
            H = HPrime = H / (1.0 - tiesSumVal / (Math.pow(N, 3.0) - (double)N));
        }
        double pValue = this.getPValue((float)H, numGroups - 1);
        results[0] = numGroups - 1;
        results[1] = (float)H;
        results[2] = (float)pValue;
        return results;
    }

    private int[] getGroupCounts(int[] groups, int numGroups) {
        int[] counts = new int[numGroups];
        for (int group = 0; group < numGroups; ++group) {
            for (int i = 0; i < groups.length; ++i) {
                if (groups[i] != group) continue;
                int n = group;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    private Vector benjaminiHochberg(float[] pvalues) {
        int i;
        Vector<float[]> valuesAndOrderArrays = new Vector<float[]>();
        QSort sort = new QSort(pvalues);
        float[] sortedP = sort.getSorted();
        int[] sortedIndices = sort.getOrigIndx();
        float[] adjustedP = new float[pvalues.length];
        for (i = 0; i < sortedP.length; ++i) {
            adjustedP[i] = sortedP[i] * (float)sortedP.length / (float)(i + 1);
        }
        if (sortedP.length > 0) {
            sortedP[sortedP.length - 1] = adjustedP[sortedP.length - 1];
            for (i = sortedP.length - 2; i >= 0; --i) {
                sortedP[i] = Math.min(sortedP[i + 1], adjustedP[i]);
            }
        }
        valuesAndOrderArrays.add(sortedP);
        valuesAndOrderArrays.add(sortedIndices);
        return valuesAndOrderArrays;
    }

    private double[] getKruskalRvalues(float[] rankings, int[] sortedOrder, int[] groups, int numGroups) {
        double[] R = new double[numGroups];
        for (int group = 0; group < numGroups; ++group) {
            R[group] = 0.0;
            for (int valIndex = 0; valIndex < rankings.length; ++valIndex) {
                if (groups[sortedOrder[valIndex]] != group) continue;
                int n = group;
                R[n] = R[n] + (double)rankings[valIndex];
            }
        }
        return R;
    }

    private void executeWilcoxon(FloatMatrix m) throws AlgorithmException {
        boolean useAlpha = this.algData.getParams().getBoolean("use-alpha-criterion", true);
        FloatMatrix resultValues = new FloatMatrix(m.getRowDimension(), useAlpha ? 8 : 9);
        int[][] clusters = new int[2][];
        String[] method = new String[m.getRowDimension()];
        String isFlatFunctionCommand = this.getIsFlatFunction();
        String wilcoxFunction = this.getWilcoxFunction();
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Prepating R for Exectution"));
        RconnectionManager manager = new RconnectionManager(new Frame(), "localhost", 6311);
        Rconnection rc = manager.getConnection();
        try {
            int[] nonSigGenesArray;
            rc.voidEval("rm(list = ls(all=TRUE))");
            rc.voidEval("library(stats)");
            rc.voidEval("library(multtest)");
            rc.assign("groups", this.algData.getIntArray("group-assignments"));
            rc.voidEval(isFlatFunctionCommand);
            rc.voidEval(wilcoxFunction);
            int numRows = m.getRowDimension();
            int firstIndex = 0;
            int lastIndex = -1;
            int totIterations = (int)(1.0f / this.FRACTION_PER_BATCH);
            totIterations = Math.max(totIterations, numRows / this.MAX_BATCH_SIZE);
            if (numRows < totIterations) {
                totIterations = 1;
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Executing Wilcoxon Rank Sum"));
            double[] p_values = new double[m.getRowDimension()];
            for (int iter = 1; iter <= totIterations; ++iter) {
                double[] vals;
                if (totIterations == 1) {
                    float[] floatVals = m.getRowPackedCopy();
                    vals = new double[floatVals.length];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = floatVals[i];
                    }
                } else {
                    lastIndex = (int)((float)numRows * this.FRACTION_PER_BATCH) * iter;
                    firstIndex = lastIndex + 1;
                    if (lastIndex - firstIndex > this.MAX_BATCH_SIZE) {
                        lastIndex = firstIndex + this.MAX_BATCH_SIZE - 1;
                    }
                    vals = this.getDataChunk(m, firstIndex, lastIndex);
                }
                rc.assign("data", vals);
                rc.voidEval("m<-matrix(data, nrow=" + vals.length / m.getColumnDimension() + ", ncol=" + Integer.toString(m.getColumnDimension()) + ", byrow=TRUE)");
                rc.voidEval("rm(data)");
                long start = System.currentTimeMillis();
                rc.voidEval("res<-wilcoxFunction()");
                long finish = System.currentTimeMillis();
                Vector resultVector = rc.eval("res;").asVector();
                double[][] groupNMatrix = ((REXP)resultVector.get(resultVector.size() - 1)).asDoubleMatrix();
                for (int i = 0; i < resultVector.size() - 1; ++i) {
                    RList res = ((REXP)resultVector.get(i)).asList();
                    resultValues.A[i][0] = (int)groupNMatrix[i][0];
                    resultValues.A[i][1] = (int)groupNMatrix[i][1];
                    REXP ciRes = res.at("conf.int");
                    if (ciRes != null) {
                        double[] lowerUpper95CI = res.at("conf.int").asDoubleArray();
                        resultValues.A[i + firstIndex][2] = (float)res.at("estimate").asDouble();
                        resultValues.A[i + firstIndex][3] = (float)lowerUpper95CI[0];
                        resultValues.A[i + firstIndex][4] = (float)lowerUpper95CI[1];
                    } else {
                        resultValues.A[i + firstIndex][2] = Float.NaN;
                        resultValues.A[i + firstIndex][3] = Float.NaN;
                        resultValues.A[i + firstIndex][4] = Float.NaN;
                    }
                    resultValues.A[i + firstIndex][5] = (float)res.at("statistic").asDouble();
                    resultValues.A[i + firstIndex][6] = resultValues.A[i][5] + resultValues.A[i][0] * (resultValues.A[i][0] + 1.0f) / 2.0f;
                    resultValues.A[i + firstIndex][7] = (float)res.at("p.value").asDouble();
                    p_values[i + firstIndex] = resultValues.A[i + firstIndex][7];
                    method[i + firstIndex] = res.at("method").asString();
                }
                this.fireValueChanged(new AlgorithmEvent((Object)this, 2, (int)((float)iter / (float)totIterations * 100.0f), "Executing Wilcoxon Rank Sum (finished batch " + iter + ")"));
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Processing Results"));
            if (!useAlpha) {
                rc.assign("rawp", p_values);
                rc.voidEval("adjpV<-mt.rawp2adjp(rawp, proc=\"BH\");");
                REXP adjRes = rc.eval("adjpV");
                RList adjList = adjRes.asList();
                double[][] adjP = adjList.at("adjp").asDoubleMatrix();
                float[] adjPValues = new float[adjP.length];
                int resultWidth = resultValues.getColumnDimension();
                int[] orderedIndices = adjList.at("index").asIntArray();
                for (int i = 0; i < adjP.length; ++i) {
                    adjPValues[i] = (float)adjP[i][1];
                    resultValues.A[orderedIndices[i] - 1][resultWidth - 1] = adjPValues[i];
                }
                if (this.algData.getParams().getBoolean("use-fdr-graph")) {
                    Object[][] frameMatrix = this.algData.getObjectMatrix("main-frame");
                    NonparFDRDialog fdrDialog = new NonparFDRDialog((JFrame)frameMatrix[0][0], adjPValues, orderedIndices);
                    if (fdrDialog.showModal() == 0) {
                        int[] sigGenesArray = fdrDialog.getSelectedIndices();
                        nonSigGenesArray = fdrDialog.getNonSelectedIndices();
                        clusters[0] = sigGenesArray;
                        clusters[1] = nonSigGenesArray;
                    }
                    this.algData.addParam("fdr", String.valueOf(fdrDialog.getFDRLimit()));
                } else {
                    int i;
                    float fdrLimit = this.algData.getParams().getFloat("fdr");
                    Vector<Integer> sigGenes = new Vector<Integer>();
                    Vector<Integer> nonSigGenes = new Vector<Integer>();
                    for (i = 0; i < adjPValues.length; ++i) {
                        if (adjPValues[i] <= fdrLimit) {
                            sigGenes.add(new Integer(orderedIndices[i] - 1));
                            continue;
                        }
                        nonSigGenes.add(new Integer(orderedIndices[i] - 1));
                    }
                    int[] sigGenesArray = new int[sigGenes.size()];
                    nonSigGenesArray = new int[nonSigGenes.size()];
                    for (i = 0; i < sigGenesArray.length; ++i) {
                        sigGenesArray[i] = (Integer)sigGenes.get(i);
                    }
                    for (i = 0; i < nonSigGenesArray.length; ++i) {
                        nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                    }
                    clusters[0] = sigGenesArray;
                    clusters[1] = nonSigGenesArray;
                }
                this.algData.addParam("estimated-fdr", String.valueOf(adjPValues[clusters[0].length - 1]));
            } else {
                int i;
                Vector<Integer> sigGenes = new Vector<Integer>();
                Vector<Integer> nonSigGenes = new Vector<Integer>();
                float alpha = this.algData.getParams().getFloat("alpha");
                int numResultCols = resultValues.getColumnDimension();
                for (i = 0; i < numRows; ++i) {
                    if (resultValues.A[i][numResultCols - 1] <= alpha) {
                        sigGenes.add(new Integer(i));
                        continue;
                    }
                    nonSigGenes.add(new Integer(i));
                }
                int[] sigGenesArray = new int[sigGenes.size()];
                nonSigGenesArray = new int[nonSigGenes.size()];
                for (i = 0; i < sigGenesArray.length; ++i) {
                    sigGenesArray[i] = (Integer)sigGenes.get(i);
                }
                for (i = 0; i < nonSigGenesArray.length; ++i) {
                    nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                }
                clusters[0] = sigGenesArray;
                clusters[1] = nonSigGenesArray;
            }
            this.algData.addMatrix("result-matrix", resultValues);
            this.algData.addStringArray("method-array", method);
            FloatMatrix clusterMeans = this.getMeans(m, clusters);
            FloatMatrix clusterVars = this.getVariances(m, clusterMeans, clusters);
            this.algData.addIntMatrix("clusters", (int[][])clusters);
            this.algData.addMatrix("cluster-means", clusterMeans);
            this.algData.addMatrix("cluster-variances", clusterVars);
            if (this.algData.getParams().getBoolean("hcl-execution")) {
                int linkageMethod = this.algData.getParams().getInt("method-linkage");
                int metric = this.algData.getParams().getInt("hcl-distance-function");
                boolean genes = this.algData.getParams().getBoolean("calculate-genes");
                boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
                boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
                this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
                NodeValueList nodeValueList = this.calculateHierarchicalTree(m, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
                Node node = new Node(clusters[0]);
                node.setValues(nodeValueList);
                NodeList nodeList = new NodeList();
                nodeList.addNode(node);
                Cluster hclCluster = new Cluster();
                hclCluster.setNodeList(nodeList);
                this.algData.addCluster("hcl-clusters", hclCluster);
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 110, "Processing Results"));
        }
        catch (RSrvException e) {
            e.printStackTrace();
        }
        rc.close();
    }

    private void executeKruskalWallis(FloatMatrix m) throws AlgorithmException {
        boolean useAlpha = this.algData.getParams().getBoolean("use-alpha-criterion", true);
        FloatMatrix resultValues = new FloatMatrix(m.getRowDimension(), useAlpha ? 3 : 4);
        int[][] clusters = new int[2][];
        String[] method = new String[m.getRowDimension()];
        String isFlatFunctionCommand = this.getIsFlatFunction();
        String kruskalFunction = this.getKruscalFunction();
        this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Prepating R for Exectution"));
        RconnectionManager manager = new RconnectionManager(new Frame(), "localhost", 6311);
        Rconnection rc = manager.getConnection();
        try {
            int[] nonSigGenesArray;
            rc.voidEval("rm(list = ls(all=TRUE))");
            rc.voidEval("library(stats)");
            rc.assign("groups", this.algData.getIntArray("group-assignments"));
            rc.voidEval(kruskalFunction);
            int numRows = m.getRowDimension();
            int firstIndex = 0;
            int lastIndex = -1;
            int totIterations = (int)(1.0f / this.FRACTION_PER_BATCH);
            totIterations = Math.max(totIterations, numRows / this.MAX_BATCH_SIZE);
            if (numRows < totIterations) {
                totIterations = 1;
            }
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 0, "Executing Kruskal-Wallis Test"));
            double[] p_values = new double[m.getRowDimension()];
            for (int iter = 1; iter <= totIterations; ++iter) {
                long start;
                double[] vals;
                if (totIterations == 1) {
                    float[] floatVals = m.getRowPackedCopy();
                    vals = new double[floatVals.length];
                    for (int i = 0; i < vals.length; ++i) {
                        vals[i] = floatVals[i];
                    }
                } else {
                    lastIndex = (int)((float)numRows * this.FRACTION_PER_BATCH) * iter;
                    firstIndex = lastIndex + 1;
                    if (lastIndex - firstIndex > this.MAX_BATCH_SIZE) {
                        lastIndex = firstIndex + this.MAX_BATCH_SIZE - 1;
                    }
                    start = System.currentTimeMillis();
                    vals = this.getDataChunk(m, firstIndex, lastIndex);
                    long l = System.currentTimeMillis();
                }
                rc.assign("data", vals);
                rc.voidEval("m<-matrix(data, nrow=" + vals.length / m.getColumnDimension() + ", ncol=" + Integer.toString(m.getColumnDimension()) + ", byrow=TRUE)");
                rc.voidEval("rm(data)");
                start = System.currentTimeMillis();
                rc.voidEval("res<-kruskalFunction()");
                long finish = System.currentTimeMillis();
                Vector resultVector = rc.eval("res;").asVector();
                for (int i = 0; i < resultVector.size() - 1; ++i) {
                    RList res = ((REXP)resultVector.get(i)).asList();
                    resultValues.A[i + firstIndex][0] = (float)res.at("statistic").asDouble();
                    resultValues.A[i + firstIndex][1] = (float)res.at("parameter").asDouble();
                    resultValues.A[i + firstIndex][2] = (float)res.at("p.value").asDouble();
                    p_values[i + firstIndex] = resultValues.A[i + firstIndex][2];
                    method[i + firstIndex] = res.at("method").asString();
                }
                this.fireValueChanged(new AlgorithmEvent((Object)this, 2, (int)((float)iter / (float)totIterations * 100.0f), "Executing Kruskal-Wallis Test (finished batch " + iter + ")"));
            }
            if (!useAlpha) {
                rc.assign("rawp", p_values);
                rc.voidEval("adjpV<-mt.rawp2adjp(rawp, proc=\"BH\");");
                REXP adjRes = rc.eval("adjpV");
                RList adjList = adjRes.asList();
                double[][] adjP = adjList.at("adjp").asDoubleMatrix();
                int[] orderedIndices = adjList.at("index").asIntArray();
                float[][] A = new float[adjP.length][1];
                float[] adjPValues = new float[adjP.length];
                int resultWidth = resultValues.getColumnDimension();
                for (int i = 0; i < adjP.length; ++i) {
                    A[i][0] = (float)adjP[i][1];
                    adjPValues[i] = (float)adjP[i][1];
                    resultValues.A[orderedIndices[i] - 1][resultWidth - 1] = adjPValues[i];
                }
                if (this.algData.getParams().getBoolean("use-fdr-graph")) {
                    Object[][] frameMatrix = this.algData.getObjectMatrix("main-frame");
                    NonparFDRDialog fdrDialog = new NonparFDRDialog((JFrame)frameMatrix[0][0], adjPValues, orderedIndices);
                    if (fdrDialog.showModal() == 0) {
                        int[] sigGenesArray = fdrDialog.getSelectedIndices();
                        nonSigGenesArray = fdrDialog.getNonSelectedIndices();
                        clusters[0] = sigGenesArray;
                        clusters[1] = nonSigGenesArray;
                    }
                    this.algData.addParam("fdr", String.valueOf(fdrDialog.getFDRLimit()));
                } else {
                    int i;
                    float fdrLimit = this.algData.getParams().getFloat("fdr");
                    Vector<Integer> sigGenes = new Vector<Integer>();
                    Vector<Integer> nonSigGenes = new Vector<Integer>();
                    for (i = 0; i < adjPValues.length; ++i) {
                        if (adjPValues[i] <= fdrLimit) {
                            sigGenes.add(new Integer(orderedIndices[i] - 1));
                            continue;
                        }
                        nonSigGenes.add(new Integer(orderedIndices[i] - 1));
                    }
                    int[] sigGenesArray = new int[sigGenes.size()];
                    nonSigGenesArray = new int[nonSigGenes.size()];
                    for (i = 0; i < sigGenesArray.length; ++i) {
                        sigGenesArray[i] = (Integer)sigGenes.get(i);
                    }
                    for (i = 0; i < nonSigGenesArray.length; ++i) {
                        nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                    }
                    clusters[0] = sigGenesArray;
                    clusters[1] = nonSigGenesArray;
                }
                this.algData.addParam("estimated-fdr", String.valueOf(adjPValues[clusters[0].length - 1]));
            } else {
                int i;
                this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Processing Results"));
                Vector<Integer> sigGenes = new Vector<Integer>();
                Vector<Integer> nonSigGenes = new Vector<Integer>();
                float alpha = this.algData.getParams().getFloat("alpha");
                int numResultCols = resultValues.getColumnDimension();
                for (i = 0; i < numRows; ++i) {
                    if (resultValues.A[i][numResultCols - 1] <= alpha) {
                        sigGenes.add(new Integer(i));
                        continue;
                    }
                    nonSigGenes.add(new Integer(i));
                }
                int[] sigGenesArray = new int[sigGenes.size()];
                nonSigGenesArray = new int[nonSigGenes.size()];
                for (i = 0; i < sigGenesArray.length; ++i) {
                    sigGenesArray[i] = (Integer)sigGenes.get(i);
                }
                for (i = 0; i < nonSigGenesArray.length; ++i) {
                    nonSigGenesArray[i] = (Integer)nonSigGenes.get(i);
                }
                clusters[0] = sigGenesArray;
                clusters[1] = nonSigGenesArray;
            }
            FloatMatrix clusterMeans = this.getMeans(m, clusters);
            FloatMatrix clusterVars = this.getVariances(m, clusterMeans, clusters);
            this.algData.addMatrix("result-matrix", resultValues);
            this.algData.addStringArray("method-array", method);
            this.algData.addIntMatrix("clusters", (int[][])clusters);
            this.algData.addMatrix("cluster-means", clusterMeans);
            this.algData.addMatrix("cluster-variances", clusterVars);
            this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 110, "Processing Results"));
            if (this.algData.getParams().getBoolean("hcl-execution")) {
                int linkageMethod = this.algData.getParams().getInt("method-linkage");
                int metric = this.algData.getParams().getInt("hcl-distance-function");
                boolean genes = this.algData.getParams().getBoolean("calculate-genes");
                boolean experiments = this.algData.getParams().getBoolean("calculate-samples");
                boolean absoluteDistance = this.algData.getParams().getBoolean("hcl-distance-absolute");
                this.fireValueChanged(new AlgorithmEvent((Object)this, 2, 100, "Constructing Hierarchical Trees"));
                NodeValueList nodeValueList = this.calculateHierarchicalTree(m, clusters[0], linkageMethod, metric, absoluteDistance, genes, experiments);
                Node node = new Node(clusters[0]);
                node.setValues(nodeValueList);
                NodeList nodeList = new NodeList();
                nodeList.addNode(node);
                Cluster hclCluster = new Cluster();
                hclCluster.setNodeList(nodeList);
                this.algData.addCluster("hcl-clusters", hclCluster);
            }
        }
        catch (RSrvException e) {
            e.printStackTrace();
        }
        rc.close();
    }

    private double[] getDataChunk(FloatMatrix m, int start, int end) {
        if (m.getRowDimension() - 1 < end) {
            end = m.getRowDimension() - 1;
        }
        double[] vals = new double[(end - start + 1) * m.getColumnDimension()];
        int nCol = m.getColumnDimension();
        int index = 0;
        for (int row = start; row <= end; ++row) {
            for (int col = 0; col < nCol; ++col) {
                vals[index] = m.A[row][col];
                ++index;
            }
        }
        return vals;
    }

    private String getIsFlatFunction() {
        String function = "isFlat<-function(v) {for(i in 1:(length(v)-1)) {\n if( (v[i]!= v[i+1]) ) { \n return(FALSE); }} \n return(TRUE);}";
        return function;
    }

    private String getKruscalFunction() {
        String function = "kruskalFunction<-function(){\noptions(warn=-1);\nnumRows<-nrow(m); numCols<-ncol(m); result<-list();\nfor(row in 1:numRows) {\nresult[[row]]<-kruskal.test(m[row, ], groups);\n}\nreturn(result);\n}";
        return function;
    }

    private String getWilcoxFunction() {
        String function = "wilcoxFunction<-function(){options(warn=-1);numRows<-nrow(m); numCols<-ncol(m); result<-list();is_not_flat = TRUE;nMatrix = matrix(nrow=numRows,ncol=2);for(row in 1:numRows) {\nv1=vector(\"numeric\");v2=vector(\"numeric\");v1Index = 1; v2Index = 1;\nfor(col in 1:numCols) \n {if(groups[col] == 0) { v1[v1Index] = m[row, col]; v1Index=v1Index+1; }else if(groups[col]==1) { \n v2[v2Index]=m[row,col]; \n v2Index=v2Index+1;}}\nis_not_flat = !(isFlat(v1) || isFlat(v2));\nresult[[row]]<-try(wilcox.test(v1,v2,conf.int=is_not_flat));\nif(class(result[[row]]) == \"try-error\") {result[[row]]<-try(wilcox.test(v1,v2,conf.int=FALSE));}\nnMatrix[row,1] = as.double(length(v1)); nMatrix[row,2] = as.double(length(v2));}\nresult[[numRows+1]] = data.matrix(nMatrix);return(result);\n}";
        return function;
    }

    private double[] pullGroupValues(float[] dataVals, int[] groupAssignments, int groupNum) {
        Vector<Double> valueV = new Vector<Double>();
        for (int i = 0; i < dataVals.length; ++i) {
            if (Float.isNaN(dataVals[i]) || groupAssignments[i] != groupNum) continue;
            valueV.add(new Double(dataVals[i]));
        }
        double[] vals = new double[valueV.size()];
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = (Double)valueV.get(i);
        }
        return vals;
    }

    public static void main(String[] args) {
        Nonpar nonpar = new Nonpar();
        AlgorithmData ad = new AlgorithmData();
        float[] data = new float[]{0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f};
        float[] data2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        int[] groups = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 1};
        ad.addIntArray("group-assignments", groups);
        ad.addParam("fisher-exact-bin-cutoff", String.valueOf(0.5f));
        nonpar.setAlgData(ad);
        FloatMatrix matrix = new FloatMatrix(2, 10);
        matrix.A[0] = data;
        matrix.A[1] = data2;
        try {
            nonpar.executeFisherExactTest(matrix);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setAlgData(AlgorithmData d) {
        this.algData = d;
    }

    public class NonparTwoWayData {
        private boolean isComplete = true;
        private boolean isBalanced = true;
        private boolean isFlat = true;
        private float[] values;
        private int[] factorAGrouping;
        private int[] factorBGrouping;
        private int[][] repTotals;
        private int nVals;

        public NonparTwoWayData(float[] rawValues, int numFactorALevels, int numFactorBLevels, int[] rawFactorAGrouping, int[] rawFactorBGrouping) {
            int i;
            this.repTotals = new int[numFactorALevels][numFactorBLevels];
            this.isFlat = true;
            Vector<Float> valueVector = new Vector<Float>();
            Vector<Integer> factorAVector = new Vector<Integer>();
            Vector<Integer> factorBVector = new Vector<Integer>();
            for (i = 0; i < rawValues.length; ++i) {
                if (Float.isNaN(rawValues[i]) || rawFactorAGrouping[i] == -1 || rawFactorBGrouping[i] == -1) continue;
                Float value = new Float(rawValues[i]);
                if (!this.isFlat || valueVector.size() <= 0 || !valueVector.contains(value)) {
                    // empty if block
                }
                this.isFlat = false;
                valueVector.add(new Float(rawValues[i]));
                factorAVector.add(new Integer(rawFactorAGrouping[i]));
                factorBVector.add(new Integer(rawFactorBGrouping[i]));
            }
            this.nVals = valueVector.size();
            this.values = new float[this.nVals];
            this.factorAGrouping = new int[this.nVals];
            this.factorBGrouping = new int[this.nVals];
            for (i = 0; i < this.nVals; ++i) {
                this.values[i] = ((Float)valueVector.get(i)).floatValue();
                this.factorAGrouping[i] = (Integer)factorAVector.get(i);
                this.factorBGrouping[i] = (Integer)factorBVector.get(i);
                int[] nArray = this.repTotals[this.factorAGrouping[i]];
                int n = this.factorBGrouping[i];
                nArray[n] = nArray[n] + 1;
            }
            int checkValue = this.repTotals[0][0];
            block2: for (int i2 = 0; i2 < this.repTotals.length; ++i2) {
                for (int j = 0; j < this.repTotals[i2].length; ++j) {
                    if (this.repTotals[i2][j] == 0) {
                        this.isBalanced = false;
                        this.isComplete = false;
                        continue block2;
                    }
                    if (this.repTotals[i2][j] == checkValue) continue;
                    this.isBalanced = false;
                }
            }
        }

        public void transposeRepTots() {
            int[][] newRepTots = new int[this.repTotals[0].length][this.repTotals.length];
            for (int i = 0; i < this.repTotals.length; ++i) {
                for (int j = 0; j < this.repTotals[i].length; ++j) {
                    newRepTots[j][i] = this.repTotals[i][j];
                }
            }
            this.repTotals = newRepTots;
        }
    }

    public class NonparOneWayData {
        private boolean isFlat = true;
        private boolean areGroupsNull = false;
        private float[] values;
        private int[] groups;
        private int[] nPerGroup;
        private int numGroups;

        private NonparOneWayData(float[] rawValues, int[] initGroupings, int nGroups) {
            int i;
            this.numGroups = nGroups;
            Vector<Float> valueVector = new Vector<Float>();
            Vector<Integer> groupVector = new Vector<Integer>();
            for (i = 0; i < rawValues.length; ++i) {
                if (Float.isNaN(rawValues[i]) || initGroupings[i] == -1) continue;
                valueVector.add(new Float(rawValues[i]));
                groupVector.add(new Integer(initGroupings[i]));
            }
            this.values = new float[valueVector.size()];
            this.groups = new int[groupVector.size()];
            for (i = 0; i < this.values.length; ++i) {
                this.values[i] = ((Float)valueVector.get(i)).floatValue();
                this.groups[i] = (Integer)groupVector.get(i);
            }
            this.isFlat = Nonpar.this.isFlat(this.values);
            this.nPerGroup = Nonpar.this.getGroupCounts(this.groups, this.numGroups);
            for (i = 0; i < this.nPerGroup.length; ++i) {
                if (this.nPerGroup[i] != 0) continue;
                this.areGroupsNull = true;
                break;
            }
        }

        public float[] getValues() {
            return this.values;
        }

        public int[] getGroups() {
            return this.groups;
        }

        public int getNumGroups() {
            return this.numGroups;
        }

        public boolean getAreGroupsNull() {
            return this.areGroupsNull;
        }

        public boolean getIsFlat() {
            return this.isFlat;
        }

        public int[] getGroupNs() {
            return this.nPerGroup;
        }
    }
}

