/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GSEAUtils;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneSetElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.Geneset;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneSetElement;
import org.tigr.microarray.mev.cluster.gui.impl.util.MatrixFunctions;
import org.tigr.microarray.mev.file.StringSplitter;
import org.tigr.util.FloatMatrix;

public class ReadGeneSet {
    private Geneset[] set = null;
    private String[][] excludedGenes;
    private Vector<String> excluded_geneSets = new Vector();
    private int minNumOfGenes;
    private GeneSetElement gsElement;
    private String filePath;
    private String fileExtension;

    public ReadGeneSet(String extension, String fPath) {
        this.filePath = fPath;
        this.fileExtension = extension;
    }

    public Geneset[] read_GMXfile(String filePath) throws Exception {
        String temp;
        ArrayList<Geneset> genesetList = new ArrayList<Geneset>();
        int curpos = 0;
        int index = 0;
        StringSplitter split = new StringSplitter('\t');
        BufferedReader bread = new BufferedReader(new FileReader(new File(filePath)));
        String currentLine = bread.readLine();
        currentLine = currentLine.trim();
        split.init(currentLine);
        while (split.hasMoreTokens()) {
            temp = split.nextToken();
            if (temp == null || temp.equalsIgnoreCase("null") || temp.equalsIgnoreCase("") || temp.equalsIgnoreCase("na")) continue;
            Geneset gset = new Geneset();
            gset.setGeneSetName(temp);
            genesetList.add(index, gset);
            ++index;
        }
        this.set = new Geneset[genesetList.size()];
        this.set = genesetList.toArray(this.set);
        bread.readLine();
        while ((currentLine = bread.readLine()) != null) {
            split.init(currentLine);
            for (index = 0; index < this.set.length; ++index) {
                temp = split.nextToken().trim();
                this.gsElement = new GeneSetElement(String.valueOf(curpos), temp);
                this.set[index].setGeneSetElement(this.gsElement, curpos);
            }
            ++curpos;
        }
        bread.close();
        return this.set;
    }

    public Geneset[] read_GMTfile(String filePath) throws Exception {
        String currentLine;
        ArrayList<Geneset> genesetList = new ArrayList<Geneset>();
        BufferedReader bread = new BufferedReader(new FileReader(new File(filePath)));
        int index = 0;
        StringSplitter split = new StringSplitter('\t');
        while ((currentLine = bread.readLine()) != null && currentLine.trim().length() != 0) {
            Geneset gset = new Geneset();
            split.init(currentLine);
            String geneSetName = split.nextToken().trim();
            gset.setGeneSetName(geneSetName);
            split.nextToken();
            int curpos = 0;
            while (split.hasMoreTokens()) {
                String temp = split.nextToken().trim();
                if (temp == null || temp.equalsIgnoreCase("null") || temp.equalsIgnoreCase("") || temp.equalsIgnoreCase("na")) continue;
                this.gsElement = new GeneSetElement(String.valueOf(curpos), temp);
                gset.setGeneSetElement(this.gsElement, curpos);
                ++curpos;
            }
            genesetList.add(index, gset);
            ++index;
        }
        bread.close();
        this.set = new Geneset[genesetList.size()];
        this.set = genesetList.toArray(this.set);
        return this.set;
    }

    public Geneset[] read_TXTfile(String filePath) throws Exception {
        String currentLine;
        ArrayList<Geneset> genesetList = new ArrayList<Geneset>();
        BufferedReader bread = new BufferedReader(new FileReader(new File(filePath)));
        int index = 0;
        StringSplitter split = new StringSplitter('\t');
        while ((currentLine = bread.readLine()) != null && currentLine.trim().length() != 0) {
            Geneset gset = new Geneset();
            split.init(currentLine);
            String geneSetName = split.nextToken().trim();
            gset.setGeneSetName(geneSetName);
            split.nextToken();
            int curpos = 0;
            while (split.hasMoreTokens()) {
                String temp = split.nextToken().trim();
                if (temp == null || temp.equalsIgnoreCase("null") || temp.equalsIgnoreCase("") || temp.equalsIgnoreCase("na")) continue;
                this.gsElement = new GeneSetElement(String.valueOf(curpos), temp);
                gset.setGeneSetElement(this.gsElement, curpos);
                ++curpos;
            }
            genesetList.add(index, gset);
            ++index;
        }
        bread.close();
        this.set = new Geneset[genesetList.size()];
        this.set = genesetList.toArray(this.set);
        return this.set;
    }

    public Geneset[] readMultipleFiles(String[] fileList, String dirPath) throws Exception {
        Geneset[] gSet;
        HashMap<String, Geneset> geneSetList = new HashMap<String, Geneset>();
        boolean num_genesets = false;
        for (int index = 0; index < fileList.length; ++index) {
            String fileExtension = this.checkFileNameExtension(fileList[index]);
            String filePath = dirPath + "/" + fileList[index];
            gSet = fileExtension.equalsIgnoreCase("gmt") ? this.read_GMTfile(filePath) : (fileExtension.equalsIgnoreCase("gmx") ? this.read_GMXfile(filePath) : this.read_TXTfile(filePath));
            for (int i = 0; i < gSet.length; ++i) {
                if (geneSetList.containsKey(gSet[i].getGeneSetName())) continue;
                geneSetList.put(gSet[i].getGeneSetName(), gSet[i]);
            }
        }
        gSet = new Geneset[geneSetList.size()];
        Iterator it = geneSetList.keySet().iterator();
        int index = 0;
        while (it.hasNext()) {
            gSet[index] = (Geneset)geneSetList.get(it.next());
            ++index;
        }
        return gSet;
    }

    public int getMaxnumberofGenesinGeneSet(Geneset[] gset) {
        int max = 0;
        for (int i = 0; i < gset.length; ++i) {
            int length = gset[i].getGenesinGeneset().size();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    public int getCountOfLines(File file) throws IOException {
        String currentLine;
        int count = 0;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((currentLine = reader.readLine()) != null) {
            ++count;
        }
        reader.close();
        return count;
    }

    public Geneset[] removeGenesNotinExpressionData(Geneset[] gset, Vector genesInExpressionData) {
        Geneset[] newGeneSet = new Geneset[gset.length];
        for (int setIndex = 0; setIndex < gset.length; ++setIndex) {
            String gsetName = gset[setIndex].getGeneSetName();
            newGeneSet[setIndex] = new Geneset();
            newGeneSet[setIndex].setGeneSetName(gsetName);
            if (gset[setIndex].getGenesetElements() == null || gsetName.equalsIgnoreCase("na") || gsetName.equalsIgnoreCase("null") || gsetName.length() < 1) {
                IGeneSetElement gsElement = null;
                newGeneSet[setIndex].setGeneSetElement(gsElement, 0);
            } else {
                ArrayList<IGeneSetElement> temp = gset[setIndex].getGenesetElements();
                int geneindex = 0;
                for (int j = 0; j < temp.size(); ++j) {
                    String gene = ((GeneSetElement)temp.get(j)).getGene();
                    if (!genesInExpressionData.contains(gene) || gene.equalsIgnoreCase("na")) continue;
                    GeneSetElement gsElement = new GeneSetElement(String.valueOf(geneindex), gene);
                    newGeneSet[setIndex].setGeneSetElement(gsElement, geneindex);
                    ++geneindex;
                }
                temp.clear();
            }
            if (newGeneSet[setIndex].getGenesetElements().size() >= this.getMinNumOfGenes()) continue;
            this.getExcludedGeneSets().add(gsetName);
        }
        return newGeneSet;
    }

    public Geneset[] removeGenesetsWithoutMinimumGenes(Vector excludedgeneSets, Geneset[] oldGenesets) {
        Geneset[] newGenesets = new Geneset[oldGenesets.length - excludedgeneSets.size()];
        Vector<String> geneSetNames = new Vector<String>();
        int newIndex = 0;
        for (int oldIndex = 0; oldIndex < oldGenesets.length; ++oldIndex) {
            String gsetName = oldGenesets[oldIndex].getGeneSetName();
            if (excludedgeneSets.contains(gsetName)) continue;
            geneSetNames.add(newIndex, gsetName);
            ArrayList<IGeneSetElement> temp = oldGenesets[oldIndex].getGenesetElements();
            newGenesets[newIndex] = new Geneset();
            boolean geneindex = false;
            for (int j = 0; j < temp.size(); ++j) {
                String gene = ((GeneSetElement)temp.get(j)).getGene();
                GeneSetElement gsElement = new GeneSetElement(String.valueOf(j), gene);
                newGenesets[newIndex].setGeneSetName(gsetName);
                newGenesets[newIndex].setGeneSetElement(gsElement, j);
            }
            temp.clear();
            ++newIndex;
        }
        if (geneSetNames.isEmpty()) {
            String eMsg = "<html>All the gene sets fail to pass the minimum genes cutoff. <br><html>You can try lowering the cutoff and running the analysis. </html>";
            JOptionPane.showMessageDialog(null, eMsg, "Error", 0);
        }
        return newGenesets;
    }

    public FloatMatrix createAssociationMatrix(Geneset[] gSets, Vector unique_genes_in_dataset, int min_genes) {
        int index;
        int rowSize = new GSEAUtils().getGeneSetNames(gSets).size();
        int colSize = unique_genes_in_dataset.size();
        FloatMatrix _tempMatrix = new FloatMatrix(rowSize, colSize);
        FloatMatrix aMatrix = null;
        Vector<String> _tempgeneset = new Vector<String>();
        boolean colIndex = false;
        for (int rowIndex = 0; rowIndex < rowSize; ++rowIndex) {
            if (gSets[rowIndex].getGenesinGeneset().size() < 1) {
                for (int j = 0; j < colSize; ++j) {
                    _tempMatrix.set(rowIndex, j, 0.0f);
                }
                continue;
            }
            ArrayList<Object> _genesinGeneset = new ArrayList();
            _genesinGeneset = gSets[rowIndex].getGenesinGeneset();
            for (int j = 0; j < _genesinGeneset.size(); ++j) {
                String Gene = (String)_genesinGeneset.get(j);
                Gene = Gene.trim();
                for (int k = 0; k < colSize; ++k) {
                    String uniq_genes = (String)unique_genes_in_dataset.get(k);
                    if (!(uniq_genes = uniq_genes.trim()).equals(Gene)) continue;
                    _tempMatrix.set(rowIndex, k, 1.0f);
                }
            }
        }
        MatrixFunctions matrixFunc = new MatrixFunctions();
        Vector rowSums = matrixFunc.getRowSums(_tempMatrix);
        int geneSetIndex = 0;
        for (index = 0; index < rowSums.size(); ++index) {
            if (!(((Float)rowSums.get(index)).floatValue() < (float)min_genes)) continue;
            _tempgeneset.add(gSets[index].getGeneSetName());
        }
        if (_tempgeneset.size() == rowSize) {
            String eMsg = "<html> Genes in the supplied gene set do not match any genes in the expression data. <br><html> 1. Please check and make sure that expression data and gene set contain genes from the <br><html>same organism. 2. Please make sure that the gene set you use has atleast some of the genes present in your data set </br></html>";
            JOptionPane.showMessageDialog(new JFrame(), eMsg, "Error", 0);
        }
        aMatrix = new FloatMatrix(rowSize - _tempgeneset.size(), colSize);
        for (index = 0; index < rowSums.size(); ++index) {
            if (!(((Float)rowSums.get(index)).floatValue() >= (float)min_genes)) continue;
            aMatrix.setMatrix(geneSetIndex, geneSetIndex, 0, colSize - 1, _tempMatrix.getMatrix(index, index, 0, colSize - 1));
            ++geneSetIndex;
        }
        _tempMatrix = null;
        this.setExcludedGeneSets(_tempgeneset);
        return aMatrix;
    }

    public void setExcludedGeneSets(Vector<String> genesets) {
        this.excluded_geneSets = genesets;
    }

    public Vector<String> getExcludedGeneSets() {
        return this.excluded_geneSets;
    }

    public String[][] getExcludedGenesfromGeneset() {
        return this.excludedGenes;
    }

    public String checkFileNameExtension(String fileName) {
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
        return extension;
    }

    public int getMinNumOfGenes() {
        return this.minNumOfGenes;
    }

    public void setMinNumOfGenes(int minNumOfGenes) {
        this.minNumOfGenes = minNumOfGenes;
    }

    public static void main(String[] str) {
    }
}

