/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import java.util.Vector;
import org.tigr.util.FloatMatrix;

public class ProcessGroupAssignments {
    protected FloatMatrix factor_matrix;
    protected Vector excludedColumns = new Vector();
    protected int nSamples;
    protected boolean removeNA;
    private int[][] fAssignments = null;

    public ProcessGroupAssignments(String[] factorNames, int[] factorLevels, int[][] factorAssignments, boolean removeNA, int num_samples) {
        this.fAssignments = factorAssignments;
        this.removeNA = removeNA;
        this.nSamples = num_samples;
    }

    public void findUnassignedSamples(String[] factorNames, int[] factorLevels, int[][] factorAssignments) {
        this.fAssignments = factorAssignments;
        for (int num_factors = 0; num_factors < factorNames.length; ++num_factors) {
            int[] tempAssignments = this.fAssignments[num_factors];
            for (int col = 0; col < tempAssignments.length; ++col) {
                if (tempAssignments[col] != 0 || this.excludedColumns.contains(col)) continue;
                this.excludedColumns.add(col);
            }
        }
    }

    public Vector getUnassignedColumns() {
        return this.excludedColumns;
    }

    public int calculateFactorMatrixColumns(String[] names, int[] levels) {
        int cols = 0;
        for (int i = 0; i < names.length; ++i) {
            int temp = levels[i] - 1;
            cols += temp;
        }
        return ++cols;
    }

    public FloatMatrix generateFactorMatrix(String[] factorNames, int[] factorLevels, int[][] factorAssignments) {
        int i;
        int cols = this.calculateFactorMatrixColumns(factorNames, factorLevels);
        int matColStart = 1;
        int matColEnd = 1;
        int unassigned = this.getUnassignedColumns().size();
        this.factor_matrix = new FloatMatrix(this.nSamples - unassigned, cols);
        for (i = 0; i < this.factor_matrix.getRowDimension(); ++i) {
            this.factor_matrix.set(i, 0, 1.0f);
        }
        for (i = 0; i < factorNames.length; ++i) {
            int tempcolStart = 0;
            int tempRowStart = 0;
            int[] rowVector = factorAssignments[i];
            int current_factor_level = factorLevels[i];
            FloatMatrix tempMatrix = new FloatMatrix(this.factor_matrix.getRowDimension(), current_factor_level - 1);
            for (int factorlevel = 2; factorlevel <= current_factor_level; ++factorlevel) {
                int samples = 0;
                while (samples < this.nSamples - 1) {
                    if (this.excludedColumns.contains(samples)) {
                        ++samples;
                        continue;
                    }
                    if (rowVector[samples] == factorlevel) {
                        tempMatrix.set(tempRowStart, tempcolStart, 1.0f);
                        ++tempRowStart;
                    } else {
                        ++tempRowStart;
                    }
                    if (samples >= this.nSamples - 1) continue;
                    ++samples;
                }
                if (tempcolStart < current_factor_level) {
                    ++tempcolStart;
                }
                tempRowStart = 0;
            }
            matColEnd = matColStart + (current_factor_level - 1) - 1;
            this.factor_matrix.setMatrix(0, this.factor_matrix.getRowDimension() - 1, matColStart, matColEnd, tempMatrix);
            matColEnd = matColStart = matColEnd + 1;
        }
        return this.factor_matrix;
    }
}

