/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import JSci.maths.ArrayMath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.tigr.microarray.mev.ISlideDataElement;
import org.tigr.microarray.mev.annotation.MevAnnotation;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.FloatGeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.FloatGeneDataElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneDataElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneData;
import org.tigr.microarray.mev.cluster.gui.GSEAExperiment;
import org.tigr.microarray.mev.cluster.gui.IData;
import org.tigr.microarray.mev.cluster.gui.impl.gsea.GSEAConstants;
import org.tigr.util.FloatMatrix;

public class ProbetoGene {
    private AlgorithmData aData;
    private IData data;
    private Vector<String> unique_genes_in_data = new Vector();
    private FloatMatrix geneDataMatrix;
    private GSEAExperiment gseaExperiment;
    private int[] columns;
    private FloatMatrix experiment_matrix;
    private GeneDataElement gde;
    private FloatGeneDataElement fgde;
    private IGeneData[] gene_data;

    public ProbetoGene(AlgorithmData algData, IData idata) {
        this.aData = algData;
        this.data = idata;
        this.experiment_matrix = this.aData.getMatrix("matrix");
    }

    public IGeneData[] convertProbeToGene(String geneIdentifier, String conversionCriteria, String SDcutoff) {
        int arrayRows = this.data.getFeaturesSize();
        int cols = this.data.getFeaturesCount();
        IGeneData[] gdata = new IGeneData[cols];
        int count = 0;
        for (int index = 0; index < arrayRows; ++index) {
            ISlideDataElement isde = this.data.getFeature(0).getSlideDataElement(index);
            MevAnnotation ann = (MevAnnotation)isde.getElementAnnotation();
            String[] temp = ann.getAttribute(geneIdentifier);
            String currentID = temp[0];
            if (this.unique_genes_in_data.contains(currentID) || currentID.equalsIgnoreCase("NA")) continue;
            this.unique_genes_in_data.add(count, currentID);
            ++count;
        }
        this.setUniqueGenesinDataset(this.unique_genes_in_data);
        int geneRows = this.unique_genes_in_data.size();
        this.geneDataMatrix = new FloatMatrix(geneRows, cols);
        for (int i = 0; i < cols; ++i) {
            if (i == 0) {
                gdata[0] = new GeneData();
            } else {
                gdata[i] = new FloatGeneData();
            }
            String slideName = this.data.getFeature(i).getSlideDataName();
            gdata[i].setSlideName(slideName);
            for (int index = 0; index < this.unique_genes_in_data.size(); ++index) {
                String requiredID = this.unique_genes_in_data.get(index);
                if (i == 0) {
                    this.gde = new GeneDataElement(index, requiredID);
                    gdata[i].setGeneDataElement(this.gde, index);
                    continue;
                }
                this.fgde = new FloatGeneDataElement(index, requiredID);
                gdata[i].setGeneDataElement(this.fgde, index);
            }
        }
        for (int index = 0; index < arrayRows; ++index) {
            ISlideDataElement isde = this.data.getFeature(0).getSlideDataElement(index);
            MevAnnotation ann = (MevAnnotation)isde.getElementAnnotation();
            boolean found = false;
            String currentID = ann.getAttribute(geneIdentifier)[0];
            String probeID = ann.getCloneID();
            count = 0;
            while (count < geneRows && !found) {
                String requiredID = this.unique_genes_in_data.get(count);
                if (currentID.equalsIgnoreCase(requiredID)) {
                    this.gde = (GeneDataElement)gdata[0].getGeneDataElement(count);
                    if (!this.gde.getProbeID().contains(probeID)) {
                        this.gde.setProbeID(probeID);
                        this.gde.setProbePosition(index);
                    }
                    found = true;
                    if (this.gde.getProbeID().size() <= ((GeneData)gdata[0]).get_max_num_probes_mapping_to_gene()) continue;
                    ((GeneData)gdata[0]).set_max_num_probes_mapping_to_gene(this.gde.getProbeID().size());
                    continue;
                }
                ++count;
            }
        }
        if (conversionCriteria.equalsIgnoreCase(GSEAConstants.SD)) {
            this.gene_data = this.remove_lowVar_probes(gdata, SDcutoff);
        } else {
            for (int j = 0; j < geneRows; ++j) {
                int num_probes = gdata[0].getGeneDataElement(j).getProbeID().size();
                ArrayList probePos = gdata[0].getGeneDataElement(j).getProbePosition();
                for (count = 0; count < cols; ++count) {
                    if (num_probes == 1) {
                        int probe_pos = Integer.parseInt(probePos.get(0).toString());
                        gdata[count].getGeneDataElement(j).setCurrentIntensity(this.experiment_matrix.get(probe_pos, count));
                        gdata[count].getGeneDataElement(j).setTrueIntensity(this.experiment_matrix.get(probe_pos, count));
                        this.geneDataMatrix.set(j, count, this.experiment_matrix.get(probe_pos, count));
                        continue;
                    }
                    for (int k = 0; k < num_probes; ++k) {
                        int probe_pos = Integer.parseInt(probePos.get(k).toString());
                        gdata[count].getGeneDataElement(j).setTrueIntensity(this.experiment_matrix.get(probe_pos, count));
                    }
                    ArrayList intensity = gdata[count].getGeneDataElement(j).getTrueIntensity();
                    if (conversionCriteria.equalsIgnoreCase(GSEAConstants.MAX_PROBE)) {
                        float max_probe = this.getMaxProbe(intensity);
                        gdata[count].getGeneDataElement(j).setCurrentIntensity(max_probe);
                        this.geneDataMatrix.set(j, count, max_probe);
                        intensity = new ArrayList();
                    }
                    if (!conversionCriteria.equalsIgnoreCase(GSEAConstants.MEDIAN_PROBE)) continue;
                    float med_probe = this.getMedianProbe(intensity);
                    gdata[count].getGeneDataElement(j).setCurrentIntensity(med_probe);
                    this.geneDataMatrix.set(j, count, med_probe);
                    intensity = new ArrayList();
                }
            }
            this.gene_data = gdata;
        }
        this.gseaExperiment = new GSEAExperiment(this.geneDataMatrix, this.createColumns(this.data.getFeaturesCount()));
        this.aData.addGeneMatrix("gene-data-matrix", this.geneDataMatrix);
        this.aData.addVector("Unique-Genes-in-Expressionset", this.unique_genes_in_data);
        return this.gene_data;
    }

    public GSEAExperiment returnGSEAExperiment() {
        return this.gseaExperiment;
    }

    public IGeneData[] remove_lowVar_probes(IGeneData[] gdata, String SDcutoff) {
        Vector<String> genes = new Vector<String>();
        Vector<Integer> probes_passing_cutoff = new Vector<Integer>();
        int num_genes_passing_cutoff = 0;
        Vector<String> genes_with_low_variability = new Vector<String>();
        int cols = this.data.getFeaturesCount();
        for (int index = 0; index < this.unique_genes_in_data.size(); ++index) {
            int max_probeSD_pos = -1;
            double max_sd = 0.0;
            double current_sd = 0.0;
            double[] matrixVals = new double[cols];
            int num_probes = gdata[0].getGeneDataElement(index).getProbeID().size();
            ArrayList probePos = gdata[0].getGeneDataElement(index).getProbePosition();
            String Gene = gdata[0].getGeneDataElement(index).getGeneIdentifier();
            int probe_pos = 0;
            if (num_probes == 1) {
                probe_pos = Integer.parseInt(probePos.get(0).toString());
                for (int col = 0; col < cols; ++col) {
                    matrixVals[col] = this.experiment_matrix.get(probe_pos, col);
                }
                current_sd = ArrayMath.standardDeviation((double[])matrixVals);
                if (current_sd >= Double.parseDouble(SDcutoff)) {
                    probes_passing_cutoff.add(num_genes_passing_cutoff, probe_pos);
                    genes.add(num_genes_passing_cutoff, Gene);
                    ++num_genes_passing_cutoff;
                    continue;
                }
                genes_with_low_variability.add(Gene);
                continue;
            }
            for (int k = 0; k < num_probes; ++k) {
                probe_pos = Integer.parseInt(probePos.get(k).toString());
                for (int val = 0; val < cols; ++val) {
                    matrixVals[val] = this.experiment_matrix.get(probe_pos, val);
                }
                current_sd = ArrayMath.standardDeviation((double[])matrixVals);
                if (!(current_sd > max_sd) || !(current_sd >= Double.parseDouble(SDcutoff))) continue;
                max_sd = current_sd;
                max_probeSD_pos = probe_pos;
            }
            if (max_probeSD_pos != -1) {
                genes.add(num_genes_passing_cutoff, Gene);
                probes_passing_cutoff.add(num_genes_passing_cutoff, max_probeSD_pos);
                ++num_genes_passing_cutoff;
                continue;
            }
            genes_with_low_variability.add(Gene);
        }
        IGeneData[] gene_data = new IGeneData[cols];
        int geneRows = genes.size();
        FloatMatrix geneDataMatrix = new FloatMatrix(geneRows, cols);
        for (int i = 0; i < cols; ++i) {
            gene_data[i] = i == 0 ? new GeneData() : new FloatGeneData();
            String slideName = this.data.getFeature(i).getSlideDataName();
            String slideFile = this.data.getFeature(i).getSlideFileName();
            gene_data[i].setSlideName(slideName);
            for (int index = 0; index < geneRows; ++index) {
                String Gene = (String)genes.get(index);
                if (i == 0) {
                    this.gde = new GeneDataElement(index, Gene);
                    gene_data[i].setGeneDataElement(this.gde, index);
                    continue;
                }
                this.fgde = new FloatGeneDataElement(index, Gene);
                gene_data[i].setGeneDataElement(this.gde, index);
            }
        }
        for (int row = 0; row < geneRows; ++row) {
            String Gene = (String)genes.get(row);
            int gIndex = this.unique_genes_in_data.indexOf(Gene);
            int maxProbePos = (Integer)probes_passing_cutoff.elementAt(row);
            ArrayList<String> probe_id = gdata[0].getGeneDataElement(gIndex).getProbeID();
            ArrayList probe_pos = gdata[0].getGeneDataElement(gIndex).getProbePosition();
            for (int index = 0; index < probe_id.size(); ++index) {
                String pid = probe_id.get(index);
                int probepos = Integer.parseInt(probe_pos.get(index).toString());
                gene_data[0].getGeneDataElement(row).setProbeID(pid);
                gene_data[0].getGeneDataElement(row).setProbePosition(probepos);
            }
            for (int col = 0; col < this.data.getFeaturesCount(); ++col) {
                ArrayList trueIntensity = gdata[col].getGeneDataElement(gIndex).getTrueIntensity();
                for (int j = 0; j < trueIntensity.size(); ++j) {
                    gene_data[col].getGeneDataElement(row).setTrueIntensity(((Float)trueIntensity.get(j)).floatValue());
                }
                gene_data[col].getGeneDataElement(row).setCurrentIntensity(this.experiment_matrix.get(maxProbePos, col));
                geneDataMatrix.set(row, col, this.experiment_matrix.get(maxProbePos, col));
            }
        }
        this.setGeneDataMatrix(geneDataMatrix);
        this.setUniqueGenesinDataset(genes);
        return gene_data;
    }

    public float getMaxProbe(ArrayList intensity) {
        float max = ((Float)intensity.get(0)).floatValue();
        if (intensity.size() == 1) {
            return max;
        }
        for (int i = 1; i < intensity.size(); ++i) {
            float current = ((Float)intensity.get(i)).floatValue();
            max = Math.max(max, current);
        }
        return max;
    }

    public float getMedianProbe(ArrayList intensity) {
        ArrayList<Float> temp = new ArrayList<Float>();
        for (int i = 0; i < intensity.size(); ++i) {
            if (((Float)intensity.get(i)).isNaN()) continue;
            temp.add((Float)intensity.get(i));
        }
        float[] vals = new float[temp.size()];
        for (int i = 0; i < temp.size(); ++i) {
            vals[i] = ((Float)temp.get(i)).floatValue();
        }
        Arrays.sort(vals);
        float median = 0.0f;
        int count = vals.length;
        if (count % 2 == 0) {
            median = (vals[count / 2 - 1] + vals[count / 2]) / 2.0f;
        }
        if (count % 2 != 0 && count != 1) {
            median = vals[count / 2];
        }
        if (count == 1) {
            median = vals[0];
        }
        return median;
    }

    public void setGeneDataMatrix(FloatMatrix gene_data_mat) {
        this.geneDataMatrix = new FloatMatrix(gene_data_mat.getRowDimension(), gene_data_mat.getColumnDimension());
        this.geneDataMatrix = gene_data_mat;
    }

    public FloatMatrix getGeneDataMatrix() {
        return this.geneDataMatrix;
    }

    public void setUniqueGenesinDataset(Vector genes) {
        this.unique_genes_in_data = new Vector();
        this.unique_genes_in_data = genes;
    }

    public Vector getUniqueGenesinDataset() {
        return this.unique_genes_in_data;
    }

    public int[] createColumns(int count) {
        this.columns = new int[count];
        for (int i = 0; i < count; ++i) {
            this.columns[i] = i;
        }
        return this.columns;
    }
}

