/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import java.util.ArrayList;
import java.util.HashMap;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneSetElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneSet;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneSetElement;
import org.tigr.util.FloatMatrix;

public class Geneset
implements IGeneSet {
    private String geneSetName;
    private ArrayList<IGeneSetElement> geneSetElements;
    private ArrayList<String> genes_in_geneset;
    private HashMap<String, String[]> synExpressionGroups = new HashMap();
    private FloatMatrix synExpressionProfile;
    private HashMap<String, String[]> similarGeneGroups = new HashMap();
    private FloatMatrix averageExpressionProfile;

    public Geneset() {
        this.geneSetElements = new ArrayList();
    }

    @Override
    public String getGSEAConstant() {
        return GSEAConstant;
    }

    @Override
    public void setGSEAConstant(String temp) {
        GSEAConstant.concat(temp);
        GSEAConstant.trim();
    }

    @Override
    public IGeneSetElement getGeneSetElement(int index) {
        return this.geneSetElements.get(index);
    }

    @Override
    public void setGeneSetElement(IGeneSetElement element, int index) {
        this.geneSetElements.add(index, element);
    }

    public ArrayList<IGeneSetElement> getGenesetElements() {
        return this.geneSetElements;
    }

    @Override
    public void setGeneSetName(String name) {
        this.geneSetName = name;
    }

    @Override
    public String getGeneSetName() {
        return this.geneSetName;
    }

    public ArrayList<String> getGenesinGeneset() {
        this.genes_in_geneset = new ArrayList();
        for (int index = 0; index < this.getGenesetElements().size(); ++index) {
            if (!this.genes_in_geneset.contains(((GeneSetElement)this.getGeneSetElement(index)).getGene())) {
                // empty if block
            }
            this.genes_in_geneset.add(index, ((GeneSetElement)this.getGeneSetElement(index)).getGene());
        }
        return this.genes_in_geneset;
    }

    @Override
    public String[] getSynExpressionGroup(String name) {
        return this.synExpressionGroups.get(name);
    }

    @Override
    public FloatMatrix getSynExpressionProfiles() {
        return this.synExpressionProfile;
    }

    @Override
    public void setSynExpressionGroup(String name, String[] groups) {
        if (!this.synExpressionGroups.containsKey(name)) {
            this.synExpressionGroups.put(name, groups);
        }
    }

    @Override
    public void setSynExpressionProfiles(FloatMatrix fm) {
        this.synExpressionProfile = new FloatMatrix(fm.getRowDimension(), fm.getColumnDimension());
        this.synExpressionProfile = fm;
    }

    @Override
    public String[] getSimilarGenes(String synExpressionGroupName) {
        return this.similarGeneGroups.get(synExpressionGroupName);
    }

    @Override
    public FloatMatrix getSimilarGeneExpressionProfile() {
        return this.averageExpressionProfile;
    }

    @Override
    public void setSimilarGeneExpressionProfile(FloatMatrix fm) {
        this.averageExpressionProfile = new FloatMatrix(fm.getRowDimension(), fm.getColumnDimension());
        this.averageExpressionProfile = fm;
    }

    @Override
    public void setSimilarGenes(String name, String[] groups) {
        if (!this.similarGeneGroups.containsKey(name)) {
            this.similarGeneGroups.put(name, groups);
        }
    }
}

