/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import java.util.ArrayList;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneDataElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneDataElement;

public class GeneData
implements IGeneData {
    private ArrayList geneDataElement = new ArrayList();
    private String slideName;
    private int max_num_of_probes_mappingtoGene = 0;

    @Override
    public IGeneDataElement getGeneDataElement(String Gene) {
        for (int i = 0; i < this.geneDataElement.size(); ++i) {
            GeneDataElement gde = (GeneDataElement)this.geneDataElement.get(i);
            if (!gde.getGeneIdentifier().equalsIgnoreCase(Gene)) continue;
            return gde;
        }
        return null;
    }

    @Override
    public IGeneDataElement getGeneDataElement(int index) {
        if (index < this.geneDataElement.size()) {
            return (IGeneDataElement)this.geneDataElement.get(index);
        }
        return null;
    }

    public int getPosition(String Gene) {
        for (int i = 0; i < this.geneDataElement.size(); ++i) {
            GeneDataElement gde = (GeneDataElement)this.geneDataElement.get(i);
            if (!gde.getGeneIdentifier().equalsIgnoreCase(Gene)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getSlideName() {
        return this.slideName;
    }

    @Override
    public void setGeneDataElement(IGeneDataElement gde, int index) {
        if (index <= this.geneDataElement.size()) {
            this.geneDataElement.add(index, gde);
        }
    }

    @Override
    public float getCurrentIntensity(int index) {
        IGeneDataElement gde = this.getGeneDataElement(index);
        return gde.getCurrentIntensity();
    }

    @Override
    public void setCurrentIntensity(float intensity, int index) {
        IGeneDataElement gde = this.getGeneDataElement(index);
        gde.setCurrentIntensity(intensity);
    }

    @Override
    public void setSlideName(String name) {
        this.slideName = name;
    }

    public ArrayList getAllGeneDataElement() {
        return this.geneDataElement;
    }

    public String[][] getProbetoGeneMapping(IGeneData[] gData) {
        int maxprobe = 0;
        String[][] gDataArray = new String[((GeneData)gData[0]).getAllGeneDataElement().size()][];
        for (int gene = 0; gene < ((GeneData)gData[0]).getAllGeneDataElement().size(); ++gene) {
            GeneDataElement gde = (GeneDataElement)gData[0].getGeneDataElement(gene);
            gDataArray[gene] = new String[gde.getProbeID().size() + 1];
            gDataArray[gene][0] = gde.getGeneIdentifier();
            ArrayList pList = gde.getProbeID();
            if (pList.size() > maxprobe) {
                maxprobe = pList.size();
            }
            for (int probes = 0; probes < pList.size(); ++probes) {
                gDataArray[gene][probes + 1] = (String)pList.get(probes);
            }
            pList = null;
        }
        this.set_max_num_probes_mapping_to_gene(maxprobe);
        return gDataArray;
    }

    public void set_max_num_probes_mapping_to_gene(int max) {
        this.max_num_of_probes_mappingtoGene = max;
    }

    public int get_max_num_probes_mapping_to_gene() {
        return this.max_num_of_probes_mappingtoGene;
    }
}

