/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.gsea;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GeneData;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.Geneset;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.IGeneData;
import org.tigr.util.FloatMatrix;

public class GSEAUtils {
    private Vector<String> geneSetNames;
    private ArrayList<String> sorted_gene_names = new ArrayList();
    private HashMap<String, Float> sortedGeneStatistics = new HashMap();
    private LinkedHashMap<String, Float> geneSetWithSize;

    public Vector<String> getGeneSetNames(Geneset[] gset) {
        this.geneSetNames = new Vector();
        for (int index = 0; index < gset.length; ++index) {
            if (this.geneSetNames == null || this.geneSetNames.contains(gset[index].getGeneSetName())) continue;
            this.geneSetNames.add(gset[index].getGeneSetName());
        }
        return this.geneSetNames;
    }

    public Geneset[] getGeneSetSortedBySize(Geneset[] gset) {
        Geneset[] tempSet = new Geneset[gset.length];
        int newGenesetIndex = 0;
        this.geneSetWithSize = new LinkedHashMap();
        for (int index = 0; index < gset.length; ++index) {
            this.geneSetWithSize.put(gset[index].getGeneSetName(), new Float(gset[index].getGenesetElements().size()));
        }
        this.geneSetWithSize = this.sortHashMapByValuesDescending(this.geneSetWithSize);
        for (String name : this.geneSetWithSize.keySet()) {
            int genesetIndex = -1;
            for (int index = 0; index < gset.length; ++index) {
                if (!gset[index].getGeneSetName().equalsIgnoreCase(name)) continue;
                genesetIndex = index;
                break;
            }
            tempSet[newGenesetIndex] = gset[genesetIndex];
            ++newGenesetIndex;
        }
        return tempSet;
    }

    public Geneset[] populateTestStatistic(IGeneData[] gData, Geneset[] geneset, FloatMatrix coef) {
        Geneset[] tempSet = geneset;
        FloatMatrix coef_intermediate = coef.getMatrix(1, 1, 0, coef.getColumnDimension() - 1);
        for (int setIndex = 0; setIndex < tempSet.length; ++setIndex) {
            for (int elementIndex = 0; elementIndex < tempSet[setIndex].getGenesetElements().size(); ++elementIndex) {
                String Gene = tempSet[setIndex].getGeneSetElement(elementIndex).getGene();
                int index = ((GeneData)gData[0]).getPosition(Gene);
                float tstat = coef_intermediate.get(0, index);
                tempSet[setIndex].getGeneSetElement(elementIndex).setTestStat(tstat);
                this.sortedGeneStatistics.put(Gene, Float.valueOf(tstat));
            }
        }
        this.sortedGeneStatistics = this.sortHashMapByValuesDescending(this.sortedGeneStatistics);
        this.setSortedGeneStatistics(this.sortedGeneStatistics);
        return tempSet;
    }

    public HashMap<String, LinkedHashMap<String, Float>> getDescendingSortedTestStats(Geneset[] gset) {
        HashMap<String, LinkedHashMap<String, Float>> sorted = new HashMap<String, LinkedHashMap<String, Float>>();
        for (int setIndex = 0; setIndex < gset.length; ++setIndex) {
            HashMap<String, Float> temp = new HashMap<String, Float>();
            for (int elementIndex = 0; elementIndex < gset[setIndex].getGenesetElements().size(); ++elementIndex) {
                String Gene = gset[setIndex].getGeneSetElement(elementIndex).getGene();
                float tStat = gset[setIndex].getGeneSetElement(elementIndex).getTestStat();
                temp.put(Gene, new Float(tStat));
            }
            sorted.put(gset[setIndex].getGeneSetName(), this.sortHashMapByValuesDescending(temp));
        }
        return sorted;
    }

    public HashMap<String, LinkedHashMap<String, Float>> getSortedTestStats(Geneset[] gset) {
        HashMap<String, LinkedHashMap<String, Float>> sorted = new HashMap<String, LinkedHashMap<String, Float>>();
        boolean index = false;
        for (int setIndex = 0; setIndex < gset.length; ++setIndex) {
            HashMap<String, Float> temp = new HashMap<String, Float>();
            for (int elementIndex = 0; elementIndex < gset[setIndex].getGenesetElements().size(); ++elementIndex) {
                String Gene = gset[setIndex].getGeneSetElement(elementIndex).getGene();
                float tStat = gset[setIndex].getGeneSetElement(elementIndex).getTestStat();
                temp.put(Gene, new Float(tStat));
            }
            LinkedHashMap tempMap = this.sortHashMapByValues(temp);
            sorted.put(gset[setIndex].getGeneSetName(), tempMap);
        }
        return sorted;
    }

    public LinkedHashMap sortHashMapByValues(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues);
        Collections.sort(mapKeys);
        LinkedHashMap<String, Float> sortedMap = new LinkedHashMap<String, Float>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (Float)val);
                continue block0;
            }
        }
        return sortedMap;
    }

    public LinkedHashMap sortHashMapByValuesDescending(HashMap passedMap) {
        ArrayList mapKeys = new ArrayList(passedMap.keySet());
        ArrayList mapValues = new ArrayList(passedMap.values());
        Collections.sort(mapValues, Collections.reverseOrder());
        Collections.sort(mapKeys, Collections.reverseOrder());
        LinkedHashMap<String, Float> sortedMap = new LinkedHashMap<String, Float>();
        block0: for (Object val : mapValues) {
            for (Object key : mapKeys) {
                String comp2;
                String comp1 = passedMap.get(key).toString();
                if (!comp1.equals(comp2 = val.toString())) continue;
                passedMap.remove(key);
                mapKeys.remove(key);
                sortedMap.put((String)key, (Float)val);
                continue block0;
            }
        }
        return sortedMap;
    }

    public ArrayList<String> getSorted_gene_names() {
        return this.sorted_gene_names;
    }

    public void setSorted_gene_names(ArrayList<String> sorted_gene_names) {
        this.sorted_gene_names = sorted_gene_names;
    }

    public HashMap<String, Float> getSortedGeneStatistics() {
        return this.sortedGeneStatistics;
    }

    public void setSortedGeneStatistics(HashMap<String, Float> sortedGeneStatistics) {
        this.sortedGeneStatistics = sortedGeneStatistics;
        ArrayList<String> tempList = new ArrayList<String>();
        Iterator<String> it = sortedGeneStatistics.keySet().iterator();
        int index = 0;
        while (it.hasNext()) {
            String name = it.next();
            tempList.add(index, name);
            ++index;
        }
        this.setSorted_gene_names(tempList);
    }

    public FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    public float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    public FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    public float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }
}

