/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.HypergeometricProbability;

public class JEASEStatistics {
    public String population_file_name = "";
    public String list_file_name = "";
    public String output_file_name;
    public Vector<String> annotation_file_names = new Vector();
    public int population_total;
    public int list_total;
    public Hashtable<String, Hashtable<String, String>> categories = new Hashtable();
    public Hashtable<String, String> categories_population = new Hashtable();
    public Hashtable<String, String> categories_list = new Hashtable();
    public Hashtable<String, Vector<String>> hitAccumulator = new Hashtable();
    public HypergeometricProbability hgp_computation = new HypergeometricProbability();
    public BufferedReader read_in_stream;
    public String[][] records;
    public String[] categoryNames;
    public String[][] listHitMatrix;
    public String[] orders;
    public boolean reportEaseScore = true;
    private Hashtable<String, Hashtable<String, String>> pop_totals = new Hashtable();
    private Hashtable<String, Hashtable<String, String>> sample_totals = new Hashtable();
    private String impliesFileLocation;
    private String sep;

    public JEASEStatistics() {
        this.population_total = 0;
        this.list_total = 0;
        this.sep = System.getProperty("file.separator");
    }

    public JEASEStatistics(boolean reportEaseScore) {
        this.reportEaseScore = reportEaseScore;
        this.population_total = 0;
        this.list_total = 0;
        this.sep = System.getProperty("file.separator");
    }

    public void UseNewPopulationFileName(String file_name) {
        this.population_file_name = file_name;
    }

    public void RemoveCurrentAnnotationFileNames() {
        this.annotation_file_names.removeAllElements();
    }

    public void AddAnnotationFileName(String file_name) {
        this.annotation_file_names.addElement(file_name);
    }

    public void UseNewListFileName(String file_name) {
        this.list_file_name = file_name;
    }

    public void SetOutputFileName(String file_name) {
        this.output_file_name = file_name;
    }

    public void setImpliesFileLocation(String impliesFileLocation) {
        this.impliesFileLocation = impliesFileLocation;
    }

    public void GetCategories() {
        BufferedReader in = null;
        Hashtable implied_associations = new Hashtable();
        String line = "";
        String category = "";
        String file_name = "";
        try {
            int idx;
            String term;
            Enumeration<String> e = this.annotation_file_names.elements();
            while (e.hasMoreElements()) {
                file_name = e.nextElement().toString();
                in = new BufferedReader(new FileReader(file_name));
                term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
                this.sample_totals.put(term, new Hashtable());
                this.pop_totals.put(term, new Hashtable());
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf("\t");
                    if (idx >= line.length() || idx < 1) continue;
                    int idx2 = line.indexOf("\t", idx + 1);
                    if (idx2 >= line.length() || idx2 < 1) {
                        idx2 = line.length();
                    }
                    if (!this.categories.containsKey(category = term + "\t" + line.substring(idx + 1, idx2).trim())) {
                        this.categories.put(category, new Hashtable());
                        this.categories.get(category).put(line.substring(0, idx).trim(), "");
                        continue;
                    }
                    this.categories.get(category).put(line.substring(0, idx).trim(), "");
                }
            }
            for (int i = 0; i < this.annotation_file_names.size(); ++i) {
                String fileName = new File(this.annotation_file_names.elementAt(i)).getName();
                File file = new File(this.impliesFileLocation, fileName);
                if (!file.exists() || !file.isFile()) {
                    System.out.println("Couldn't find implies file at " + file.getAbsolutePath());
                    continue;
                }
                in = new BufferedReader(new FileReader(file));
                term = fileName.substring(fileName.lastIndexOf(this.sep) + 1, fileName.lastIndexOf("."));
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf(9);
                    if (idx >= line.length() || idx < 1) continue;
                    if (!implied_associations.containsKey(term + "\t" + line.substring(0, idx).trim())) {
                        implied_associations.put(term + "\t" + line.substring(0, idx).trim(), new Vector());
                        ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                        continue;
                    }
                    ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                }
            }
            boolean end = false;
            for (int k = 0; k < 10 && !end; ++k) {
                String cat = "";
                end = true;
                Enumeration _enum = implied_associations.keys();
                while (_enum.hasMoreElements()) {
                    cat = (String)_enum.nextElement();
                    if (!this.categories.containsKey(cat)) continue;
                    Hashtable<String, String> catHash = this.categories.get(cat);
                    Vector impVector = (Vector)implied_associations.get(cat);
                    for (int i = 0; i < impVector.size(); ++i) {
                        Enumeration<String> categoryEnum;
                        String impCat = (String)impVector.elementAt(i);
                        if (!this.categories.containsKey(impCat)) {
                            end = false;
                            this.categories.put(impCat, new Hashtable());
                            categoryEnum = catHash.keys();
                            while (categoryEnum.hasMoreElements()) {
                                this.categories.get(impCat).put(categoryEnum.nextElement(), "");
                            }
                            continue;
                        }
                        categoryEnum = catHash.keys();
                        while (categoryEnum.hasMoreElements()) {
                            String indexString = categoryEnum.nextElement();
                            if (this.categories.get(impCat).containsKey(indexString)) continue;
                            this.categories.get(impCat).put(indexString, "");
                            end = false;
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            System.out.println("Error occured collecting categories");
            System.out.println(error.getMessage());
            error.printStackTrace();
        }
    }

    public void GetCategories(Vector<String> popVector) {
        BufferedReader in = null;
        Hashtable implied_associations = new Hashtable();
        String line = "";
        String category = "";
        String file_name = "";
        try {
            int idx;
            String term;
            Enumeration<String> e = this.annotation_file_names.elements();
            while (e.hasMoreElements()) {
                file_name = e.nextElement().toString();
                in = new BufferedReader(new FileReader(file_name));
                term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
                this.sample_totals.put(term, new Hashtable());
                this.pop_totals.put(term, new Hashtable());
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf("\t");
                    if (idx >= line.length() || idx < 1) continue;
                    int idx2 = line.indexOf("\t", idx + 1);
                    if (idx2 >= line.length() || idx2 < 1) {
                        idx2 = line.length();
                    }
                    category = term + "\t" + line.substring(idx + 1, idx2).trim();
                    if (!popVector.contains(line.substring(0, idx).trim())) continue;
                    if (!this.categories.containsKey(category)) {
                        this.categories.put(category, new Hashtable());
                        this.categories.get(category).put(line.substring(0, idx).trim(), "");
                        continue;
                    }
                    this.categories.get(category).put(line.substring(0, idx).trim(), "");
                }
            }
            for (int i = 0; i < this.annotation_file_names.size(); ++i) {
                String fileName = new File(this.annotation_file_names.elementAt(i)).getName();
                File file = new File(this.impliesFileLocation, fileName);
                if (!file.exists() || !file.isFile()) {
                    System.out.println("Couldn't find implies file at " + file.getAbsolutePath());
                    continue;
                }
                in = new BufferedReader(new FileReader(file));
                term = fileName.substring(fileName.lastIndexOf(this.sep) + 1, fileName.lastIndexOf("."));
                while ((line = in.readLine()) != null) {
                    idx = line.indexOf(9);
                    if (idx >= line.length() || idx < 1) continue;
                    if (!implied_associations.containsKey(term + "\t" + line.substring(0, idx).trim())) {
                        implied_associations.put(term + "\t" + line.substring(0, idx).trim(), new Vector());
                        ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                        continue;
                    }
                    ((Vector)implied_associations.get(term + "\t" + line.substring(0, idx).trim())).addElement(term + "\t" + line.substring(idx, line.length()).trim());
                }
            }
            boolean end = false;
            for (int k = 0; k < 10 && !end; ++k) {
                String cat = "";
                end = true;
                Enumeration _enum = implied_associations.keys();
                while (_enum.hasMoreElements()) {
                    cat = (String)_enum.nextElement();
                    if (!this.categories.containsKey(cat)) continue;
                    Hashtable<String, String> catHash = this.categories.get(cat);
                    Vector impVector = (Vector)implied_associations.get(cat);
                    for (int i = 0; i < impVector.size(); ++i) {
                        Enumeration<String> categoryEnum;
                        String impCat = (String)impVector.elementAt(i);
                        if (!this.categories.containsKey(impCat)) {
                            end = false;
                            this.categories.put(impCat, new Hashtable());
                            categoryEnum = catHash.keys();
                            while (categoryEnum.hasMoreElements()) {
                                this.categories.get(impCat).put(categoryEnum.nextElement(), "");
                            }
                            continue;
                        }
                        categoryEnum = catHash.keys();
                        while (categoryEnum.hasMoreElements()) {
                            String indexString = categoryEnum.nextElement();
                            if (this.categories.get(impCat).containsKey(indexString)) continue;
                            this.categories.get(impCat).put(indexString, "");
                            end = false;
                        }
                    }
                }
            }
        }
        catch (Exception error) {
            System.out.println("Error occured collecting categories");
            System.out.println(error.getMessage());
            error.printStackTrace();
        }
    }

    public Vector<String> getSubPopulationForCategory(String term) {
        String key = "";
        Hashtable<Object, Object> hash_table = new Hashtable();
        Vector<String> returnVector = new Vector<String>();
        Enumeration<String> _enum = this.categories.keys();
        while (_enum.hasMoreElements()) {
            key = _enum.nextElement();
            hash_table = this.categories.get(key);
            if (!key.equals(term)) continue;
            Enumeration<Object> e = hash_table.keys();
            while (e.hasMoreElements()) {
                String categoryKey = (String)e.nextElement();
                returnVector.add(categoryKey);
            }
        }
        return returnVector;
    }

    public void GetPopulationHitsByCategory() {
        BufferedReader in = null;
        String line = "";
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable<Object, Object> hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        try {
            in = new BufferedReader(new FileReader(this.population_file_name));
            while ((line = in.readLine()) != null) {
                locus_ids.put(line.trim(), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration<String> _enum = this.categories.keys();
                while (_enum.hasMoreElements()) {
                    key = _enum.nextElement();
                    hash_table = this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_population.containsKey(key)) {
                        this.categories_population.put(key, "1");
                    } else {
                        hits = String.valueOf(Integer.parseInt(this.categories_population.get(key)) + 1);
                        this.categories_population.put(key, hits);
                    }
                    count_ids.put(locus_id, "");
                }
            }
            this.population_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void GetListHitsByCategory() {
        BufferedReader in = null;
        String line = "";
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable<Object, Object> hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        try {
            in = new BufferedReader(new FileReader(this.list_file_name));
            while ((line = in.readLine()) != null) {
                locus_ids.put(line.trim(), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration<String> _enum = this.categories.keys();
                while (_enum.hasMoreElements()) {
                    key = _enum.nextElement();
                    hash_table = this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_list.containsKey(key)) {
                        this.categories_list.put(key, "1");
                    } else {
                        hits = String.valueOf(Integer.parseInt(this.categories_list.get(key)) + 1);
                        this.categories_list.put(key, hits);
                    }
                    count_ids.put(locus_id, "");
                }
            }
            this.list_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void ConstructResults() {
        String key = "";
        String list_hit = "";
        String population_hit = "";
        String temp = "";
        this.records = new String[this.categories_list.size()][7];
        this.orders = new String[this.categories_list.size()];
        int c = 0;
        Enumeration<String> e = this.categories_list.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            list_hit = "";
            population_hit = "";
            temp = key.substring(0, key.indexOf(9)).trim();
            this.records[c][0] = temp.substring(temp.lastIndexOf(this.sep) + 1).trim();
            this.records[c][1] = key.substring(key.indexOf(9)).trim();
            this.records[c][2] = list_hit = this.categories_list.get(key);
            this.list_total = this.sample_totals.get(temp).size();
            this.records[c][3] = String.valueOf(this.list_total);
            this.records[c][4] = this.categories_population.containsKey(key) ? (population_hit = this.categories_population.get(key)) : "";
            this.population_total = this.pop_totals.get(temp).size();
            this.records[c][5] = String.valueOf(this.population_total);
            if (!list_hit.equals("") && !population_hit.equals("")) {
                double p = this.reportEaseScore ? (Integer.parseInt(list_hit) > 1 ? this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(population_hit), this.list_total - 1, Integer.parseInt(list_hit) - 1) : 1.0) : this.hgp_computation.SumHGP(this.population_total, Integer.parseInt(population_hit), this.list_total, Integer.parseInt(list_hit));
                this.records[c][6] = String.valueOf(p);
            } else {
                this.records[c][6] = "1.0";
            }
            ++c;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int cnt = 0;
        Enumeration<String> e2 = this.hitAccumulator.keys();
        while (e2.hasMoreElements()) {
            String cat;
            this.categoryNames[cnt] = cat = e2.nextElement();
            Vector<String> locusVector = this.hitAccumulator.get(cat);
            this.listHitMatrix[cnt] = new String[locusVector.size()];
            for (int i = 0; i < this.listHitMatrix[cnt].length; ++i) {
                this.listHitMatrix[cnt][i] = locusVector.elementAt(i);
            }
            ++cnt;
        }
    }

    public void SortRecords() {
        int len = this.records.length;
        for (int i0 = 0; i0 < len; ++i0) {
            for (int i = 0; i < len - 1 - i0; ++i) {
                BigDecimal big1 = new BigDecimal(this.records[i][6]);
                BigDecimal big2 = new BigDecimal(this.records[i + 1][6]);
                if (big1.compareTo(big2) <= 0) continue;
                String holder = this.records[i][0];
                this.records[i][0] = this.records[i + 1][0];
                this.records[i + 1][0] = holder;
                holder = this.records[i][1];
                this.records[i][1] = this.records[i + 1][1];
                this.records[i + 1][1] = holder;
                holder = this.records[i][2];
                this.records[i][2] = this.records[i + 1][2];
                this.records[i + 1][2] = holder;
                holder = this.records[i][3];
                this.records[i][3] = this.records[i + 1][3];
                this.records[i + 1][3] = holder;
                holder = this.records[i][4];
                this.records[i][4] = this.records[i + 1][4];
                this.records[i + 1][4] = holder;
                holder = this.records[i][5];
                this.records[i][5] = this.records[i + 1][5];
                this.records[i + 1][5] = holder;
                holder = this.records[i][6];
                this.records[i][6] = this.records[i + 1][6];
                this.records[i + 1][6] = holder;
            }
        }
    }

    public void DisplayResults() {
        try {
            File output_file = new File(this.output_file_name);
            FileWriter output_writer = new FileWriter(output_file);
            for (int i = 0; i < this.records.length; ++i) {
                System.out.print(this.records[i][0] + "\t");
                output_writer.write(this.records[i][0] + "\t");
                System.out.print(this.records[i][1] + "\t");
                output_writer.write(this.records[i][1] + "\t");
                System.out.print(this.records[i][2] + "\t");
                output_writer.write(this.records[i][2] + "\t");
                System.out.print(this.records[i][3] + "\t");
                output_writer.write(this.records[i][3] + "\t");
                System.out.print(this.records[i][4] + "\t");
                output_writer.write(this.records[i][4] + "\t");
                System.out.println(this.records[i][5] + "\t");
                output_writer.write(this.records[i][5] + "\t");
                output_writer.write("\n");
            }
            output_writer.close();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        JEASEStatistics jstatistics = new JEASEStatistics();
        System.out.println(new Date(System.currentTimeMillis()));
        jstatistics.UseNewPopulationFileName("C:/01_Work_Test_4/Files/JStatistics/All Homo sapiens.txt");
        jstatistics.RemoveCurrentAnnotationFileNames();
        jstatistics.AddAnnotationFileName("C:/01_Work_Test_4/Files/JStatistics/GO Biological Process.txt");
        jstatistics.UseNewListFileName("C:/01_Work_Test_4/Files/JStatistics/Bigger_HepC_chimp.txt");
        jstatistics.SetOutputFileName("C:/del.txt");
        jstatistics.GetCategories();
        jstatistics.GetListHitsByCategory();
        jstatistics.GetPopulationHitsByCategory();
        jstatistics.ConstructResults();
        jstatistics.SortRecords();
        System.out.println(new Date(System.currentTimeMillis()));
        System.out.println("\nCompleted.");
    }

    public void GetPopulationHitsByCategory(Vector<String> list) {
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable<Object, Object> hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put(list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration<String> _enum = this.categories.keys();
                while (_enum.hasMoreElements()) {
                    key = _enum.nextElement();
                    hash_table = this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_population.containsKey(key)) {
                        this.categories_population.put(key, "1");
                    } else {
                        hits = String.valueOf(Integer.parseInt(this.categories_population.get(key)) + 1);
                        this.categories_population.put(key, hits);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    this.pop_totals.get(key).put(locus_id, "");
                }
            }
            this.population_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void GetListHitsByCategory(Vector<String> list) {
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable<Object, Object> hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put(list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration<String> _enum = this.categories.keys();
                while (_enum.hasMoreElements()) {
                    key = _enum.nextElement();
                    hash_table = this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_list.containsKey(key)) {
                        this.categories_list.put(key, "1");
                        this.hitAccumulator.put(key, new Vector());
                        this.hitAccumulator.get(key).add(locus_id);
                    } else {
                        hits = String.valueOf(Integer.parseInt(this.categories_list.get(key)) + 1);
                        this.categories_list.put(key, hits);
                        this.hitAccumulator.get(key).add(locus_id);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    this.sample_totals.get(key).put(locus_id, "");
                }
            }
            this.list_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    String[][] getResults() {
        return this.records;
    }

    String[][] getSurveyResults() {
        return this.records;
    }

    String[][] getListHitMatrix() {
        return this.listHitMatrix;
    }

    String[] getCategoryNames() {
        return this.categoryNames;
    }

    public void resetForNewList() {
        this.categories_list = new Hashtable();
        this.sample_totals = new Hashtable();
        Enumeration<String> e = this.annotation_file_names.elements();
        while (e.hasMoreElements()) {
            String file_name = e.nextElement().toString();
            String term = file_name.substring(file_name.lastIndexOf(this.sep) + 1, file_name.lastIndexOf("."));
            this.sample_totals.put(term, new Hashtable());
        }
    }

    public void GetPopulationHitsByCategoryForSurvey(Vector<String> list) {
        String hits = "";
        String key = "";
        Hashtable<String, String> locus_ids = new Hashtable<String, String>();
        Hashtable<Object, Object> hash_table = new Hashtable();
        Hashtable<String, String> count_ids = new Hashtable<String, String>();
        try {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                locus_ids.put(list.elementAt(i), "");
            }
            Enumeration enum1 = locus_ids.keys();
            while (enum1.hasMoreElements()) {
                String locus_id = (String)enum1.nextElement();
                Enumeration<String> _enum = this.categories.keys();
                while (_enum.hasMoreElements()) {
                    key = _enum.nextElement();
                    hash_table = this.categories.get(key);
                    if (!hash_table.containsKey(locus_id)) continue;
                    if (!this.categories_population.containsKey(key)) {
                        this.categories_population.put(key, "1");
                        this.hitAccumulator.put(key, new Vector());
                        this.hitAccumulator.get(key).add(locus_id);
                    } else {
                        hits = String.valueOf(Integer.parseInt(this.categories_population.get(key)) + 1);
                        this.categories_population.put(key, hits);
                        this.hitAccumulator.get(key).add(locus_id);
                    }
                    count_ids.put(locus_id, "");
                    key = key.substring(0, key.indexOf("\t")).trim();
                    this.pop_totals.get(key).put(locus_id, "");
                }
            }
            this.population_total = count_ids.size();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void ConstructSurveyResults() {
        String key = "";
        String list_hit = "";
        String population_hit = "";
        String temp = "";
        this.records = new String[this.categories_population.size()][4];
        this.orders = new String[this.categories_population.size()];
        int c = 0;
        Enumeration<String> e = this.categories_population.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            list_hit = "";
            population_hit = "";
            temp = key.substring(0, key.indexOf(9)).trim();
            this.records[c][0] = temp.substring(temp.lastIndexOf(this.sep) + 1).trim();
            this.records[c][1] = key.substring(key.indexOf(9)).trim();
            this.records[c][2] = list_hit = this.categories_population.get(key);
            this.population_total = this.pop_totals.get(temp).size();
            this.records[c][3] = String.valueOf(this.population_total);
            ++c;
        }
        this.categoryNames = new String[this.hitAccumulator.size()];
        this.listHitMatrix = new String[this.categoryNames.length][];
        int cnt = 0;
        Enumeration<String> e2 = this.hitAccumulator.keys();
        while (e2.hasMoreElements()) {
            String cat;
            this.categoryNames[cnt] = cat = e2.nextElement();
            Vector<String> locusVector = this.hitAccumulator.get(cat);
            this.listHitMatrix[cnt] = new String[locusVector.size()];
            for (int i = 0; i < this.listHitMatrix[cnt].length; ++i) {
                this.listHitMatrix[cnt][i] = locusVector.elementAt(i);
            }
            ++cnt;
        }
    }
}

