/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

public class HypergeometricProbability {
    public final double P12 = Math.PI * 2;
    public final double S0 = 0.08333333333333333;
    public final double S1 = 0.002777777777777778;
    public final double S2 = 7.936507936507937E-4;
    public final double S3 = 5.952380952380953E-4;
    public final double S4 = 8.417508417508417E-4;
    public static double[] sfe = new double[16];

    public HypergeometricProbability() {
        HypergeometricProbability.sfe[0] = 0.0;
        HypergeometricProbability.sfe[1] = 0.08106146679532726;
        HypergeometricProbability.sfe[2] = 0.0413406959554093;
        HypergeometricProbability.sfe[3] = 0.02767792568499834;
        HypergeometricProbability.sfe[4] = 0.020790672103765093;
        HypergeometricProbability.sfe[5] = 0.016644691189821193;
        HypergeometricProbability.sfe[6] = 0.013876128823070748;
        HypergeometricProbability.sfe[7] = 0.01189670994589177;
        HypergeometricProbability.sfe[8] = 0.010411265261972096;
        HypergeometricProbability.sfe[9] = 0.009255462182712733;
        HypergeometricProbability.sfe[10] = 0.00833056343336287;
        HypergeometricProbability.sfe[11] = 0.007573675487951841;
        HypergeometricProbability.sfe[12] = 0.00694284010720953;
        HypergeometricProbability.sfe[13] = 0.006408994188004207;
        HypergeometricProbability.sfe[14] = 0.0059513701127588475;
        HypergeometricProbability.sfe[15] = 0.005554733551962801;
    }

    public double stirlerr(int n) {
        if (n < 16) {
            return sfe[n];
        }
        double nn = n;
        nn *= nn;
        if (n > 500) {
            return (0.08333333333333333 - 0.002777777777777778 / nn) / (double)n;
        }
        if (n > 80) {
            return (0.08333333333333333 - (0.002777777777777778 - 7.936507936507937E-4 / nn) / nn) / (double)n;
        }
        if (n > 35) {
            return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - 5.952380952380953E-4 / nn) / nn) / nn) / (double)n;
        }
        return (0.08333333333333333 - (0.002777777777777778 - (7.936507936507937E-4 - (5.952380952380953E-4 - 8.417508417508417E-4 / nn) / nn) / nn) / nn) / (double)n;
    }

    public double bd0(int x, double np) {
        if (Math.abs((double)x - np) < 0.1 * ((double)x + np)) {
            double s = ((double)x - np) * ((double)x - np) / ((double)x + np);
            double v = ((double)x - np) / ((double)x + np);
            double ej = (double)(2 * x) * v;
            v *= v;
            int j = 1;
            while (true) {
                double s1;
                if ((s1 = s + (ej *= v) / (double)((j << 1) + 1)) == s) {
                    return s1;
                }
                s = s1;
                ++j;
            }
        }
        return (double)x * Math.log((double)x / np) + np - (double)x;
    }

    public double dbinom(int x, int n, double p) {
        if (p == 0.0) {
            return x == 0 ? 1.0 : 0.0;
        }
        if (p == 1.0) {
            return x == n ? 1.0 : 0.0;
        }
        if (x == 0) {
            return Math.exp((double)n * Math.log(1.0 - p));
        }
        if (x == n) {
            return Math.exp((double)n * Math.log(p));
        }
        if (x < 0 | x > n) {
            return 0.0;
        }
        double lc = this.stirlerr(n) - this.stirlerr(x) - this.stirlerr(n - x) - this.bd0(x, (double)n * p) - this.bd0(n - x, (double)n * (1.0 - p));
        return Math.exp(lc) * Math.sqrt((double)n / (Math.PI * 2 * (double)x * (double)(n - x)));
    }

    public double dhyperg(int x, int t, int m, int n) {
        double p = (double)m / (double)n;
        return this.dbinom(x, t, p) * this.dbinom(m - x, n - t, p) / this.dbinom(m, n, p);
    }

    public double pExactForMatrix(int a1, int a2, int a3, int a4) {
        return this.dhyperg(a1, a1 + a3, a1 + a2, a1 + a2 + a3 + a4);
    }

    public double SumHGP(int POPTOT, int POPHITS, int SAMPTOT, int SAMPHITS) {
        if (SAMPHITS > SAMPTOT || SAMPHITS > POPHITS || SAMPTOT > POPTOT || POPHITS > POPTOT) {
            return 0.0;
        }
        if (SAMPHITS < 1) {
            return 1.0;
        }
        if (POPHITS < SAMPTOT) {
            double P = 0.0;
            for (int R = SAMPHITS; R < POPHITS + 1; ++R) {
                P += this.dhyperg(R, SAMPTOT, POPHITS, POPTOT);
            }
            return P;
        }
        double P = 0.0;
        for (int R = SAMPHITS; R < SAMPTOT + 1; ++R) {
            P += this.dhyperg(R, SAMPTOT, POPHITS, POPTOT);
        }
        return P;
    }

    public static void main(String[] args) {
        HypergeometricProbability hgp = new HypergeometricProbability();
        System.out.println("p = " + hgp.SumHGP(325, 19, 37, 5));
    }
}

