/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseDataElement;

public class EaseElementList
extends Vector<EaseDataElement> {
    private static final long serialVersionUID = 2712099912710373113L;

    public EaseElementList() {
    }

    public EaseElementList(int[] indices, String[] keys) {
        super(Math.min(indices.length, keys.length));
        int numberOfElements = Math.min(indices.length, keys.length);
        for (int i = 0; i < numberOfElements; ++i) {
            this.addElement(new EaseDataElement(indices[i], keys[i]));
        }
    }

    public EaseElementList(String[] keys) {
        super(keys.length);
        int numberOfElements = keys.length;
        for (int i = 0; i < numberOfElements; ++i) {
            this.addElement(new EaseDataElement(i, keys[i]));
        }
    }

    public EaseDataElement dataElementAt(int index) {
        return (EaseDataElement)super.elementAt(index);
    }

    public void setValue(String key, String value) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.dataElementAt(i).ifEqualsAdd(key, value);
        }
    }

    public Vector<String> getValueList() {
        Vector<String> list = new Vector<String>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Vector<String> values = this.dataElementAt(i).getEaseKeys();
            for (int j = 0; j < values.size(); ++j) {
                list.add(values.elementAt(j));
            }
        }
        return list;
    }

    public Vector<String> getUniqueValueList() {
        Vector<String> list = new Vector<String>();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Vector<String> values = this.dataElementAt(i).getEaseKeys();
            for (int j = 0; j < values.size(); ++j) {
                if (list.contains(values.elementAt(j))) continue;
                list.addElement(values.elementAt(j));
            }
        }
        return list;
    }

    public int[] getIndices(String[] valuesList) {
        Vector<Integer> indices = new Vector<Integer>();
        int size = this.size();
        for (int i = 0; i < valuesList.length; ++i) {
            String value = valuesList[i];
            for (int j = 0; j < size; ++j) {
                Integer intObj;
                int index = this.dataElementAt(j).ifContainsValueGetIndex(value);
                if (index <= -1 || indices.contains(intObj = new Integer(index))) continue;
                indices.addElement(intObj);
            }
        }
        size = indices.size();
        int[] list = new int[size];
        for (int i = 0; i < size; ++i) {
            list[i] = (Integer)indices.elementAt(i);
        }
        return list;
    }

    public void loadValues(String fileName) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        String line = "";
        String key = "";
        String value = "";
        int delIndex = 0;
        Hashtable<String, String> ht = new Hashtable<String, String>();
        while ((line = in.readLine()) != null) {
            delIndex = line.indexOf(9);
            if (delIndex < 0) continue;
            value = line.substring(0, delIndex).trim();
            key = line.substring(delIndex + 1).trim();
            ht.put(key, value);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            EaseDataElement ede = this.dataElementAt(i);
            value = (String)ht.get(ede.getMevKey());
            if (value == null) continue;
            ede.addValue(value);
        }
        in.close();
    }

    public void setDefaultValues() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            EaseDataElement ede = this.dataElementAt(i);
            ede.addValue(ede.getMevKey());
        }
    }
}

