/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.util.FloatMatrix;

public class EaseAlgorithmData
extends AlgorithmData {
    private static final String NESTING_TERM_OPTION = "nesting-term";
    private static final String HAVE_ACCESSIONS_OPTION = "have-accession-numbers";
    private static final String RUN_NEASE_OPTION = "run-nease";
    private static final String PERFORM_CLUSTER_ANALYSIS_OPTION = "perform-cluster-analysis";
    private static final String EXPRESSION_OPTION = "expression";
    private static final String IS_RECURSED_RUN_OPTION = "is-recursed-run";
    private static final String RESULT_MATRIX_OPTION = "result-matrix";
    private static final String POPULATION_LIST_OPTION = "population-list";
    private static final String ANNOTATION_FILE_LIST_OPTION = "annotation-file-list";
    private static final String IMPLIES_FILE_LOCATION_OPTION = "implies-file-location";
    private static final String TAG_FILE_LOCATION_OPTION = "tag-file-location";
    private static final String RUN_PERMUTATION_OPTION = "run-permutation-analysis";
    private static final String HOCHBERG_CORRECTION_OPTION = "hochberg-correction";
    private static final String SELECTED_NESTED_TERMS_OPTION = "selected-nested-ease-terms";
    private static final String REPORT_EASE_SCORE_OPTION = "report-ease-score";
    private static final String TRIM_OPTION = "trim-option";
    private static final String TRIM_VALUE = "trim-value";
    private static final String NEASE_CONSOLIDATED_RESULTS_OPTION = "nease-consolidated-results";
    private static final String NESTED_EASE_COUNT = "nested-ease-count";
    private static final String NEASE_HEADER_NAMES_OPTION = "nease-headers";
    private static final String CLUSTER_MATRIX_OPTION = "cluster-matrix";
    private static final String HIT_LIST_MATRIX_OPTION = "hit-list-matrix";
    private static final String SAMPLE_LIST_OPTION = "sample-list";
    private static final String SAMPLE_INDICES_OPTION = "sample-indices";
    private static final String CONVERTER_FILE_NAME_OPTION = "converter-file-name";
    private static final String HEADER_NAMES_OPTION = "header-names";
    private static final String P_VALUE_CORRECTIONS_OPTION = "p-value-corrections";

    public String getPvalueCorrectionsOption() {
        return this.getParams().getString(P_VALUE_CORRECTIONS_OPTION);
    }

    public void setPvalueCorrectionsOption(String value) {
        this.getParams().setProperty(P_VALUE_CORRECTIONS_OPTION, value);
    }

    public void setNeaseHeaderNames(String[] values) {
        this.addStringArray(NEASE_HEADER_NAMES_OPTION, values);
    }

    public String[] getNeaseHeaderNames() {
        return this.getStringArray(NEASE_HEADER_NAMES_OPTION);
    }

    public void setHeaderNames(String[] values) {
        this.addStringArray(HEADER_NAMES_OPTION, values);
    }

    public String[] getHeaderNames() {
        return this.getStringArray(HEADER_NAMES_OPTION);
    }

    public String getConverterFileName() {
        return this.getParams().getString(CONVERTER_FILE_NAME_OPTION);
    }

    public void setConverterFileName(String value) {
        this.getParams().setProperty(CONVERTER_FILE_NAME_OPTION, value);
    }

    public void setSampleIndices(int[] values) {
        this.addIntArray(SAMPLE_INDICES_OPTION, values);
    }

    public int[] getSampleIndices() {
        return this.getIntArray(SAMPLE_INDICES_OPTION);
    }

    public String[] getSampleList() {
        return this.getStringArray(SAMPLE_LIST_OPTION);
    }

    public void setSampleList(String[] value) {
        this.addStringArray(SAMPLE_LIST_OPTION, value);
    }

    public String[][] getHitListMatrix() {
        return (String[][])this.getObjectMatrix(HIT_LIST_MATRIX_OPTION);
    }

    public void setHitListMatrix(String[][] value) {
        this.addObjectMatrix(HIT_LIST_MATRIX_OPTION, value);
    }

    public void setTrimValue(float value) {
        this.getParams().setProperty(TRIM_VALUE, new Float(value).toString());
    }

    public float getTrimValue() {
        return this.getParams().getFloat(TRIM_VALUE);
    }

    public void setTrimOption(String value) {
        this.getParams().setProperty(TRIM_OPTION, value);
    }

    public String getTrimOption() {
        return this.getParams().getString(TRIM_OPTION);
    }

    public void setReportEaseScore(boolean value) {
        this.getParams().setProperty(REPORT_EASE_SCORE_OPTION, new Boolean(value).toString());
    }

    public boolean isReportEaseScore() {
        return this.getParams().getBoolean(REPORT_EASE_SCORE_OPTION);
    }

    public void setSelectedNestedTerms(String[] value) {
        this.addStringArray(SELECTED_NESTED_TERMS_OPTION, value);
    }

    public String[] getSelectedNestedTerms() {
        return this.getStringArray(SELECTED_NESTED_TERMS_OPTION);
    }

    public int[][] getClusterMatrix() {
        return this.getIntMatrix(CLUSTER_MATRIX_OPTION);
    }

    public void setClusterMatrix(int[][] matrix) {
        this.addIntMatrix(CLUSTER_MATRIX_OPTION, matrix);
    }

    public void setHochbergCorrection(boolean value) {
        this.getParams().setProperty(HOCHBERG_CORRECTION_OPTION, new Boolean(value).toString());
    }

    public boolean getHochbergCorrection() {
        return this.getParams().getBoolean(HOCHBERG_CORRECTION_OPTION);
    }

    public void setRunPermutationAnalysis(boolean value) {
        this.getParams().setProperty(RUN_PERMUTATION_OPTION, new Boolean(value).toString());
    }

    public boolean isRunPermutationAnalysis() {
        return this.getParams().getBoolean(RUN_PERMUTATION_OPTION, false);
    }

    public void setAnnotationFileList(String[] annFileList) {
        this.addStringArray(ANNOTATION_FILE_LIST_OPTION, annFileList);
    }

    public String[] getAnnotationFileList() {
        return this.getStringArray(ANNOTATION_FILE_LIST_OPTION);
    }

    public void setImpliesFileLocation(String impliesFileLocation) {
        this.getParams().setProperty(IMPLIES_FILE_LOCATION_OPTION, impliesFileLocation);
    }

    public String getImpliesFileLocation() {
        return this.getParams().getString(IMPLIES_FILE_LOCATION_OPTION);
    }

    public void setTagFileLocation(String tagFileLocation) {
        this.getParams().setProperty(TAG_FILE_LOCATION_OPTION, tagFileLocation);
    }

    public String getTagFileLocation() {
        return this.getParams().getString(TAG_FILE_LOCATION_OPTION);
    }

    public EaseAlgorithmData getNEASEResults(int index) {
        return (EaseAlgorithmData)this.getResultAlgorithmData(new Integer(index));
    }

    public int getNestedEaseCount() {
        return new Integer(this.getParams().getString(NESTED_EASE_COUNT));
    }

    public void setNestedEaseCount(int value) {
        this.getParams().setProperty(NESTED_EASE_COUNT, new Integer(value).toString());
    }

    public String[][] getNeaseConsolidatedResults() {
        return (String[][])this.getObjectMatrix(NEASE_CONSOLIDATED_RESULTS_OPTION);
    }

    public void setNeaseConsolidatedResults(String[][] value) {
        this.addObjectMatrix(NEASE_CONSOLIDATED_RESULTS_OPTION, value);
    }

    public String getNestingTerm() {
        return this.getParams().getString(NESTING_TERM_OPTION);
    }

    public void setNestingTerm(String value) {
        this.getParams().setProperty(NESTING_TERM_OPTION, value);
    }

    public boolean isPerformClusterAnalysis() {
        return this.getParams().getBoolean(PERFORM_CLUSTER_ANALYSIS_OPTION, true);
    }

    public void setPerformClusterAnalysis(boolean value) {
        this.getParams().setProperty(PERFORM_CLUSTER_ANALYSIS_OPTION, Boolean.toString(value));
    }

    public FloatMatrix getExpression() {
        return this.getMatrix(EXPRESSION_OPTION);
    }

    public void setExpression(FloatMatrix value) {
        this.addMatrix(EXPRESSION_OPTION, value);
    }

    public boolean isHaveAccessions() {
        return this.getParams().getBoolean(HAVE_ACCESSIONS_OPTION);
    }

    public void setHaveAccessions(boolean value) {
        this.getParams().setProperty(HAVE_ACCESSIONS_OPTION, Boolean.toString(value));
    }

    public double getFishers(int index) {
        if (this.isHaveAccessions()) {
            return new Double(this.getResultMatrix()[index][8]);
        }
        return new Double(this.getResultMatrix()[index][7]);
    }

    public String getFileName(int index) {
        if (this.isHaveAccessions()) {
            return this.getResultMatrix()[index][2];
        }
        return this.getResultMatrix()[index][1];
    }

    public String getTerm(int index) {
        if (this.isHaveAccessions()) {
            return this.getResultMatrix()[index][3];
        }
        return this.getResultMatrix()[index][2];
    }

    public String[][] getResultMatrix() {
        return (String[][])this.getObjectMatrix(RESULT_MATRIX_OPTION);
    }

    public void setResultMatrix(String[][] matrix) {
        this.addObjectMatrix(RESULT_MATRIX_OPTION, matrix);
    }

    public int getIndexForTerm(String term) {
        String[][] result = this.getResultMatrix();
        for (int k = 0; k < result.length; ++k) {
            if (!this.getTerm(k).equals(term)) continue;
            return k;
        }
        return -1;
    }

    public int getPopSize(int index) {
        if (this.isHaveAccessions()) {
            return new Integer(this.getResultMatrix()[index][7]);
        }
        return new Integer(this.getResultMatrix()[index][6]);
    }

    public int getPopHits(int index) {
        if (this.isHaveAccessions()) {
            return new Integer(this.getResultMatrix()[index][6]);
        }
        return new Integer(this.getResultMatrix()[index][5]);
    }

    public int getListSize(int index) {
        if (this.isHaveAccessions()) {
            return new Integer(this.getResultMatrix()[index][5]);
        }
        return new Integer(this.getResultMatrix()[index][4]);
    }

    public int getListHits(int index) {
        if (this.isHaveAccessions()) {
            return new Integer(this.getResultMatrix()[index][4]);
        }
        return new Integer(this.getResultMatrix()[index][3]);
    }

    public boolean isRecursedRun() {
        return this.getParams().getBoolean(IS_RECURSED_RUN_OPTION);
    }

    public void setRecursedRun(boolean value) {
        this.getParams().setProperty(IS_RECURSED_RUN_OPTION, Boolean.toString(value));
    }

    public boolean isRunNease() {
        return this.getParams().getBoolean(RUN_NEASE_OPTION);
    }

    public void setRunNease(boolean value) {
        this.getParams().setProperty(RUN_NEASE_OPTION, Boolean.toString(value));
    }

    public String[] getPopulationList() {
        return this.getStringArray(POPULATION_LIST_OPTION);
    }

    public void setPopulationList(String[] stringArray) {
        this.addStringArray(POPULATION_LIST_OPTION, stringArray);
    }
}

