/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.ease;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmEvent;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseAlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseDataElement;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.EaseElementList;
import org.tigr.microarray.mev.cluster.algorithm.impl.ease.JEASEStatistics;
import org.tigr.util.FloatMatrix;
import org.tigr.util.QSort;

public class EASE
extends AbstractAlgorithm {
    protected JEASEStatistics jstats;
    protected Vector<String> sampleVector;
    protected Vector<String> populationVector;
    protected String[] annotationFileList;
    protected String impliesFileLocation;
    protected String[][] result;
    protected String[][] hitList;
    protected String[] categoryNames;
    protected boolean haveAccessionNumbers = false;
    protected boolean reportEaseScore = false;
    protected AlgorithmEvent event;
    protected Vector<String> headerNames;
    protected DecimalFormat format;
    protected FloatMatrix expData;
    protected boolean stop = false;
    protected boolean performClusterAnalysis;
    protected boolean isRecursedEaseRun = false;
    String tagsFileLocation;
    protected EaseElementList populationElementList;
    protected static final String HAVE_ACCESSIONS_OPTION = "have-accession-numbers";
    long start;

    public void abort() {
        this.stop = true;
    }

    public AlgorithmData execute(AlgorithmData algData) throws AlgorithmException {
        EaseAlgorithmData algorithmData = (EaseAlgorithmData)algData;
        AlgorithmParameters params = algorithmData.getParams();
        this.performClusterAnalysis = params.getBoolean("perform-cluster-analysis", true);
        this.expData = algorithmData.getMatrix("expression");
        this.isRecursedEaseRun = params.getBoolean("is-recursed-run", false);
        if (this.performClusterAnalysis) {
            if (!algorithmData.isRunNease()) {
                return this.performClusterAnnotationAnalysis(algorithmData);
            }
            EaseAlgorithmData temp = this.performClusterAnnotationAnalysis(algorithmData);
            return this.performNestedEaseAnalysis(temp);
        }
        return this.performSlideAnnotationSurvey(algorithmData);
    }

    protected EaseAlgorithmData performNestedEaseAnalysis(EaseAlgorithmData algorithmData) throws AlgorithmException {
        int i;
        double fishersCutoff = 0.05;
        if (algorithmData == null) {
            return null;
        }
        String[][] initialResultMatrix = algorithmData.getResultMatrix();
        if (initialResultMatrix == null || initialResultMatrix.length == 0) {
            return algorithmData;
        }
        Vector<String[]> selectionGroup = new Vector<String[]>();
        for (int i2 = 0; i2 < initialResultMatrix.length; ++i2) {
            double compareValue;
            try {
                compareValue = new Double(initialResultMatrix[i2][9]);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                compareValue = new Double(initialResultMatrix[i2][8]);
            }
            if (!(compareValue < fishersCutoff)) continue;
            Double d = new Double(initialResultMatrix[i2][6]);
            if (!(d > 4.0)) continue;
            selectionGroup.add(initialResultMatrix[i2]);
        }
        int[] termlist = new int[selectionGroup.size()];
        for (int k = 0; k < selectionGroup.size(); ++k) {
            termlist[k] = k;
        }
        algorithmData.setNestedEaseCount(termlist.length);
        int[][] clusterMatrix = algorithmData.getClusterMatrix();
        EaseAlgorithmData[] nestedAlgorithmResults = new EaseAlgorithmData[termlist.length];
        String[] nestedEaseTerms = new String[termlist.length];
        Vector<String[]> consolidatedNeaseTable = new Vector<String[]>();
        for (i = 0; i < termlist.length; ++i) {
            String[] thisTerm = (String[])selectionGroup.get(termlist[i]);
            int[] thisCluster = clusterMatrix[termlist[i]];
            EaseAlgorithmData nData = this.duplicateEASEAlgorithmData(algorithmData);
            if (algorithmData.isHaveAccessions()) {
                this.event.setDescription("Running Nested EASE analysis on " + thisTerm[3] + "\n");
            } else {
                this.event.setDescription("Running Nested EASE analysis on " + thisTerm[2] + "\n");
            }
            this.fireValueChanged(this.event);
            EASE nEase = new EASE();
            nData.setRecursedRun(true);
            nData.setRunNease(false);
            if (algorithmData.isHaveAccessions()) {
                nData.setNestingTerm(thisTerm[1] + "\t" + thisTerm[3]);
                nestedEaseTerms[i] = thisTerm[1] + ": " + thisTerm[3];
            } else {
                nData.setNestingTerm(thisTerm[1] + "\t" + thisTerm[2]);
                nestedEaseTerms[i] = thisTerm[1] + ": " + thisTerm[2];
            }
            String[] oldClusterKeys = algorithmData.getSampleList();
            int[] oldCluster = algorithmData.getSampleIndices();
            String[] newClusterKeys = new String[thisCluster.length];
            for (int j = 0; j < oldClusterKeys.length; ++j) {
                for (int k = 0; k < thisCluster.length; ++k) {
                    if (oldCluster[j] != thisCluster[k]) continue;
                    newClusterKeys[k] = oldClusterKeys[j];
                }
            }
            nData.setSampleList(newClusterKeys);
            nData.setSampleIndices(thisCluster);
            Vector<String> _temp1 = this.jstats.getSubPopulationForCategory(nData.getNestingTerm());
            String[] newPopKeys = new String[_temp1.size()];
            for (int k = 0; k < _temp1.size(); ++k) {
                String thisKey = _temp1.get(k);
                for (int j = 0; j < this.populationElementList.size(); ++j) {
                    if (!((EaseDataElement)this.populationElementList.get(j)).getEaseKeys().contains(thisKey)) continue;
                    newPopKeys[k] = ((EaseDataElement)this.populationElementList.get(j)).getMevKey();
                }
            }
            String[] annFileList = new String[1];
            String[] oldAnnFileList = algorithmData.getAnnotationFileList();
            for (int k = 0; k < oldAnnFileList.length; ++k) {
                String oldAnnFile = oldAnnFileList[k].substring(oldAnnFileList[k].lastIndexOf(System.getProperty("file.separator")) + 1, oldAnnFileList[k].lastIndexOf("."));
                if (!thisTerm[1].equalsIgnoreCase(oldAnnFile)) continue;
                annFileList[0] = oldAnnFileList[k];
                break;
            }
            nData.setPopulationList(newPopKeys);
            nData.setAnnotationFileList(annFileList);
            nData.setRunPermutationAnalysis(false);
            nData.setHochbergCorrection(false);
            nData = (EaseAlgorithmData)nEase.execute(nData);
            if (nData.getResultMatrix() != null) {
                nData.setResultMatrix(this.expandResults(nData, algorithmData));
                consolidatedNeaseTable.addAll(this.getFilteredSignificantData(nData, algorithmData));
            }
            nestedAlgorithmResults[i] = nData;
        }
        algorithmData.setSelectedNestedTerms(nestedEaseTerms);
        for (i = 0; i < nestedAlgorithmResults.length; ++i) {
            algorithmData.addResultAlgorithmData(i, nestedAlgorithmResults[i]);
        }
        String[][] neases = new String[consolidatedNeaseTable.size()][];
        for (int k = 0; k < consolidatedNeaseTable.size(); ++k) {
            String[] consolidatedTemp;
            neases[k] = consolidatedTemp = (String[])consolidatedNeaseTable.get(k);
        }
        String[] temp = algorithmData.getHeaderNames();
        String[] neaseSummaryHeaders = new String[15];
        for (int j = 0; j < 9; ++j) {
            neaseSummaryHeaders[j] = temp[j];
        }
        neaseSummaryHeaders[neaseSummaryHeaders.length - 6] = "Gene Enrich.";
        neaseSummaryHeaders[neaseSummaryHeaders.length - 5] = "p-value log diff.";
        neaseSummaryHeaders[neaseSummaryHeaders.length - 4] = "nEASE Gene Enrich.";
        neaseSummaryHeaders[neaseSummaryHeaders.length - 3] = "Percent Gene Enrich.";
        neaseSummaryHeaders[neaseSummaryHeaders.length - 2] = "EASE Acc";
        neaseSummaryHeaders[neaseSummaryHeaders.length - 1] = "EASE Term";
        algorithmData.setNeaseConsolidatedResults(neases);
        algorithmData.setNeaseHeaderNames(neaseSummaryHeaders);
        return algorithmData;
    }

    private Vector<String[]> getFilteredSignificantData(EaseAlgorithmData nData, EaseAlgorithmData eData) {
        String[][] longResults = nData.getResultMatrix();
        Vector<String[]> filteredResults = new Vector<String[]>();
        for (int resultsIndex = 0; resultsIndex < longResults.length; ++resultsIndex) {
            String[] thisRow = longResults[resultsIndex];
            int rowlength = thisRow.length;
            double neaseGeneEnrichment = new Double(longResults[resultsIndex][rowlength - 4]);
            double neasePvalueDiff = new Double(longResults[resultsIndex][rowlength - 3]);
            double newNeaseGeneEnrich = new Double(longResults[resultsIndex][rowlength - 2]);
            double neaseScore = new Double(longResults[resultsIndex][rowlength - 1]);
            double percentGeneEnrich = new Double(longResults[resultsIndex][rowlength - 1]) * 100.0;
            double neaseFishers = nData.getFishers(resultsIndex);
            if (!(neaseScore > 0.0) || !(neaseGeneEnrichment > 0.0) || !(neasePvalueDiff > 0.0) || !(newNeaseGeneEnrich > 0.0) || !(neaseFishers < 0.05)) continue;
            String[] consolidatedTemp = new String[15];
            for (int k = 0; k < 9; ++k) {
                consolidatedTemp[k] = thisRow[k];
            }
            String condensedNestedTerm = nData.getNestingTerm().substring(nData.getNestingTerm().lastIndexOf("\t") + 1, nData.getNestingTerm().length());
            int eDataResultsIndex = eData.getIndexForTerm(condensedNestedTerm);
            consolidatedTemp[consolidatedTemp.length - 6] = String.valueOf(neaseGeneEnrichment);
            consolidatedTemp[consolidatedTemp.length - 5] = String.valueOf(neasePvalueDiff);
            consolidatedTemp[consolidatedTemp.length - 4] = String.valueOf(newNeaseGeneEnrich);
            consolidatedTemp[consolidatedTemp.length - 3] = String.valueOf(percentGeneEnrich);
            consolidatedTemp[consolidatedTemp.length - 2] = eData.getFileName(eDataResultsIndex);
            consolidatedTemp[consolidatedTemp.length - 1] = nData.getNestingTerm();
            consolidatedTemp[consolidatedTemp.length - 1] = condensedNestedTerm;
            filteredResults.add(consolidatedTemp);
        }
        return filteredResults;
    }

    private String[][] expandResults(EaseAlgorithmData neaseData, EaseAlgorithmData easeData) {
        String[][] nResults = neaseData.getResultMatrix();
        for (int neaseResultsIndex = 0; neaseResultsIndex < nResults.length; ++neaseResultsIndex) {
            String thisNeaseResultTerm = neaseData.getTerm(neaseResultsIndex);
            int easeRowIndexForThisTerm = easeData.getIndexForTerm(thisNeaseResultTerm);
            String[] originalShortNeaseResultRow = nResults[neaseResultsIndex];
            String[] newLongNeaseResultRow = new String[originalShortNeaseResultRow.length + 4];
            for (int x = 0; x < originalShortNeaseResultRow.length; ++x) {
                newLongNeaseResultRow[x] = originalShortNeaseResultRow[x];
            }
            double neaseListHits = neaseData.getListHits(neaseResultsIndex);
            double neaseListSize = neaseData.getListSize(neaseResultsIndex);
            double neasePopHits = neaseData.getPopHits(neaseResultsIndex);
            double neasePopSize = neaseData.getPopSize(neaseResultsIndex);
            double neaseFishers = neaseData.getFishers(neaseResultsIndex);
            double easeListHits = easeData.getListHits(easeRowIndexForThisTerm);
            double easeListSize = easeData.getListSize(easeRowIndexForThisTerm);
            double easePopHits = easeData.getPopHits(easeRowIndexForThisTerm);
            double easePopSize = easeData.getPopSize(easeRowIndexForThisTerm);
            double easeFishers = easeData.getFishers(easeRowIndexForThisTerm);
            double percentGeneEnrich = neaseListHits / neasePopHits - neaseListSize / neasePopSize;
            double neaseGeneEnrichment = neaseListHits - neaseListSize / neasePopSize * neasePopHits;
            double easeEnrichment = easeListHits / easePopHits - easeListSize / easePopSize;
            double neaseEnrichment = (percentGeneEnrich - easeEnrichment) / easeEnrichment;
            double easeMinusLog = -Math.log10(easeFishers);
            double neaseMinusLog = -Math.log10(neaseFishers);
            double neasePvalueDiff = neaseMinusLog - easeMinusLog;
            double easeGeneEnrichment = easeListHits - easeListSize / easePopSize * easePopHits;
            double newNeaseGeneEnrich = neaseGeneEnrichment - easeGeneEnrichment;
            double neaseScore = neasePvalueDiff + newNeaseGeneEnrich;
            newLongNeaseResultRow[newLongNeaseResultRow.length - 4] = String.valueOf(neaseGeneEnrichment);
            newLongNeaseResultRow[newLongNeaseResultRow.length - 3] = String.valueOf(neasePvalueDiff);
            newLongNeaseResultRow[newLongNeaseResultRow.length - 2] = String.valueOf(newNeaseGeneEnrich);
            newLongNeaseResultRow[newLongNeaseResultRow.length - 1] = String.valueOf(percentGeneEnrich);
            nResults[neaseResultsIndex] = newLongNeaseResultRow;
        }
        String[] temp = neaseData.getHeaderNames();
        String[] temp2 = new String[temp.length + 4];
        for (int j = 0; j < temp.length; ++j) {
            temp2[j] = temp[j];
        }
        temp2[temp2.length - 4] = "Gene Enrich.";
        temp2[temp2.length - 3] = "p-value log diff.";
        temp2[temp2.length - 2] = "nEASE Gene Enrich.";
        temp2[temp2.length - 1] = "Percent Gene Enrich.";
        neaseData.addStringArray("header-names", temp2);
        return nResults;
    }

    protected EaseAlgorithmData duplicateEASEAlgorithmData(EaseAlgorithmData oldData) {
        EaseAlgorithmData newData = new EaseAlgorithmData();
        newData.setExpression(oldData.getExpression());
        newData.setPerformClusterAnalysis(oldData.isPerformClusterAnalysis());
        newData.setRunNease(false);
        newData.setReportEaseScore(oldData.isReportEaseScore());
        if (oldData.getConverterFileName() != null) {
            newData.setConverterFileName(oldData.getConverterFileName());
        }
        if (oldData.getAnnotationFileList() != null) {
            newData.setAnnotationFileList(oldData.getAnnotationFileList());
        }
        newData.setImpliesFileLocation(oldData.getImpliesFileLocation());
        newData.setTagFileLocation(oldData.getTagFileLocation());
        newData.setPopulationList(oldData.getPopulationList());
        newData.setHaveAccessions(oldData.isHaveAccessions());
        newData.setHochbergCorrection(false);
        newData.setTrimOption(oldData.getTrimOption());
        newData.setTrimValue(oldData.getTrimValue());
        return newData;
    }

    protected EaseAlgorithmData performClusterAnnotationAnalysis(EaseAlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters params = algorithmData.getParams();
        this.headerNames = new Vector();
        this.reportEaseScore = algorithmData.isReportEaseScore();
        this.intializeHeaderNames();
        this.format = new DecimalFormat("0.###E00");
        this.event = new AlgorithmEvent((Object)this, 3, 0);
        this.event.setDescription("Start EASE Analysis\n");
        this.fireValueChanged(this.event);
        String converterFileName = algorithmData.getConverterFileName();
        int[] clusterIndices = algorithmData.getSampleIndices();
        String[] sampleList = algorithmData.getSampleList();
        String[] populationList = algorithmData.getPopulationList();
        this.annotationFileList = algorithmData.getAnnotationFileList();
        this.impliesFileLocation = algorithmData.getImpliesFileLocation();
        this.tagsFileLocation = algorithmData.getTagFileLocation();
        EaseElementList sampleElementList = new EaseElementList(clusterIndices, sampleList);
        this.populationElementList = new EaseElementList(populationList);
        if (this.stop) {
            return null;
        }
        try {
            if (converterFileName != null) {
                this.event.setDescription("Loading Cluster Annotation List\n");
                this.fireValueChanged(this.event);
                sampleElementList.loadValues(converterFileName);
                this.event.setDescription("Loading Population Annotation List\n");
                this.fireValueChanged(this.event);
                this.populationElementList.loadValues(converterFileName);
            } else {
                this.event.setDescription("Preparing Annotation Lists (no conversion file)\n");
                sampleElementList.setDefaultValues();
                this.populationElementList.setDefaultValues();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + converterFileName + "\n" + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new AlgorithmException("Error Reading File: " + converterFileName + "\n" + ioe.getMessage());
        }
        this.event.setDescription("Extracting Unique Cluster Annotation List\n");
        this.fireValueChanged(this.event);
        this.sampleVector = sampleElementList.getUniqueValueList();
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Extracting Unique Population Annotation List\n");
        this.fireValueChanged(this.event);
        this.populationVector = this.populationElementList.getUniqueValueList();
        if (this.stop) {
            return null;
        }
        this.jstats = new JEASEStatistics(this.reportEaseScore);
        for (int i = 0; i < this.annotationFileList.length; ++i) {
            this.jstats.AddAnnotationFileName(this.annotationFileList[i]);
        }
        this.jstats.setImpliesFileLocation(this.impliesFileLocation);
        this.event.setDescription("Loading Annotation Category Files\n");
        this.fireValueChanged(this.event);
        this.jstats.GetCategories(this.populationVector);
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Finding Sample Category Hits\n");
        this.fireValueChanged(this.event);
        this.jstats.GetListHitsByCategory(this.sampleVector);
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Finding Population Category Hits\n");
        this.fireValueChanged(this.event);
        this.jstats.GetPopulationHitsByCategory(this.populationVector);
        this.event.setDescription("Statistical Testing and Result Prep.\n");
        this.fireValueChanged(this.event);
        this.jstats.ConstructResults();
        this.result = this.jstats.getResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.jstats.getListHitMatrix();
        this.categoryNames = this.jstats.getCategoryNames();
        this.event.setDescription("Sorting Result on p-value\n");
        this.fireValueChanged(this.event);
        this.sortResults();
        if (this.stop) {
            return null;
        }
        if (algorithmData.getParams().getBoolean("p-value-corrections", false)) {
            this.event.setDescription("Applying p-value Multiplicity Corrections\n");
            this.fireValueChanged(this.event);
            this.pValueCorrections(algorithmData);
        }
        if (algorithmData.isRunPermutationAnalysis()) {
            this.event.setDescription("Resampling Analysis\n");
            this.fireValueChanged(this.event);
            Vector<String> sourcePop = null;
            if (this.isRecursedEaseRun) {
                String nestingTerm = algorithmData.getNestingTerm();
                sourcePop = this.jstats.getSubPopulationForCategory(nestingTerm);
            }
            this.permutationAnalysis(algorithmData.getParams().getInt("permutation-count", 1), sourcePop);
        }
        if (this.stop) {
            return null;
        }
        this.event.setDescription("Appending Accessions\n");
        this.fireValueChanged(this.event);
        this.result = this.appendAccessions(this.result, this.annotationFileList);
        algorithmData.setHaveAccessions(this.haveAccessionNumbers);
        String trimOption = algorithmData.getTrimOption();
        if (!trimOption.equals("NO_TRIM")) {
            this.event.setDescription("Trim Result\n");
            this.fireValueChanged(this.event);
            float trimValue = algorithmData.getTrimValue();
            this.trimResult(trimOption, trimValue);
        }
        this.event.setDescription("Indexing Result\n");
        this.fireValueChanged(this.event);
        this.indexResult();
        algorithmData.setResultMatrix(this.result);
        algorithmData.setHitListMatrix(this.hitList);
        this.event.setDescription("Extracting Cluster Indices and Stats\n");
        this.fireValueChanged(this.event);
        int[][] clusters = this.getClusters(sampleElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.setClusterMatrix(clusters);
        algorithmData.setHeaderNames(this.getHeaderNames());
        FloatMatrix means = this.getMeans(this.expData, clusters);
        algorithmData.addMatrix("means", means);
        algorithmData.addMatrix("variances", this.getVariances(this.expData, means, clusters));
        if (this.stop) {
            return null;
        }
        return algorithmData;
    }

    protected EaseAlgorithmData performSlideAnnotationSurvey(EaseAlgorithmData algorithmData) throws AlgorithmException {
        AlgorithmParameters params = algorithmData.getParams();
        this.headerNames = new Vector();
        this.intializeHeaderNames();
        this.format = new DecimalFormat("0.###E00");
        AlgorithmEvent event = new AlgorithmEvent((Object)this, 3, 0);
        event.setDescription("Start Survey\n");
        this.fireValueChanged(event);
        String converterFileName = algorithmData.getConverterFileName();
        String[] populationList = algorithmData.getPopulationList();
        String[] annotationFileList = algorithmData.getAnnotationFileList();
        this.populationElementList = new EaseElementList(populationList);
        try {
            if (converterFileName != null) {
                event.setDescription("Loading Population Annotation List\n");
                this.fireValueChanged(event);
                this.populationElementList.loadValues(converterFileName);
            } else {
                event.setDescription("Preparing Annotation Lists (no conversion file)\n");
                this.populationElementList.setDefaultValues();
            }
        }
        catch (FileNotFoundException fnfe) {
            throw new AlgorithmException("Annotation Conversion File Not Found\n" + converterFileName + "\n" + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new AlgorithmException("Error Reading File: " + converterFileName + "\n" + ioe.getMessage());
        }
        event.setDescription("Extracting Unique Population Annotation List\n");
        this.fireValueChanged(event);
        this.populationVector = this.populationElementList.getUniqueValueList();
        this.jstats = new JEASEStatistics();
        for (int i = 0; i < annotationFileList.length; ++i) {
            this.jstats.AddAnnotationFileName(annotationFileList[i]);
        }
        this.jstats.setImpliesFileLocation(this.impliesFileLocation);
        event.setDescription("Reading Annotation Category Files into Memory\n");
        this.fireValueChanged(event);
        this.jstats.GetCategories();
        event.setDescription("Finding Population Category Hits\n");
        this.fireValueChanged(event);
        this.jstats.GetPopulationHitsByCategoryForSurvey(this.populationVector);
        event.setDescription("Result Prep.\n");
        this.fireValueChanged(event);
        this.jstats.ConstructSurveyResults();
        this.result = this.jstats.getSurveyResults();
        if (this.result.length < 1) {
            return algorithmData;
        }
        this.hitList = this.jstats.getListHitMatrix();
        this.categoryNames = this.jstats.getCategoryNames();
        event.setDescription("Sorting Result on hit count\n");
        this.fireValueChanged(event);
        this.sortSurveyResults();
        event.setDescription("Appending Accessions\n");
        this.fireValueChanged(event);
        this.result = this.appendAccessions(this.result, annotationFileList);
        algorithmData.setHaveAccessions(this.haveAccessionNumbers);
        algorithmData.setHeaderNames(this.getHeaderNames());
        String trimOption = algorithmData.getTrimOption();
        if (!trimOption.equals("NO_TRIM")) {
            event.setDescription("Trim Result\n");
            this.fireValueChanged(event);
            float trimValue = algorithmData.getTrimValue();
            this.trimResult(trimOption, trimValue);
        }
        event.setDescription("Indexing Result\n");
        this.fireValueChanged(event);
        this.indexResult();
        algorithmData.setResultMatrix(this.result);
        algorithmData.addObjectMatrix("hit-list-matrix", this.hitList);
        event.setDescription("Extracting Cluster Indices and Stats\n");
        this.fireValueChanged(event);
        int[][] clusters = this.getClusters(this.populationElementList, this.hitList);
        algorithmData.addStringArray("category-names", this.categoryNames);
        algorithmData.setClusterMatrix(clusters);
        FloatMatrix means = this.getMeans(this.expData, clusters);
        algorithmData.addMatrix("means", means);
        algorithmData.addMatrix("variances", this.getVariances(this.expData, means, clusters));
        return algorithmData;
    }

    protected void intializeHeaderNames() {
        if (this.performClusterAnalysis) {
            this.headerNames.add("Index");
            this.headerNames.add("File");
            this.headerNames.add("Term");
            this.headerNames.add("List Hits");
            this.headerNames.add("List Size");
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
            if (this.reportEaseScore) {
                this.headerNames.add("EASE Score");
            } else {
                this.headerNames.add("Fisher's Exact");
            }
        } else {
            this.headerNames.add("Index");
            this.headerNames.add("File");
            this.headerNames.add("Term");
            this.headerNames.add("Pop. Hits");
            this.headerNames.add("Pop. Size");
        }
    }

    protected int[][] getClusters(EaseElementList clusterList, String[][] hitList) {
        int[][] clusters = new int[hitList.length][];
        for (int i = 0; i < hitList.length; ++i) {
            clusters[i] = clusterList.getIndices(hitList[i]);
        }
        return clusters;
    }

    protected void sortResults() {
        int i;
        double[] stat = new double[this.result.length];
        int pValueIndex = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --pValueIndex;
        for (int i2 = 0; i2 < this.result.length; ++i2) {
            stat[i2] = Double.parseDouble(this.result[i2][pValueIndex]);
        }
        QSort qsorter = new QSort(stat);
        stat = qsorter.getSortedDouble();
        int[] orderedIndices = qsorter.getOrigIndx();
        String[] newCatNames = new String[this.categoryNames.length];
        String[][] newHitList = new String[this.hitList.length][];
        String[][] newResult = new String[this.result.length][];
        for (i = 0; i < orderedIndices.length; ++i) {
            newCatNames[i] = this.categoryNames[orderedIndices[i]];
            newHitList[i] = this.hitList[orderedIndices[i]];
            newResult[i] = this.result[orderedIndices[i]];
        }
        for (i = 0; i < newResult.length; ++i) {
            newResult[i][pValueIndex] = this.format.format(Double.parseDouble(newResult[i][pValueIndex]));
            newResult[i][pValueIndex] = newResult[i][pValueIndex].replace(',', '.');
        }
        this.categoryNames = newCatNames;
        this.hitList = newHitList;
        this.result = newResult;
    }

    protected void sortSurveyResults() {
        double[] hitCounts = new double[this.result.length];
        int hitIndex = this.headerNames.indexOf("Pop. Hits");
        --hitIndex;
        for (int i = 0; i < this.result.length; ++i) {
            hitCounts[i] = Double.parseDouble(this.result[i][hitIndex]);
        }
        QSort qsorter = new QSort(hitCounts);
        hitCounts = qsorter.getSortedDouble();
        int[] orderedIndices = qsorter.getOrigIndx();
        String[] newCatNames = new String[this.categoryNames.length];
        String[][] newHitList = new String[this.hitList.length][];
        String[][] newResult = new String[this.result.length][];
        int index = 0;
        for (int i = orderedIndices.length - 1; i >= 0; --i) {
            newCatNames[index] = this.categoryNames[orderedIndices[i]];
            newHitList[index] = this.hitList[orderedIndices[i]];
            newResult[index] = this.result[orderedIndices[i]];
            ++index;
        }
        this.categoryNames = newCatNames;
        this.hitList = newHitList;
        this.result = newResult;
    }

    protected String[][] appendAccessions(String[][] resultMatrix, String[] fileNames) {
        if (resultMatrix == null || resultMatrix.length < 1) {
            return resultMatrix;
        }
        String[][] newResult = null;
        File file = null;
        this.haveAccessionNumbers = false;
        try {
            for (int i = 0; i < fileNames.length; ++i) {
                file = this.getAccessionFile(fileNames[i]);
                if (!file.isFile()) continue;
                if (!this.haveAccessionNumbers) {
                    newResult = new String[resultMatrix.length][resultMatrix[0].length + 1];
                    this.initializeNewResult(newResult, resultMatrix);
                    this.headerNames.insertElementAt("Acc.", 2);
                }
                this.insertAccessions(file, newResult);
                this.haveAccessionNumbers = true;
                resultMatrix = newResult;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(new JFrame(), "Error in collecting accessions following analysis from file: " + file.getName() + "\n Results will not have accessions.  Please check file location" + " and format", "File Error", 2);
            return this.result;
        }
        if (this.haveAccessionNumbers) {
            return newResult;
        }
        return resultMatrix;
    }

    protected void initializeNewResult(String[][] newResult, String[][] oldResult) {
        int i;
        for (i = 0; i < newResult.length; ++i) {
            for (int j = 0; j < oldResult[0].length; ++j) {
                if (j < 1) {
                    newResult[i][j] = oldResult[i][j];
                    continue;
                }
                newResult[i][j + 1] = oldResult[i][j];
            }
        }
        for (i = 0; i < newResult.length; ++i) {
            newResult[i][1] = " ";
        }
    }

    protected void indexResult() {
        if (this.result == null || this.result.length < 1) {
            return;
        }
        String[][] newResult = new String[this.result.length][this.result[0].length + 1];
        for (int i = 0; i < this.result.length; ++i) {
            newResult[i][0] = String.valueOf(i + 1);
            for (int j = 1; j < newResult[0].length; ++j) {
                newResult[i][j] = this.result[i][j - 1];
            }
        }
        this.result = newResult;
    }

    protected void insertAccessions(File file, String[][] result) throws IOException {
        String line;
        if (file == null) {
            return;
        }
        BufferedReader fr = new BufferedReader(new FileReader(file));
        Hashtable<String, String> accHash = new Hashtable<String, String>();
        while ((line = fr.readLine()) != null) {
            StringTokenizer stok = new StringTokenizer(line, "\t");
            accHash.put(stok.nextToken(), stok.nextToken());
        }
        for (int i = 0; i < result.length; ++i) {
            String acc = (String)accHash.get(result[i][2]);
            if (acc == null) continue;
            result[i][1] = acc;
        }
    }

    protected File getAccessionFile(String fileName) {
        File file = new File(fileName);
        String accFileName = file.getName();
        return new File(this.tagsFileLocation, accFileName);
    }

    protected String[] getHeaderNames() {
        String[] headerNamesArray = new String[this.headerNames.size()];
        for (int i = 0; i < headerNamesArray.length; ++i) {
            headerNamesArray[i] = this.headerNames.elementAt(i);
        }
        return headerNamesArray;
    }

    protected FloatMatrix getMeans(FloatMatrix data, int[][] clusters) {
        FloatMatrix means = new FloatMatrix(clusters.length, data.getColumnDimension());
        for (int i = 0; i < clusters.length; ++i) {
            means.A[i] = this.getMeans(data, clusters[i]);
        }
        return means;
    }

    protected float[] getMeans(FloatMatrix data, int[] indices) {
        int nSamples = data.getColumnDimension();
        float[] means = new float[nSamples];
        float sum = 0.0f;
        float n = 0.0f;
        for (int i = 0; i < nSamples; ++i) {
            n = 0.0f;
            sum = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sum += value;
                n += 1.0f;
            }
            means[i] = n > 0.0f ? sum / n : Float.NaN;
        }
        return means;
    }

    protected FloatMatrix getVariances(FloatMatrix data, FloatMatrix means, int[][] clusters) {
        int nSamples = data.getColumnDimension();
        FloatMatrix variances = new FloatMatrix(clusters.length, nSamples);
        for (int i = 0; i < clusters.length; ++i) {
            variances.A[i] = this.getVariances(data, means, clusters[i], i);
        }
        return variances;
    }

    protected float[] getVariances(FloatMatrix data, FloatMatrix means, int[] indices, int clusterIndex) {
        int nSamples = data.getColumnDimension();
        float[] variances = new float[nSamples];
        float sse = 0.0f;
        int n = 0;
        for (int i = 0; i < nSamples; ++i) {
            float mean = means.get(clusterIndex, i);
            n = 0;
            sse = 0.0f;
            for (int j = 0; j < indices.length; ++j) {
                float value = data.get(indices[j], i);
                if (Float.isNaN(value)) continue;
                sse += (float)Math.pow(value - mean, 2.0);
                ++n;
            }
            variances[i] = n > 1 ? (float)Math.sqrt(sse / (float)(n - 1)) : 0.0f;
        }
        return variances;
    }

    protected void appendResult(Vector<double[]> resultVector) {
        int numCorr = resultVector.size();
        int rawPIndex = this.result[0].length;
        int resultColumns = rawPIndex + numCorr;
        String[][] newResult = new String[this.result.length][resultColumns];
        for (int i = 0; i < this.result.length; ++i) {
            for (int j = 0; j < this.result[0].length; ++j) {
                newResult[i][j] = this.result[i][j];
            }
        }
        for (int col = 0; col < numCorr; ++col) {
            double[] currentArray = resultVector.elementAt(col);
            int resultCol = col + rawPIndex;
            for (int row = 0; row < newResult.length; ++row) {
                newResult[row][resultCol] = this.format.format(currentArray[row]);
                newResult[row][resultCol] = newResult[row][resultCol].replace(',', '.');
            }
        }
        this.result = newResult;
    }

    protected void pValueCorrections(AlgorithmData inputData) {
        int k = this.result.length;
        double[] pValues = new double[k];
        int pIndex = this.reportEaseScore ? this.headerNames.indexOf("EASE Score") : this.headerNames.indexOf("Fisher's Exact");
        --pIndex;
        Vector<double[]> pValueCorrectionVector = new Vector<double[]>();
        for (int i = 0; i < k; ++i) {
            pValues[i] = Double.parseDouble(this.result[i][pIndex]);
        }
        AlgorithmParameters params = inputData.getParams();
        if (params.getBoolean("bonferroni-correction", false)) {
            pValueCorrectionVector.add(this.bonferroniCorrection(pValues));
            this.headerNames.add("Bonf. Corr.");
        }
        if (params.getBoolean("bonferroni-step-down-correction", false)) {
            pValueCorrectionVector.add(this.stepDownBonferroniCorrection(pValues));
            this.headerNames.add("Bonf. S.D. Corr.");
        }
        if (params.getBoolean("sidak-correction", false)) {
            pValueCorrectionVector.add(this.sidakCorrection(pValues));
            this.headerNames.add("Sidak Corr.");
        }
        if (params.getBoolean("hochberg-correction", false)) {
            pValueCorrectionVector.add(this.benjaminiHochbergCorrection(pValues));
            this.headerNames.add("Hoch. Corr.");
        }
        this.appendResult(pValueCorrectionVector);
    }

    private double[] benjaminiHochbergCorrection(double[] pvalues) {
        int i;
        QSort sort = new QSort(pvalues);
        double[] sortedP = sort.getSortedDouble();
        double[] adjustedP = new double[pvalues.length];
        for (i = 0; i < sortedP.length; ++i) {
            adjustedP[i] = sortedP[i] * (double)sortedP.length / (double)(i + 1);
        }
        if (sortedP.length > 0) {
            sortedP[sortedP.length - 1] = adjustedP[sortedP.length - 1];
            for (i = sortedP.length - 2; i >= 0; --i) {
                sortedP[i] = Math.min(sortedP[i + 1], adjustedP[i]);
            }
        }
        return sortedP;
    }

    protected double[] bonferroniCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        for (int i = 0; i < k; ++i) {
            correctedP[i] = pValues[i] * (double)k;
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    protected double[] stepDownBonferroniCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        int m = 0;
        correctedP[0] = pValues[0] * (double)k;
        for (int i = 1; i < k; ++i) {
            if (pValues[i] > pValues[i - 1]) {
                m = i;
            }
            correctedP[i] = pValues[i] * (double)(k - m);
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    protected double[] sidakCorrection(double[] pValues) {
        int k = pValues.length;
        double[] correctedP = new double[k];
        for (int i = 0; i < k; ++i) {
            correctedP[i] = 1.0 - Math.pow(1.0 - pValues[i], k);
            if (!(correctedP[i] > 1.0)) continue;
            correctedP[i] = 1.0;
        }
        return correctedP;
    }

    protected void permutationAnalysis(int p, Vector<String> sourcePop) {
        AlgorithmEvent permEvent = new AlgorithmEvent((Object)this, 2, p);
        permEvent.setDescription("SET_UNITS");
        permEvent.setIntValue(p);
        this.fireValueChanged(permEvent);
        permEvent.setDescription("SET_VALUE");
        int k = this.result.length;
        int sampleSize = this.sampleVector.size();
        int[] accumulator = new int[this.result.length];
        for (int i = 0; i < accumulator.length; ++i) {
            accumulator[0] = 0;
        }
        Random rand = new Random(System.currentTimeMillis());
        double[] resampledLowestPValues = new double[p];
        int[] lowerPvalueCounts = new int[this.result.length];
        boolean chooseLowestPValueFromEachPermutation = false;
        boolean chooseLowestPValueFromEachFunctionalClass = true;
        for (int i = 0; i < p; ++i) {
            permEvent.setIntValue(i + 1);
            this.fireValueChanged(permEvent);
            this.sampleVector = sourcePop != null ? this.getRandomSampleVector(sampleSize, rand, sourcePop) : this.getRandomSampleVector(sampleSize, rand, null);
            this.jstats.resetForNewList();
            this.jstats.GetListHitsByCategory(this.sampleVector);
            this.jstats.ConstructResults();
            String[][] testResult = this.jstats.getResults();
            this.accumulateBinHits(testResult, accumulator);
        }
        double[] prob = new double[k];
        for (int i = 0; i < k; ++i) {
            prob[i] = (double)accumulator[i] / (double)p;
            if (prob[i] != 0.0) continue;
            prob[i] = 1.0 / (double)p;
        }
        permEvent.setDescription("DISPOSE");
        this.fireValueChanged(permEvent);
        Vector<double[]> probVector = new Vector<double[]>();
        probVector.add(prob);
        this.appendResult(probVector);
        this.headerNames.add("Prob. Anal.");
    }

    protected int getMaxPopHits(String[][] result) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < result.length; ++i) {
            max = Math.max(max, Integer.parseInt(result[i][4]));
        }
        return max;
    }

    protected Vector<String> getRandomSampleVector(int sampleSize, Random rand, Vector<String> sourcePop) {
        Vector<String> sampleVector = new Vector<String>(sampleSize);
        Vector<String> dummyPopVector = sourcePop == null ? new Vector<String>(this.populationVector) : new Vector<String>(sourcePop);
        int index = 0;
        for (int i = 0; i < sampleSize; ++i) {
            index = (int)((float)dummyPopVector.size() * rand.nextFloat());
            sampleVector.add(dummyPopVector.remove(index));
        }
        return sampleVector;
    }

    protected void accumulateHits(String[][] result, String[] keys, int[] accumulator) {
        block0: for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < keys.length; ++j) {
                if (!result[i][1].equals(keys[j])) continue;
                if (Integer.parseInt(result[i][2]) <= Integer.parseInt(this.result[j][2])) continue block0;
                int n = j;
                accumulator[n] = accumulator[n] + 1;
                continue block0;
            }
        }
    }

    protected void accumulateBinHits(String[][] permutedResult, int[] accumulator) {
        for (int cat = 0; cat < this.annotationFileList.length; ++cat) {
            double minP = Double.POSITIVE_INFINITY;
            for (int i = 0; i < permutedResult.length; ++i) {
                if (this.annotationFileList[cat].indexOf(permutedResult[i][0]) < 0) continue;
                minP = Math.min(minP, Double.parseDouble(permutedResult[i][6]));
            }
            for (int j = 0; j < this.result.length; ++j) {
                if (this.annotationFileList[cat].indexOf(this.result[j][0]) < 0 || !(minP < Double.parseDouble(this.result[j][6]))) continue;
                int n = j;
                accumulator[n] = accumulator[n] + 1;
            }
        }
    }

    protected double[] orderBootStrappedProb(double[] prob) {
        double[] orderedProb = new double[this.result.length];
        for (int i = 0; i < this.result.length; ++i) {
            orderedProb[i] = prob[Integer.parseInt(this.result[i][2])];
        }
        return orderedProb;
    }

    protected void trimResult(String trimOption, float trimValue) {
        int i;
        boolean[] flagged = new boolean[this.result.length];
        int hitIndex = this.performClusterAnalysis ? this.headerNames.indexOf("List Hits") : this.headerNames.indexOf("Pop. Hits");
        --hitIndex;
        int keeperCount = this.result.length;
        if (trimOption.equals("N_TRIM")) {
            for (i = 0; i < this.result.length; ++i) {
                if (!((float)Integer.parseInt(this.result[i][hitIndex]) < trimValue)) continue;
                flagged[i] = true;
                --keeperCount;
            }
        } else {
            trimValue /= 100.0f;
            for (i = 0; i < this.result.length; ++i) {
                if (!(Double.parseDouble(this.result[i][hitIndex]) / Double.parseDouble(this.result[i][hitIndex + 1]) < (double)trimValue)) continue;
                flagged[i] = true;
                --keeperCount;
            }
        }
        String[][] newResult = new String[keeperCount][];
        String[][] newHitList = new String[keeperCount][];
        String[] newCategoryNames = new String[keeperCount];
        int keeperIndex = 0;
        for (int i2 = 0; i2 < this.result.length; ++i2) {
            if (flagged[i2]) continue;
            newResult[keeperIndex] = this.result[i2];
            newHitList[keeperIndex] = this.hitList[i2];
            newCategoryNames[keeperIndex] = this.categoryNames[i2];
            ++keeperIndex;
        }
        this.result = newResult;
        this.hitList = newHitList;
        this.categoryNames = newCategoryNames;
    }
}

