/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.mev.cluster.algorithm.impl.attract;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.rosuda.JRI.REXP;
import org.rosuda.JRI.Rengine;
import org.tigr.microarray.mev.cluster.algorithm.AbortException;
import org.tigr.microarray.mev.cluster.algorithm.AbstractAlgorithm;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmData;
import org.tigr.microarray.mev.cluster.algorithm.AlgorithmException;
import org.tigr.microarray.mev.cluster.algorithm.impl.attract.AttractAlgorithmParameters;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.GSEAUtils;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.Geneset;
import org.tigr.microarray.mev.cluster.algorithm.impl.gsea.ReadGeneSet;
import org.tigr.rhook.RHook;
import org.tigr.util.FloatMatrix;

public class ATTRACT
extends AbstractAlgorithm {
    private FloatMatrix geneDataMatrix;
    private FloatMatrix incidenceMatrix;
    private String[] geneNames;
    private String[] geneSetNames;
    private String[] sampleNames;
    private String[] removedGenes;
    private String factorName;
    private int[][] grpAssignments;
    private LinkedHashMap<String, Float> geneSetSize;
    private LinkedHashMap<String, Integer> overEnriched;
    private boolean stop = false;
    private Geneset[] geneSets;
    private int topPathways;
    private Vector<String> excludedGeneSets;
    private String[] excludedGenes;

    public AlgorithmData execute(AlgorithmData data) throws AlgorithmException {
        this.geneDataMatrix = data.getGeneMatrix("gene-data-matrix");
        this.geneNames = new String[data.getVector("Unique-Genes-in-Expressionset").size()];
        data.getVector("Unique-Genes-in-Expressionset").toArray(this.geneNames);
        this.geneSetNames = new String[data.getVector("gene-set-names").size()];
        data.getVector("gene-set-names").toArray(this.geneSetNames);
        this.sampleNames = data.getStringArray("sampleLabels");
        this.factorName = data.getStringArray("factor-names")[0];
        this.grpAssignments = data.getIntMatrix("factor-assignments");
        this.incidenceMatrix = data.getGeneMatrix("association-matrix");
        this.overEnriched = data.getMappings("over-enriched");
        this.geneSetSize = data.getMappings("gene-set-size");
        this.geneSets = ((AttractAlgorithmParameters)data.getAlgorithmParameters("attract")).getGenesets();
        this.topPathways = Integer.valueOf(data.getParams().getString("pathway-cutoff"));
        this.excludedGeneSets = data.getVector("excluded-gene-sets");
        this.runRAlg();
        if (this.stop) {
            throw new AbortException();
        }
        ((AttractAlgorithmParameters)data.getAlgorithmParameters("attract")).setGenesets(this.geneSets);
        AlgorithmData result = new AlgorithmData();
        result.addVector("excluded-gene-sets", this.excludedGeneSets);
        System.out.println("length of excluded genesets:" + this.excludedGeneSets.size());
        result.addStringArray("excluded-genes", this.excludedGenes);
        return result;
    }

    public void abort() {
    }

    public void runRAlg() throws AbortException {
        try {
            Rengine re = RHook.startRSession();
            if (re == null) {
                JOptionPane.showMessageDialog(null, "Error creating R Engine", "REngine", 0);
                throw new AbortException();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "REngine", 0);
            throw new AbortException();
        }
        try {
            RHook.testPackage((String)"attract");
            RHook.log((String)"Starting R Algorithim");
            String rCmd = "library(attract)";
            RHook.evalR((String)rCmd);
            rCmd = "library(Biobase)";
            RHook.evalR((String)rCmd);
            rCmd = "library(limma)";
            RHook.evalR((String)rCmd);
            rCmd = "library(DBI)";
            RHook.evalR((String)rCmd);
            rCmd = "library(RSQLite)";
            RHook.evalR((String)rCmd);
            rCmd = "library(AnnotationDbi)";
            RHook.evalR((String)rCmd);
            rCmd = "library(KEGG.db)";
            RHook.evalR((String)rCmd);
            rCmd = "library(XML)";
            RHook.evalR((String)rCmd);
            rCmd = "library(GSEABase)";
            RHook.evalR((String)rCmd);
            rCmd = "library(genefilter)";
            RHook.evalR((String)rCmd);
            rCmd = "library(xtable)";
            RHook.evalR((String)rCmd);
            rCmd = "library(Category)";
            RHook.evalR((String)rCmd);
            rCmd = "library(GO.db)";
            RHook.evalR((String)rCmd);
            rCmd = "library(RBGL)";
            RHook.evalR((String)rCmd);
            rCmd = "library(annotate)";
            RHook.evalR((String)rCmd);
            rCmd = "library(GOstats)";
            RHook.evalR((String)rCmd);
            rCmd = "library(graph)";
            RHook.evalR((String)rCmd);
            rCmd = "library(cluster)";
            RHook.evalR((String)rCmd);
            rCmd = "library(GSEAlm)";
            RHook.evalR((String)rCmd);
            String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "dataMatrixfile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            String filePath = this.writeGeneDataMatrixToFile(fileLoc, this.geneDataMatrix, this.geneNames, this.sampleNames);
            System.out.println("Reading in data matrix");
            RHook.log((String)"Reading in data matrix");
            rCmd = "data<-read.delim('" + filePath + "', sep='\\t', header=TRUE)";
            RHook.evalR((String)rCmd);
            fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "sampleGroupingsR.txt";
            fileLoc = fileLoc.replace("\\", "/");
            filePath = this.writeAssignmentsAsFile(fileLoc);
            filePath = fileLoc;
            System.out.println("Reading in sample grouping");
            RHook.log((String)"Reading in sample grouping");
            rCmd = "sample.info<-read.delim('" + filePath + "', sep='\\t', header=TRUE)";
            RHook.evalR((String)rCmd);
            rCmd = "exprs.dat<-data[,-1]";
            RHook.evalR((String)rCmd);
            rCmd = "rownames(exprs.dat)<-as.character(data[,1])";
            RHook.evalR((String)rCmd);
            rCmd = "exprs.dat<-as.matrix(exprs.dat)";
            RHook.evalR((String)rCmd);
            System.out.println("Creating expression set");
            RHook.log((String)"Creating Expression Set");
            rCmd = "eset<-new('ExpressionSet')";
            RHook.evalR((String)rCmd);
            rCmd = "eset@assayData<-new.env()";
            RHook.evalR((String)rCmd);
            rCmd = "assign('exprs', exprs.dat, eset@assayData)";
            RHook.evalR((String)rCmd);
            rCmd = "p.eset<-new('AnnotatedDataFrame', data=sample.info)";
            RHook.evalR((String)rCmd);
            rCmd = "eset@phenoData<-p.eset";
            RHook.evalR((String)rCmd);
            RHook.log((String)"Creating incidence matrix in R");
            fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "incidenceMatrixFile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            filePath = this.writeGeneDataMatrixToFile(fileLoc, this.incidenceMatrix, this.geneSetNames, this.geneNames);
            rCmd = "incidencematrix<-read.delim('" + fileLoc + "', sep='\\t', header=TRUE)";
            RHook.evalR((String)rCmd);
            rCmd = "incidence<-incidencematrix[,-1]";
            RHook.evalR((String)rCmd);
            rCmd = "rownames(incidence)<-as.character(incidencematrix[,1])";
            RHook.evalR((String)rCmd);
            rCmd = "incidence<-as.matrix(incidence)";
            RHook.evalR((String)rCmd);
            fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator") + "significantGeneSetFile.txt";
            fileLoc = fileLoc.replace("\\", "/");
            this.writeSignificantGenesetsToFile(fileLoc, this.geneSetSize, this.overEnriched);
            RHook.log((String)"Reading in Significant Genesets");
            rCmd = "rankedPathways<-read.delim('" + fileLoc + "', sep='\\t', header=TRUE)";
            RHook.evalR((String)rCmd);
            RHook.log((String)"Creating AttractorModuleSet");
            rCmd = "eModuleSet<-new('AttractorModuleSet')";
            RHook.evalR((String)rCmd);
            rCmd = "eModuleSet@eSet<-eset";
            RHook.evalR((String)rCmd);
            rCmd = "eModuleSet@incidenceMatrix<-incidence";
            RHook.evalR((String)rCmd);
            rCmd = "eModuleSet@rankedPathways<-rankedPathways";
            RHook.evalR((String)rCmd);
            rCmd = "cellType<-as.character('" + this.factorName + "')";
            RHook.evalR((String)rCmd);
            rCmd = "eModuleSet@cellTypeTag<-cellType";
            RHook.evalR((String)rCmd);
            rCmd = "remove.these.genes<-removeFlatGenes(eset, cellType, contrasts=NULL, limma.cutoff=0.05)";
            REXP x = RHook.evalR((String)rCmd);
            this.excludedGenes = x.asStringArray();
            rCmd = "keepTheseGenes<-setdiff(featureNames(eset), remove.these.genes)";
            x = RHook.evalR((String)rCmd);
            Vector<String> genesToKeep = new Vector<String>(Arrays.asList(x.asStringArray()));
            ReadGeneSet rgset = new ReadGeneSet(new String(""), new String(""));
            rgset.setMinNumOfGenes(5);
            this.geneSets = rgset.removeGenesNotinExpressionData(this.geneSets, genesToKeep);
            this.geneSets = rgset.removeGenesetsWithoutMinimumGenes(rgset.getExcludedGeneSets(), this.geneSets);
            this.excludedGeneSets.addAll(rgset.getExcludedGeneSets());
            this.geneSets = new GSEAUtils().getGeneSetSortedBySize(this.geneSets);
            RHook.log((String)"Finding synexpression groups");
            for (int geneSetIndex = 0; geneSetIndex < this.topPathways; ++geneSetIndex) {
                String geneSetName = this.geneSets[geneSetIndex].getGeneSetName();
                rCmd = "mapk.syn<-findSynexprs('" + geneSetName + "', eModuleSet, remove.these.genes)";
                RHook.evalR((String)rCmd);
                rCmd = "mapk.cor<-findCorrPartners(mapk.syn, eset, remove.these.genes)";
                RHook.evalR((String)rCmd);
                rCmd = "length(mapk.syn@groups)";
                x = RHook.evalR((String)rCmd);
                int numGroups = x.asInt();
                for (int groups = 0; groups < numGroups; ++groups) {
                    rCmd = "asMatrix<-t(as.matrix(unlist(mapk.syn@groups[[" + (groups + 1) + "]]), nrow=length((mapk.syn@groups[[" + (groups + 1) + "]])), ncol=length(unlist(mapk.syn@groups[[" + (groups + 1) + "]])), byrow=true))";
                    RHook.evalR((String)rCmd);
                    rCmd = "asVector<-as.vector(asMatrix)";
                    x = RHook.evalR((String)rCmd);
                    this.geneSets[geneSetIndex].setSynExpressionGroup("Group" + (groups + 1), x.asStringArray());
                    rCmd = "asMatrix<-t(as.matrix(unlist(mapk.cor@groups[[" + (groups + 1) + "]]), nrow=length((mapk.cor@groups[[" + (groups + 1) + "]])), ncol=length(unlist(mapk.cor@groups[[" + (groups + 1) + "]])), byrow=true))";
                    RHook.evalR((String)rCmd);
                    rCmd = "asVector<-as.vector(asMatrix)";
                    x = RHook.evalR((String)rCmd);
                    this.geneSets[geneSetIndex].setSimilarGenes("Group" + (groups + 1), x.asStringArray());
                }
                rCmd = "mapk.syn@profiles";
                x = RHook.evalR((String)rCmd);
                double[][] doubleArray = x.asMatrix();
                float[][] floatArray = this.convertDoubleToFloat(doubleArray);
                this.geneSets[geneSetIndex].setSynExpressionProfiles(new FloatMatrix(floatArray));
                rCmd = "mapk.cor@profiles";
                x = RHook.evalR((String)rCmd);
                doubleArray = x.asMatrix();
                floatArray = this.convertDoubleToFloat(doubleArray);
                this.geneSets[geneSetIndex].setSimilarGeneExpressionProfile(new FloatMatrix(floatArray));
            }
            RHook.endRSession();
            this.removeAllTmps();
        }
        catch (Exception e) {
            RHook.log((Exception)e);
            try {
                RHook.endRSession();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private float[][] convertDoubleToFloat(double[][] doubleArray) {
        float[][] floatArray = new float[doubleArray.length][];
        for (int index = 0; index < doubleArray.length; ++index) {
            floatArray[index] = new float[doubleArray[index].length];
            for (int index2 = 0; index2 < doubleArray[index].length; ++index2) {
                floatArray[index][index2] = (float)doubleArray[index][index2];
            }
        }
        return floatArray;
    }

    private String writeAssignmentsAsFile(String fileLoc) {
        File file = new File(fileLoc);
        try {
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            pw.println("Sample Name\t" + this.factorName);
            for (int sample = 0; sample < this.sampleNames.length; ++sample) {
                pw.print(this.sampleNames[sample] + "\t");
                for (int grpIndex = 0; grpIndex < this.grpAssignments.length; ++grpIndex) {
                    if (this.grpAssignments[grpIndex][sample] != 0) {
                        pw.write("Group" + this.grpAssignments[grpIndex][sample]);
                    } else {
                        pw.print("Exclude");
                    }
                    if (grpIndex == this.grpAssignments.length - 1) {
                        pw.println();
                        continue;
                    }
                    pw.print('\t');
                }
            }
            pw.flush();
            pw.close();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return fileLoc;
    }

    public String writeSignificantGenesetsToFile(String fileLoc, LinkedHashMap<String, Float> geneSetSize, LinkedHashMap overenriched) {
        System.out.println("write significant genesets to file");
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(fileLoc));
            String[][] pVals = new String[overenriched.size()][3];
            Object[] gene_sets = overenriched.keySet().toArray();
            for (int i = 0; i < overenriched.size(); ++i) {
                pVals[i][0] = (String)gene_sets[i];
                pVals[i][1] = (String)gene_sets[i];
                pVals[i][2] = ((Float)overenriched.get(gene_sets[i])).toString();
            }
            int row = pVals.length;
            int col = 3;
            String srtVector = "";
            srtVector = "GeneSetName\tDescription\tpValues\n";
            out.write(srtVector);
            srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                for (int jCol = 0; jCol < col; ++jCol) {
                    srtVector = jCol == col - 1 ? srtVector + pVals[iRow][jCol] + "\n" : srtVector + pVals[iRow][jCol] + "\t";
                }
                out.write(srtVector);
                srtVector = "";
            }
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    public String writeMatrix(String fileLoc, FloatMatrix fm, String[] rowNames, String[] sampleNames) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(fileLoc));
            fm.print(writer, 2, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileLoc;
    }

    public String writeGeneDataMatrixToFile(String fileLoc, FloatMatrix fm, String[] rowNames, String[] sampleNames) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileLoc)));
            int row = fm.getRowDimension();
            int col = fm.getColumnDimension();
            String srtVector = "";
            srtVector = "GeneNames\t";
            out.write(srtVector);
            for (int cols = 0; cols < col; ++cols) {
                if (cols == col - 1) {
                    srtVector = sampleNames[cols] + "\n";
                    out.write(srtVector);
                    continue;
                }
                srtVector = sampleNames[cols] + "\t";
                out.write(srtVector);
            }
            srtVector = "";
            for (int iRow = 0; iRow < row; ++iRow) {
                srtVector = rowNames[iRow] + "\t";
                out.write(srtVector);
                for (int jCol = 0; jCol < col; ++jCol) {
                    if (jCol == col - 1) {
                        srtVector = fm.get(iRow, jCol) + "\n";
                        out.write(srtVector);
                        continue;
                    }
                    srtVector = fm.get(iRow, jCol) + "\t";
                    out.write(srtVector);
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            return null;
        }
        return fileLoc;
    }

    private void removeAllTmps() {
        String fileLoc = System.getProperty("user.dir") + System.getProperty("file.separator");
        String fPath = fileLoc + "dataMatrixfile.txt";
        fPath = fPath.replace("\\", "/");
        new File(fPath).delete();
        fPath = fileLoc + "sampleGroupingsR.txt";
        fPath = fPath.replace("\\", "/");
        new File(fPath).delete();
        fPath = fileLoc + "incidenceMatrixFile.txt";
        fPath = fPath.replace("\\", "/");
        new File(fPath).delete();
        fPath = fileLoc + "significantGeneSetFile.txt";
        fPath = fPath.replace("\\", "/");
        new File(fPath).delete();
    }

    public Geneset[] getGeneSets() {
        return this.geneSets;
    }

    public void setGenesets(Geneset[] gset) {
        this.geneSets = gset;
    }
}

